/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.Table.TableInfo;
import dbatool.TreeNode.DBATreeNode;
import dbaut.GuiUt;
import dbaut.locale.LocaleChangeEvent;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class TableTreeNode
extends DBATreeNode {
    private String table_owner = null;
    private String table_name = null;
    private String table_type = null;
    private static ImageIcon icon = null;
    private String toString = null;
    public TableInfo tableInfo = null;

    public TableTreeNode(String table_owner, String table_name, String table_type) {
        this.table_name = GuiUt.rightTrim(table_name);
        this.table_owner = GuiUt.rightTrim(table_owner);
        this.table_type = table_type;
        this.toString = this.table_owner + "." + this.table_name;
    }

    public void finalize() throws Throwable {
        this.table_owner = null;
        this.table_name = null;
        this.table_type = null;
        icon = null;
        super.finalize();
    }

    @Override
    public String getHelpID() {
        return "table.info";
    }

    @Override
    public String toString() {
        return this.toString;
    }

    public String getTableType() {
        return this.table_type;
    }

    public String getTableName() {
        return this.table_name;
    }

    public String getTableOwner() {
        return this.table_owner;
    }

    @Override
    public void displayObject() {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(res.getString("Information_about"), this.table_owner + "." + this.table_name));
        this.tableInfo = new TableInfo(this);
        DbFrame.frame.setContentPanel(this.tableInfo);
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
        popup = null;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_table.gif");
        }
        return icon;
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
    }

    @Override
    public boolean isFound(String s1, String s2, String s3) {
        return this.table_owner.equalsIgnoreCase(s1) && this.table_name.equalsIgnoreCase(s2);
    }

    @Override
    public void refresh() {
        DbFrame.frame.treePanel.refreshTableSubTree(this);
        this.displayObject();
    }
}

