/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.Tablespace.TableSpaceInfo;
import dbatool.TreeNode.DBATreeNode;
import dbaut.GuiUt;
import dbaut.locale.LocaleChangeEvent;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class TableSpaceTreeNode
extends DBATreeNode {
    public String name;
    private static ImageIcon icon = null;

    public TableSpaceTreeNode(String tablespace_name) {
        this.name = GuiUt.rightTrim(tablespace_name);
    }

    @Override
    public String getHelpID() {
        return "tablespace.info";
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getTableSpaceName() {
        return this.name;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_tablespace.gif");
        }
        return icon;
    }

    @Override
    public void displayObject() {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(res.getString("Information_about"), this.name));
        DbFrame.frame.setContentPanel(new TableSpaceInfo(this.name));
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
    }

    @Override
    public boolean isFound(String s1, String s2, String s3) {
        return this.name.equalsIgnoreCase(s1);
    }

    @Override
    public void refresh() {
        this.displayObject();
    }
}

