/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Task;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;

public class TaskList
extends DbaTabbedPane
implements ComponentPrivilege {
    private int OWNER = 0;
    private int NAME = 1;
    private int TYPE = 2;
    private int ACTIONS = 3;
    private DbaButton Create_Button;
    private DbaButton Drop_Button;
    private DbaTableModel model;
    private DBAToolAbstractTableModel absModel;
    private JTable table;

    public TaskList() {
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        this.model = null;
        this.absModel = null;
        this.table = null;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("TasksTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "task.list");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Owner"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("Actions")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table = new JTable(this.absModel);
        this.table.setName("TaskListTable");
        jPanel1.setLayout(new BorderLayout());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TaskList.this.table_mouseClicked(e);
            }
        });
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Task"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        jPanel2.setName("TaskButtonPanel");
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table, null);
        this.initColumnSizes();
        this.getTaskList();
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.absModel.addMouseListenerToHeaderInTable(this.table);
    }

    @Override
    public int getComponentType() {
        return 16;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Drop_Button.setEnabled(enabled);
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table.getSelectedRow();
            Object value = this.table.getValueAt(r, 1);
            String owner = (String)value;
            this.authority.authorise(owner);
        }
    }

    private void initColumnSizes() {
    }

    private void getTaskList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            boolean insystbl = DbFrame.frame.treePanel.getOption("INSYSTBL");
            this.model.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TASK_OWNER, TASK_NAME, TASK_TYPE, ACTIONS from SYSTEM.SYSTASK ";
            if (!insystbl) {
                query = query + "where task_owner!='SYSTEM' ";
            }
            query = query + "order by TASK_OWNER, TASK_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model.addValue(new DBARowInfo(this.getRowInfo(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getString(4))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.res.getString("The_number_of_tasks_is"), Integer.toString(this.model.getRowCount())));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
    }

    private Object[] getRowInfo(String owner, String name, int type, String actions) {
        Object[] data = new Object[4];
        data[this.OWNER] = owner.trim();
        data[this.NAME] = name.trim();
        String[] types = new String[]{"SQL_STATEMENT", "STORE_PROCEDURE", "EXECUTABLE"};
        data[this.TYPE] = types[type - 1];
        data[this.ACTIONS] = actions;
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(23);
        DbFrame.frame.treePanel.refreshTaskTree();
        this.getTaskList();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        String owner = (String)this.model.getValueAt(row, this.OWNER);
        String name = (String)this.model.getValueAt(row, this.NAME);
        if (DbFrame.conn_DatabaseConnection.dropTask(owner, name)) {
            DbFrame.frame.treePanel.afterDropObject(27);
        }
    }

    private void table_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            String owner = (String)this.absModel.getValueAt(row, this.OWNER);
            String name = (String)this.absModel.getValueAt(row, this.NAME);
            DbFrame.frame.treePanel.openTaskTree(owner, name);
        }
    }
}

