/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Task;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class Scheduler {
    private BitSet minutes = new BitSet(60);
    private BitSet hours = new BitSet(24);
    private BitSet daysOfMonth = new BitSet(31);
    private BitSet months = new BitSet(12);
    private BitSet daysOfWeek = new BitSet(7);
    private Map<String, Integer> monthMap;
    private Map<String, Integer> dayOfWeekMap;

    public Scheduler() {
        this.initializeMaps();
    }

    private void initializeMaps() {
        this.monthMap = new HashMap<String, Integer>();
        this.dayOfWeekMap = new HashMap<String, Integer>();
        String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        for (int i = 0; i < months.length; ++i) {
            this.monthMap.put(months[i], i);
        }
        String[] days = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
        for (int i = 0; i < days.length; ++i) {
            this.dayOfWeekMap.put(days[i], i);
        }
    }

    public void initTimetable(String timeTable) throws IllegalArgumentException {
        String[] parts = timeTable.toUpperCase().trim().split("\\s+");
        if (parts.length == 1) {
            this.handleSpecialSchedules(parts[0]);
            return;
        }
        if (parts.length != 5) {
            throw new IllegalArgumentException("Invalid format");
        }
        this.minutes = this.parseTimeField(parts[0], 0, 59);
        this.hours = this.parseTimeField(parts[1], 0, 23);
        this.daysOfMonth = this.parseTimeField(parts[2], 1, 31);
        this.months = this.parseTimeField(parts[3], 0, 11, this.monthMap);
        this.daysOfWeek = this.parseTimeField(parts[4], 0, 6, this.dayOfWeekMap);
    }

    private BitSet parseTimeField(String field, int low, int high) {
        return this.parseTimeField(field, low, high, null);
    }

    private BitSet parseTimeField(String field, int low, int high, Map<String, Integer> nameMap) {
        BitSet bits = new BitSet(high - low + 1);
        if (field.equals("*")) {
            bits.set(low, high + 1);
        } else {
            String[] parts;
            for (String part : parts = field.split(",")) {
                if (part.contains("/")) {
                    String[] stepParts = part.split("/");
                    if (!stepParts[0].equals("*")) {
                        throw new IllegalArgumentException("Step interval can only follow an asterisk: " + part);
                    }
                    int step = Integer.parseInt(stepParts[1]);
                    for (int i = low; i <= high; i += step) {
                        bits.set(i);
                    }
                    continue;
                }
                if (part.contains("-")) {
                    String[] rangeParts = part.split("-");
                    int start = this.parsePart(rangeParts[0], low, high, nameMap);
                    int end = this.parsePart(rangeParts[1], low, high, nameMap);
                    bits.set(start, end + 1);
                    continue;
                }
                int value = this.parsePart(part, low, high, nameMap);
                bits.set(value);
            }
        }
        return bits;
    }

    private int parsePart(String part, int low, int high, Map<String, Integer> nameMap) {
        if (nameMap != null && nameMap.containsKey(part)) {
            return nameMap.get(part);
        }
        try {
            int value = Integer.parseInt(part);
            if (value < low || value > high) {
                throw new IllegalArgumentException("Value out of bounds: " + value);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for part: " + part, e);
        }
    }

    private void handleSpecialSchedules(String schedule) {
        switch (schedule) {
            case "@ONCE": {
                break;
            }
            case "@YEARLY": 
            case "@ANNUALLY": {
                this.setSchedule(0, 0, 1, 0, 0);
                break;
            }
            case "@MONTHLY": {
                this.setSchedule(0, 0, 1, -1, -1);
                break;
            }
            case "@WEEKLY": {
                this.setSchedule(0, 0, -1, -1, 2);
                break;
            }
            case "@DAILY": 
            case "@MIDNIGHT": {
                this.setSchedule(0, 0, -1, -1, -1);
                break;
            }
            case "@HOURLY": {
                this.setSchedule(0, -1, -1, -1, -1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported schedule expression: " + schedule);
            }
        }
    }

    private void setSchedule(int minute, int hour, int dom, int month, int dow) {
        this.minutes.clear();
        this.hours.clear();
        this.daysOfMonth.clear();
        this.months.clear();
        this.daysOfWeek.clear();
        if (minute != -1) {
            this.minutes.set(minute);
        }
        if (hour != -1) {
            this.hours.set(hour);
        }
        if (dom != -1) {
            this.daysOfMonth.set(dom);
        }
        if (month != -1) {
            this.months.set(month);
        }
        if (dow != -1) {
            this.daysOfWeek.set(dow);
        }
    }

    public static void main(String[] args) {
        String[] testExpressions;
        Scheduler scheduler = new Scheduler();
        for (String expression : testExpressions = new String[]{"@monthly", "0 0 1 JAN *", "*/5 * * * MON-FRI", "* * * JAN-DEC SUN-SAT", "60 * * * *", "* * * * SUN-MON", "0/5 * * * MON-FRI"}) {
            System.out.print("Cron '" + expression + "' is valid: ");
            try {
                scheduler.initTimetable(expression);
                System.out.println("true");
            }
            catch (IllegalArgumentException e) {
                System.out.println("false");
            }
        }
    }
}

