/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.Index.IndexList;
import dbatool.Table.ConstraintEditor;
import dbatool.Table.PrimaryKeyEditor;
import dbatool.Table.PrimaryKeyRenderer;
import dbatool.Table.PrimaryKeyVector;
import dbatool.Table.RenameTableDlg;
import dbatool.Table.SchemaDefaultAttri1;
import dbatool.Table.SchemaDefaultAttri2;
import dbatool.Table.SchemaTableModel;
import dbatool.Table.SchemaType;
import dbatool.Table.SchemaUpdatableRowInfo;
import dbatool.Table.SchemaUpdatableTableModel;
import dbatool.Table.TableInfo;
import dbatool.tableCell.BooleanEditor;
import dbatool.tableCell.BooleanRenderer;
import dbatool.tableCell.ColumnTextField;
import dbatool.tableCell.TableHeaderRenderer;
import dbatool.tableModel.DBARowInfo;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.comp.TableColumnSelectionListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.text.TextField;
import dbaut.textField.CharField;
import dbaut.textField.IntegerField;
import dbaut.textField.SmallintField;
import dbaut.util.JavaTypeUtil;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class TableSchema
extends DbaPanel
implements ComponentPrivilege {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.TableRes", LocaleManager.getLocale());
    private String[] SchemaColumnNames = new String[]{this.res.getString("Name"), this.res.getString("Type"), this.res.getString("Precision"), this.res.getString("Scale"), this.res.getString("Nullable"), this.res.getString("Primary_Key"), this.res.getString("Default_Attri1"), this.res.getString("Default_Value"), this.res.getString("Default_Attri2"), this.res.getString("Constraint"), this.res.getString("Encrypt")};
    public SchemaTableModel schemaTableModel = new SchemaTableModel(this.SchemaColumnNames);
    private SchemaUpdatableTableModel upd_model = new SchemaUpdatableTableModel(this);
    private int[] dropOptions = null;
    private DbaTable Schema_Columns = new DbaTable(this.schemaTableModel);
    private KeyStroke controlC = KeyStroke.getKeyStroke(67, 2);
    private AbstractAction ctrlCAction = new AbstractAction("columnNameCopy"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            String columns = "";
            String str = null;
            for (int[] entry : TableSchema.this.selectedCells) {
                str = (String)TableSchema.this.Schema_Columns.getValueAt(entry[0], entry[1]);
                if (str == null || str.length() <= 0) continue;
                if (columns.length() == 0) {
                    columns = str;
                    continue;
                }
                columns = columns + "," + str;
            }
            System.out.println("columns=" + columns);
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(columns);
            if (clip != null && columns.length() > 0) {
                clip.setContents(stringSelection, null);
            }
        }
    };
    private Action defaultCtrlCAction = null;
    boolean pressingCTRL = false;
    Vector<int[]> selectedCells = new Vector();
    private String orig_primarykey_str = "";
    public PrimaryKeyVector primarykey = new PrimaryKeyVector();
    public JTextField Schema_PrimaryKey = new TextField();
    private JComboBox tsNameComboBox = new JComboBox();
    private JCheckBox fastCopyCheckBox = new JCheckBox();
    private String dtsName = null;
    private boolean isReadOnlyTableSpace = false;
    private DbaButton Schema_Up_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Up"), 'U', DBAImageResource.getResource(this.getClass(), "/jdbaimages/up.gif"), new ReflectionAction(this, "Schema_Up_Button_actionPerformed"));
    private DbaButton Schema_Down_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Down"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/down.gif"), new ReflectionAction(this, "Schema_Down_Button_actionPerformed"));
    public DbaButton Schema_Modify_Button = new DbaButton(new Dimension(80, 24), this.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Schema_Modify_Button_actionPerformed"));
    private DbaButton Schema_Confirm_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Schema_Confirm_Button_actionPerformed"));
    private DbaButton Schema_Cancel_Button = new DbaButton(new Dimension(80, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancel.gif"), new ReflectionAction(this, "Schema_Cancel_Button_actionPerformed"));
    private DbaButton Rename_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Rename"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rename.gif"), new ReflectionAction(this, "Rename_Button_actionPerformed"));
    private JCheckBox traceTableJCheckBox = new JCheckBox(this.res.getString("Trace_Table"));
    private DbaButton Schema_Del_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Del"), 'E', DBAImageResource.getResource(this.getClass(), "/jdbaimages/delete.gif"), new ReflectionAction(this, "Schema_Del_Button_actionPerformed"));
    private TableInfo tableinfo = null;
    private String table_owner = null;
    private String table_name = null;

    public TableSchema(String helpid2, TableInfo tableinfo) {
        super(DbFrame.helpres, helpid2);
        this.tableinfo = tableinfo;
        this.table_owner = tableinfo.table_owner;
        this.table_name = tableinfo.table_name;
        if (!DbFrame.conn_DatabaseConnection.isDBTDE()) {
            this.Schema_Columns.hideColumn(SchemaTableModel.ENCRYPT);
        }
        this.setName("TableSchemaPanel");
        this.Rename_Button.setName("RenameButton");
        this.Schema_Modify_Button.setName("ModifyButton");
        this.Schema_Confirm_Button.setName("ConfirmButton");
        this.Schema_Cancel_Button.setName("CancelButton");
        this.traceTableJCheckBox.setName("TraceTableCheckBox");
        this.Schema_Columns.setName("SchemaColumnsTable");
        this.tsNameComboBox.setName("TablespaceComboBox");
        this.fastCopyCheckBox.setName("FastCopyCheckBox");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jToolBar3 = new JPanel(new FlowLayout(0));
        JLabel jLabel1 = new JLabel();
        JPanel jPanel18 = new JPanel();
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new FlowLayout(0));
        jPanel18.setLayout((LayoutManager)new VerticalFlowLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel18, "North");
        this.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.Schema_Columns, null);
        jPanel18.add((Component)jToolBar3, null);
        jToolBar3.add((Component)this.Schema_Modify_Button, null);
        jToolBar3.add((Component)this.Schema_Confirm_Button, null);
        jToolBar3.add((Component)this.Schema_Cancel_Button, null);
        jToolBar3.add((Component)this.Rename_Button, null);
        JPanel emptyPanel = new JPanel();
        emptyPanel.setPreferredSize(new Dimension(100, 0));
        jToolBar3.add(emptyPanel);
        jToolBar3.add(this.traceTableJCheckBox);
        this.traceTableJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableSchema.this.traceTableJCheckBoxActionPerformed(e);
            }
        });
        JPanel tsPanel = new JPanel(new FlowLayout(0, 0, 0));
        tsPanel.add(new JLabel(this.res.getString("Tablespace_Name")));
        this.tsNameComboBox.setEditable(false);
        this.fastCopyCheckBox.setEnabled(false);
        this.fastCopyCheckBox.setText(this.res.getString("Fast_Copy"));
        this.fastCopyCheckBox.setSelected(true);
        this.tsNameComboBox.setPreferredSize(new Dimension(270, 24));
        this.fastCopyCheckBox.setPreferredSize(new Dimension(500, 24));
        tsPanel.add(this.tsNameComboBox);
        tsPanel.add(this.fastCopyCheckBox);
        this.authority = DbaAuthorityFactory.create(this);
        if (this.authority.isAboveDba() || this.authority.isResource()) {
            jPanel18.add((Component)tsPanel, null);
        }
        this.Schema_PrimaryKey.setPreferredSize(new Dimension(100, 24));
        jPanel18.add((Component)jPanel16, null);
        jPanel16.add(jLabel1);
        jPanel16.add(this.Schema_PrimaryKey);
        jPanel16.add(this.Schema_Del_Button);
        jPanel16.add(this.Schema_Up_Button);
        jPanel16.add(this.Schema_Down_Button);
        this.Schema_PrimaryKey.setPreferredSize(new Dimension(300, 24));
        jScrollPane1.setPreferredSize(new Dimension(454, 100));
        jLabel1.setText(this.res.getString("Primary_Key_s_"));
        this.Schema_PrimaryKey.setEditable(false);
        this.Schema_Columns.setAutoResizeMode(4);
        this.Schema_Columns.setColumnSelectionAllowed(true);
        this.Schema_Columns.setRowSelectionAllowed(true);
        this.Schema_Columns.addRowSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TableSchema.this.TableSelectionChanged(e);
                }
            }
        });
        this.Schema_Columns.addColumnSelectionListener(new TableColumnSelectionListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TableSchema.this.TableSelectionChanged(e);
                }
            }
        });
        this.getTableSchema();
        this.initSchemaColumnSizes(this.Schema_Columns);
        this.defaultCtrlCAction = (Action)this.Schema_Columns.getActionForKeyStroke(this.controlC);
        this.setEditable(false);
        this.initTraceTableJCheckBox();
        this.authority.authorise(this.table_owner, this.table_name);
        this.authority.authoriseOnce();
    }

    @Override
    public int getComponentType() {
        return 201;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.getDefaultTsName();
        this.isReadOnlyTableSpace = this.isReadOnlyTs();
        this.initTSName(this.isReadOnlyTableSpace);
    }

    @Override
    public void grant(boolean enabled) {
        this.Rename_Button.setEnabled(enabled);
        this.Schema_Modify_Button.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReadOnlyTs() {
        Statement stmt = null;
        ResultSet rs = null;
        boolean isReadOnlyTs = true;
        try {
            int type;
            String sql = "select TS_TYPE from SYSTEM.SYSTABLESPACE where TS_NAME = '" + this.dtsName + "'";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next() && ((type = rs.getInt(1)) == 2 || type == 3)) {
                isReadOnlyTs = true;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return isReadOnlyTs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTSName(boolean isReadOnlyTs) {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            sql = isReadOnlyTs ? "select TS_NAME from SYSTEM.SYSTABLESPACE WHERE TS_NAME NOT IN ('SYSTABLESPACE','TMPTABLESPACE')" : "select TS_NAME from SYSTEM.SYSTABLESPACE WHERE TS_NAME NOT IN ('SYSTABLESPACE','TMPTABLESPACE') AND TS_TYPE!=2 AND TS_TYPE!=3";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(sql);
            String tsName = null;
            while (rs.next()) {
                tsName = rs.getString(1).trim();
                this.tsNameComboBox.addItem(tsName);
            }
            if (this.dtsName != null && this.dtsName.length() > 0) {
                this.tsNameComboBox.setSelectedItem(this.dtsName);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDefaultTsName() {
        Statement stmt1 = null;
        ResultSet rs1 = null;
        try {
            String sql1 = "select TS_NAME from SYSTEM.SYSTABLE where TABLE_OWNER = '" + this.table_owner + "' and TABLE_NAME = '" + this.table_name + "'";
            stmt1 = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs1 = stmt1.executeQuery(sql1);
            while (rs1.next()) {
                this.dtsName = rs1.getString(1).trim();
            }
        }
        catch (SQLException e1) {
            GuiUt.showSQLException(DbFrame.frame, "", e1);
            e1.printStackTrace();
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                }
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTraceTableJCheckBox() {
        CallableStatement cstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            cstmt = DbFrame.conn_DatabaseConnection.getDbConnection().prepareCall("{call GETSYSTEMOPTION('lgsvr', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            int lgsvr = JavaTypeUtil.parseInt(cstmt.getString(1), DbFrame.frame);
            if (lgsvr < 4) {
                this.traceTableJCheckBox.setEnabled(false);
                return;
            }
            this.traceTableJCheckBox.setEnabled(true);
            String traceTableSql = "select TBNAME from SYSTEM.SYSTRIGGER where TBOWNER = '" + this.table_owner + "' and TBNAME = '" + this.table_name + "' and RESERVE1 = 1" + " and TRIGNAME like 'AU%'";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(traceTableSql);
            String tbName = null;
            while (rs.next()) {
                tbName = rs.getString(1);
            }
            if (tbName != null) {
                this.traceTableJCheckBox.setSelected(true);
            } else {
                this.traceTableJCheckBox.setSelected(false);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceTableJCheckBoxActionPerformed(ActionEvent e) {
        CallableStatement cstmt = null;
        try {
            cstmt = DbFrame.conn_DatabaseConnection.getDbConnection().prepareCall("{call GETSYSTEMOPTION('lgsvr', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            int lgsvr = JavaTypeUtil.parseInt(cstmt.getString(1), DbFrame.frame);
            if (lgsvr < 4) {
                return;
            }
            String sql = null;
            sql = this.traceTableJCheckBox.isSelected() ? "add trace on " + this.table_owner + "." + this.table_name : "remove trace on " + this.table_owner + "." + this.table_name;
            DatabaseConnection.executeSQL(sql);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void setEditable(boolean editable) {
        if (this.isReadOnlyTableSpace) {
            this.tsNameComboBox.setEnabled(false);
            this.fastCopyCheckBox.setEnabled(false);
        } else {
            this.tsNameComboBox.setEnabled(editable);
            this.fastCopyCheckBox.setEnabled(editable);
        }
        this.Schema_Modify_Button.setEnabled(!editable);
        this.Schema_Confirm_Button.setEnabled(editable);
        this.Schema_Cancel_Button.setEnabled(editable);
        this.Schema_Columns.setForeground(editable ? Color.black : Color.darkGray);
        this.set3SchemaButtons();
        if (!editable) {
            this.Schema_Columns.setSelectionMode(2);
            this.Schema_Columns.getActionMap().put("columnNameCopy", this.ctrlCAction);
            this.Schema_Columns.getInputMap(1).put(this.controlC, "columnNameCopy");
        } else {
            this.Schema_Columns.setSelectionMode(0);
            this.Schema_Columns.getActionMap().put("columnNameCopy", this.defaultCtrlCAction);
            this.Schema_Columns.getInputMap(1).put(this.controlC, "columnNameCopy");
        }
    }

    public void Rename_Button_actionPerformed(ActionEvent e) {
        RenameTableDlg dlg = new RenameTableDlg(this.tableinfo, DbFrame.frame, this.res.getString("Rename_Table"), true, this.table_owner, this.table_name);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.show();
    }

    public void Schema_Modify_Button_actionPerformed(ActionEvent e) {
        this.setEditable(true);
        this.tableinfo.dataPanel.removeAll();
        this.tableinfo.dataPanel.clean();
        this.dropOptions = new int[this.schemaTableModel.getRowCount()];
        this.tableinfo.fixTabbedPanelAt(this.tableinfo.getSelectedIndex());
        this.Schema_Columns.setModel(this.upd_model);
        if (!DbFrame.conn_DatabaseConnection.isDBTDE()) {
            this.Schema_Columns.hideColumn(12);
        }
        this.initUpdSchemaColumns(this.Schema_Columns);
        this.Schema_Columns.setSelectedRow(0);
        this.Schema_Columns.setForeground(Color.darkGray);
        DbFrame.frame.setStatusDisc(this.res.getString("Start_modifying_table"));
    }

    public void Schema_Cancel_Button_actionPerformed(ActionEvent e) {
        if (this.Schema_Columns.isEditing()) {
            this.Schema_Columns.editingStopped(null);
        }
        this.setEditable(false);
        this.tsNameComboBox.setSelectedItem(this.dtsName);
        this.getTableSchema();
        this.Schema_Columns.setModel(this.schemaTableModel);
        if (!DbFrame.conn_DatabaseConnection.isDBTDE()) {
            this.Schema_Columns.hideColumn(SchemaTableModel.ENCRYPT);
        }
        this.initSchemaColumnSizes(this.Schema_Columns);
        this.Schema_Columns.setForeground(Color.darkGray);
        this.tableinfo.releaseTabbedPanel();
        DbFrame.frame.setStatusDisc(this.res.getString("Cancel_modifying"));
    }

    private void getTableSchema() {
        this.tableinfo.isExistSerial = false;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        try {
            this.schemaTableModel.removeAll();
            this.upd_model.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select COLUMN_ORDER, COLUMN_NAME,TYPE_NAME,LENGTH, SCALE,NULLABLE, CONSTR, ASCII_DEF, PRECISION,RESERVE5, BIN_DEF_LEN from SYSTEM.SYSCOLUMN where TABLE_OWNER = '" + GuiUt.singleQuoteHandle(this.table_owner) + "' and TABLE_NAME = '" + GuiUt.singleQuoteHandle(this.table_name) + "' and RESERVE6>0" + " order by COLUMN_ORDER";
            String constraint_String = null;
            String column_name = null;
            String type_name = null;
            String default_value = null;
            int reserve5 = 0;
            int bin_def_len = 0;
            String defaultAttri1 = null;
            String defaultAttri2 = null;
            boolean isTDE = false;
            rs = stmt.executeQuery(query);
            rsmd = rs.getMetaData();
            while (rs.next()) {
                reserve5 = rs.getInt(10);
                defaultAttri1 = (reserve5 & 1) == 0 ? "USER" : "SYSTEM";
                defaultAttri2 = (reserve5 & 2) == 0 ? "" : "ON UPDATE";
                isTDE = (reserve5 & 8) != 0;
                constraint_String = rs.getString(7);
                constraint_String = rs.wasNull() ? "" : constraint_String.trim();
                column_name = rs.getString(2);
                type_name = rs.getString(3).trim();
                if (type_name.equalsIgnoreCase("serial") || type_name.equalsIgnoreCase("bigserial")) {
                    this.tableinfo.isExistSerial = true;
                }
                bin_def_len = rs.getInt(11);
                short nullable = rs.getShort(6);
                if (bin_def_len == -1) {
                    default_value = nullable == 0 ? "" : "NULL";
                } else {
                    default_value = rs.getString(8);
                    if (rs.wasNull()) {
                        default_value = "";
                    } else if ((default_value = default_value.trim()).length() > 0 && default_value.startsWith("'") && default_value.endsWith("'")) {
                        default_value = default_value.substring(1, default_value.length() - 1);
                    }
                }
                int length = type_name.equalsIgnoreCase("DECIMAL") || type_name.equalsIgnoreCase("NCHAR") || type_name.equalsIgnoreCase("NVARCHAR") ? rs.getInt(9) : rs.getInt(4);
                short scale = rs.getShort(5);
                column_name = GuiUt.rightTrim(column_name);
                this.schemaTableModel.addValue(new DBARowInfo(this.getSchemeRowInfo(column_name, type_name, length, scale, nullable, defaultAttri1, default_value, defaultAttri2, constraint_String, false, isTDE)));
                SchemaUpdatableRowInfo upd_row = new SchemaUpdatableRowInfo(column_name, type_name, length, scale, nullable, defaultAttri1, default_value, defaultAttri2, constraint_String, false, isTDE);
                this.upd_model.addValue(upd_row);
            }
            rs.close();
            stmt.close();
            SchemaUpdatableRowInfo upd_row = new SchemaUpdatableRowInfo();
            this.upd_model.addValue(upd_row);
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        int unique = 3;
        this.primarykey.removeAllElements();
        IndexList.getIndexKeys(DbFrame.conn_DatabaseConnection.getDbConnection(), this.primarykey, this.table_owner, this.table_name);
        this.orig_primarykey_str = this.primarykey.toString();
        int num_cols = this.schemaTableModel.getRowCount();
        String name = null;
        for (int i = 0; i < num_cols; ++i) {
            name = this.schemaTableModel.getValueAt(i, SchemaTableModel.NAME).toString();
            if (this.primarykey.indexOf(name) < 0) continue;
            this.schemaTableModel.setValueAt(new Boolean(true), i, SchemaTableModel.PRIMARYKEY);
            this.upd_model.setValueAt(new Boolean(true), i, 6);
        }
        this.Schema_PrimaryKey.setText(this.orig_primarykey_str);
    }

    public void Schema_Up_Button_actionPerformed(ActionEvent e) {
        int goup;
        if (this.Schema_Columns.isEditing()) {
            int edit_row = this.Schema_Columns.getEditingRow();
            this.Schema_Columns.editingStopped(null);
            this.Schema_Columns.setSelectedRow(edit_row);
        }
        if ((goup = this.Schema_Columns.getSelectedRow()) > 0) {
            this.upd_model.switchOrder(goup - 1, goup);
            this.upd_model.fireTableChanged(new TableModelEvent(this.upd_model));
            this.Schema_Columns.setSelectedRow(goup - 1);
        }
    }

    public void Schema_Down_Button_actionPerformed(ActionEvent e) {
        int godown;
        if (this.Schema_Columns.isEditing()) {
            int edit_row = this.Schema_Columns.getEditingRow();
            this.Schema_Columns.editingStopped(null);
            this.Schema_Columns.setSelectedRow(edit_row);
        }
        if ((godown = this.Schema_Columns.getSelectedRow()) < 0) {
            return;
        }
        if (godown < this.upd_model.getRowCount() - 1) {
            this.upd_model.switchOrder(godown, godown + 1);
            this.upd_model.fireTableChanged(new TableModelEvent(this.upd_model));
            this.Schema_Columns.setSelectedRow(godown + 1);
        }
    }

    public void Schema_Del_Button_actionPerformed(ActionEvent e) {
        int row;
        if (this.Schema_Columns.isEditing()) {
            int edit_row = this.Schema_Columns.getEditingRow();
            this.Schema_Columns.editingStopped(null);
            this.Schema_Columns.setSelectedRow(edit_row);
        }
        if ((row = this.Schema_Columns.getSelectedRow()) < 0 || row >= this.Schema_Columns.getRowCount()) {
            DbFrame.frame.setStatusDisc(this.res.getString("No_row_has_been"));
            return;
        }
        String name = (String)this.upd_model.getValueAt(row, 0);
        int index = this.primarykey.indexOf(name);
        if (index >= 0) {
            this.primarykey.removeElementAt(index);
            this.Schema_PrimaryKey.setText(this.primarykey.toString());
        }
        this.upd_model.deleteRow(row);
        int row_count = this.Schema_Columns.getRowCount();
        if (row >= row_count && row_count > 0) {
            row = row_count - 1;
        }
        if (row < row_count) {
            this.Schema_Columns.setSelectedRow(row);
        }
        this.set3SchemaButtons();
    }

    private boolean isReplicationEffected() {
        Statement stmt = null;
        ResultSet rs = null;
        boolean isFound = false;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select REPLICATION_NAME from SYSTEM.SYSPUBLISH where TABLE_OWNER = '" + this.table_owner + "' " + "and TABLE_NAME = '" + this.table_name + "' ";
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                isFound = true;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        return isFound;
    }

    private boolean isDependencyEffected() {
        Statement stmt = null;
        ResultSet rs = null;
        boolean isFound = false;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select DEPEND_ID from SYSTEM.SYSDEPENDS where DEPEND_NAME = '" + this.table_name + "' " + "and DEPEND_OWNER = '" + this.table_owner + "' ";
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                isFound = true;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        return isFound;
    }

    private String getTextIndex(String column_name) {
        Statement stmt = null;
        ResultSet rs = null;
        String s = "";
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "SELECT COLUMN_ORDER FROM SYSTEM.SYSCOLUMN WHERE TABLE_OWNER = '" + this.table_owner + "'" + " and TABLE_NAME = '" + this.table_name + "'" + " and COLUMN_NAME = '" + column_name + "'";
            rs = stmt.executeQuery(query);
            byte column_order = -1;
            while (rs.next()) {
                column_order = rs.getInt(1);
            }
            rs.close();
            query = "select TEXTINDEX_NAME, RESERVE2 from SYSTEM.SYSTEXTINDEX textidx where TABLE_OWNER = '" + this.table_owner + "'" + " and TABLE_NAME = '" + this.table_name + "'";
            rs = stmt.executeQuery(query);
            String index_name = null;
            byte[] reserve_bytes = null;
            int i = 0;
            block3: while (rs.next()) {
                index_name = rs.getString(1).trim();
                reserve_bytes = rs.getBytes(2);
                while (reserve_bytes[i] != 0) {
                    if (reserve_bytes[i] == column_order || reserve_bytes[i] + 128 == column_order) {
                        if (s.length() == 0) {
                            s = index_name;
                            continue block3;
                        }
                        s = s + ", " + index_name;
                        continue block3;
                    }
                    ++i;
                }
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        return s;
    }

    private String getIndex(String column_name) {
        Statement stmt = null;
        ResultSet rs = null;
        String s = "";
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            DatabaseMetaData dbmd = DbFrame.conn_DatabaseConnection.getDbConnection().getMetaData();
            rs = dbmd.getIndexInfo(null, this.table_owner, this.table_name, false, false);
            String in_name = "";
            while (rs.next()) {
                String index_name = rs.getString("INDEX_NAME");
                String col_name = rs.getString("COLUMN_NAME");
                if (col_name == null || !col_name.equalsIgnoreCase(column_name) || in_name.equalsIgnoreCase(index_name)) continue;
                in_name = index_name;
                if (s.length() == 0) {
                    s = in_name;
                    continue;
                }
                s = s + "," + in_name;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        return s;
    }

    public void Schema_Confirm_Button_actionPerformed(ActionEvent e) {
        String msql;
        int result;
        Boolean isTDE;
        String start;
        String constraint;
        String default_attri2;
        String default_attri1;
        String default_value;
        String give_value;
        Boolean nullable;
        String scale;
        String size;
        String name;
        String type;
        int i;
        this.Schema_Columns.editingStopped(null);
        boolean is_repl_effected = this.isReplicationEffected();
        boolean is_depend_effected = this.isDependencyEffected();
        Vector<String> idx_v = new Vector<String>();
        String droppk_query = "";
        if (!this.Schema_PrimaryKey.getText().equals(this.orig_primarykey_str) && this.orig_primarykey_str.length() > 0) {
            droppk_query = "ALTER TABLE \"" + this.table_owner + "\".\"" + this.table_name + "\"" + " DROP PRIMARY KEY";
        }
        Vector<String> addcolumn_order_strs = new Vector<String>();
        StringBuffer addcolumn_query_sb = new StringBuffer();
        int count = this.upd_model.getRowCount();
        String orig_constraint = null;
        for (i = 0; i < count; ++i) {
            type = (String)this.upd_model.getValueAt(i, 1);
            name = (String)this.upd_model.getValueAt(i, 0);
            size = (String)this.upd_model.getValueAt(i, 2);
            scale = (String)this.upd_model.getValueAt(i, 3);
            if (name.length() == 0) continue;
            if ((type.equals("binary") || type.equals("char") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar")) && size.length() == 0) {
                String[] rp = new String[]{GuiUt.getIDString(name), type};
                String s = GuiUt.mapStringForProperty(this.res.getString("Size_cannot_be_empty"), rp);
                GuiUt.showErrorDlg(DbFrame.frame, s, null);
                return;
            }
            if (!type.equals("decimal") || size.length() != 0 && scale.length() != 0) continue;
            String[] rp = new String[]{GuiUt.getIDString(name), type};
            String s = GuiUt.mapStringForProperty(this.res.getString("Size_and_scale_cannot_be_empty"), rp);
            GuiUt.showErrorDlg(DbFrame.frame, s, null);
            return;
        }
        for (i = 0; i < count; ++i) {
            String after;
            String old_name = (String)this.upd_model.getValueAt(i, 13);
            name = (String)this.upd_model.getValueAt(i, 0);
            if (old_name.length() > 0 || name.length() == 0) continue;
            boolean after_old = true;
            String temp = null;
            for (int j = i; j < count; ++j) {
                temp = (String)this.upd_model.getValueAt(j, 13);
                if (temp.length() <= 0) continue;
                after_old = false;
                break;
            }
            type = (String)this.upd_model.getValueAt(i, 1);
            size = (String)this.upd_model.getValueAt(i, 2);
            scale = (String)this.upd_model.getValueAt(i, 3);
            nullable = (Boolean)this.upd_model.getValueAt(i, 4);
            give_value = (String)this.upd_model.getValueAt(i, 5);
            default_value = (String)this.upd_model.getValueAt(i, 8);
            default_attri1 = (String)this.upd_model.getValueAt(i, 7);
            default_attri2 = (String)this.upd_model.getValueAt(i, 9);
            constraint = (String)this.upd_model.getValueAt(i, 10);
            start = (String)this.upd_model.getValueAt(i, 11);
            isTDE = (Boolean)this.upd_model.getValueAt(i, 12);
            if (addcolumn_query_sb.length() == 0) {
                addcolumn_query_sb.append("ALTER TABLE ").append(GuiUt.getIDString(this.table_owner)).append(".").append(GuiUt.getIDString(this.table_name)).append(" ADD ( ").append(GuiUt.getIDString(name)).append(" ");
            } else {
                addcolumn_query_sb.append(", ").append(GuiUt.getIDString(name)).append(" ");
            }
            if (SchemaType.isDomainType(type)) {
                addcolumn_query_sb.append("\"").append(type).append("\"");
            } else {
                addcolumn_query_sb.append(type);
            }
            if (type.equals("binary") || type.equals("char") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar")) {
                addcolumn_query_sb.append(" (").append(size).append(") ");
            } else if (type.equals("decimal")) {
                addcolumn_query_sb.append(" (").append(size).append(",").append(scale.toString()).append(") ");
            } else if (type.equals("serial") || type.equals("bigserial")) {
                if (start.length() > 0) {
                    addcolumn_query_sb.append(" (").append(start).append(") ");
                } else {
                    addcolumn_query_sb.append(" (1) ");
                }
            } else {
                addcolumn_query_sb.append(" ");
            }
            if (!type.equals("serial") && !type.equals("bigserial")) {
                if (nullable.booleanValue()) {
                    addcolumn_query_sb.append("NULL ");
                } else {
                    addcolumn_query_sb.append("NOT NULL ");
                }
            }
            if (default_value.length() > 0) {
                if (default_attri1 == null) {
                    default_attri1 = "USER";
                }
                if (default_attri2 == null) {
                    default_attri2 = "";
                }
                if (this.isNeedQuotes(type, default_value)) {
                    addcolumn_query_sb.append(" ").append(default_attri1).append(" DEFAULT '").append(default_value).append("' ").append(default_attri2).append(" ");
                } else {
                    addcolumn_query_sb.append(" ").append(default_attri1).append(" DEFAULT ").append(default_value).append(" ").append(default_attri2).append(" ");
                }
            }
            if (give_value.length() > 0) {
                if (SchemaType.isNumberType(type)) {
                    addcolumn_query_sb.append("GIVE ").append(give_value).append(" ");
                } else {
                    addcolumn_query_sb.append("GIVE '").append(give_value).append("' ");
                }
            }
            if (constraint.length() > 0) {
                addcolumn_query_sb.append("CHECK ").append(constraint).append(" ");
            }
            if (i > 0 && !after_old) {
                String previous = (String)this.upd_model.getValueAt(i - 1, 0);
                if (previous.length() > 0) {
                    addcolumn_order_strs.addElement(GuiUt.getIDString(name) + " AFTER " + GuiUt.getIDString(previous) + " ");
                }
            } else if (i + 1 < this.upd_model.getRowCount() && !after_old && (after = (String)this.upd_model.getValueAt(i + 1, 0)).length() > 0) {
                addcolumn_order_strs.addElement(GuiUt.getIDString(name) + " BEFORE " + GuiUt.getIDString(after) + " ");
            }
            if (!isTDE.booleanValue()) continue;
            addcolumn_query_sb.append("ENCRYPT ");
        }
        if (addcolumn_query_sb.length() > 0) {
            addcolumn_query_sb.append(")");
        }
        Vector<String> alter_strs = new Vector<String>();
        String dropcolumn_query = "";
        String tempstr2 = null;
        count = this.schemaTableModel.getRowCount();
        for (int i2 = 0; i2 < count; ++i2) {
            String str;
            String orig_name = (String)this.schemaTableModel.getValueAt(i2, SchemaTableModel.NAME);
            int row = this.upd_model.getRowByOrigName(orig_name);
            if (row < 0) {
                dropcolumn_query = dropcolumn_query.length() == 0 ? GuiUt.getIDString(orig_name) : dropcolumn_query + ", " + GuiUt.getIDString(orig_name);
                String tempstr1 = this.getIndex(orig_name);
                if (tempstr1.length() > 0) {
                    tempstr1 = "Index " + tempstr1;
                }
                if ((tempstr2 = this.getTextIndex(orig_name)).length() > 0) {
                    tempstr1 = tempstr1.length() > 0 ? tempstr1 + " and text index " + tempstr2 : "Text index " + tempstr2;
                }
                if (tempstr1.length() <= 0) continue;
                idx_v.addElement(tempstr1 + " " + GuiUt.mapStringForProperty(this.res.getString("will_be_dropped_because_of_drop_column"), orig_name));
                continue;
            }
            String orig_type = (String)this.schemaTableModel.getValueAt(i2, SchemaTableModel.TYPE);
            String orig_size = (String)this.schemaTableModel.getValueAt(i2, SchemaTableModel.SIZE);
            String orig_scale = (String)this.schemaTableModel.getValueAt(i2, SchemaTableModel.SCALE);
            Boolean orig_nullable = (Boolean)this.schemaTableModel.getValueAt(i2, SchemaTableModel.NULLABLE);
            String orig_default_value = (String)this.schemaTableModel.getValueAt(i2, SchemaTableModel.DEFAULT);
            String orig_default_attri1 = (String)this.schemaTableModel.getValueAt(i2, SchemaTableModel.DEFAULTATTRI1);
            String orig_default_attri2 = (String)this.schemaTableModel.getValueAt(i2, SchemaTableModel.DEFAULTATTRI2);
            orig_constraint = (String)this.schemaTableModel.getValueAt(i2, SchemaTableModel.CONSTRAINT);
            Boolean orig_isTDE = (Boolean)this.schemaTableModel.getValueAt(i2, SchemaTableModel.ENCRYPT);
            name = (String)this.upd_model.getValueAt(row, 0);
            type = (String)this.upd_model.getValueAt(row, 1);
            size = (String)this.upd_model.getValueAt(row, 2);
            scale = (String)this.upd_model.getValueAt(row, 3);
            nullable = (Boolean)this.upd_model.getValueAt(row, 4);
            give_value = (String)this.upd_model.getValueAt(row, 5);
            default_value = (String)this.upd_model.getValueAt(row, 8);
            constraint = (String)this.upd_model.getValueAt(row, 10);
            start = (String)this.upd_model.getValueAt(row, 11);
            default_attri1 = (String)this.upd_model.getValueAt(row, 7);
            default_attri2 = (String)this.upd_model.getValueAt(row, 9);
            isTDE = (Boolean)this.upd_model.getValueAt(i2, 12);
            if (!name.equals(orig_name)) {
                alter_strs.addElement(GuiUt.getIDString(orig_name) + " NAME TO " + GuiUt.getIDString(name));
            }
            if (!(type.equals(orig_type) && size.equals(orig_size) && scale.equals(orig_scale) && start.length() <= 0)) {
                str = "";
                str = SchemaType.isDomainType(type) ? GuiUt.getIDString(orig_name) + " TYPE TO \"" + type + "\"" : GuiUt.getIDString(orig_name) + " TYPE TO " + type;
                if (type.equals("binary") || type.equals("char") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar")) {
                    str = str + "(" + size + ")";
                } else if (type.equals("decimal")) {
                    str = str + "(" + size + "," + scale + ")";
                } else if (type.equals("serial") || type.equals("bigserial")) {
                    str = start.length() > 0 ? str + "(" + start + ")" : str + "(1)";
                }
                alter_strs.addElement(str);
            }
            if (!(nullable.equals(orig_nullable) || type.equals("serial") || type.equals("bigserial"))) {
                str = "";
                str = nullable != false ? GuiUt.getIDString(orig_name) + " NOT NULL TO NULL" : GuiUt.getIDString(orig_name) + " NULL TO NOT NULL";
                if (give_value.length() > 0) {
                    str = SchemaType.isNumberType(type) ? str + " GIVE " + give_value : str + " GIVE '" + give_value + "'";
                }
                alter_strs.addElement(str);
            }
            if (!default_value.equals(orig_default_value) || default_attri1 != orig_default_attri1 || default_attri2 != orig_default_attri2) {
                str = "";
                if (default_value.length() > 0) {
                    if (default_attri1 == null) {
                        default_attri1 = "USER";
                    }
                    if (default_attri2 == null) {
                        default_attri2 = "";
                    }
                    str = this.isNeedQuotes(type, default_value) ? GuiUt.getIDString(orig_name) + " DEFAULT TO " + default_attri1 + " '" + default_value + "'" + " " + default_attri2 : GuiUt.getIDString(orig_name) + " DEFAULT TO " + default_attri1 + " " + default_value + " " + default_attri2;
                } else {
                    str = GuiUt.getIDString(orig_name) + " DROP DEFAULT";
                }
                alter_strs.addElement(str);
            }
            if (!constraint.equals(orig_constraint)) {
                str = "";
                str = constraint.length() > 0 ? GuiUt.getIDString(orig_name) + " CONSTRAINT TO CHECK " + constraint : GuiUt.getIDString(orig_name) + " DROP CONSTRAINT";
                alter_strs.addElement(str);
            }
            if (!isTDE.equals(orig_isTDE)) {
                str = "";
                str = isTDE != false ? GuiUt.getIDString(orig_name) + " ENCRYPT" : GuiUt.getIDString(orig_name) + " DECRYPT";
                alter_strs.addElement(str);
            }
            if (row == i2) continue;
            str = "";
            if (row == 0 && row + 1 < this.upd_model.getRowCount()) {
                String after = (String)this.upd_model.getValueAt(row + 1, 0);
                if (after.length() <= 0) continue;
                str = GuiUt.getIDString(orig_name) + " BEFORE \"" + after + "\"";
                alter_strs.addElement(str);
                continue;
            }
            String previous = (String)this.upd_model.getValueAt(row - 1, 0);
            if (previous.length() <= 0) continue;
            str = GuiUt.getIDString(orig_name) + " AFTER \"" + previous + "\"";
            alter_strs.addElement(str);
        }
        alter_strs.addAll(addcolumn_order_strs);
        StringBuffer modifycolumn_query_sb = new StringBuffer();
        count = alter_strs.size();
        if (count > 0) {
            modifycolumn_query_sb.append("ALTER TABLE \"").append(this.table_owner).append("\".\"").append(this.table_name).append("\" MODIFY ( ").append((String)alter_strs.elementAt(0));
        }
        for (int i3 = 1; i3 < count; ++i3) {
            modifycolumn_query_sb.append(", ").append((String)alter_strs.elementAt(i3));
        }
        if (dropcolumn_query.length() > 0) {
            String[] optionStr = new String[]{"", "RESTRICT", "CASCADE"};
            String msg = this.res.getString("confirm_delete_column");
            MessageFormat mf = new MessageFormat(msg);
            String fmsg = mf.format(new String[]{dropcolumn_query});
            int[] option = new int[1];
            int reply = GuiUt.showDropOptionsDlg(DbFrame.frame, this.res.getString("delete_column"), fmsg, option);
            if (reply != 0) {
                return;
            }
            dropcolumn_query = "ALTER TABLE " + GuiUt.getIDString(this.table_owner) + "." + GuiUt.getIDString(this.table_name) + " DROP ( " + dropcolumn_query + ") " + optionStr[option[0]];
        }
        if (modifycolumn_query_sb.length() > 0) {
            modifycolumn_query_sb.append(" )");
        }
        String createpk_query = "";
        if (!this.Schema_PrimaryKey.getText().equals(this.orig_primarykey_str) && this.Schema_PrimaryKey.getText().length() > 0) {
            createpk_query = "ALTER TABLE \"" + this.table_owner + "\".\"" + this.table_name + "\"" + " PRIMARY KEY (" + this.primarykey.toSQLString() + ")";
        }
        StringBuffer query_sb = new StringBuffer();
        StringBuffer warning_sb = new StringBuffer();
        if (droppk_query.length() > 0) {
            query_sb.append(droppk_query).append(";\n");
        }
        if (dropcolumn_query.length() > 0) {
            query_sb.append(dropcolumn_query).append(";\n");
            int v_size = idx_v.size();
            if (v_size > 0) {
                for (int i4 = 0; i4 < v_size; ++i4) {
                    warning_sb.append((String)idx_v.elementAt(i4)).append(".  ");
                }
            }
        }
        if (addcolumn_query_sb.length() > 0) {
            query_sb.append(addcolumn_query_sb.toString()).append(";\n");
        }
        if (modifycolumn_query_sb.length() > 0) {
            query_sb.append(modifycolumn_query_sb.toString()).append(";\n");
        }
        if (createpk_query.length() > 0) {
            query_sb.append(createpk_query).append(";\n");
        }
        if (is_repl_effected) {
            if (dropcolumn_query.length() > 0) {
                if (modifycolumn_query_sb.length() > 0) {
                    warning_sb.append(this.res.getString("Replication_will_be_dropped1") + "  ");
                } else {
                    warning_sb.append(this.res.getString("Replication_will_be_dropped2") + "  ");
                }
            } else if (modifycolumn_query_sb.length() > 0) {
                warning_sb.append(this.res.getString("Replication_will_be_dropped3") + "  ");
            }
        }
        if (is_depend_effected) {
            if (dropcolumn_query.length() > 0) {
                if (modifycolumn_query_sb.length() > 0) {
                    warning_sb.append(this.res.getString("View_storedcommand_trigger_foriegnkey_will_become_invalid1") + "  ");
                } else {
                    warning_sb.append(this.res.getString("View_storedcommand_trigger_foriegnkey_will_become_invalid2") + "  ");
                }
            } else if (modifycolumn_query_sb.length() > 0) {
                warning_sb.append(this.res.getString("View_storedcommand_trigger_foriegnkey_will_become_invalid3") + "  ");
            }
        }
        if (warning_sb.length() > 0 && (result = GuiUt.showOptionDlg(DbFrame.frame, this.res.getString("Alter_table_warning"), warning_sb.toString())) == 1) {
            return;
        }
        if (query_sb.length() > 0 && !(result = DatabaseConnection.executeMultiSQL(query_sb.toString()))) {
            return;
        }
        Connection dbconn = DbFrame.conn_DatabaseConnection.getDbConnection();
        try {
            if (this.fastCopyCheckBox.isSelected()) {
                ((JdbcOdbcConnection)dbconn).setOption(1441, 1);
            } else {
                ((JdbcOdbcConnection)dbconn).setOption(1441, 0);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        String tsName = (String)this.tsNameComboBox.getSelectedItem();
        if (tsName != null && !tsName.equals(this.dtsName) && DatabaseConnection.executeSQL(msql = "alter table " + GuiUt.getIDString(this.table_owner) + "." + GuiUt.getIDString(this.table_name) + " move tablespace " + GuiUt.getIDString(tsName))) {
            this.dtsName = tsName;
        }
        this.Schema_Cancel_Button_actionPerformed(null);
        this.tableinfo.dependGraphPanel.removeAll();
        this.tableinfo.permissionPanel.removeAll();
        this.tableinfo.statisticsPanel.removeAll();
    }

    private boolean isDate(String str) {
        boolean flag = true;
        try {
            DateFormat.getDateTimeInstance().parse(str);
        }
        catch (ParseException e) {
            flag = false;
        }
        return flag;
    }

    private boolean isNeedQuotes(String type, String default_value) {
        return (SchemaType.isCharType(type) || SchemaType.isDateTimeType(type) && this.isDate(default_value)) && default_value.indexOf("'") < 0 && default_value.indexOf(40) < 0;
    }

    private void set3SchemaButtons() {
        int row = this.Schema_Columns.getSelectedRow();
        int rowcount = this.Schema_Columns.getRowCount();
        if (this.Schema_Modify_Button.isEnabled() || this.Schema_Columns.getSelectionModel().isSelectionEmpty()) {
            this.Schema_Del_Button.setEnabled(false);
            this.Schema_Up_Button.setEnabled(false);
            this.Schema_Down_Button.setEnabled(false);
        } else {
            this.Schema_Del_Button.setEnabled(row >= 0 && row < rowcount);
            this.Schema_Up_Button.setEnabled(row > 0 && row < rowcount);
            this.Schema_Down_Button.setEnabled(row >= 0 && row + 1 < rowcount);
        }
    }

    void TableSelectionChanged(ListSelectionEvent e) {
        this.set3SchemaButtons();
        int[] rows = this.Schema_Columns.getSelectedRows();
        int[] cols = this.Schema_Columns.getSelectedColumns();
        this.selectedCells.removeAllElements();
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                this.selectedCells.add(new int[]{rows[i], cols[j]});
            }
        }
        int row = this.Schema_Columns.getSelectedRow();
        int col = this.Schema_Columns.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row >= this.Schema_Columns.getRowCount() || col >= this.Schema_Columns.getColumnCount()) {
            return;
        }
        this.Schema_Columns.editCellAt(row, col);
    }

    private void initUpdSchemaColumns(JTable table) {
        TableColumn column = null;
        DefaultTableCellRenderer renderer = null;
        int[] size = new int[]{100, 100, 60, 40, 60, 40, 60, 100, 60, 120, 120, 60, 60};
        int[] align = new int[]{2, 2, 4, 4, 0, 2, 0, 0, 2, 0, 2, 2, 0};
        for (int i = 0; i < size.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(size[i]);
            if (i == 4 || i == 12) {
                column.setCellEditor(new BooleanEditor(this.Schema_Columns, this.upd_model));
                renderer = new BooleanRenderer();
            } else if (i == 6) {
                column.setCellEditor(new PrimaryKeyEditor(this.Schema_Columns, this.upd_model));
                renderer = new PrimaryKeyRenderer();
            } else {
                renderer = new DefaultTableCellRenderer();
            }
            renderer.setToolTipText(table.getColumnName(i));
            renderer.setHorizontalAlignment(align[i]);
            column.setCellRenderer(renderer);
            column.setHeaderRenderer(new TableHeaderRenderer());
        }
        this.setUpSchemaEditor();
    }

    private void initSchemaColumnSizes(JTable table) {
        TableColumn column = null;
        DefaultTableCellRenderer renderer = null;
        int[] size = new int[]{100, 100, 60, 40, 60, 60, 100, 60, 100, 160, 60};
        int[] align = new int[]{2, 2, 4, 4, 0, 0, 0, 2, 0, 2, 0};
        for (int i = 0; i < size.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(size[i]);
            renderer = i == 4 || i == 10 ? new BooleanRenderer() : (i == 5 ? new PrimaryKeyRenderer() : new DefaultTableCellRenderer());
            renderer.setToolTipText(table.getColumnName(i));
            renderer.setHorizontalAlignment(align[i]);
            column.setCellRenderer(renderer);
            column.setHeaderRenderer(new TableHeaderRenderer());
        }
    }

    private void setUpSchemaEditor() {
        this.Schema_Columns.setUpCharEditor(0, new CharField(128, true));
        this.setUpSchemaSizeEditor();
        this.setUpSchemaScaleEditor();
        this.setUpSchemaTypeEditor();
        this.setUpSchemaDefaultEditor();
        this.setUpSchemaDefaultAttri1Editor();
        this.setUpSchemaDefaultAttri2Editor();
        if (DbFrame.frame.px.getPopupConstraintEditor()) {
            this.setUpConstraintEditor();
        }
    }

    private Object[] getSchemeRowInfo(String name, String orig_type, int size, short scale, short nullable, String defaultAttri1, String default_value, String defaultAttri2, String constraint, boolean primaryKey, boolean isTDE) {
        String type = orig_type.toLowerCase();
        Object[] data = new Object[11];
        data[SchemaTableModel.NAME] = name;
        data[SchemaTableModel.TYPE] = type;
        if (!default_value.isEmpty()) {
            data[SchemaTableModel.DEFAULTATTRI1] = defaultAttri1;
            data[SchemaTableModel.DEFAULTATTRI2] = defaultAttri2;
        }
        data[SchemaTableModel.SIZE] = type.equals("binary") || type.equals("char") || type.equals("decimal") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar") ? Integer.toString(size) : new String("");
        data[SchemaTableModel.SCALE] = type.equals("decimal") ? Integer.toString(scale) : new String("");
        data[SchemaTableModel.NULLABLE] = nullable == 0 ? new Boolean(false) : new Boolean(true);
        data[SchemaTableModel.PRIMARYKEY] = new Boolean(primaryKey);
        data[SchemaTableModel.DEFAULT] = default_value;
        data[SchemaTableModel.CONSTRAINT] = constraint;
        data[SchemaTableModel.ENCRYPT] = isTDE;
        return data;
    }

    private void setUpSchemaDefaultEditor() {
        final ColumnTextField field = new ColumnTextField();
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return new String(field.getValue());
            }
        };
        TableColumn column = this.Schema_Columns.getColumnModel().getColumn(8);
        column.setCellEditor(editor);
    }

    private void setUpSchemaTypeEditor() {
        TableColumn column = this.Schema_Columns.getColumnModel().getColumn(1);
        SchemaType schemaTypeComboBox = new SchemaType();
        column.setCellEditor(new DefaultCellEditor(schemaTypeComboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(this.res.getString("Type"));
        column.setCellRenderer(renderer);
    }

    private void setUpSchemaDefaultAttri1Editor() {
        TableColumn column = this.Schema_Columns.getColumnModel().getColumn(7);
        SchemaDefaultAttri1 schemaDefaultAttri1ComboBox = new SchemaDefaultAttri1();
        column.setCellEditor(new DefaultCellEditor(schemaDefaultAttri1ComboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(this.res.getString("Default_Attri1"));
        column.setCellRenderer(renderer);
    }

    private void setUpSchemaDefaultAttri2Editor() {
        TableColumn column = this.Schema_Columns.getColumnModel().getColumn(9);
        SchemaDefaultAttri2 schemaDefaultAttri2ComboBox = new SchemaDefaultAttri2();
        column.setCellEditor(new DefaultCellEditor(schemaDefaultAttri2ComboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(this.res.getString("Default_Attri2"));
        column.setCellRenderer(renderer);
    }

    private void setUpConstraintEditor() {
        ConstraintEditor constraintEditor = new ConstraintEditor(new JButton());
        TableColumn column = this.Schema_Columns.getColumnModel().getColumn(10);
        column.setCellEditor(constraintEditor);
    }

    private void setUpSchemaSizeEditor() {
        this.Schema_Columns.setUpIntegerEditorStr(2, new IntegerField(4, true, true));
    }

    private void setUpSchemaScaleEditor() {
        this.Schema_Columns.setUpShortEditorStr(3, new SmallintField(true));
    }
}

