/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import dbatool.DbFrame;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.SteppedComboBox;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class SchemaType
extends SteppedComboBox {
    public SchemaType() {
        Vector v = SchemaType.getBasicTypes();
        v.addAll(this.getDomainTypes());
        DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
        this.setModel((ComboBoxModel)cbm);
    }

    public static Vector getBasicTypes() {
        Vector<String> v = new Vector<String>(22);
        v.add("binary");
        v.add("char");
        v.add("date");
        v.add("decimal");
        v.add("double");
        v.add("float");
        v.add("file");
        v.add("real");
        v.add("integer");
        v.add("bigint");
        v.add("long varbinary");
        v.add("long varchar");
        v.add("oid");
        v.add("serial");
        v.add("bigserial");
        v.add("smallint");
        v.add("time");
        v.add("timestamp");
        v.add("varchar");
        v.add("blob");
        v.add("clob");
        v.add("nchar");
        v.add("nvarchar");
        v.add("nclob");
        return v;
    }

    private Vector getDomainTypes() {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> v = new Vector<String>();
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select DOMAIN_NAME from SYSTEM.SYSDOMAIN  order by DOMAIN_OWNER, DOMAIN_NAME ";
            rs = stmt.executeQuery(query);
            String name = "";
            while (rs.next()) {
                name = rs.getString(1);
                v.add(name.trim());
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        return v;
    }

    public static boolean isDomainType(String type) {
        return !type.equalsIgnoreCase("BINARY") && !type.equalsIgnoreCase("CHAR") && !type.equalsIgnoreCase("DATE") && !type.equalsIgnoreCase("DECIMAL") && !type.equalsIgnoreCase("DOUBLE") && !type.equalsIgnoreCase("FILE") && !type.equalsIgnoreCase("REAL") && !type.equalsIgnoreCase("CHAR") && !type.equalsIgnoreCase("INTEGER") && !type.equalsIgnoreCase("BIGINT") && !type.equalsIgnoreCase("FLOAT") && !type.equalsIgnoreCase("LONG VARBINARY") && !type.equalsIgnoreCase("LONG VARCHAR") && !type.equalsIgnoreCase("OID") && !type.equalsIgnoreCase("SERIAL") && !type.equalsIgnoreCase("BIGSERIAL") && !type.equalsIgnoreCase("SMALLINT") && !type.equalsIgnoreCase("TIME") && !type.equalsIgnoreCase("TIMESTAMP") && !type.equalsIgnoreCase("VARCHAR") && !type.equalsIgnoreCase("BLOB") && !type.equalsIgnoreCase("CLOB") && !type.equalsIgnoreCase("NCLOB") && !type.equalsIgnoreCase("NCHAR") && !type.equalsIgnoreCase("NVARCHAR") && !type.equalsIgnoreCase("LONGVARBINARY") && !type.equalsIgnoreCase("LONGVARCHAR") && !type.equalsIgnoreCase("JSONCOLS");
    }

    public static boolean isBlobType(String s) {
        String type = s;
        if (SchemaType.isDomainType(s)) {
            type = SchemaType.getDomainType(s);
        }
        return type.equalsIgnoreCase("LONG VARBINARY") || type.equalsIgnoreCase("LONGVARBINARY") || type.equalsIgnoreCase("LONG VARCHAR") || type.equalsIgnoreCase("LONGVARCHAR") || type.equalsIgnoreCase("FILE") || type.equalsIgnoreCase("NCLOB") || type.equalsIgnoreCase("CLOB") || type.equalsIgnoreCase("BLOB") || type.equalsIgnoreCase("JSONCOLS");
    }

    public static String getDomainType(String type) {
        if (!SchemaType.isDomainType(type)) {
            return type;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TYPE_NAME from SYSTEM.SYSDOMAIN  where DOMAIN_NAME = '" + type.toUpperCase() + "'";
            rs = stmt.executeQuery(query);
            String type_name = "";
            while (rs.next()) {
                type_name = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
            return type_name;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            return type;
        }
    }

    public static boolean isCharType(String type) {
        if (type.equalsIgnoreCase("CHAR") || type.equalsIgnoreCase("VARCHAR") || type.equalsIgnoreCase("LONG VARBINARY") || type.equalsIgnoreCase("LONG VARCHAR") || type.equalsIgnoreCase("NCHAR") || type.equalsIgnoreCase("NVARCHAR") || type.equalsIgnoreCase("NCLOB") || type.equalsIgnoreCase("CLOB") || type.equalsIgnoreCase("BLOB")) {
            return true;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TYPE_NAME from SYSTEM.SYSDOMAIN  where DOMAIN_NAME = '" + type + "'";
            rs = stmt.executeQuery(query);
            String type_name = "";
            while (rs.next()) {
                type_name = rs.getString(1);
                type_name = type_name.trim();
            }
            rs.close();
            stmt.close();
            return type_name.equalsIgnoreCase("CHAR") || type_name.equalsIgnoreCase("VARCHAR") || type_name.equalsIgnoreCase("LONG VARBINARY") || type_name.equalsIgnoreCase("LONG VARCHAR") || type_name.equalsIgnoreCase("NCHAR") || type_name.equalsIgnoreCase("NVARCHAR") || type_name.equalsIgnoreCase("CLOB") || type_name.equalsIgnoreCase("BLOB") || type_name.equalsIgnoreCase("NCLOB");
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            return false;
        }
    }

    public static boolean isNumberType(String type) {
        if (type.equalsIgnoreCase("DECIMAL") || type.equalsIgnoreCase("DOUBLE") || type.equalsIgnoreCase("REAL") || type.equalsIgnoreCase("INTEGER") || type.equalsIgnoreCase("BIGINT") || type.equalsIgnoreCase("SERIAL") || type.equalsIgnoreCase("BIGSERIAL") || type.equalsIgnoreCase("SMALLINT")) {
            return true;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TYPE_NAME from SYSTEM.SYSDOMAIN  where DOMAIN_NAME = '" + type + "'";
            rs = stmt.executeQuery(query);
            String type_name = "";
            while (rs.next()) {
                type_name = rs.getString(1);
                type_name = type_name.trim();
            }
            rs.close();
            stmt.close();
            return type_name.equalsIgnoreCase("DECIMAL") || type_name.equalsIgnoreCase("DOUBLE") || type_name.equalsIgnoreCase("REAL") || type_name.equalsIgnoreCase("INTEGER") || type_name.equalsIgnoreCase("BIGINT") || type_name.equalsIgnoreCase("SERIAL") || type_name.equalsIgnoreCase("BIGSERIAL") || type_name.equalsIgnoreCase("SMALLINT");
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            return false;
        }
    }

    public static boolean isDateTimeType(String type) {
        if (type.equalsIgnoreCase("DATE") || type.equalsIgnoreCase("TIME") || type.equalsIgnoreCase("TIMESTAMP")) {
            return true;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TYPE_NAME from SYSTEM.SYSDOMAIN  where DOMAIN_NAME = '" + type + "'";
            rs = stmt.executeQuery(query);
            String type_name = "";
            while (rs.next()) {
                type_name = rs.getString(1);
                type_name = type_name.trim();
            }
            rs.close();
            stmt.close();
            return type_name.equalsIgnoreCase("DATE") || type_name.equalsIgnoreCase("TIME") || type_name.equalsIgnoreCase("TIMESTAMP");
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            return false;
        }
    }
}

