/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import dbatool.DbFrame;
import dbatool.Table.LinePanel;
import dbatool.Table.ResizableBorder;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class Resizable
extends JComponent {
    public static final int MIDDLE = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    private int panelLocation;
    private ResizableBorder border;
    private String[] fk;
    private int pkCount;
    private ArrayList<Vector> tableColumns;
    private ArrayList<Resizable> rect;
    private JLabel stretch = new JLabel("", 0);
    private LinePanel linePanel;
    private Map<String, Line2D.Float> saveLine;
    private DBAResourceBundle res = null;
    private static Point middleRectStart = null;
    private static Point middleRectEnd = null;
    private String msg;
    private MouseInputListener resizeListener = new MouseInputAdapter(){
        private int cursor;
        private Point startPos = null;
        private int w = 0;
        private int h = 0;

        @Override
        public void mouseMoved(MouseEvent me) {
            if (Resizable.this.hasFocus()) {
                ResizableBorder border = (ResizableBorder)Resizable.this.getBorder();
                Resizable.this.setCursor(Cursor.getPredefinedCursor(border.getCursor(me)));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Resizable.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mousePressed(MouseEvent me) {
            ResizableBorder border = (ResizableBorder)Resizable.this.getBorder();
            this.cursor = border.getCursor(me);
            this.startPos = me.getPoint();
            Resizable.this.requestFocus();
            Resizable.this.MousePress();
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            Resizable.this.requestFocus();
            if (this.startPos != null) {
                int x = Resizable.this.getX();
                int y = Resizable.this.getY();
                int w = Resizable.this.getWidth();
                int h = Resizable.this.getHeight();
                int dx = me.getX() - this.startPos.x;
                int dy = me.getY() - this.startPos.y;
                switch (this.cursor) {
                    case 8: {
                        if (h - dy < 60) break;
                        Resizable.this.setBounds(x, y + dy, w, h - dy);
                        Resizable.this.resize();
                        break;
                    }
                    case 9: {
                        if (h + dy < 60) break;
                        Resizable.this.setBounds(x, y, w, h + dy);
                        this.startPos = me.getPoint();
                        Resizable.this.resize();
                        break;
                    }
                    case 10: {
                        if (w - dx < 60) break;
                        Resizable.this.setBounds(x + dx, y, w - dx, h);
                        Resizable.this.resize();
                        break;
                    }
                    case 11: {
                        if (w + dx < 60) break;
                        Resizable.this.setBounds(x, y, w + dx, h);
                        this.startPos = me.getPoint();
                        Resizable.this.resize();
                        break;
                    }
                    case 6: {
                        if (w - dx < 60 || h - dy < 60) break;
                        Resizable.this.setBounds(x + dx, y + dy, w - dx, h - dy);
                        Resizable.this.resize();
                        break;
                    }
                    case 7: {
                        if (w + dx < 60 || h - dy < 60) break;
                        Resizable.this.setBounds(x, y + dy, w + dx, h - dy);
                        this.startPos = new Point(me.getX(), this.startPos.y);
                        Resizable.this.resize();
                        break;
                    }
                    case 4: {
                        if (w - dx < 60 || h + dy < 60) break;
                        Resizable.this.setBounds(x + dx, y, w - dx, h + dy);
                        this.startPos = new Point(this.startPos.x, me.getY());
                        Resizable.this.resize();
                        break;
                    }
                    case 5: {
                        if (w + dx < 60 || h + dy < 60) break;
                        Resizable.this.setBounds(x, y, w + dx, h + dy);
                        this.startPos = me.getPoint();
                        Resizable.this.resize();
                        break;
                    }
                    case 13: {
                        Rectangle bounds = Resizable.this.getBounds();
                        bounds.translate(dx, dy);
                        Resizable.this.setBounds(bounds);
                        Resizable.this.resize();
                    }
                }
                Resizable.this.setCursor(Cursor.getPredefinedCursor(this.cursor));
            }
            int dw = Resizable.this.getWidth() - this.w;
            int dh = Resizable.this.getHeight() - this.h;
            if (Resizable.this.getX() < 0 && Resizable.this.getY() < 0) {
                this.w = Resizable.this.getWidth() - dw;
                this.h = Resizable.this.getHeight() - dh;
                Resizable.this.setBounds(2, 10, this.w, this.h);
            } else if (Resizable.this.getX() < 0) {
                this.w = Resizable.this.getWidth() - dw;
                this.h = Resizable.this.getHeight() - dh;
                Resizable.this.setBounds(2, Resizable.this.getY(), this.w, this.h);
            } else if (Resizable.this.getY() < 0) {
                this.w = Resizable.this.getWidth() - dw;
                this.h = Resizable.this.getHeight() - dh;
                Resizable.this.setBounds(Resizable.this.getX(), 10, this.w, this.h);
            }
            this.w = Resizable.this.getWidth();
            this.h = Resizable.this.getHeight();
            Resizable.this.MouseDrag();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.startPos = null;
        }
    };

    public LinePanel getLinePanel() {
        return this.linePanel;
    }

    public int getPanelLocation() {
        return this.panelLocation;
    }

    public String[] getFk() {
        return this.fk;
    }

    public Resizable(String[] fk, Component comp, int location, ArrayList<Resizable> rect, ArrayList<Vector> tableColumns, DBAResourceBundle res, Map<String, Line2D.Float> saveLine, int pkCount) {
        this(comp);
        this.panelLocation = location;
        this.rect = rect;
        this.fk = fk;
        this.tableColumns = tableColumns;
        this.res = res;
        this.saveLine = saveLine;
        this.pkCount = pkCount;
    }

    public Resizable(Component comp) {
        this.border = new ResizableBorder(8);
        this.linePanel = new LinePanel();
        this.linePanel.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.stretch.setFont(new Font("Dialog", 1, 15));
        this.stretch.setOpaque(true);
        this.stretch.setBackground(Color.WHITE);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(comp);
        jp.add((Component)this.stretch, "South");
        this.add(jp);
        jp.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.drawRect(x, y, width - 1, height - 1);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(2, 2, 1, 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        });
        JScrollPane js = (JScrollPane)comp;
        JPanel j = (JPanel)js.getViewport().getComponent(0);
        for (Component c : j.getComponents()) {
            c.addMouseListener(this.resizeListener);
            c.addMouseMotionListener(this.resizeListener);
        }
        this.addMouseListener(this.resizeListener);
        this.addMouseMotionListener(this.resizeListener);
        this.setBorder(this.border);
    }

    private void resize() {
        if (this.getParent() != null) {
            ((JComponent)this.getParent()).revalidate();
        }
        this.repaint();
    }

    public void MousePress() {
        for (int i = 0; i < this.rect.size(); ++i) {
            Resizable r = this.rect.get(i);
            if (!r.equals(this)) continue;
            this.rect.remove(r);
        }
        this.rect.add(this);
        this.repaint();
    }

    public void MouseDrag() {
        if (this.getPanelLocation() == 1) {
            middleRectEnd = new Point((int)this.getLocation().getX() + this.getWidth() - 8, (int)this.getLocation().getY() + 18);
            middleRectStart = new Point((int)this.getLocation().getX() + 8, (int)this.getLocation().getY() + 38);
            for (int i = 0; i < this.rect.size() - 1; ++i) {
                this.resetLinePanel(this.rect.get(i));
            }
            return;
        }
        this.resetLinePanel(this);
    }

    private void resetLinePanel(Resizable r) {
        String pkCol;
        String fkCol;
        String[] fk = r.getFk();
        String fkName = fk[0];
        if (fkName.length() > 32) {
            fkName = fkName.substring(0, 32) + "...";
        }
        if ((fkCol = fk[1]).length() > 32) {
            fkCol = fkCol.substring(0, 32) + "...";
        }
        if ((pkCol = fk[2]).length() > 32) {
            pkCol = pkCol.substring(0, 32) + "...";
        }
        String upd_act = fk[3];
        String del_act = fk[4];
        this.msg = r.getName().length() + "_" + r.getPanelLocation() + r.getName() + this.res.getString("Name") + " :" + fkName + "<br>" + this.res.getString("Type") + " :" + this.res.getString("Foreign_Keys") + "<br>" + this.res.getString("Referenced_Columns") + fkCol + "--->" + pkCol + "<br>" + DbFrame.frame.res.getString("Update_Action") + ": " + upd_act + "<br>" + DbFrame.frame.res.getString("Delete_Action") + ": " + del_act;
        if (r.getPanelLocation() == 2) {
            Point rightRectStart = new Point((int)r.getLocation().getX() + 8, (int)r.getLocation().getY() + 38);
            this.setLinePanelBound(middleRectEnd, rightRectStart, r);
            this.drawLineInfo(middleRectEnd, rightRectStart, this.msg);
        } else if (r.getPanelLocation() == 3) {
            Point leftRectEnd = new Point((int)r.getLocation().getX() + r.getWidth() - 8, (int)r.getLocation().getY() + 18);
            this.setLinePanelBound(leftRectEnd, middleRectStart, r);
            this.drawLineInfo(leftRectEnd, middleRectStart, this.msg);
        }
    }

    public void setLinePanelBound(Point p1, Point p2, Resizable r) {
        int x1 = p1.x;
        int y1 = p1.y;
        int x2 = p2.x;
        int y2 = p2.y;
        if (x1 >= x2 && y1 <= y2) {
            r.getLinePanel().setLineDirection(1);
            r.getLinePanel().setBounds(x2 - 3, y1 - 3, x1 - x2 + 6, y2 - y1 + 6);
        } else if (x1 <= x2 && y1 <= y2) {
            r.getLinePanel().setLineDirection(2);
            r.getLinePanel().setBounds(x1 - 3, y1 - 3, x2 - x1 + 6, y2 - y1 + 6);
        } else if (x1 <= x2 && y1 >= y2) {
            r.getLinePanel().setLineDirection(3);
            r.getLinePanel().setBounds(x1 - 3, y2 - 3, x2 - x1 + 6, y1 - y2 + 6);
        } else if (x1 >= x2 && y1 >= y2) {
            r.getLinePanel().setLineDirection(4);
            r.getLinePanel().setBounds(x2 - 3, y2 - 3, x1 - x2 + 6, y1 - y2 + 6);
        }
    }

    private void drawLineInfo(Point point1, Point point2, String message) {
        Line2D.Float line = new Line2D.Float(point1, point2);
        this.saveLine.put(message, line);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.panelLocation == 1) {
            for (Resizable res : this.rect) {
                if (res.getPanelLocation() != 2) continue;
                Graphics2D g2D = (Graphics2D)g;
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fillOval(this.getWidth() - 11, 15, 6, 6);
                break;
            }
        }
        g.drawLine(10, 30, this.getWidth() - 10, 30);
        if (this.pkCount > 0 && this.getHeight() > this.pkCount * 20 + 60) {
            g.setColor(Color.GRAY);
            g.drawLine(10, this.pkCount * 20 + 30, this.getWidth() - 10, this.pkCount * 20 + 30);
        }
        if (this.tableColumns.size() * 20 + 20 + 10 + 10 > this.getHeight()) {
            this.stretch.setText("...");
        } else {
            this.stretch.setText("");
        }
    }
}

