/*
 * Decompiled with CFR 0.152.
 */
package dbatool.StoredCommand;

import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.StoredCommand.CommandPermissionRowInfo;
import dbatool.StoredCommand.CommandPermissionTableModel;
import dbatool.StoredCommand.ExecuteCommand;
import dbatool.Table.UserGroupRenderer;
import dbatool.tableCell.BooleanEditor;
import dbatool.tableCell.BooleanRenderer;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.editorPanel.SQLTextPane;
import dbaut.resource.DBAImageResource;
import dbaut.text.TextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class StoredCommandInfo
extends DbaTabbedPane
implements ComponentPrivilege {
    private String modulename;
    private String owner;
    private String name;
    private String sc_def;
    private int num_parm;
    private DbaButton Cancel_Button;
    private DbaButton Confirm_Button;
    private DbaButton Modify_Button;
    private DbaButton rebuildButton;
    private DbaButton Execute_Button;
    private CommandPermissionTableModel model;
    private DBAToolAbstractTableModel absModel;
    private JTable permission_table;
    private SQLTextPane Source;
    private DbaButton Sc_Cancel_Button;
    private DbaButton Sc_Confirm_Button;
    private DbaButton Sc_Modify_Button;

    public StoredCommandInfo(String modulename, String owner, String name, int num_parm) {
        this.Cancel_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        this.Confirm_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Confirm_Button_actionPerformed"));
        this.Modify_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Modify_Button_actionPerformed"));
        this.rebuildButton = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Rebuild"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/edit.gif"), new ReflectionAction(this, "rebuildButtonActionPerformed"));
        this.Execute_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Execute"), 'E', DBAImageResource.getResource(this.getClass(), "/jdbaimages/execute.gif"), new ReflectionAction(this, "Execute_Button_actionPerformed"));
        this.model = null;
        this.absModel = null;
        this.permission_table = null;
        this.Source = new SQLTextPane();
        this.Sc_Cancel_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Sc_Cancel_Button_actionPerformed"));
        this.Sc_Confirm_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Sc_Confirm_Button_actionPerformed"));
        this.Sc_Modify_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Sc_Modify_Button_actionPerformed"));
        this.modulename = GuiUt.rightTrim(modulename);
        this.owner = GuiUt.rightTrim(owner);
        this.name = GuiUt.rightTrim(name);
        this.num_parm = num_parm;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("StoredCommandTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "storedcommand.info.properties");
        DbaPanel jPanel4 = new DbaPanel(DbFrame.helpres, "storedcommand.info.permission");
        JScrollPane jScrollPane1 = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        TextField Command_Name = new TextField();
        TextField Owner_Name = new TextField();
        TextField Module_Name = new TextField();
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        this.model = new CommandPermissionTableModel(this.owner);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.permission_table = new JTable(this.absModel);
        this.permission_table.getTableHeader().setReorderingAllowed(false);
        jPanel1.setLayout(new BorderLayout(5, 5));
        jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.setLayout((LayoutManager)new XYLayout());
        jLabel1.setText(DbFrame.frame.res.getString("Module_Name"));
        jLabel2.setText(DbFrame.frame.res.getString("Schema_Name_Big_x"));
        jLabel3.setText(DbFrame.frame.res.getString("Command_Name"));
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), DbFrame.frame.res.getString("Statement")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Module_Name.setText(this.modulename);
        Owner_Name.setText(this.owner);
        Command_Name.setText(this.name);
        Module_Name.setEnabled(false);
        Owner_Name.setEnabled(false);
        Command_Name.setEnabled(false);
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.Source.setEditable(false);
        jPanel2.setPreferredSize(new Dimension(385, 110));
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Properties"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.setName("PropertiesStoredCommandButtonPanel");
        this.Execute_Button.setName("ExecuteButton");
        this.rebuildButton.setName("RebuildButton");
        Module_Name.setName("ModuleNameField");
        Owner_Name.setName("OwnerNameField");
        Command_Name.setName("CommandNameField");
        this.Source.setName("StoredCommandScriptsJEditorPanel");
        jPanel2.add((Component)Command_Name, new XYConstraints(195, 85, 190, -1));
        jPanel2.add((Component)jLabel1, new XYConstraints(0, 29, 190, 23));
        jPanel2.add((Component)Module_Name, new XYConstraints(195, 29, 190, -1));
        jPanel2.add((Component)Owner_Name, new XYConstraints(195, 57, 190, -1));
        jPanel2.add((Component)jLabel2, new XYConstraints(0, 57, 190, 23));
        jPanel2.add((Component)jLabel3, new XYConstraints(0, 85, 190, 23));
        JPanel toolbar1 = new JPanel(new FlowLayout(0));
        toolbar1.add((Component)this.Execute_Button, null);
        toolbar1.add((Component)this.rebuildButton, null);
        toolbar1.add((Component)this.Sc_Modify_Button, null);
        toolbar1.add((Component)this.Sc_Confirm_Button, null);
        toolbar1.add((Component)this.Sc_Cancel_Button, null);
        jPanel2.add((Component)toolbar1, "North");
        this.Sc_Confirm_Button.setEnabled(false);
        this.Sc_Cancel_Button.setEnabled(false);
        jPanel1.add((Component)jPanel3, "Center");
        jPanel3.add((Component)jScrollPane1, "Center");
        this.add((Component)jPanel4, DbFrame.frame.res.getTitle("Permission"));
        jPanel4.add((Component)jPanel5, "North");
        jPanel5.add((Component)this.Modify_Button, null);
        jPanel5.add((Component)this.Confirm_Button, null);
        jPanel5.add((Component)this.Cancel_Button, null);
        jPanel4.add((Component)jScrollPane2, "Center");
        jScrollPane2.getViewport().add((Component)this.permission_table, null);
        jScrollPane1.getViewport().add((Component)this.Source, null);
        this.setUpUserGroupRenderer(this.permission_table, 0);
        this.setUpBooleanRendererEditor(this.permission_table);
        this.getStoredCommandInfo();
        this.getPermission();
        this.absModel.addMouseListenerToHeaderInTable(this.permission_table);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce(this.owner);
        this.setPermissionEditable(false);
    }

    @Override
    public int getComponentType() {
        return 116;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.rebuildButton.setEnabled(true);
    }

    @Override
    public void grant(boolean enabled) {
        this.Modify_Button.setEnabled(enabled);
    }

    private void setPermissionEditable(boolean editable) {
        if (editable) {
            this.grant(false);
            this.Confirm_Button.setEnabled(true);
            this.Cancel_Button.setEnabled(true);
        } else {
            this.authority.authorise(this.owner);
            this.Confirm_Button.setEnabled(false);
            this.Cancel_Button.setEnabled(false);
        }
    }

    private void setUpUserGroupRenderer(JTable table, int index) {
        TableColumn column = table.getColumnModel().getColumn(index);
        column.setCellRenderer(new UserGroupRenderer());
    }

    private void setUpBooleanRendererEditor(JTable table) {
        table.setDefaultEditor(Boolean.class, new BooleanEditor(table, table.getModel()));
        table.setDefaultRenderer(Boolean.class, new BooleanRenderer());
    }

    private void getStoredCommandInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select STATEMENT from SYSTEM.SYSCMDINFO where MODULENAME = '" + this.modulename + "' " + "and CMDOWNER = '" + this.owner + "'" + "and CMDNAME = '" + this.name + "'";
            rs = stmt.executeQuery(query);
            String source = null;
            while (rs.next()) {
                source = rs.getString(1);
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            if (source != null) {
                this.sc_def = source;
                this.Source.setText(source);
            }
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private void getPermission() {
        this.model.removeAll();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            boolean includePublic = false;
            String query = "select USER_NAME, 'USER', au.GRANTEE, DBA, RESOURCE from SYSAUTHUSER usr outer SYSAUTHEXE au where usr.USER_NAME = au.GRANTEE and OBJNAME = '" + this.name + "' " + "union all " + "select GROUP_NAME, 'GROUP', au.GRANTEE, 0, 0 " + "from SYSAUTHMEMBER grp outer SYSAUTHEXE au " + "where grp.GROUP_NAME = au.GRANTEE " + "and OBJNAME = '" + this.name + "' " + "and GROUP_NAME != 'PUBLIC' " + "union all " + "select 'PUBLIC', 'GROUP', GRANTEE, 0, 0 " + "from SYSAUTHEXE au " + "where GRANTEE = 'PUBLIC' " + "and OBJNAME = '" + this.name + "' ";
            boolean execute = false;
            String user = null;
            String grantee = null;
            String authority_type = null;
            short resource = 0;
            CommandPermissionRowInfo one_row = null;
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                user = GuiUt.rightTrim(rs.getString(1));
                grantee = rs.getString(3);
                execute = !rs.wasNull();
                authority_type = GuiUt.rightTrim(rs.getString(2));
                short dba = rs.getShort(4);
                resource = rs.getShort(5);
                if (user.equals("PUBLIC")) {
                    includePublic = true;
                }
                one_row = new CommandPermissionRowInfo(user, authority_type, dba >= 1 || resource == 1 && user.equals(this.owner) || execute, dba >= 1, resource == 1);
                this.model.addValue(one_row);
            }
            rs.close();
            stmt.close();
            if (!includePublic) {
                one_row = new CommandPermissionRowInfo("PUBLIC", "GROUP", false, false, false);
                this.model.addValue(one_row);
            }
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.setPermissionEditable(true);
        this.model.setEditable(true);
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.revalidate();
        this.repaint();
    }

    public void Confirm_Button_actionPerformed(ActionEvent e) {
        boolean result;
        Vector v = this.model.getUpdatingPermission(this.modulename, this.owner, this.name);
        StringBuffer query_sb = new StringBuffer();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            query_sb.append((String)v.elementAt(i)).append(";\n");
        }
        if (query_sb.length() > 0 && !(result = DatabaseConnection.executeMultiSQL(query_sb.toString()))) {
            return;
        }
        this.Cancel_Button_actionPerformed(null);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setPermissionEditable(false);
        this.model.setEditable(false);
        this.getPermission();
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.releaseTabbedPanel();
    }

    public void Execute_Button_actionPerformed(ActionEvent e) {
        StringBuffer query_sb = new StringBuffer("EXEC COMMAND \"");
        if (this.owner.length() > 0) {
            query_sb.append(this.owner).append("\".\"");
        }
        query_sb.append(this.name).append("\" ");
        if (this.num_parm > 0) {
            query_sb.append("(?");
            for (int i = 1; i < this.num_parm; ++i) {
                query_sb.append(",?");
            }
            query_sb.append(")");
        }
        ExecuteCommand es = new ExecuteCommand(query_sb.toString(), this.num_parm);
        es.execute();
    }

    public void rebuildButtonActionPerformed(ActionEvent e) {
        String sql = "rebuild command \"" + this.owner + "\".\"" + this.name + "\"";
        boolean isOK = DatabaseConnection.executeSQL(DbFrame.frame, sql);
        if (isOK) {
            GuiUt.showSuccessDlg(DbFrame.frame, DbFrame.frame.res.getString("Rebuild_command_successfully"), null);
        }
    }

    public void Sc_Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.rebuildButton.setEnabled(false);
        this.Execute_Button.setEnabled(false);
        this.Sc_Confirm_Button.setEnabled(true);
        this.Sc_Cancel_Button.setEnabled(true);
        this.Source.setEditable(true);
    }

    public void Sc_Cancel_Button_actionPerformed(ActionEvent e) {
        this.getStoredCommandInfo();
        this.Source.setText(this.sc_def);
        this.revalidate();
        this.repaint();
        this.releaseTabbedPanel();
        this.Source.setEditable(false);
        this.rebuildButton.setEnabled(true);
        this.Execute_Button.setEnabled(true);
        this.Sc_Modify_Button.setEnabled(true);
        this.Sc_Confirm_Button.setEnabled(false);
        this.Sc_Cancel_Button.setEnabled(false);
    }

    public void Sc_Confirm_Button_actionPerformed(ActionEvent e) {
        String modifySql = this.Source.getText().trim();
        String executeSql = "CREATE OR REPLACE COMMAND " + this.owner + "." + this.name + " AS " + modifySql;
        Statement stmt = null;
        ResultSet rs = null;
        JDialog dialog = new JDialog();
        GuiUt.setCenterLocation(DbFrame.frame, dialog);
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            stmt.execute(executeSql);
            this.Source.setText(modifySql);
            String query = "select NUM_PARM from SYSTEM.SYSCMDINFO where CMDOWNER='" + this.owner + "' and CMDNAME='" + this.name + "' and STATUS != 0 " + "and CMDTYPE = 0 ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.num_parm = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(dialog, null, sqle);
            DbaObject.close(stmt);
            this.Source.setText(modifySql);
            return;
        }
        dialog.setVisible(false);
        dialog.dispose();
        this.Source.setEditable(false);
        this.revalidate();
        this.repaint();
        this.releaseTabbedPanel();
        this.rebuildButton.setEnabled(true);
        this.Execute_Button.setEnabled(true);
        this.Sc_Confirm_Button.setEnabled(false);
        this.Sc_Cancel_Button.setEnabled(false);
        this.Sc_Modify_Button.setEnabled(true);
    }
}

