/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Replication;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.MenuObject.CreateReplicationDlg;
import dbatool.tableModel.ColumnSorting;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;

public class ReplicationList
extends DbaTabbedPane
implements ComponentPrivilege {
    private int TABLE_OWNER = 0;
    private int TABLE_NAME = 1;
    private int REPLICATION_NAME = 2;
    private int TYPE = 3;
    private int COLUMNS = 4;
    private int NUM_SUBSCRIBER = 5;
    private DbaButton Drop_Button;
    private DbaButton Create_Button;
    private TableCols model;
    private DBAToolAbstractTableModel absModel;
    private JTable table;
    private String table_owner;
    private String table_name;
    private DefaultMutableTreeNode parent_node;

    public ReplicationList() {
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.model = null;
        this.absModel = null;
        this.table = null;
        this.table_owner = null;
        this.table_name = null;
        this.parent_node = null;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ReplicationList(DefaultMutableTreeNode node, String table_owner, String table_name) {
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.model = null;
        this.absModel = null;
        this.table = null;
        this.table_owner = null;
        this.table_name = null;
        this.parent_node = null;
        this.table_owner = table_owner;
        this.table_name = table_name;
        this.parent_node = node;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("RepTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "replication.list");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        this.model = new TableCols();
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table = new JTable(this.absModel);
        this.table.setName("RepListTable");
        jPanel1.setLayout(new BorderLayout());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ReplicationList.this.table_mouseClicked(e);
            }
        });
        this.add((Component)jPanel1, DbFrame.frame.res.getString("Replication"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.setName("RepListButtonPanel");
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        this.table.setAutoResizeMode(4);
        jScrollPane1.getViewport().add((Component)this.table, null);
        jPanel1.add((Component)jScrollPane1, "Center");
        this.initColumnSizes();
        this.getReplicationList();
        this.table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.absModel.addMouseListenerToHeaderInTable(this.table);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
    }

    @Override
    public int getComponentType() {
        return 20;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Drop_Button.setEnabled(enabled);
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            this.authority.authorise();
        }
    }

    private void initColumnSizes() {
        TableColumn column = null;
        int[] sizes = new int[]{80, 80, 100, 80, 120, 60};
        if (this.table_owner != null) {
            for (int i = 0; i < 4; ++i) {
                column = this.table.getColumnModel().getColumn(i);
                column.setPreferredWidth(sizes[i + 2]);
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                column = this.table.getColumnModel().getColumn(i);
                column.setPreferredWidth(sizes[i]);
            }
        }
    }

    private void getReplicationList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select REPLICATION_NAME, TYPE, TABLE_OWNER, TABLE_NAME, PROJECT, NUM_SUBSCRIBER from SYSTEM.SYSPUBLISH ";
            if (this.table_name != null) {
                query = query + "where TABLE_OWNER = '" + this.table_owner + "' " + "and TABLE_NAME = '" + this.table_name + "' ";
            }
            query = query + "order by TABLE_OWNER, TABLE_NAME, REPLICATION_NAME";
            rs = stmt.executeQuery(query);
            RowInfo aRow = null;
            while (rs.next()) {
                String proj = rs.getString(5);
                String newStr = "";
                if (proj != null && proj.length() > 0) {
                    int len = proj.length();
                    int i = 0;
                    while (i < len) {
                        String sub = proj.substring(i, 128 + i).trim();
                        String mark = "";
                        mark = (i += 128) == len / 128 * 128 ? "" : ", ";
                        newStr = newStr + sub + mark;
                    }
                }
                aRow = new RowInfo(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), newStr, rs.getInt(6));
                this.model.addValue(aRow);
            }
            rs.close();
            stmt.close();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.res.getString("The_number_of_replications_is"), Integer.toString(this.model.getRowCount())));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        CreateReplicationDlg dlg = DbFrame.isWindows ? new CreateReplicationDlg(DbFrame.frame) : new CreateReplicationDlg((Frame)DbFrame.frame, "", true);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.show();
        int choice = dlg.getChoice();
        dlg = null;
        System.gc();
        DbFrame.frame.menubar.CreateObjectChoice(choice, this.table_owner, this.table_name);
        this.getReplicationList();
        if (this.parent_node == null) {
            DbFrame.frame.treePanel.refreshReplicationTree();
        } else {
            DbFrame.frame.treePanel.refreshReplicationTree(this.parent_node);
        }
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        String tb_name;
        String tb_owner;
        String repl_name;
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        if (this.table_name != null) {
            repl_name = (String)this.model.getValueAt(row, 0);
            tb_owner = this.table_owner;
            tb_name = this.table_name;
        } else {
            repl_name = (String)this.model.getValueAt(row, this.REPLICATION_NAME);
            tb_owner = (String)this.model.getValueAt(row, this.TABLE_OWNER);
            tb_name = (String)this.model.getValueAt(row, this.TABLE_NAME);
        }
        if (DbFrame.conn_DatabaseConnection.dropReplication(repl_name, tb_owner, tb_name)) {
            DbFrame.frame.treePanel.afterDropReplication(tb_owner, tb_name);
        }
    }

    void table_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            if (this.table_name != null) {
                String owner = this.table_owner;
                String name = this.table_name;
                String rpname = (String)this.absModel.getValueAt(row, this.TABLE_OWNER);
                DbFrame.frame.treePanel.openTableObjectTree(owner, name, rpname, 4);
            } else {
                String owner = (String)this.absModel.getValueAt(row, this.TABLE_OWNER);
                String name = (String)this.absModel.getValueAt(row, this.TABLE_NAME);
                String rpname = (String)this.absModel.getValueAt(row, this.REPLICATION_NAME);
                DbFrame.frame.treePanel.openReplicationTree(owner, name, rpname);
            }
        }
    }

    public class TableCols
    extends AbstractTableModel
    implements ColumnSorting {
        private String[] allColumnNames;
        private String[] columnNames;
        private Vector data;

        public TableCols() {
            this.allColumnNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Table_Name"), DbFrame.frame.res.getString("Replication_Name"), DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("Columns"), DbFrame.frame.res.getString("Num_of_Subscribers")};
            this.columnNames = new String[]{DbFrame.frame.res.getString("Replication_Name"), DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("Columns"), DbFrame.frame.res.getString("Num_of_Subscribers")};
            this.data = new Vector();
        }

        @Override
        public int getColumnCount() {
            if (ReplicationList.this.table_name != null) {
                return this.columnNames.length;
            }
            return this.allColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            if (ReplicationList.this.table_name != null) {
                return this.columnNames[col];
            }
            return this.allColumnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            RowInfo rowData = (RowInfo)this.data.elementAt(row);
            if (ReplicationList.this.table_name != null) {
                return rowData.getValueAt(col + 2);
            }
            return rowData.getValueAt(col);
        }

        public Class getColumnClass(int c) {
            RowInfo rowData = (RowInfo)this.data.elementAt(0);
            if (ReplicationList.this.table_name != null) {
                return rowData.getValueAt(c + 2).getClass();
            }
            return rowData.getValueAt(c).getClass();
        }

        public void addValue(RowInfo newData) {
            this.data.addElement(newData);
        }

        public void removeAll() {
            this.data.removeAllElements();
        }

        @Override
        public void switchOrder(int godown, int goup) {
            Object downRow = this.data.elementAt(godown);
            Object upRow = this.data.elementAt(goup);
            this.data.setElementAt(downRow, goup);
            this.data.setElementAt(upRow, godown);
        }
    }

    private class RowInfo {
        Object[] data = new Object[6];

        public RowInfo(String name, String type, String tb_owner, String tb_name, String columns, int num_subscriber) {
            this.data[((ReplicationList)ReplicationList.this).REPLICATION_NAME] = GuiUt.rightTrim(name);
            this.data[((ReplicationList)ReplicationList.this).TYPE] = type.trim().equalsIgnoreCase("A") ? DbFrame.frame.res.getString("Asynchronous") : DbFrame.frame.res.getString("Synchronous");
            this.data[((ReplicationList)ReplicationList.this).TABLE_OWNER] = GuiUt.rightTrim(tb_owner);
            this.data[((ReplicationList)ReplicationList.this).TABLE_NAME] = GuiUt.rightTrim(tb_name);
            String str = columns.trim();
            String resultStr = "";
            while (true) {
                int index = str.lastIndexOf(0);
                resultStr = resultStr.length() == 0 ? str.substring(index + 1) : str.substring(index + 1) + "," + resultStr;
                if (index < 0) break;
                str = str.substring(0, index).trim();
            }
            this.data[((ReplicationList)ReplicationList.this).COLUMNS] = resultStr;
            this.data[((ReplicationList)ReplicationList.this).NUM_SUBSCRIBER] = new Integer(num_subscriber);
        }

        public Object getValueAt(int index) {
            return this.data[index];
        }
    }
}

