/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Qbe.treetable;

import dbatool.Qbe.QbeInterfaceWizardPanel3;
import dbatool.Qbe.TableInfo;
import dbatool.Qbe.treetable.AbstractCellEditor;
import dbatool.Qbe.treetable.QbeTreeRenderer;
import dbatool.Qbe.treetable.TreeTableModel;
import dbatool.Qbe.treetable.TreeTableModelAdapter;
import dbaut.GuiUt;
import dbaut.resource.DBAImageResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class QbeTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    private QbeInterfaceWizardPanel3 wizard3 = null;

    public QbeTreeTable(TreeTableModel treeTableModel, QbeInterfaceWizardPanel3 wizard3) {
        this.wizard3 = wizard3;
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.tree.setRootVisible(false);
        TreeUI treeUI = this.tree.getUI();
        if (treeUI instanceof MetalTreeUI) {
            MetalTreeUI mTreeUI = (MetalTreeUI)treeUI;
            ImageIcon icon = DBAImageResource.getResource(this.tree.getClass(), "/jdbaimages/minus.gif");
            mTreeUI.setExpandedIcon(icon);
            icon = DBAImageResource.getResource(this.tree.getClass(), "/jdbaimages/plus.gif");
            mTreeUI.setCollapsedIcon(icon);
        }
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new QbeTreeRenderer());
        TreePath aTreePath = this.tree.getPathForRow(0);
        this.tree.setSelectionPath(aTreePath);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                QbeTreeTable.this.tree_valueChanged(e);
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                QbeTreeTable.this.tree_treeWillExpand(e);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
                QbeTreeTable.this.tree_treeWillCollapse(e);
            }
        });
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    public void tree_valueChanged(TreeSelectionEvent e) {
        if (this.tree.getSelectionPath() == null) {
            this.wizard3.remove_Button.setEnabled(false);
            this.wizard3.up_Button.setEnabled(false);
            this.wizard3.down_Button.setEnabled(false);
            return;
        }
        DefaultMutableTreeNode snode = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        if (snode == null) {
            return;
        }
        this.wizard3.remove_Button.setEnabled(true);
        this.wizard3.up_Button.setEnabled(true);
        this.wizard3.down_Button.setEnabled(true);
        DefaultMutableTreeNode nsnode = snode.getNextSibling();
        if (nsnode == null) {
            this.wizard3.down_Button.setEnabled(false);
        } else {
            this.wizard3.down_Button.setEnabled(true);
        }
        DefaultMutableTreeNode psnode = snode.getPreviousSibling();
        if (psnode == null) {
            this.wizard3.up_Button.setEnabled(false);
        } else {
            this.wizard3.up_Button.setEnabled(true);
        }
    }

    public void tree_treeWillCollapse(TreeExpansionEvent e) {
        try {
            TreePath path = e.getPath();
            Object obj = path.getLastPathComponent();
            if (obj == null) {
                return;
            }
            if (obj instanceof TableInfo) {
                TableInfo ti = (TableInfo)obj;
                ti.setExpand(false);
            }
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void tree_treeWillExpand(TreeExpansionEvent e) {
        try {
            TreePath path = e.getPath();
            Object obj = path.getLastPathComponent();
            if (obj == null) {
                return;
            }
            if (obj instanceof TableInfo) {
                TableInfo ti = (TableInfo)obj;
                ti.setExpand(true);
            }
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = QbeTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            QbeTreeTable.this.tree.setSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return QbeTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = QbeTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (QbeTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(QbeTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - QbeTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    QbeTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (QbeTreeTable.this != null && QbeTreeTable.this.getRowHeight() != rowHeight) {
                    QbeTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, QbeTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }
}

