/*
 * Decompiled with CFR 0.152.
 */
package dbatool;

import DmEditor.MainDlg;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.VersionManager;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.locale.LocaleManager;
import dbaut.preference.CorePreferences;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.textField.CharPasswordField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LoginDlg
extends JDialog {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    public static String loginUserName;
    public static String loginPassword;
    public static String selectedDBName;
    private static String localHostName;
    private static List<String> localIpAddress;
    private SteppedComboBox Database_Name = new SteppedComboBox();
    private CharField User_Name_Field = new CharField(128, true);
    private CharPasswordField Password_Field = new CharPasswordField(16, true);
    private JCheckBox SaveUserPw_Checkbox = new JCheckBox("Save username and password");
    private DbaButton OK_Button = new DbaButton(new Dimension(100, 24), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "OK_Button_actionPerformed"));
    private DbaButton Setup_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Setup"), 'S', DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_trigger.gif"), new ReflectionAction(this, "Setup_Button_actionPerformed"));
    private CorePreferences cp = null;

    public LoginDlg(Frame frame, String title, boolean modal) {
        super(frame, title, true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LoginDlg(Frame frame) {
        super(frame);
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.OK_Button.requestFocus();
        }
    }

    void jbInit() throws Exception {
        this.cp = DbFrame.frame.px;
        this.setName("LoginDialog");
        this.OK_Button.setName("OKButton");
        this.Database_Name.setName("DatabaseNameComboBox");
        this.User_Name_Field.setName("UserNameField");
        this.Password_Field.setName("PasswordField");
        HelpButton Help_Button = new HelpButton();
        this.initialLocalHostInfo();
        this.setTitle(this.res.getString("JDBATool_Login"));
        DbaButton Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        Cancel_Button.setName("CancelButton");
        JLabel jLabel1 = new JLabel(this.res.getString("Database_Name") + "  :");
        JLabel jLabel2 = new JLabel(this.res.getString("User_Name") + "  :");
        JLabel jLabel3 = new JLabel(this.res.getString("Password") + "  :");
        jLabel1.setHorizontalAlignment(4);
        jLabel2.setHorizontalAlignment(4);
        jLabel3.setHorizontalAlignment(4);
        Vector<String> dataSource = JdmConfig.getDatabaseNames("dmconfig.ini", false);
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(dataSource);
        this.Database_Name.setModel((ComboBoxModel)comboModel);
        this.Database_Name.setMaximumRowCount(6);
        this.Database_Name.addActionListener(new ReflectionAction(this, "Database_Name_actionPerformed"));
        this.User_Name_Field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    LoginDlg.this.User_Name_Field_keyPressed(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                LoginDlg.this.User_Name_Field_keyPressed(e);
            }
        });
        this.Password_Field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    LoginDlg.this.Password_Field_keyPressed(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                LoginDlg.this.Password_Field_keyPressed(e);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.darkGray);
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel2.setMinimumSize(new Dimension(2, 2));
        jPanel2.setPreferredSize(new Dimension(2, 2));
        DbFrame.frame.enableDialogHelp(this.getRootPane(), Help_Button, "LoginDlg", null);
        JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel5 = new JPanel(new GridLayout(4, 1, 5, 5));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel5.add((Component)jLabel1, null);
        jPanel5.add((Component)jLabel2, null);
        jPanel5.add((Component)jLabel3, null);
        JPanel jPanel6 = new JPanel(new GridLayout(4, 1, 5, 5));
        jPanel6.setPreferredSize(new Dimension(300, 120));
        jPanel6.add((Component)this.Database_Name, null);
        jPanel6.add((Component)this.User_Name_Field, null);
        jPanel6.add((Component)this.Password_Field, null);
        jPanel6.add((Component)this.SaveUserPw_Checkbox, null);
        JPanel jPanel7 = new JPanel(new GridLayout(4, 1, 5, 5));
        jPanel7.add((Component)this.OK_Button, null);
        jPanel7.add((Component)Cancel_Button, null);
        jPanel7.add((Component)this.Setup_Button, null);
        jPanel7.add((Component)Help_Button, null);
        jPanel4.add((Component)jPanel5, "West");
        jPanel4.add((Component)jPanel6, "Center");
        jPanel4.add((Component)jPanel7, "East");
        JPanel jPanel8 = new JPanel(new BorderLayout(10, 10));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel8.add((Component)jPanel2, "North");
        jPanel8.add((Component)new JLabel(DBAImageResource.getResource(this.getClass(), "/jdbaimages/logo32.gif")), "West");
        jPanel8.add((Component)new JLabel(this.res.getString("c_2001_CASEMaker") + VersionManager.getBuildYear() + " " + VersionManager.getCompanyName() + this.res.getString("c_2001_CASEMaker2"), 0), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        jPanel3.add((Component)jPanel4, "Center");
        jPanel3.add((Component)jPanel8, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel3, "Center");
        if (this.Database_Name.getItemCount() == 0) {
            return;
        }
        String previouslogindb = this.cp.getLoginDbName();
        if (previouslogindb != null || previouslogindb.length() > 0) {
            this.Database_Name.setSelectedItem(previouslogindb);
            this.Database_Name_actionPerformed(null);
        } else {
            this.Database_Name.setSelectedIndex(0);
        }
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        if (DbFrame.frame != null) {
            if (this.User_Name_Field.getText().equalsIgnoreCase("")) {
                GuiUt.showInformationDlg(this, this.res.getString("Please_input_user_name"));
                return;
            }
            DbFrame.frame.Disconnect_MenuItem_actionPerformed(null);
        }
        loginUserName = this.User_Name_Field.getText();
        this.setCursor(Cursor.getPredefinedCursor(3));
        selectedDBName = this.Database_Name.getSelectedItem().toString().trim();
        loginPassword = new String(this.Password_Field.getPassword());
        DbFrame.conn_DatabaseConnection = new DatabaseConnection(selectedDBName, loginUserName, loginPassword, this);
        DbFrame.frame.isConnect = DbFrame.frame.initPrivilege(DbFrame.conn_DatabaseConnection, loginUserName, this);
        this.cp.setLoginDbName(selectedDBName);
        if (this.SaveUserPw_Checkbox.isSelected()) {
            this.cp.setLoginIdName(loginUserName);
            this.cp.setLoginPassword(loginPassword);
        } else {
            this.cp.removeLoginInfo(selectedDBName);
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (loginUserName.length() > 0 && DbFrame.conn_DatabaseConnection.isIDCAP()) {
            loginUserName = loginUserName.toUpperCase();
        }
        if (DbFrame.conn_DatabaseConnection != null) {
            DbFrame.frame.px.getHistory(DbFrame.conn_DatabaseConnection.dbname, DbFrame.conn_DatabaseConnection.username);
        }
        try {
            this.cp.save();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.setVisible(false);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.isConnect = false;
        this.setVisible(false);
    }

    public void Database_Name_actionPerformed(ActionEvent e) {
        String databaseName = this.Database_Name.getSelectedItem().toString();
        this.User_Name_Field.setText("");
        this.Password_Field.setText("");
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", databaseName, "r");
        if (rc != 0) {
            System.out.println("Error open dmconfig.ini via JdmConfig");
            return;
        }
        this.SaveUserPw_Checkbox.setSelected(false);
        String username = null;
        String password = null;
        if (databaseName.equalsIgnoreCase(this.cp.getLoginDbName())) {
            if (this.cp.getLoginIdName() != null && this.cp.getLoginIdName().length() > 0) {
                username = this.cp.getLoginIdName();
                password = this.cp.getLoginPassword();
                this.SaveUserPw_Checkbox.setSelected(true);
            }
        } else {
            username = this.cp.getLoginIdName(databaseName);
            password = this.cp.getLoginPassword(databaseName);
            this.SaveUserPw_Checkbox.setSelected(username != null && username.length() > 0);
        }
        if (username == null) {
            username = (String)config.getPara("DB_USRID", 4096);
        }
        if (password == null) {
            password = (String)config.getPara("DB_PASSWD", 4096);
        }
        config.fileClose();
        if (username != null && username.length() > 0) {
            this.User_Name_Field.setText(username);
        }
        if (password != null && password.length() > 0) {
            this.Password_Field.setText(password);
        }
    }

    public void initialLocalHostInfo() {
        boolean isup = true;
        this.initialLocalHostInfo(isup);
    }

    public void initialLocalHostInfo(boolean isup) {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            localHostName = ia.getHostName();
            localIpAddress = JdmConfig.getLocalIP(isup);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public static boolean isLocalHost(String dbname) {
        JdmConfig config = new JdmConfig();
        return config.isLocalHost("dmconfig.ini", dbname);
    }

    void User_Name_Field_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.User_Name_Field.getText().length() > 0) {
            this.OK_Button_actionPerformed(null);
        }
    }

    void Password_Field_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.User_Name_Field.getText().length() > 0) {
            this.OK_Button_actionPerformed(null);
        }
    }

    public void Setup_Button_actionPerformed(ActionEvent e) {
        MainDlg dlg;
        String name = (String)this.Database_Name.getSelectedItem();
        short language = LocaleManager.getLanguageChoice();
        if (DbFrame.isWindows) {
            dlg = new MainDlg((Frame)DbFrame.frame, language, name, "connection");
            dlg.setTitle(this.res.getString("Connect_database_advance_setting"));
            dlg.setModal(true);
        } else {
            dlg = new MainDlg(DbFrame.frame, this.res.getString("Connect_database_advance_setting"), true, language, name, "connection");
        }
        dlg.setSize(620, 580);
        dlg.show();
        dlg = null;
    }

    static {
        localHostName = "";
        localIpAddress = new ArrayList<String>();
    }
}

