/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Index;

import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MoveIndexDialog
extends JDialog {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DbaButton okButton = new DbaButton(new Dimension(100, 24), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "okButtonActionPerformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private HelpButton helpButton = new HelpButton();
    private Frame frame = null;
    private JComboBox tsNameComboBox = new JComboBox();
    private String tbName = null;
    private String ownName = null;
    private String idxName = null;
    private String dtsName = null;

    public MoveIndexDialog(Frame frame, String tbName, String ownName, String idxName, String dtsName) {
        super(frame, true);
        this.frame = frame;
        this.tbName = tbName;
        this.ownName = ownName;
        this.idxName = idxName;
        this.dtsName = dtsName;
        this.init();
        this.setPreferredSize(new Dimension(400, 200));
        this.pack();
        GuiUt.setCenterLocation(frame, this);
        this.setVisible(true);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.okButton.requestFocus();
        }
    }

    private void init() {
        this.setName("MoveIndexDialog");
        this.tsNameComboBox.setName("TSNameComboBox");
        this.okButton.setName("OKButton");
        this.cancelButton.setName("CancelButton");
        this.setTitle(this.res.getString("Move_Index"));
        this.setDefaultCloseOperation(0);
        WindowAdapter closeListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MoveIndexDialog.this.cancelButtonActionPerformed(null);
            }
        };
        this.addWindowListener(closeListener);
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "MoveIndexDialog", null);
        JPanel contentPanel = new JPanel(new FlowLayout(0));
        contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Move_To"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        contentPanel.add(new JLabel(this.res.getString("Tablespace_Name")));
        this.tsNameComboBox.setPreferredSize(new Dimension(200, 24));
        contentPanel.add(this.tsNameComboBox);
        Container container = this.getContentPane();
        container.add(contentPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        container.add((Component)buttonPanel, "South");
        boolean isReadOnlyTs = this.isReadOnlyTs();
        this.initTSName(isReadOnlyTs);
        if (isReadOnlyTs) {
            this.tsNameComboBox.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReadOnlyTs() {
        Statement stmt = null;
        ResultSet rs = null;
        boolean isReadOnlyTs = false;
        try {
            int type;
            String sql = "select TS_TYPE from SYSTEM.SYSTABLESPACE where TS_NAME = '" + this.dtsName + "'";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next() && ((type = rs.getInt(1)) == 2 || type == 3)) {
                isReadOnlyTs = true;
            }
        }
        catch (SQLException e1) {
            GuiUt.showSQLException(DbFrame.frame, "", e1);
            e1.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return isReadOnlyTs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTSName(boolean isReadOnlyTs) {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            sql = isReadOnlyTs ? "select TS_NAME from SYSTEM.SYSTABLESPACE WHERE TS_NAME NOT IN ('SYSTABLESPACE','TMPTABLESPACE')" : "select TS_NAME from SYSTEM.SYSTABLESPACE WHERE TS_NAME NOT IN ('SYSTABLESPACE','TMPTABLESPACE') AND TS_TYPE!=2 AND TS_TYPE!=3";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(sql);
            String tsName = null;
            while (rs.next()) {
                tsName = rs.getString(1).trim();
                this.tsNameComboBox.addItem(tsName);
            }
        }
        catch (SQLException e1) {
            GuiUt.showSQLException(DbFrame.frame, "", e1);
            e1.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.tsNameComboBox.setSelectedItem(this.dtsName);
    }

    public void okButtonActionPerformed(ActionEvent e) {
        String tsName = (String)this.tsNameComboBox.getSelectedItem();
        if (tsName.equals(this.dtsName)) {
            this.cancelButtonActionPerformed(null);
            return;
        }
        String sql = "rebuild index " + GuiUt.getIDString(this.idxName) + " for " + GuiUt.getIDString(this.ownName) + "." + GuiUt.getIDString(this.tbName) + " in " + GuiUt.getIDString(tsName);
        if (!GuiUt.showSqlScript(sql)) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            stmt.execute(sql);
            stmt.close();
            GuiUt.showSuccessDlg(this.frame, this.res.getString("Move_index_sccessfully"), null);
        }
        catch (SQLException e1) {
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, e1);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

