/*
 * Decompiled with CFR 0.152.
 */
package dbatool;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import javax.swing.JPanel;

public class GraphicPanel
extends JPanel {
    private int start = 0;
    private int extent = 0;
    private String used = "";
    private String title = "";
    private String total = "";

    public GraphicPanel(String title, String total, String used, float ratio) {
        try {
            this.title = title;
            this.total = total;
            this.used = used;
            Float temp = new Float(360.0f * ratio / 100.0f);
            this.extent = temp.intValue();
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setMaximumSize(new Dimension(400, 400));
        this.setPreferredSize(new Dimension(240, 160));
        this.setLayout(new FlowLayout());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint redtowhite = new GradientPaint(10.0f, 75.0f, Color.white, 100.0f, 75.0f, Color.pink);
        GradientPaint graytowhite = new GradientPaint(10.0f, 75.0f, Color.gray, 100.0f, 75.0f, Color.white);
        if (this.extent == 0) {
            this.extent = 1;
        }
        g.drawString(this.title, 10, 30);
        g2.setPaint(redtowhite);
        g2.fill(new Arc2D.Double(10.0, 40.0, 90.0, 90.0, this.start, this.extent, 2));
        g2.setPaint(graytowhite);
        g2.fill(new Arc2D.Double(10.0, 40.0, 90.0, 90.0, this.start + this.extent, 360 - this.extent, 2));
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.black);
        g2.draw(new Arc2D.Double(10.0, 40.0, 90.0, 90.0, this.start, this.extent, 2));
        g2.draw(new Arc2D.Double(10.0, 40.0, 90.0, 90.0, this.start + this.extent, 360 - this.extent, 2));
        g.drawString(this.total, 100, 65);
        g.drawString(this.used.substring(0, this.used.indexOf(".") + 2) + " %", 100, 85);
    }
}

