/*
 * Decompiled with CFR 0.152.
 */
package dbatool;

import com.syscom.dm.dba.sca.DbaAuthority;
import dbatool.DbFrame;
import dbaut.comp.DbaPanel;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.help.CSH;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import queryAnalyzer.QueryFrame;

public class DbaTabbedPane
extends JTabbedPane {
    protected DbaAuthority authority = null;
    private ChangeListener listener = null;

    public DbaTabbedPane() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DbaTabbedPane.this.this_stateChanged(e);
            }
        };
        this.addChangeListener(this.listener);
    }

    public void this_stateChanged(ChangeEvent e) {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getComponentCount()) {
            return;
        }
        Component panel = this.getComponentAt(index);
        if (panel instanceof DbaPanel) {
            String helpid2 = ((DbaPanel)panel).getHelpIDString();
            DbFrame.frame.setHelpMenuitem(helpid2);
            CSH.setHelpIDString((Component)this, (String)helpid2);
        } else if (panel instanceof QueryFrame) {
            String helpid3 = ((QueryFrame)panel).getHelpIDString();
            DbFrame.frame.setHelpMenuitem(helpid3);
            CSH.setHelpIDString((Component)this, (String)helpid3);
        }
    }

    public void fixTabbedPanelAt(int index) {
        int size = this.getComponentCount();
        if (index < 0 || index > size) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            if (i == index) continue;
            this.setEnabledAt(i, false);
        }
        DbFrame.frame.freezeTreeSelection(true);
    }

    public void releaseTabbedPanel() {
        int size = this.getComponentCount();
        for (int i = 0; i < size; ++i) {
            this.setEnabledAt(i, true);
        }
        DbFrame.frame.freezeTreeSelection(false);
    }

    class MyTabbedPaneUI
    extends BasicTabbedPaneUI {
        MyTabbedPaneUI() {
        }

        @Override
        protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
            return 100;
        }
    }
}

