/*
 * Decompiled with CFR 0.152.
 */
package dbatool;

import com.syscom.dm.dba.sca.DbaAuthority;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbaMenuBar;
import dbatool.DbaToolBar;
import dbatool.DbaTreePane;
import dbatool.Index.IndexList;
import dbatool.LoginDlg;
import dbatool.MenuObject.CreateObjectPopupMenu;
import dbatool.Preferences.PreferencesXml;
import dbatool.StatisticsParser;
import dbatool.Table.TableInfo;
import dbatool.TreeNode.DBATreeNode;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.ProgressDialog;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.privilege.UserPrivilege;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import queryAnalyzer.QueryFrame;

public class DbFrame
extends JFrame
implements LocaleChangeListener {
    public DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.ToolRes", LocaleManager.getLocale());
    public DbaTreePane treePanel = null;
    private JPanel contentPanel = new JPanel(new BorderLayout());
    public static DatabaseConnection conn_DatabaseConnection = null;
    private UserPrivilege userPrivilege = null;
    public static DbFrame frame = null;
    public static HelpResourceBundle helpres = null;
    public static boolean isWindows = true;
    public boolean isConnect = false;
    public boolean isLocalHost = true;
    public DbaMenuBar menubar = null;
    public DbaToolBar toolbar = null;
    private JLabel statusBar = new JLabel();
    private String helpsetName = "JDBA2.hs";
    public HelpSet mainHS = null;
    public DefaultHelpBroker mainHB = null;
    public boolean isFromRefreshFeature = false;
    private JSplitPane jSplitPane1 = new JSplitPane();
    public PreferencesXml px = PreferencesXml.getPreferencesXml();
    public Point centerLocation = null;
    private String dbName = null;
    private String userName = null;
    private String password = null;
    private String updConID = null;
    private boolean isSuccess = false;
    private boolean isUserCanceled = false;
    private String updErrorMessage = null;
    public static QueryFrame jsqlFrame = null;
    private JPopupMenu popup = null;
    private JMenuItem closeItem = null;

    public DbFrame() {
        try {
            this.jbInit();
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
        catch (Exception e) {
            System.out.println("DbFrame init failed: " + e.getMessage());
        }
    }

    public Point getDefaultCenterLocation() {
        return this.centerLocation;
    }

    public void setDefaultCenterLocation(Point p) {
        this.centerLocation = p;
    }

    public int getDividerLocation() {
        return this.jSplitPane1.getDividerLocation();
    }

    public void autoConnect(String dbname, String username, String password) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        DatabaseConnection conn = new DatabaseConnection(dbname, username, password, this);
        if (conn == null || !conn.isConnected) {
            this.setCursor(Cursor.getDefaultCursor());
            this.setTitle(this.res.getString("No_database_connected"));
            this.setStatusDisc(this.res.getString("No_database_connected"));
            return;
        }
        conn.isConnected = frame.initPrivilege(conn, username, this);
        DbaAuthority authority = DbaAuthorityFactory.create(null);
        if (conn.isConnected && !authority.isAboveDba()) {
            this.setCursor(Cursor.getDefaultCursor());
            this.setTitle(this.res.getString("No_database_connected"));
            this.setStatusDisc(this.res.getString("No_database_connected"));
            return;
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.menubar.setDatabaseMenuitemEnable(true);
        this.toolbar.setToolBarButtonEnable(true);
        conn_DatabaseConnection = conn;
        this.isConnect = true;
        this.dbName = dbname;
        this.userName = username;
        this.password = password;
        this.treePanel.initDatabaseTree();
        System.gc();
        this.enableEvents(64L);
        this.setTitle(dbname + " : " + username);
        this.setStatusDisc(this.res.getString("Login_Success"));
    }

    private static String getHelpSetName() {
        String s = "JDBA.hs";
        switch (LocaleManager.getHelpFileLanguage()) {
            default: 
        }
        s = "JDBA.hs";
        return s;
    }

    private void initHelpSet(boolean first) {
        try {
            this.mainHS = null;
            this.mainHB = null;
            helpres = new HelpResourceBundle("jdbaproperties.help");
            ClassLoader cl = DbFrame.class.getClassLoader();
            this.helpsetName = this.getHelpSetName();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)this.helpsetName);
            this.mainHS = new HelpSet(cl, url);
            this.mainHB = (DefaultHelpBroker)this.mainHS.createHelpBroker();
            this.mainHB.enableHelpKey((Component)this.getRootPane(), helpres.getString("home"), null);
        }
        catch (Exception ex) {
            System.out.println("Help Set " + this.helpsetName + " not found");
            ex.printStackTrace();
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println("initialization error:");
            ex.getException().printStackTrace();
        }
        if (this.menubar != null) {
            this.menubar.Help_Menuitem.setEnabled(true);
            this.menubar.Help_Popup_Menuitem.setEnabled(true);
            if (first) {
                this.menubar.setHelpButton(true);
            } else {
                this.menubar.setHelpButton(false);
            }
        }
        if (this.toolbar != null) {
            this.toolbar.helpButton.setEnabled(true);
            if (first) {
                this.toolbar.setHelpButton(true);
            } else {
                this.toolbar.setHelpButton(false);
            }
        }
    }

    private void jbInit() throws Exception {
        this.setName("JdbaFrame");
        JPanel jPanel1 = new JPanel(new BorderLayout());
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
        isWindows = DbFrame.isWindows();
        frame = this;
        this.setSize(new Dimension(this.px.getFrameWidth(), this.px.getFrameHeight()));
        this.setPreferredSize(new Dimension(this.px.getFrameWidth(), this.px.getFrameHeight()));
        this.setMinimumSize(new Dimension(1000, 800));
        frame.setTitle(this.res.getString("JDBA_Tool"));
        ImageIcon i = DBAImageResource.getResource(this.getClass(), "/jdbaimages/logo16.gif");
        this.setIconImage(i.getImage());
        this.menubar = new DbaMenuBar();
        this.setJMenuBar(this.menubar);
        this.toolbar = new DbaToolBar();
        this.toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.initHelpSet(true);
        this.treePanel = new DbaTreePane();
        this.treePanel.setAutoscrolls(true);
        this.treePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.contentPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jSplitPane1.setLeftComponent(this.treePanel);
        this.jSplitPane1.setRightComponent(this.contentPanel);
        this.contentPanel.setMinimumSize(new Dimension(800, 800));
        this.jSplitPane1.setOneTouchExpandable(true);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.getContentPane().add((Component)jPanel1, "South");
        jPanel1.add((Component)this.statusBar, "Center");
        this.menubar.setDatabaseMenuitemEnable(false);
        this.toolbar.setToolBarButtonEnable(false);
        this.jSplitPane1.setDividerLocation(this.px.getDividerLocation());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    DbFrame.this.dbFrame_keyRelease(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DbFrame.this.dbFrame_keyRelease(e);
            }
        });
        this.closeItem = new JMenuItem(this.res.getString("close"));
        this.popup = new JPopupMenu();
        this.popup.add(this.closeItem);
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = DbFrame.this.contentPanel.getComponent(0);
                if (c instanceof JTabbedPane) {
                    JTabbedPane tab = (JTabbedPane)c;
                    int selectedIndex = tab.getSelectedIndex();
                    tab.remove(selectedIndex);
                    jsqlFrame = null;
                    QueryFrame.frame.clearResultPane();
                    QueryFrame.frame.isConnect = false;
                    c.repaint();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component comp = DbFrame.this.getContentPanel();
                if (comp != null) {
                    DbFrame.this.setContentPanel(comp);
                }
                if (QueryFrame.frame != null) {
                    QueryFrame.frame.revalidate();
                    QueryFrame.frame.repaint();
                }
            }
        });
    }

    void dbFrame_keyRelease(KeyEvent e) {
        if (e.getKeyCode() == 116) {
            TreePath path = this.treePanel.tree.getSelectionPath();
            if (path == null) {
                return;
            }
            DBATreeNode node = (DBATreeNode)path.getLastPathComponent();
            if (node == null) {
                path = null;
                return;
            }
            this.treePanel.tree.setSelectionPath(path);
            DbFrame.frame.isFromRefreshFeature = true;
            node.refresh();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.Disconnect_MenuItem_actionPerformed(null);
            System.exit(0);
        }
    }

    public void exitApplication() {
        try {
            Toolkit.getDefaultToolkit().beep();
            int reply = GuiUt.showOptionDlg(this, this.res.getString("DBATool_Exit"), this.res.getString("Do_you_really_want_to_exit"));
            if (reply == 0) {
                this.Disconnect_MenuItem_actionPerformed(null);
                this.setVisible(false);
                this.dispose();
                System.exit(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStatusDisc(String text) {
        this.statusBar.setText(text);
        this.statusBar.revalidate();
        this.statusBar.repaint();
    }

    public Component getContentPanel() {
        try {
            Component comp = this.contentPanel.getComponent(0);
            return comp;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setContentPanel(Component comp) {
        int tabbedPosition = 0;
        if (DbFrame.frame.isFromRefreshFeature) {
            Component tmpComponent = null;
            tmpComponent = this.contentPanel.getComponent(0);
            if (tmpComponent != null && tmpComponent instanceof JTabbedPane) {
                tabbedPosition = ((JTabbedPane)tmpComponent).getSelectedIndex();
            }
        }
        Component previous = this.getContentPanel();
        int index = 0;
        if (previous != null && previous instanceof TableInfo) {
            index = ((TableInfo)previous).getSelectedIndex();
            ((TableInfo)previous).clean();
        } else if (previous != null && previous instanceof IndexList) {
            ((IndexList)previous).clean();
        }
        this.contentPanel.removeAll();
        this.contentPanel.add(comp, "Center");
        if (comp instanceof JTabbedPane) {
            JTabbedPane t = (JTabbedPane)comp;
            if (DbFrame.frame.isFromRefreshFeature) {
                int tabbedCount = t.getTabCount();
                if (tabbedCount < tabbedPosition) {
                    tabbedPosition = 0;
                }
                t.setSelectedIndex(tabbedPosition);
                DbFrame.frame.isFromRefreshFeature = false;
            }
            if (comp instanceof TableInfo && index != 0 && index < 7) {
                ((TableInfo)comp).setSelectedIndex(index);
            }
            t.grabFocus();
        }
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e != null ? DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.ToolRes", e.getLocale()) : DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.ToolRes", LocaleManager.getLocale());
        this.menubar.localeChanged(e);
        this.toolbar.localeChanged(e);
        this.closeItem.setText(this.res.getString("close"));
        if (!this.isConnect) {
            this.setTitle(this.res.getString("No_database_connected"));
        }
        this.validate();
    }

    public void Connect_MenuItem_actionPerformed(ActionEvent e) {
        try {
            this.isConnect = false;
            LoginDlg dlg = isWindows ? new LoginDlg(this) : new LoginDlg(this, "", true);
            GuiUt.setCenterLocation(this, dlg);
            dlg.setVisible(true);
            dlg = null;
            if (!this.isConnect || conn_DatabaseConnection == null) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.isConnect = this.initPrivilege(conn_DatabaseConnection, DbFrame.conn_DatabaseConnection.username, this);
            this.treePanel.initDatabaseTree();
            this.setCursor(Cursor.getDefaultCursor());
            System.gc();
            DbaAuthority authority = DbaAuthorityFactory.create(null);
            this.menubar.setDatabaseMenuitemEnable(true);
            this.menubar.checkUserPrivilege(authority);
            this.toolbar.setToolBarButtonEnable(true);
            this.toolbar.checkUserPrivilege(authority);
            this.setTitle(DbFrame.conn_DatabaseConnection.dbname + " : " + DbFrame.conn_DatabaseConnection.username);
            this.setStatusDisc(this.res.getString("Login_Success"));
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void Refresh_menuitem_actionPerformed(ActionEvent e) {
        this.treePanel.refreshTree();
    }

    void createObjectButton_mouseReleased(MouseEvent e) {
        CreateObjectPopupMenu popup = new CreateObjectPopupMenu();
        popup.show(this, e.getX() + 40, e.getY() + 60);
    }

    public void createJsqlQuery_actionPerformed(ActionEvent e) {
        Component comp = this.contentPanel.getComponent(0);
        JTabbedPane t = null;
        if (comp instanceof JTabbedPane) {
            t = (JTabbedPane)comp;
            if (jsqlFrame == null) {
                jsqlFrame = new QueryFrame();
                jsqlFrame.setName("jsqlFrame");
            }
            t.addTab(this.res.getString("sql_query"), jsqlFrame);
            int contentPanelTop = this.contentPanel.getBorder().getBorderInsets((Component)t).top;
            int contentPanelBottom = this.contentPanel.getBorder().getBorderInsets((Component)t).bottom;
            int contentPanelLeft = this.contentPanel.getBorder().getBorderInsets((Component)t).left;
            int contentPanelRight = this.contentPanel.getBorder().getBorderInsets((Component)t).right;
            t.setPreferredSize(new Dimension(this.contentPanel.getWidth() - (contentPanelLeft + contentPanelRight), this.contentPanel.getHeight() - (contentPanelTop + contentPanelBottom)));
        }
        if (t != null) {
            int count = t.getTabCount();
            t.setSelectedIndex(count - 1);
        }
        t.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                JTabbedPane tab;
                String s;
                Component c;
                if (e.getModifiers() == 4 && (c = e.getComponent()) instanceof JTabbedPane && "jsqlFrame".equals(s = (tab = (JTabbedPane)c).getComponentAt(index = tab.getSelectedIndex()).getName())) {
                    DbFrame.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void defTable(ActionEvent e) {
        Component comp = this.contentPanel.getComponent(0);
        if (comp instanceof TableInfo) {
            TableInfo t = (TableInfo)comp;
            t.defTable(e);
        }
    }

    public void renameTable(ActionEvent e) {
        Component comp = this.contentPanel.getComponent(0);
        if (comp instanceof TableInfo) {
            TableInfo t = (TableInfo)comp;
            t.rename(e);
        }
    }

    void Disconnect_MenuItem_actionPerformed(ActionEvent e) {
        this.contentPanel.removeAll();
        jsqlFrame = null;
        if (this.treePanel != null) {
            this.treePanel.removeTree();
        }
        if (conn_DatabaseConnection != null) {
            this.px.save();
            conn_DatabaseConnection.disconnect();
            conn_DatabaseConnection = null;
        }
        this.isConnect = false;
        this.menubar.freezeMenuitem(false);
        this.toolbar.freezeMenuitem(false);
        this.menubar.setDatabaseMenuitemEnable(false);
        this.toolbar.setToolBarButtonEnable(false);
        this.setTitle(this.res.getString("No_database_connected"));
        this.setStatusDisc(this.res.getString("No_database_connected"));
        System.gc();
        this.repaint();
    }

    public void Sync_Auto_Index_Menuitem_actionPerformed(ActionEvent e) {
        int reply = GuiUt.showOptionDlg(frame, this.res.getString("Sync_Auto_Index"), this.res.getString("Do_you_want_to_sync_auto_index"));
        if (reply != 0) {
            return;
        }
        frame.setStatusDisc(this.res.getString("Sync_Auto_Index"));
        String query = "SYNC AUTO INDEX";
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            GuiUt.showInformationDlg(frame, this.res.getString("Auto_Index_Synchronized"));
            frame.setStatusDisc(this.res.getString("Auto_Index_Synchronized"));
        } else {
            frame.setStatusDisc("  ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void Update_Statistics_MenuItem_actionPerformed(ActionEvent e) {
        int reply = GuiUt.showOptionDlg(frame, this.res.getString("Update_Statistics"), this.res.getString("Do_you_want_to_update_database_statistics"));
        if (reply != 0) {
            return;
        }
        this.setStatusDisc(this.res.getString("Updating_statistics_"));
        DatabaseConnection conn = new DatabaseConnection(DbFrame.conn_DatabaseConnection.dbname, DbFrame.conn_DatabaseConnection.username, DbFrame.conn_DatabaseConnection.password, this);
        if (conn == null || !conn.isConnected) {
            System.out.println("Can not create new connection for update statistics.");
            return;
        }
        final Connection con = conn.getDbConnection();
        Statement stmt1 = null;
        ResultSet rs1 = null;
        try {
            stmt1 = con.createStatement();
            rs1 = stmt1.executeQuery("select CONNECTION_ID from SYSTEM.SYSCONINFO");
            while (rs1.next()) {
                this.updConID = rs1.getString(1);
            }
        }
        catch (SQLException e1) {
            try {
                GuiUt.showErrorDlg(frame, e1.getMessage(), null);
            }
            catch (Throwable throwable) {
                DbaObject.close(rs1);
                DbaObject.close(stmt1);
                throw throwable;
            }
            DbaObject.close(rs1);
            DbaObject.close(stmt1);
        }
        DbaObject.close(rs1);
        DbaObject.close(stmt1);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                DbFrame.this.updateStatistics(con);
            }
        };
        t1.start();
        Thread t2 = new Thread(){

            @Override
            public void run() {
                DbFrame.this.monitorUpdateStatistics();
            }
        };
        t2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatistics(Connection con) {
        this.isSuccess = false;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            String query = "UPDATE STATISTICS";
            stmt.execute(query);
            this.isSuccess = true;
        }
        catch (SQLException e) {
            this.updErrorMessage = e.getMessage();
            e.printStackTrace();
        }
        finally {
            DbaObject.close(stmt);
            DbaObject.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void monitorUpdateStatistics() {
        Statement stmt = null;
        CallableStatement stmt1 = null;
        ResultSet rs = null;
        final ProgressDialog progressDialog = new ProgressDialog(frame, this.res.getString("Update_Statistics"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(true);
            }
        });
        String sql = "select SQL_CMD from SYSTEM.SYSUSER where CONNECTION_ID=" + this.updConID;
        block11: while (true) {
            block20: {
                try {
                    block19: {
                        String tName;
                        String per;
                        while (true) {
                            Thread.sleep(500L);
                            stmt = conn_DatabaseConnection.getDbConnection().createStatement();
                            rs = stmt.executeQuery(sql);
                            if (!rs.next()) break block19;
                            String value = rs.getString(1).trim().toUpperCase();
                            System.out.println("sql_cmd : " + value);
                            if (value.indexOf("[EXIT]  UPDATE STATISTICS") < 0 && value.indexOf("//") < 0) {
                                DbaObject.close(rs);
                                DbaObject.close(stmt);
                                DbaObject.close(stmt1);
                                continue;
                            }
                            if (value.indexOf("[EXIT]  UPDATE STATISTICS") >= 0) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        progressDialog.setProgressBarValue(100);
                                        progressDialog.setVisible(false);
                                        progressDialog.dispose();
                                    }
                                });
                                DbaObject.close(rs);
                                DbaObject.close(stmt);
                                DbaObject.close(stmt1);
                                break block11;
                            }
                            StatisticsParser sp = StatisticsParser.getParser();
                            sp.parse(value);
                            ArrayList<String> total = sp.getTotalList();
                            ArrayList<String> table = sp.getTableList();
                            per = total.get(0).trim();
                            tName = table.get(4).trim();
                            if (!per.equals("-")) break;
                            DbaObject.close(rs);
                            DbaObject.close(stmt);
                            DbaObject.close(stmt1);
                        }
                        per = per.substring(0, per.length() - 1);
                        final int percent = Integer.parseInt(per);
                        System.out.println("current percent: " + percent);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressDialog.setProgressBarValue(percent);
                                progressDialog.setUpdateContent(tName);
                            }
                        });
                        if (progressDialog.isCanceling()) {
                            ProgressDialog.sem.semaphoreWait();
                            progressDialog.setIsCanceling(false);
                            if (progressDialog.isUserCanceled()) {
                                this.isUserCanceled = progressDialog.isUserCanceled();
                                String abortSQL = "call SETSYSTEMOPTION('STS_ABORT', '" + this.updConID + "')";
                                stmt1 = conn_DatabaseConnection.getDbConnection().prepareCall(abortSQL);
                                stmt1.execute();
                                DbaObject.close(rs);
                                DbaObject.close(stmt);
                                DbaObject.close(stmt1);
                                break;
                            }
                        }
                        DbaObject.close(rs);
                        break block20;
                    }
                    if (progressDialog.isCanceling()) {
                        ProgressDialog.sem.semaphoreWait();
                        progressDialog.setIsCanceling(false);
                        if (progressDialog.isUserCanceled()) {
                            this.isUserCanceled = progressDialog.isUserCanceled();
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.setProgressBarValue(100);
                            progressDialog.setVisible(false);
                            progressDialog.dispose();
                        }
                    });
                    DbaObject.close(rs);
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                        continue;
                    }
                }
                finally {
                    DbaObject.close(rs);
                    DbaObject.close(stmt);
                    DbaObject.close(stmt1);
                    continue;
                }
                DbaObject.close(stmt);
                DbaObject.close(stmt1);
                break;
            }
            DbaObject.close(stmt);
            DbaObject.close(stmt1);
            continue;
            break;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!DbFrame.this.isUserCanceled) {
                    if (DbFrame.this.isSuccess) {
                        DbFrame.this.setStatusDisc(DbFrame.this.res.getString("Updated_statistics"));
                        GuiUt.showSuccessDlg(frame, DbFrame.this.res.getString("Updated_statistics"), null);
                    } else {
                        DbFrame.this.setStatusDisc("  ");
                        GuiUt.showErrorDlg(frame, DbFrame.this.updErrorMessage, null);
                    }
                    DbFrame.frame.treePanel.openDatabaseNode();
                }
            }
        });
    }

    private String getUpdPercent(String value) {
        StatisticsParser sp = StatisticsParser.getParser();
        sp.parse(value);
        ArrayList<String> total = sp.getTotalList();
        String per = total.get(0).trim();
        return per;
    }

    public static boolean isWindows() {
        String fileseparator = System.getProperty("file.separator");
        return fileseparator.equals("\\");
    }

    public static boolean isWindowNT() {
        String detailOSType = System.getProperty("os.name");
        return detailOSType.equals("Windows NT") || detailOSType.equals("Windows 2000") || detailOSType.equals("Windows XP");
    }

    public static boolean isWindow9X() {
        String detailOSType = System.getProperty("os.name");
        return detailOSType.equals("Windows 95");
    }

    public boolean isRefreshable() {
        return this.menubar.isRefreshable();
    }

    public void enableHelpKey(Component comp, String id) {
        if (this.mainHB == null) {
            return;
        }
        this.mainHB.enableHelpKey(comp, id, null);
    }

    public void setHelpID(Component comp, String id) {
        if (this.mainHB == null || helpres == null) {
            return;
        }
        String mapped = helpres.getString(id);
        CSH.setHelpIDString((Component)comp, (String)mapped);
        this.setHelpMenuitem(mapped);
    }

    public void setHelpMenuitem(String id) {
        if (this.mainHB == null) {
            return;
        }
        this.mainHB.enableHelp((Component)this.menubar.Help_Menuitem, id, null);
        this.mainHB.enableHelp((Component)this.menubar.Help_Popup_Menuitem, id, null);
        this.mainHB.enableHelp((Component)this.toolbar.helpButton, id, null);
    }

    public void enableDialogHelp(Component comp, JButton button, String id, HelpSet hs) {
        if (this.mainHB == null) {
            return;
        }
        String helpid2 = helpres.getString(id);
        if (comp != null) {
            this.mainHB.enableHelpKey(comp, helpid2, hs);
        }
        if (button != null) {
            this.mainHB.enableHelpOnButton((Component)button, helpid2, hs);
        }
    }

    public DBAResourceBundle getResourceBundle() {
        return this.res;
    }

    public void freezeTreeSelection(boolean isFreeze) {
        this.menubar.freezeMenuitem(isFreeze);
        this.toolbar.freezeMenuitem(isFreeze);
        this.treePanel.freezeTreeSelection(isFreeze);
    }

    boolean initPrivilege(DatabaseConnection conn, String userName, Component comp) {
        boolean result = true;
        if (conn.isConnected) {
            try {
                if (conn.isIDCAP()) {
                    userName = userName.toUpperCase();
                }
                this.setUserPrivilege(new UserPrivilege(conn.getDbConnection(), userName, comp));
                conn.userPrivilege = this.userPrivilege;
            }
            catch (SQLException ex) {
                result = false;
                ex.printStackTrace();
            }
        } else {
            result = false;
        }
        if (!result || !conn.isDBTDE() || !this.userPrivilege.isSYSADM() && !this.userPrivilege.isSYSDBA()) {
            this.menubar.removeTDEMenuitem();
            this.toolbar.removeTDEButton();
        } else {
            this.menubar.addTDEMenuitem();
            this.toolbar.addTDEButton();
        }
        return result;
    }

    public UserPrivilege getUserPrivilege() {
        return this.userPrivilege;
    }

    private void setUserPrivilege(UserPrivilege userPrivilege) {
        this.userPrivilege = userPrivilege;
    }
}

