/*
 * Decompiled with CFR 0.152.
 */
package dbatool;

import dbatool.DbFrame;
import dbatool.LoginDlg;
import dbatool.ShowSQLDlg;
import dbatool.TableNameObject;
import dbatool.TreeNode.TableTreeNode;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.locale.LocaleManager;
import dbaut.privilege.UserPrivilege;
import dbaut.resource.DBAResourceBundle;
import dbaut.util.JavaTypeUtil;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DatabaseConnection {
    private Connection dbconn = null;
    private final String dbLogin = "jdbc:dbmaker:";
    private final String dbDriverName = "dbmaker.sql.JdbcOdbcDriver";
    public boolean isSecure = true;
    public String dbname = "";
    public String username = "";
    public String password = "";
    public boolean isConnected = false;
    private String db_dir = "";
    private Float fileversion = null;
    private Float version = null;
    private boolean isIDCAP = true;
    private boolean isDBTDE = false;
    private boolean startDB = false;
    private int dbPageSize = -1;
    private int blob_frame_size = -1;
    private int bepeIndex = -1;
    public int db_lcdec = 0;
    private Component dlg = null;
    UserPrivilege userPrivilege = null;
    private String[] optionStr = new String[]{"", "RESTRICT", "CASCADE"};

    public DatabaseConnection(String databaseName, String userName, String password, Component dlg) {
        this.dlg = dlg == null ? DbFrame.frame : dlg;
        Object stmt = null;
        Object rs = null;
        try {
            this.dbname = databaseName;
            this.username = userName;
            this.password = password;
            Class.forName("dbmaker.sql.JdbcOdbcDriver");
            JdmConfig config = new JdmConfig();
            if (config.isTerminalServer(this.dbname)) {
                System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
                if (!GuiUt.isWindows()) {
                    System.out.println("DM_CONNECT_MODE=START_DB");
                    System.setProperty("DM_CONNECT_MODE", "START_DB");
                    this.startDB = true;
                } else {
                    System.out.println("DM_CONNECT_MODE=SQL_DMTOOL_CONNECT_DB");
                    System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
                }
            } else {
                System.out.println("DM_DRIVER_MODE=CLIENT_SERVER");
                System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
                System.out.println("DM_CONNECT_MODE=SQL_DMTOOL_CONNECT_DB");
                System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
            }
            String errlcode = LocaleManager.getErrlcode();
            String conStr = "jdbc:dbmaker:" + this.dbname + ";errlcode=" + errlcode;
            this.dbconn = DriverManager.getConnection(conStr, this.username, password);
            this.dbconn.setAutoCommit(true);
            ((JdbcOdbcConnection)this.dbconn).setOption(1126, 2);
            ((JdbcOdbcConnection)this.dbconn).setOption(1136, 0);
            ((JdbcOdbcConnection)this.dbconn).setOption(1445, 1);
            this.setIDCAP(this.getIDCAP());
            this.isDBTDE = this.getDBTDE();
            this.getVersion();
            if (dlg instanceof LoginDlg) {
                DbFrame.frame.isConnect = true;
                DbFrame.frame.isLocalHost = LoginDlg.isLocalHost(databaseName);
            }
            this.isConnected = true;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            if (dlg instanceof LoginDlg) {
                DbFrame.frame.isConnect = false;
            }
            GuiUt.showSQLException(this.dlg, null, sqle);
            this.isConnected = false;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            GuiUt.showErrorDlg(this.dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUt.showErrorDlg(this.dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    public boolean isFileVersionLater35() {
        if (this.fileversion == null) {
            this.getVersion();
        }
        return this.fileversion != null && this.fileversion.floatValue() > 3.5f;
    }

    public boolean isFileVersionLater52() {
        if (this.fileversion == null) {
            this.getVersion();
        }
        return this.fileversion != null && this.fileversion.floatValue() > 5.2f;
    }

    public boolean isVersionLaterOrEqual36() {
        if (this.version == null) {
            this.getVersion();
        }
        return this.version != null && this.version.floatValue() >= 3.6f;
    }

    public boolean isIdexSvrOn() {
        boolean isIdexSvrOn = false;
        try {
            CallableStatement cstmt = this.getDbConnection().prepareCall("{call GETSYSTEMOPTION('IDXSV', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            int i = JavaTypeUtil.parseInt(cstmt.getString(1));
            isIdexSvrOn = i == 1;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            GuiUt.showErrorDlg(DbFrame.frame, sqle.getMessage(), "");
        }
        return isIdexSvrOn;
    }

    public String getCliLcode() {
        String cliLcode = null;
        try {
            Statement stmt = this.dbconn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT GETSYSINFO('CLILCODE') as CLILCODE");
            while (rs.next()) {
                cliLcode = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return cliLcode;
    }

    public int getDatabaseEncodingInInt() {
        int lcode = -1;
        try {
            Statement stmt = this.dbconn.createStatement();
            ResultSet rs = stmt.executeQuery("select GETSYSINFO('LCODE') as LCODE");
            if (rs.next()) {
                lcode = new Integer(rs.getString(1).trim());
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (lcode == -1) {
            lcode = 0;
        }
        return lcode;
    }

    public String getDatabaseEncoding() {
        String dbEncode = null;
        int lcode = -1;
        try {
            Statement stmt = this.dbconn.createStatement();
            ResultSet rs = stmt.executeQuery("select GETSYSINFO('LCODE') as LCODE");
            while (rs.next()) {
                lcode = new Integer(rs.getString(1).trim());
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        switch (lcode) {
            case 0: {
                dbEncode = "ASCII";
                break;
            }
            case 1: {
                dbEncode = "BIG5";
                break;
            }
            case 2: {
                dbEncode = "Shift-JIS";
                break;
            }
            case 3: {
                dbEncode = "GB2312";
                break;
            }
            case 4: {
                dbEncode = "ISO-8859-1";
                break;
            }
            case 5: {
                dbEncode = "ISO-8859-2";
                break;
            }
            case 6: {
                dbEncode = "ISO-8859-5";
                break;
            }
            case 7: {
                dbEncode = "ISO-8859-7";
                break;
            }
            case 8: {
                dbEncode = "EUC-JP";
                break;
            }
            case 9: {
                dbEncode = "GB18030";
                break;
            }
            case 10: {
                dbEncode = "UTF-8";
            }
        }
        return dbEncode;
    }

    public Connection getDbConnection() {
        return this.dbconn;
    }

    public void disconnect() {
        try {
            if (this.dbconn != null) {
                if (this.startDB) {
                    System.out.println("DM_DISCONNECT_MODE=TERMINATE_DB");
                    System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
                }
                this.dbconn.close();
            }
        }
        catch (SQLException E) {
            E.printStackTrace();
            if (E.getErrorCode() == 5307) {
                System.out.println(E.getMessage());
                return;
            }
            GuiUt.showSQLException(DbFrame.frame, null, E);
        }
    }

    public void setDBDir(String db_dir) {
        this.db_dir = db_dir != null ? db_dir.trim() : db_dir;
    }

    public String getDBDir() {
        return this.db_dir;
    }

    public void setBlobFrameSize(int size) {
        this.blob_frame_size = size;
    }

    public int getBlobFrameSize() {
        return this.blob_frame_size;
    }

    private void setDbPageSize(int dbPageSize) {
        this.dbPageSize = dbPageSize;
    }

    public int getDbPageSize() {
        return this.dbPageSize;
    }

    public int getBePeIndex() {
        if ((long)this.getDbPageSize() == 4096L) {
            this.bepeIndex = 0;
        } else if ((long)this.getDbPageSize() == 8192L) {
            this.bepeIndex = 1;
        } else if ((long)this.getDbPageSize() == 16384L) {
            this.bepeIndex = 2;
        } else if ((long)this.getDbPageSize() == 32768L) {
            this.bepeIndex = 3;
        }
        return this.bepeIndex;
    }

    public static boolean executeSQL(String query) {
        return DatabaseConnection.executeSQL(null, query, true);
    }

    public static boolean executeSQL(String query, boolean show_sql_script) {
        return DatabaseConnection.executeSQL(null, query, show_sql_script);
    }

    public static boolean executeSQL(Component comp, String query) {
        return DatabaseConnection.executeSQL(comp, query, true);
    }

    public static boolean executeSQL(Component comp, String query, boolean show_sql_script) {
        if (DbFrame.conn_DatabaseConnection == null) {
            return false;
        }
        int result = 0;
        if (DbFrame.frame.px.getShowSqlScript() && show_sql_script) {
            ShowSQLDlg dlg = ShowSQLDlg.createDlg(query);
            dlg.show();
            result = dlg.getResult();
            query = dlg.getSQLText();
            dlg.dispose();
        }
        if (result != 0) {
            return false;
        }
        Component mycomp = comp != null ? comp : DbFrame.frame;
        mycomp.setCursor(Cursor.getPredefinedCursor(3));
        Statement stmt = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            stmt.executeUpdate(query);
            stmt.close();
            stmt = null;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            mycomp.setCursor(Cursor.getDefaultCursor());
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            return false;
        }
        mycomp.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    public static boolean executeMultiSQL(String query) {
        return DatabaseConnection.executeMultiSQL(null, query);
    }

    public static boolean executeMultiSQL(Component comp, String query) {
        return DatabaseConnection.executeMultiSQL(comp, query, false);
    }

    public static boolean executeMultiSQL(Component comp, String query, boolean autoCommit) {
        return DatabaseConnection.executeMultiSQL(comp, query, true, autoCommit);
    }

    public static boolean executeMultiSQL(Component comp, String query, boolean show_sql_script, boolean autoCommit) {
        if (DbFrame.conn_DatabaseConnection == null) {
            return false;
        }
        int result = 0;
        if (DbFrame.frame.px.getShowSqlScript() && show_sql_script) {
            ShowSQLDlg dlg = ShowSQLDlg.createDlg(query);
            dlg.show();
            result = dlg.getResult();
            query = dlg.getSQLText();
            dlg.dispose();
        }
        if (result != 0) {
            return false;
        }
        Component mycomp = comp != null ? comp : DbFrame.frame;
        mycomp.setCursor(Cursor.getPredefinedCursor(3));
        Statement stmt = null;
        try {
            if (!autoCommit) {
                DbFrame.conn_DatabaseConnection.getDbConnection().setAutoCommit(false);
            }
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            int pos = 0;
            while (pos >= 0) {
                pos = query.indexOf(";");
                if (pos < 0) {
                    if (query.trim().length() == 0) break;
                    pos = query.length();
                }
                String oneSQL = query.substring(0, pos);
                stmt.executeUpdate(oneSQL);
                if (pos == query.length()) {
                    query = "";
                    continue;
                }
                query = query.substring(pos + 1).trim();
            }
            stmt.close();
            stmt = null;
            DbFrame.conn_DatabaseConnection.getDbConnection().setAutoCommit(true);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            mycomp.setCursor(Cursor.getDefaultCursor());
            DbaObject.rollback(DbFrame.conn_DatabaseConnection.getDbConnection());
            DbaObject.setAutoCommit(DbFrame.conn_DatabaseConnection.getDbConnection(), true);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            return false;
        }
        mycomp.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    public boolean dropReplication(String repl_name, String owner, String name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_replication");
        String str2 = GuiUt.mapStringForProperty(str1, repl_name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Drop_Replication"), str2 + " ?");
        if (reply != 0) {
            return false;
        }
        String query = "DROP REPLICATION \"" + repl_name + "\"" + " FROM \"" + owner + "\".\"" + name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean removeJarfile(String owner, String name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_remove_jar_file");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Remove_Jar_File"), str2 + " ?");
        if (reply != 0) {
            return false;
        }
        String query = "REMOVE JARFILE ";
        if (owner.length() > 0) {
            query = query + "\"" + owner + "\".";
        }
        query = query + "\"" + name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropProcedure(String module, String owner, String name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_stored_procedure");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Drop_Stored_Procedure"), str2 + " ?");
        if (reply != 0) {
            return false;
        }
        String query = "DROP PROCEDURE ";
        if (module.length() > 0) {
            query = query + "\"" + module + "\".";
        }
        if (owner.length() > 0) {
            query = query + "\"" + owner + "\".";
        }
        query = query + "\"" + name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropFunction(String owner, String name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_function");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Drop_Function"), str2 + " ?");
        if (reply != 0) {
            return false;
        }
        String query = "DROP FUNCTION ";
        query = query + "\"" + name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropCommand(String owner, String name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_stored_command");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Drop_Stored_Command"), str2 + "?");
        if (reply != 0) {
            return false;
        }
        String query = "DROP COMMAND ";
        query = owner.length() > 0 ? query + "\"" + owner + "\".\"" + name + "\"" : query + "\"" + name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropTask(String owner, String name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_task");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Drop_Task"), str2 + "?");
        if (reply != 0) {
            return false;
        }
        String query = "{call TASK_DROP('" + GuiUt.getIDString(owner) + "." + GuiUt.getIDString(name) + "')} ";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropSchedule(String name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_schedule");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Drop_Schedule"), str2 + "?");
        if (reply != 0) {
            return false;
        }
        String query = "DROP SCHEDULE FOR REPLICATION TO \"" + name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropGroup(String group_name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_group");
        String str2 = GuiUt.mapStringForProperty(str1, group_name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Drop_Group"), str2 + " ?");
        if (reply != 0) {
            return false;
        }
        String query = "DROP GROUP \"" + group_name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropUser(String user_name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_user");
        String str2 = GuiUt.mapStringForProperty(str1, user_name);
        int[] option = new int[1];
        int reply = GuiUt.showDropOptionsDlg(DbFrame.frame, res.getString("revoke_connect"), str2, option);
        if (reply != 0) {
            return false;
        }
        String query = "REVOKE CONNECT FROM \"" + user_name + "\" " + this.optionStr[option[0]];
        return DatabaseConnection.executeSQL(query);
    }

    public boolean truncateTable(TableTreeNode node) {
        return this.dropTable(node.getTableOwner(), node.getTableName());
    }

    public boolean truncateTable(String table_owner, String table_name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_truncate_table");
        String str2 = GuiUt.mapStringForProperty(str1, table_owner + "." + table_name);
        int[] option = new int[1];
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Truncate_Table"), str2 + " ?");
        if (reply != 0) {
            return false;
        }
        String query = "TRUNCATE TABLE \"" + table_owner + "\".\"" + table_name + "\" ";
        boolean rc = DatabaseConnection.executeSQL(query);
        return rc;
    }

    public boolean dropTable(TableTreeNode node) {
        return this.dropTable(node.getTableOwner(), node.getTableName());
    }

    public boolean dropTable(String table_owner, String table_name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_table");
        String str2 = GuiUt.mapStringForProperty(str1, table_owner + "." + table_name);
        int[] option = new int[1];
        int reply = GuiUt.showDropOptionsDlg(DbFrame.frame, res.getString("Drop_Table"), str2 + " ?", option);
        if (reply != 0) {
            return false;
        }
        String query = "DROP TABLE \"" + table_owner + "\".\"" + table_name + "\" " + this.optionStr[option[0]];
        return DatabaseConnection.executeSQL(query);
    }

    public boolean disableAllIndex(String table_owner, String table_name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_disable_all_index");
        String str2 = GuiUt.mapStringForProperty(str1, table_owner + "." + table_name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Disable_All"), str2);
        if (reply != 0) {
            return false;
        }
        String query = "DISABLE INDEX ALL for \"" + table_owner + "\".\"" + table_name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean rebuildAllIndex(String table_owner, String table_name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_rebuild_all_index");
        String str2 = GuiUt.mapStringForProperty(str1, table_owner + "." + table_name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Rebuild_All"), str2);
        if (reply != 0) {
            return false;
        }
        String query = "REBUILD INDEX ALL for \"" + table_owner + "\".\"" + table_name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean deleteFromTable(String table_owner, String table_name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_delete_from_table");
        String str2 = GuiUt.mapStringForProperty(str1, table_owner + "." + table_name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Delete_From_Table"), str2 + " ?");
        if (reply != 0) {
            return false;
        }
        String query = "DELETE FROM \"" + table_owner + "\".\"" + table_name + "\" ";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropTrigger(String trig_name, String table_owner, String table_name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_trigger");
        String str2 = GuiUt.mapStringForProperty(str1, trig_name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Drop_Trigger"), str2 + " ?");
        if (reply != 0) {
            return false;
        }
        String query = "DROP TRIGGER \"" + trig_name + "\" FROM \"" + table_owner + "\".\"" + table_name + "\"";
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropView(String view_owner, String view_name) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_view");
        String str2 = GuiUt.mapStringForProperty(str1, view_owner + "." + view_name);
        int[] option = new int[1];
        int reply = GuiUt.showDropOptionsDlg(DbFrame.frame, res.getString("Drop_View"), str2 + " ?", option);
        if (reply != 0) {
            return false;
        }
        String query = "DROP VIEW \"" + view_owner + "\".\"" + view_name + "\" " + this.optionStr[option[0]];
        return DatabaseConnection.executeSQL(query);
    }

    public boolean dropTablespace(String ts_name, boolean isTreeLaunch) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String str1 = res.getString("Do_you_want_to_drop_tablespace");
        String str2 = GuiUt.mapStringForProperty(str1, ts_name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, res.getString("Drop_Tablespace"), str2 + " ?");
        if (reply != 0) {
            return false;
        }
        Vector v = this.getTableSpacePhysicalFileName(ts_name);
        if (v == null) {
            return false;
        }
        String query = "DROP TABLESPACE \"" + ts_name + "\"";
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            if (DbFrame.frame.isLocalHost) {
                this.dropPhysicalFiles(v);
            } else {
                GuiUt.showWarningDlg(DbFrame.frame, res.getString("Warning"), res.getString("Cannot_delete_remote_database_tablespace_files"));
            }
        }
        return result;
    }

    public Vector getTableSpacePhysicalFileName(String ts_name) {
        Vector<String[]> v = new Vector<String[]>();
        String[] strA = null;
        Statement stmt = null;
        ResultSet rs = null;
        String str = "SELECT FILE_NAME, GETFILENAME(FILE_NAME) FROM SYSTEM.SYSFILE WHERE TS_NAME = '" + ts_name + "'";
        try {
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery(str);
            while (rs.next()) {
                strA = new String[]{rs.getString(1).trim(), rs.getString(2).trim()};
                v.addElement(strA);
            }
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        catch (SQLException sqlefile) {
            sqlefile.printStackTrace();
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqlefile);
            return null;
        }
        return v;
    }

    public void dropPhysicalFiles(Vector v) {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        String filename = "";
        boolean b = true;
        String[] strA = null;
        JdmConfig config = new JdmConfig();
        config.fileOpen("dmconfig.ini", DbFrame.conn_DatabaseConnection.dbname, "r+");
        for (int i = 0; i < v.size(); ++i) {
            strA = (String[])v.elementAt(i);
            filename = strA[1];
            System.out.println(filename);
            File f = new File(filename);
            b = f.delete();
            if (!b) {
                GuiUt.showErrorDlg(DbFrame.frame, filename + " " + res.getString("deletion_failed"), null);
                continue;
            }
            config.procDelete(strA[0], 0);
        }
        config.fileClose();
    }

    public int searchTableNameObject(Vector v, String owner, String name) {
        if (owner == null || name == null) {
            return 0;
        }
        int size = v.size();
        TableNameObject obj = null;
        for (int i = 0; i < size; ++i) {
            obj = (TableNameObject)v.elementAt(i);
            if (!obj.owner.equals(owner) || !obj.name.equals(name)) continue;
            return i;
        }
        return 0;
    }

    public Vector getTablespaceNames() {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> v = new Vector<String>(5);
        try {
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("select TS_NAME from SYSTABLESPACE where TS_NAME != 'SYSTABLESPACE'");
            while (rs.next()) {
                v.addElement(GuiUt.rightTrim(rs.getString(1)));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException qtse) {
            qtse.printStackTrace();
            GuiUt.showSQLException(DbFrame.frame, null, qtse);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        return v;
    }

    public Vector getTableNames() {
        DatabaseMetaData dbmd = null;
        ResultSet dbmdrs = null;
        Vector<TableNameObject> v = new Vector<TableNameObject>();
        try {
            dbmd = this.dbconn.getMetaData();
            dbmdrs = dbmd.getTables(null, null, null, null);
            while (dbmdrs.next()) {
                if (!dbmdrs.getString(4).equals("TABLE")) continue;
                v.addElement(new TableNameObject(GuiUt.rightTrim(dbmdrs.getString(2)), GuiUt.rightTrim(dbmdrs.getString(3))));
            }
            dbmdrs.close();
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            DbaObject.close(dbmdrs);
        }
        return v;
    }

    public Vector getUserNames() {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> v = new Vector<String>();
        try {
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("SELECT USER_NAME FROM SYSAUTHUSER");
            while (rs.next()) {
                v.addElement(rs.getString(1));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        v.insertElementAt("", 0);
        return v;
    }

    public Vector getTextConverterName() {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> v = new Vector<String>();
        try {
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("SELECT FUNC_NAME FROM SYSUSERFUNC WHERE (RETURN_TYPE = 'NCLOB' OR RETURN_TYPE = 'CLOB' OR RETURN_TYPE = 'LONG VARCHAR') AND  NUM_OF_PARAMETER = 1 AND (PARAMETER = '1 BLOB' OR PARAMETER = '1 CLOB' OR PARAMETER = '1 NCLOB' or PARAMETER = '1 FILE' or PARAMETER = '1 LONG VARBINARY' or PARAMETER = '1 LONG VARCHAR')");
            String domainNameStr = null;
            while (rs.next()) {
                domainNameStr = rs.getString(1).trim();
                if (domainNameStr.equalsIgnoreCase("PURETEXT")) continue;
                v.addElement(domainNameStr);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        v.insertElementAt("", 0);
        return v;
    }

    public int indexOfTableNames(Vector v, String owner, String name) {
        int i = 0;
        int size = v.size();
        TableNameObject tnObj = null;
        for (i = 0; i < size; ++i) {
            tnObj = (TableNameObject)v.elementAt(i);
            if (!tnObj.owner.equals(owner) || !tnObj.name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public boolean isTableNameExist(String owner, String table) {
        String query = "select TABLE_NAME from SYSTABLE where TABLE_TYPE = 'TABLE' and TABLE_OWNER='" + owner + "' and TABLE_NAME='" + GuiUt.singleQuoteHandle(table) + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isTablespaceNameExist(String tsname) {
        String query = "select TS_NAME from SYSTABLESPACE where TS_NAME = '" + GuiUt.singleQuoteHandle(tsname) + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isFKNameExist(TableNameObject tnobj, String fkname) {
        String query = "select FK_NAME from SYSFOREIGNKEY where FK_TBL_OWNER = '" + tnobj.owner + "' and FK_TBL_NAME = '" + tnobj.name + "' and FK_NAME = '" + GuiUt.singleQuoteHandle(fkname) + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isIndexNameExist(TableNameObject tnobj, String indexname) {
        String query = "select INDEX_NAME from SYSINDEX where TABLE_OWNER = '" + tnobj.owner + "' and TABLE_NAME = '" + tnobj.name + "' and INDEX_NAME = '" + GuiUt.singleQuoteHandle(indexname) + "' and UNIQUE != 3";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isTextIndexNameExist(TableNameObject tnobj, String textindexname) {
        String query = "select TEXTINDEX_NAME from SYSTEXTINDEX where TABLE_OWNER = '" + tnobj.owner + "' and TABLE_NAME = '" + tnobj.name + "' and TEXTINDEX_NAME = '" + GuiUt.singleQuoteHandle(textindexname) + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isTriggerNameExist(TableNameObject tnobj, String triggername) {
        String query = "select TRIGNAME from SYSTRIGGER where TBOWNER = '" + tnobj.owner + "' and TBNAME = '" + tnobj.name + "' and TRIGNAME = '" + GuiUt.singleQuoteHandle(triggername) + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isViewNameExist(String owner, String viewname) {
        String query = "select TABLE_NAME from SYSTABLE where TABLE_OWNER = '" + owner + "' and TABLE_NAME = '" + GuiUt.singleQuoteHandle(viewname) + "' and TABLE_TYPE = 'VIEW'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isUserNameExist(String username) {
        String query = "select USER_NAME from SYSAUTHUSER where USER_NAME = '" + GuiUt.singleQuoteHandle(username) + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isGroupNameExist(String groupname) {
        String query = "select GROUP_NAME from SYSAUTHGROUP where GROUP_NAME = '" + GuiUt.singleQuoteHandle(groupname) + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isDomainNameExist(String domainname) {
        String query = "select DOMAIN_NAME from SYSDOMAIN where DOMAIN_NAME = '" + GuiUt.singleQuoteHandle(domainname) + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isSynonymExist(String synonym) {
        String query = "select SNAME from SYSSYNONYM where SNAME = '" + GuiUt.singleQuoteHandle(synonym) + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isScheduleExist(String schedule) {
        String query = "select SVRNAME from SYSTEM.SYSTRPDEST where ucase(SVRNAME) = '" + GuiUt.singleQuoteHandle(schedule).toUpperCase() + "'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isSynchronousExist(String synchronous, String owner, String table) {
        String query = "select REPLICATION_NAME from SYSTEM.SYSPUBLISH where REPLICATION_NAME = '" + GuiUt.singleQuoteHandle(synchronous) + "' and TABLE_OWNER ='" + owner + "' and TABLE_NAME = '" + table + "' and TYPE = 'S'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isAsynchronousExist(String synchronous, String owner, String table) {
        String query = "select REPLICATION_NAME from SYSTEM.SYSPUBLISH where REPLICATION_NAME = '" + GuiUt.singleQuoteHandle(synchronous) + "' and TABLE_OWNER ='" + owner + "' and TABLE_NAME = '" + table + "' and TYPE = 'A'";
        boolean result = this.querySQL(null, query);
        return result;
    }

    public boolean isLegalDatabaseObjectName(String s) {
        boolean b = true;
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (i == 0 && (Character.isLetter(c) || c == '_')) {
                b = true;
                continue;
            }
            if (i == 0) {
                b = false;
                return b;
            }
            if (Character.isSpaceChar(c)) {
                b = false;
                return b;
            }
            if (Character.isLetterOrDigit(c) || c == '_') {
                b = true;
                continue;
            }
            b = false;
            return b;
        }
        return b;
    }

    private boolean querySQL(Component comp, String query) {
        if (DbFrame.conn_DatabaseConnection == null) {
            return false;
        }
        Component mycomp = comp != null ? comp : DbFrame.frame;
        mycomp.setCursor(Cursor.getPredefinedCursor(3));
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(query);
            boolean isFound = false;
            if (rs.next()) {
                isFound = true;
            }
            rs.close();
            stmt.close();
            mycomp.setCursor(Cursor.getDefaultCursor());
            return isFound;
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
            mycomp.setCursor(Cursor.getDefaultCursor());
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqlex);
            this.isConnected = false;
            return false;
        }
    }

    private void getVersion() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.db_dir = JdmConfig.getDBDir(this.dbname);
            JdmConfig config = new JdmConfig();
            config.fileOpen("dmconfig.ini", this.dbname, "r");
            Object value = config.getPara("DB_LCDEC", 8192);
            this.db_lcdec = value != null ? (Integer)value : 0;
            config.fileClose();
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("SELECT VALUE FROM SYSTEM.SYSINFO WHERE INFO IN ('FILE_VERSION', 'VERSION', 'DB_PAGE_SIZE') ORDER BY ID");
            if (rs.next()) {
                this.setDbPageSize(Integer.valueOf(rs.getString(1)));
            }
            if (rs.next()) {
                this.version = new Float(rs.getString(1));
            }
            if (rs.next()) {
                this.fileversion = new Float(rs.getString(1));
            }
            rs.close();
            if (this.version.floatValue() >= 3.6f) {
                rs = stmt.executeQuery("SELECT GETSYSINFO('DBDIR') FROM SYSTEM.SYSINFO");
                if (rs.next()) {
                    this.db_dir = rs.getString(1);
                    if (this.db_dir != null) {
                        this.db_dir = this.db_dir.trim();
                    }
                }
                rs.close();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            GuiUt.showSQLException(this.dlg, null, sqle);
            DbaObject.close(rs);
        }
        DbaObject.close(stmt);
    }

    public void setErrlcode(String errlcode) {
        try {
            if (this.isConnected && this.dbconn != null) {
                ((JdbcOdbcConnection)this.dbconn).setOption(1145, errlcode);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            GuiUt.showSQLException(this.dlg, null, sqle);
        }
    }

    private boolean getIDCAP() throws SQLException {
        boolean result = false;
        int value = ((JdbcOdbcConnection)this.dbconn).getOptionInt(28);
        if (value == 1) {
            result = true;
        }
        return result;
    }

    private boolean getDBTDE() throws SQLException {
        boolean result = false;
        try {
            Statement stmt = this.dbconn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT VALUE FROM SYSINFO WHERE ID = '0724'");
            String tdeOpen = null;
            if (rs.next()) {
                tdeOpen = rs.getString(1).trim();
                result = tdeOpen.compareToIgnoreCase("ON") == 0;
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isDBTDE() {
        return this.isDBTDE;
    }

    public boolean isIDCAP() {
        return this.isIDCAP;
    }

    private void setIDCAP(boolean isIDCAP) {
        this.isIDCAP = isIDCAP;
    }

    public boolean isSYSADM() {
        return this.userPrivilege.isSYSADM();
    }

    public boolean isSYSDBA() {
        return this.userPrivilege.isSYSDBA();
    }
}

