/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Alarm;

import dbatool.Alarm.Sleeper;
import java.util.Vector;

public class Alarm {
    private Vector sleepers = new Vector();

    public synchronized void setAlarm(Sleeper s, long time) {
        if (time == 0L) {
            System.out.println("Can't set timer in 0 second");
            return;
        }
        this.sleepers.addElement(s);
        new AlarmThread(s, time *= 1000L).start();
    }

    public synchronized void cancelAlarm(Sleeper s) {
        int index = this.sleepers.indexOf(s);
        this.sleepers.removeElementAt(index);
    }

    private synchronized void wakeUpSleeper(Sleeper s) {
        int index = this.sleepers.indexOf(s);
        if (index < 0) {
            return;
        }
        s.wakeUp();
    }

    private class AlarmThread
    extends Thread {
        Sleeper s = null;
        long time = 0L;

        AlarmThread(Sleeper s, long time) {
            this.s = s;
            this.time = time;
        }

        @Override
        public void run() {
            try {
                AlarmThread.sleep(this.time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Alarm.this.wakeUpSleeper(this.s);
        }
    }
}

