/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.ExecutorManager;
import controller.UIManager;
import executor.Command;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import parser.ASTStart;
import parser.Jsql2Parser;
import parser.Jsql2TreeVistor;
import parser.jsqlparser.PreParser;
import reporter.Reporter;
import ui.JsqlUI;
import ui.gui.JsqlGUI;

public class ParserManager {
    private UIManager uiManager = null;
    private ExecutorManager executorManager = null;
    private Reporter reporter = null;
    private JsqlUI ui = null;
    private Jsql2Parser parser = null;

    public ParserManager(UIManager uiManager) {
        this.uiManager = uiManager;
        this.reporter = uiManager.getReporter();
        this.ui = uiManager.getUI();
        this.executorManager = new ExecutorManager(this);
        this.parser = new Jsql2Parser(new StringReader(""));
    }

    public void parse(String cmd) {
        StringReader sr = new StringReader(cmd);
        this.parser.ReInit(sr);
        try {
            ASTStart n = this.parser.Start();
            Command command = Jsql2TreeVistor.getCommand(this.ui, n);
            this.executorManager.execute(command);
            if (cmd.length() > 0) {
                this.ui.addCmdToHisLists(cmd);
            }
        }
        catch (Exception e) {
            System.out.println("Parser: " + e.getMessage());
            System.out.println("use callable statement to execute this unkown statement.");
        }
        catch (Throwable e) {
            System.out.println("Parser: " + e.getMessage());
            System.out.println("use callable statement to execute this unkown statement.");
        }
    }

    private void updateGUI(final String tmp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ((JsqlGUI)ParserManager.this.ui).getFrame().getSimulator().setCmdPromptText(tmp);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void parse(Reader reader) {
        BufferedReader br = new BufferedReader(reader);
        String line = "";
        StringBuffer sb = new StringBuffer();
        int i = 1;
        boolean needMore = false;
        String pro = "jsql> ";
        try {
            while ((line = br.readLine()) != null) {
                String newPro;
                String str;
                int b;
                if (line != null && line.trim().length() > 0) {
                    this.reporter.reportln(pro + line);
                    sb.append(line);
                    if (!PreParser.isOneCMDFinished(sb.toString())) {
                        needMore = true;
                        b = pro.indexOf("> ");
                        str = pro.substring(0, b);
                        newPro = String.format("%" + str.length() + "s", ++i);
                        pro = newPro + "> ";
                        if (!(this.ui instanceof JsqlGUI)) continue;
                        this.updateGUI(pro);
                        continue;
                    }
                    needMore = false;
                    i = 1;
                    String cmd = sb.toString();
                    sb = new StringBuffer();
                    this.parse(cmd);
                    pro = "jsql> ";
                    if (!(this.ui instanceof JsqlGUI)) continue;
                    this.updateGUI(pro);
                    continue;
                }
                if (needMore) {
                    this.reporter.reportln(pro);
                    if (this.ui instanceof JsqlGUI) {
                        this.updateGUI(pro);
                    }
                    b = pro.indexOf("> ");
                    str = pro.substring(0, b);
                    newPro = String.format("%" + str.length() + "s", ++i);
                    pro = newPro + "> ";
                    continue;
                }
                this.reporter.reportln("jsql> ");
                this.reporter.reportln();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

