/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.dm.dba.sca.role;

import com.syscom.dm.dba.sca.AbstractDbaAuthority;
import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthority;
import com.syscom.dm.dba.sca.role.Role;

public class Connect
extends AbstractDbaAuthority
implements Role,
DbaAuthority {
    public Connect(ComponentPrivilege privilege) {
        super(privilege);
        super.setRole(this);
    }

    @Override
    public boolean isAuthorisedOnce(String owner, String name) {
        boolean result = false;
        switch (this.getComponentPrivilege().getComponentType()) {
            case 101: {
                result = this.getPrivilege().hasSelectAllPrivilege(owner, name);
                break;
            }
            case 701: {
                if (this.isSystem(owner)) break;
                result = this.getPrivilege().canModifyData(owner, name);
                break;
            }
            case 102: {
                result = this.getPrivilege().hasSelectAllPrivilege(owner, name);
                break;
            }
            case 108: {
                result = this.getComponentRole().isAuthorised();
            }
        }
        return result;
    }

    @Override
    public boolean isAuthorised(String owner, String name) {
        boolean result = false;
        switch (this.getComponentPrivilege().getComponentType()) {
            case 701: {
                if (this.isSystem(owner)) break;
                result = this.getPrivilege().hasDeleteAllPrivilege(owner, name);
                break;
            }
            case 201: {
                if (this.isSystem(owner)) break;
                result = this.getPrivilege().hasAlterAllPrivilege(owner, name);
            }
        }
        return result;
    }

    @Override
    public boolean isConnect() {
        return true;
    }
}

