/*
 * Decompiled with CFR 0.152.
 */
package ServerMgr;

import ServerMgr.SmFrame;
import com.syscom.dm.svrmgr.sca.DefaultSvrmgrAuthority;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.locale.LocaleManager;
import dbaut.privilege.InsufficientPrivilegeException;
import dbaut.privilege.UserPrivilege;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JDialog;

public class DatabaseConnection {
    public Connection dbconn;
    private static String dbLogin = "jdbc:dbmaker:";
    private static String dbDriverName = "dbmaker.sql.JdbcOdbcDriver";
    private String dbname = "";
    private String username = "";
    private String dbdir = "";
    private Float fileversion = null;
    private Float version = null;
    public boolean result = false;
    private Component dlg = null;
    private boolean isConnected = false;
    private boolean startDB = false;
    private boolean isIDCAP = true;
    private UserPrivilege userPrivilege = null;

    public DatabaseConnection(String dbname, String username, String password, Component dlg) {
        this(dbname, username, password, dlg, false);
    }

    public DatabaseConnection(String dbname, String username, String password, Component dlg, boolean isCreateDB) {
        this.dlg = dlg == null ? SmFrame.frame : dlg;
        Object stmt = null;
        try {
            this.dbname = dbname;
            this.username = username;
            Class.forName(dbDriverName);
            JdmConfig config = new JdmConfig();
            if (config.isTerminalServer(dbname)) {
                System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
                if (isCreateDB) {
                    System.setProperty("DM_CONNECT_MODE", "CREATE_DB");
                } else if (!GuiUt.isWindows()) {
                    System.setProperty("DM_CONNECT_MODE", "START_DB");
                    this.startDB = true;
                } else {
                    System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
                }
            } else {
                if (isCreateDB) {
                    System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
                } else {
                    System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
                }
                if (isCreateDB) {
                    System.setProperty("DM_CONNECT_MODE", "CREATE_DB");
                } else {
                    System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
                }
            }
            String errlcode = LocaleManager.getErrlcode();
            String conStr = dbLogin + dbname + ";errlcode=" + errlcode;
            this.dbconn = DriverManager.getConnection(conStr, username, password);
            this.setIDCAP(this.getIDCAP());
            this.isConnected = this.result = this.initPrivilege(this.dbconn, this.username, this.dlg);
            if (isCreateDB) {
                return;
            }
            this.dbconn.setAutoCommit(true);
            ((JdbcOdbcConnection)this.dbconn).setOption(1126, 2);
            this.getVersion();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.dlg, null, sqle);
            this.result = false;
            this.isConnected = false;
            DbaObject.close(stmt);
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private boolean initPrivilege(Connection conn, String userName, Component comp) {
        boolean result = true;
        try {
            if (this.isIDCAP()) {
                userName = userName.toUpperCase();
            }
            this.setUserPrivilege(new UserPrivilege(conn, userName, comp));
        }
        catch (SQLException ex) {
            result = false;
            ex.printStackTrace();
        }
        return result;
    }

    public UserPrivilege getUserPrivilege() {
        return this.userPrivilege;
    }

    private void setUserPrivilege(UserPrivilege userPrivilege) {
        this.userPrivilege = userPrivilege;
    }

    private void getVersion() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.dbdir = JdmConfig.getDBDir(this.dbname);
            stmt = this.dbconn.createStatement();
            String sql = "select VALUE from SYSTEM.SYSINFO WHERE INFO in ('FILE_VERSION', 'VERSION') ORDER BY ID";
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                this.version = new Float(rs.getString(1));
            }
            if (rs.next()) {
                this.fileversion = new Float(rs.getString(1));
            }
            rs.close();
            if (this.version.floatValue() >= 3.6f) {
                String sql1 = "SELECT GETSYSINFO('DBDIR') FROM SYSTEM.SYSINFO";
                rs = stmt.executeQuery(sql1);
                if (rs.next()) {
                    this.dbdir = rs.getString(1);
                    if (this.dbdir != null) {
                        this.dbdir = this.dbdir.trim();
                    }
                }
                rs.close();
            }
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.dlg, null, sqle);
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    public boolean disconnect() {
        try {
            if (this.dbconn != null) {
                if (this.startDB) {
                    System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
                }
                if (!this.dbconn.isClosed()) {
                    this.dbconn.close();
                }
                this.isConnected = false;
            }
            return true;
        }
        catch (SQLException E) {
            System.out.println("Transaction failed : " + E.getMessage());
            this.isConnected = false;
            GuiUt.showSQLException(SmFrame.frame, null, E);
            return false;
        }
    }

    public static boolean isServerOn(String dbname, String user, String password) throws SQLException {
        try {
            JdmConfig config = new JdmConfig();
            Integer default_ctimo = null;
            int rc = config.fileOpen("dmconfig.ini", dbname, "r+");
            if (rc == 0) {
                default_ctimo = (Integer)config.getPara("DB_CTIMO", 8192);
                config.insertPara("DB_CTIMO", new Integer(5), 8192);
                config.fileClose();
            }
            System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
            System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
            Class.forName(dbDriverName);
            String errlcode = LocaleManager.getErrlcode();
            String conStr = dbLogin + dbname + ";errlcode=" + errlcode;
            Connection conn = DriverManager.getConnection(conStr, user, password);
            if (default_ctimo != null) {
                config.fileOpen("dmconfig.ini", dbname, "r+");
                config.insertPara("DB_CTIMO", default_ctimo, 8192);
                config.fileClose();
            }
            if (conn != null) {
                conn.close();
                return true;
            }
            System.out.println("conn is null");
            return false;
        }
        catch (SQLException sqle) {
            if (sqle.getSQLState().equals("28000")) {
                throw sqle;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void shutdowndatabase(JDialog dlg, String name, String user, String psword) throws InsufficientPrivilegeException {
        Object stmt = null;
        try {
            Class.forName(dbDriverName);
            JdmConfig config = new JdmConfig();
            if (config.isTerminalServer(name)) {
                return;
            }
            System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
            System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
            String errlcode = LocaleManager.getErrlcode();
            String conStr = dbLogin + name + ";errlcode=" + errlcode;
            Connection conn = DriverManager.getConnection(conStr, user, psword);
            UserPrivilege privilege = new UserPrivilege(conn, user, dlg);
            DefaultSvrmgrAuthority authority = new DefaultSvrmgrAuthority(privilege);
            if (!authority.isAboveDba()) {
                authority.errorIsNotDBA(dlg);
                conn.close();
                throw new InsufficientPrivilegeException();
            }
            System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
            conn.close();
            System.setProperty("DM_DISCONNECT_MODE", "DISCONNECT_DB");
        }
        catch (SQLException sqle) {
            System.out.println(sqle.getMessage());
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public float getFileVersion() {
        Float tmp = this.fileversion;
        if (tmp == null) {
            return 0.0f;
        }
        return tmp.floatValue();
    }

    private boolean getIDCAP() throws SQLException {
        boolean result = false;
        int value = ((JdbcOdbcConnection)this.dbconn).getOptionInt(28);
        if (value == 1) {
            result = true;
        }
        return result;
    }

    public boolean isIDCAP() {
        return this.isIDCAP;
    }

    private void setIDCAP(boolean isIDCAP) {
        this.isIDCAP = isIDCAP;
    }
}

