/*
 * Decompiled with CFR 0.152.
 */
package ServerMgr;

import DmEditor.MainDlg;
import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import ServerMgr.SvrMgrDlg;
import com.borland.jbcl.layout.VerticalFlowLayout;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.VersionManager;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.dbalib;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.textField.CharField;
import dbaut.textField.FilePathField;
import dbaut.textField.IntegerRangeField;
import dbaut.util.PlatformUtil;
import dbaut.winlib;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CreateDatabaseDlg
extends JDialog
implements SvrMgrDlg {
    private boolean result = false;
    private boolean new_section = false;
    private boolean old_section = false;
    private String new_dbname = null;
    private CharField Database_Name = new CharField(128, true);
    private FilePathField Database_Directory;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private CharField Server_Address;
    private JCheckBox Multi_User;
    private IntegerRangeField Server_Port_Number;
    private DbaButton Create_Button;
    private DbaButton Setup_Button;

    public CreateDatabaseDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.Database_Directory = new FilePathField(this, "", SmFrame.frame.res.getString("Select_Path"), true);
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.Server_Address = new CharField(255, true);
        this.Multi_User = new JCheckBox();
        this.Server_Port_Number = new IntegerRangeField(65535, 1025);
        this.Create_Button = new DbaButton(SmFrame.frame.res.getString("Create"), 'R', new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Setup_Button = new DbaButton(SmFrame.frame.res.getString("Setup"), 'S', new ReflectionAction(this, "Setup_Button_actionPerformed"));
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CreateDatabaseDlg(Frame frame) {
        super(frame);
        this.Database_Directory = new FilePathField(this, "", SmFrame.frame.res.getString("Select_Path"), true);
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.Server_Address = new CharField(255, true);
        this.Multi_User = new JCheckBox();
        this.Server_Port_Number = new IntegerRangeField(65535, 1025);
        this.Create_Button = new DbaButton(SmFrame.frame.res.getString("Create"), 'R', new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Setup_Button = new DbaButton(SmFrame.frame.res.getString("Setup"), 'S', new ReflectionAction(this, "Setup_Button_actionPerformed"));
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setName("CreateDatabaseDialog");
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JPanel jPanel9 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        JLabel jLabel1 = new JLabel(SmFrame.frame.res.getString("Database_Name"));
        JLabel jLabel2 = new JLabel(SmFrame.frame.res.getString("Database_Directory"));
        JPanel jPanel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel jPanel4 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 2, true, false));
        DbaButton Cancel_Button = new DbaButton(SmFrame.frame.res.getString("Cancel"), 'C', new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        SmHelpButton help_Button = new SmHelpButton();
        this.Create_Button.setName("CreateButton");
        this.Create_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/database.gif"));
        Cancel_Button.setName("CancelButton");
        Cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.Setup_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"));
        SmFrame.frame.enableDialogHelp(this.getRootPane(), help_Button, "CreateDatabaseDlgHelpIDInformation", null);
        this.setTitle(SmFrame.frame.res.getString("Create_Database"));
        this.getContentPane().setLayout(new BorderLayout());
        this.Database_Directory.setName("DatabaseDirectoryPanel");
        this.Database_Directory.setBorder(BorderFactory.createLoweredBevelBorder());
        this.Database_Directory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateDatabaseDlg.this.Database_Directory_keyReleased(null);
            }
        });
        this.Database_Name.setName("DatabaseNameField");
        this.Database_Name.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    CreateDatabaseDlg.this.Database_Name_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CreateDatabaseDlg.this.Database_Name_keyReleased(e);
            }
        });
        this.jLabel3.setText(SmFrame.frame.res.getString("Server_Port_Number"));
        this.jLabel4.setText(SmFrame.frame.res.getString("Server_Address"));
        this.jLabel5.setText("(1025-65535)");
        this.Server_Address.setName("ServerAddressField");
        this.Server_Address.setPreferredSize(new Dimension(4, 24));
        this.Server_Address.setText(SmFrame.frame.local_address);
        this.Multi_User.addActionListener(new ReflectionAction(this, "Multi_User_actionPerformed"));
        this.Multi_User.setPreferredSize(new Dimension(137, 24));
        this.Multi_User.setText(SmFrame.frame.res.getString("Multi_User_Database"));
        this.Multi_User.setSelected(true);
        this.Server_Port_Number.setName("ServerPortNumberPanel");
        this.Server_Port_Number.setMinimumSize(new Dimension(4, 24));
        this.Server_Port_Number.setPreferredSize(new Dimension(4, 24));
        this.Database_Name.setPreferredSize(new Dimension(200, 28));
        this.Database_Directory.setPreferredSize(new Dimension(200, 28));
        this.Server_Address.setPreferredSize(new Dimension(200, 28));
        this.Server_Port_Number.setPreferredSize(new Dimension(100, 28));
        JPanel panel0 = new JPanel(new GridLayout(2, 2, 5, 5));
        panel0.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        panel0.add(jLabel1);
        panel0.add(this.Database_Name);
        panel0.add(jLabel2);
        panel0.add(this.Database_Directory);
        jPanel9.add(panel0);
        jPanel6.setBorder(BorderFactory.createEtchedBorder());
        jPanel6.add(this.Multi_User);
        panel0 = new JPanel(new FlowLayout(0));
        panel0.add(this.jLabel4);
        panel0.add(this.Server_Address);
        jPanel6.add(panel0);
        panel0 = new JPanel(new FlowLayout(0));
        panel0.add(this.jLabel3);
        panel0.add(this.Server_Port_Number);
        panel0.add(this.jLabel5);
        jPanel6.add(panel0);
        jPanel9.add((Component)jPanel6, null);
        this.Create_Button.setPreferredSize(new Dimension(120, 26));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel8.add((Component)jPanel9, "Center");
        jPanel8.add((Component)jPanel4, "East");
        jPanel4.add((Component)this.Create_Button, null);
        jPanel4.add((Component)Cancel_Button, null);
        jPanel4.add((Component)this.Setup_Button, null);
        jPanel4.add((Component)help_Button, null);
        this.getContentPane().add(jPanel8);
        this.Setup_Button.setEnabled(false);
        this.Create_Button.setEnabled(false);
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        String defaultuser;
        int i;
        this.setCursor(Cursor.getPredefinedCursor(3));
        String dbname = this.Database_Name.getText();
        dbalib lib = new dbalib();
        int id_result = lib.utchkid(dbname.getBytes(), dbname.length());
        if (id_result == 1) {
            GuiUt.showErrorDlg(this, SmFrame.frame.res.getString("Invalid_Database_Name"), "");
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        String dbdir = this.Database_Directory.getText().trim();
        if (dbdir.indexOf(32) >= 0 && !dbdir.startsWith("\"") && !dbdir.endsWith("\"")) {
            dbdir = "\"" + dbdir + "\"";
        }
        boolean multi_user = this.Multi_User.isSelected();
        String svr_address = "";
        String svr_port = "";
        if (multi_user) {
            svr_address = this.Server_Address.getText();
            Integer I = this.Server_Port_Number.getValue();
            svr_port = I == null ? "" : this.Server_Port_Number.getValue().toString();
        }
        if (multi_user && (svr_address.length() <= 0 || svr_port.length() <= 0)) {
            GuiUt.showErrorDlg(this, SmFrame.frame.res.getString("Server_addr_and_portnum_are_required"), "");
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (multi_user && ((i = Integer.parseInt(svr_port)) > 65536 || i < 1025)) {
            GuiUt.showErrorDlg(this, SmFrame.frame.res.getString("Port_number_should_be_between_1025_and_65536"), "");
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (!this.checkForNewSection(dbname)) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", dbname, "r+");
        if (dbdir.length() > 0) {
            config.insertPara("DB_DBDIR", dbdir, 4096);
        } else {
            config.procDelete("DB_DBDIR", 0);
        }
        config.procDelete("DB_SVADR", 0);
        config.procDelete("DB_PTNUM", 0);
        config.fileClose();
        DatabaseConnection connection = new DatabaseConnection(dbname, "SYSADM", "", this, true);
        if (connection == null || !connection.result) {
            GuiUt.showErrorDlg(this, SmFrame.frame.res.getString("cant_create_or_connect_database") + " " + dbname, "");
            this.setCursor(Cursor.getDefaultCursor());
            config.fileOpen("dmconfig.ini", dbname, "r+");
            config.procDelete("", 0);
            config.fileClose();
            this.new_section = false;
            return;
        }
        connection.disconnect();
        connection = null;
        rc = config.fileOpen("dmconfig.ini", dbname, "r+");
        if (svr_address.length() > 0 && svr_port.length() > 0) {
            config.insertPara("DB_SvAdr", svr_address, 4096);
            Integer portnum = new Integer(svr_port);
            config.insertPara("DB_PtNum", portnum, 8192);
        }
        if ((defaultuser = (String)config.getPara("DB_UsrID", 4096)) == null) {
            config.insertPara("DB_UsrID", "SYSADM", 4096);
        }
        config.fileClose();
        if (SmFrame.frame.isWindows()) {
            String driverPath = this.getDriverPath(lib);
            winlib wlib = new winlib();
            wlib.setRegistryKeys(dbname, dbdir, svr_address, svr_port, driverPath);
        }
        GuiUt.showInformationDlg(this, SmFrame.frame.res.getString("Create_Database_Successfully"));
        this.setVisible(false);
        this.dispose();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getDriverPath(dbalib lib) {
        String result = "";
        int LEN_FNAME = 256;
        byte[] b = new byte[256];
        int rc2 = lib.utInstDir(b);
        if (rc2 == 0) {
            String instdir = new String(b).trim();
            String fileseparator = System.getProperty("file.separator");
            String version = VersionManager.getVersion().trim().replace(".", "");
            result = instdir + "bin" + fileseparator + "DMAPI" + version + ".DLL";
        }
        return result;
    }

    boolean checkForNewSection(String name) {
        JdmConfig config = new JdmConfig();
        if (!this.new_section && !this.old_section) {
            int rc = config.fileOpen("dmconfig.ini", name, "r");
            if (rc == 0) {
                int reply = GuiUt.showOption3Dlg(this, SmFrame.frame.res.getString("Create_new_section_in_dmconfig_file"), SmFrame.frame.res.getString("Database") + " " + name + " " + SmFrame.frame.res.getString("is_already_in_dmconfig"));
                if (reply != 0 && reply != 1) {
                    return false;
                }
                if (reply == 0) {
                    config.procDelete("", 0);
                }
                config.fileClose();
                if (reply == 1) {
                    this.old_section = true;
                    return true;
                }
            }
            if ((rc = config.create("dmconfig.ini", name)) != 0) {
                System.out.println("Error create new section in dmconfig.ini, the section might be already in it.");
                return false;
            }
            this.new_section = true;
            this.new_dbname = name;
            return true;
        }
        return true;
    }

    boolean isDatabaseExists(String name) {
        String cname;
        Vector<String> v = JdmConfig.getDatabaseNames("dmconfig.ini", false);
        int i = v.indexOf(cname = name.toUpperCase());
        return i >= 0;
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        if (this.new_section) {
            JdmConfig config = new JdmConfig();
            config.fileOpen("dmconfig.ini", this.new_dbname, "r+");
            config.procDelete("", 0);
            config.fileClose();
        }
        this.setVisible(false);
        this.dispose();
    }

    public void Multi_User_actionPerformed(ActionEvent e) {
        this.setEnableMultiUser(this.Multi_User.isSelected());
    }

    void setEnableMultiUser(boolean enable) {
        if (enable) {
            this.Server_Address.setEnabled(true);
            this.Server_Port_Number.setEnabled(true);
            this.jLabel3.setForeground(Color.black);
            this.jLabel4.setForeground(Color.black);
            this.jLabel5.setForeground(Color.black);
        } else {
            this.Server_Address.setEnabled(false);
            this.Server_Port_Number.setEnabled(false);
            this.jLabel3.setForeground(Color.gray);
            this.jLabel4.setForeground(Color.gray);
            this.jLabel5.setForeground(Color.gray);
        }
    }

    void Database_Directory_keyReleased(KeyEvent e) {
        if (this.Database_Directory.getText().length() > 0 && this.Database_Name.getText().length() > 0) {
            this.Create_Button.setEnabled(true);
            this.Setup_Button.setEnabled(true);
        } else {
            this.Create_Button.setEnabled(false);
            this.Setup_Button.setEnabled(false);
        }
    }

    void Database_Name_keyReleased(KeyEvent e) {
        String name;
        if (this.new_section) {
            int reply = GuiUt.showOptionDlg(this, SmFrame.frame.res.getString("a_dummy_section_in_dmconfig_file"), SmFrame.frame.res.getString("Database") + " " + this.new_dbname + " " + SmFrame.frame.res.getString("is_in_dmconfig"));
            if (reply == 0) {
                JdmConfig config = new JdmConfig();
                config.fileOpen("dmconfig.ini", this.new_dbname, "r+");
                config.procDelete("", 0);
                config.fileClose();
            }
            this.new_section = false;
            this.new_dbname = null;
        }
        if ((name = this.Database_Name.getText()).length() > 0 && this.Database_Directory.getText().length() > 0) {
            this.Create_Button.setEnabled(true);
            this.Setup_Button.setEnabled(true);
        } else {
            this.Create_Button.setEnabled(false);
            this.Setup_Button.setEnabled(false);
        }
    }

    @Override
    public void setResult(boolean result) {
        this.result = result;
    }

    public void Setup_Button_actionPerformed(ActionEvent e) {
        String name = this.Database_Name.getText();
        short language = LocaleManager.getLanguageChoice();
        if (!this.checkForNewSection(name)) {
            return;
        }
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", name, "r+");
        if (rc != 0) {
            GuiUt.showErrorDlg(this, SmFrame.frame.res.getString("Error_open_section_in_dmconfig_file"), null);
            return;
        }
        if (this.Database_Directory.getText().length() > 0) {
            config.insertPara("DB_DBDIR", this.Database_Directory.getText(), 4096);
        }
        if (this.Multi_User.isSelected()) {
            if (this.Server_Address.getText().length() > 0) {
                config.insertPara("DB_SVADR", this.Server_Address.getText(), 4096);
            }
            if (this.Server_Port_Number.getValue() != null) {
                config.insertPara("DB_PTNUM", this.Server_Port_Number.getValue().toString().trim(), 4096);
            }
        }
        config.fileClose();
        MainDlg dlg = new MainDlg(SmFrame.frame, SmFrame.frame.res.getString("Create_Database_Advance_Setting"), true, language, name, "create");
        dlg.setSize(800, 700);
        GuiUt.setCenterLocation(SmFrame.frame, dlg);
        dlg.show();
        rc = config.fileOpen("dmconfig.ini", name, "r");
        if (rc != 0) {
            System.out.println("User doesn't setup anything by config editor");
            config.fileClose();
            return;
        }
        String svr_address = (String)config.getPara("DB_SVADR", 4096);
        Integer svr_portnum = (Integer)config.getPara("DB_PTNUM", 8192);
        String db_dbdir = (String)config.getPara("DB_DBDIR", 4096);
        config.fileClose();
        if (svr_address != null) {
            this.Server_Address.setText(svr_address);
            this.Multi_User.setSelected(true);
        }
        if (svr_portnum != null) {
            this.Server_Port_Number.setValue(svr_portnum.toString());
        }
        if (db_dbdir != null) {
            this.Database_Directory.setText(db_dbdir);
        }
    }
}

