/*
 * Decompiled with CFR 0.152.
 */
package DmEditor;

import DmEditor.ConfigComponent;
import dbaut.TimeDocument;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;

public class ConfigTimeTextField
extends JTextField
implements ConfigComponent {
    public String initStr = null;
    public static String emptytime = "  :  :  ";

    public String getTimeText() {
        String s = null;
        try {
            s = super.getText(0, 8);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        String hour = s.substring(0, 2).trim();
        String min = s.substring(3, 5).trim();
        String sec = s.substring(6, 8).trim();
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if (min.length() == 1) {
            min = "0" + min;
        }
        if (sec.length() == 1) {
            sec = "0" + sec;
        }
        if (hour.length() == 0) {
            hour = "00";
        }
        if (min.length() == 0) {
            min = "00";
        }
        if (sec.length() == 0) {
            sec = "00";
        }
        return hour + ":" + min + ":" + sec;
    }

    public ConfigTimeTextField() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setDocument(new TimeDocument(this));
        TimeDocument.initString = emptytime;
        this.setText(TimeDocument.initString);
        this.initStr = this.getTimeText();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ConfigTimeTextField.this.this_focusLost(e);
            }
        });
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    void this_focusLost(FocusEvent e) {
        if (this.getTimeText().equals(emptytime)) {
            this.grabFocus();
        }
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    @Override
    public void setInitValue(Object value) {
        if (value != null) {
            this.initStr = (String)value;
            TimeDocument.initString = (String)value;
            this.setText(TimeDocument.initString);
            this.initStr = this.getTimeText();
        } else {
            this.initStr = "  :  :  ";
            TimeDocument.initString = "  :  :  ";
            this.setText(TimeDocument.initString);
            this.initStr = this.getTimeText();
        }
    }

    public boolean isEmpty() {
        String txt = this.getValue();
        return txt == null || txt.compareTo(emptytime) == 0;
    }

    @Override
    public boolean isChanged() {
        String curStr = this.getTimeText();
        if (curStr == null) {
            return false;
        }
        return !curStr.equals(this.initStr);
    }

    public String getValue() {
        String content = "";
        try {
            content = this.getText(0, 8).equalsIgnoreCase("  :  :  ") ? "  :  :  " : this.getText(0, 8);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return content;
    }
}

