/*
 * Decompiled with CFR 0.152.
 */
package DmEditor;

import DmEditor.ConfigComponent;
import DmEditor.ConfigTimeTextField;
import dbaut.JdmConfig;
import dbaut.TimeDocument;
import dbaut.textField.IntegerRangeField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class ConfigTimeIntervalObject
extends JPanel
implements ConfigComponent {
    public IntegerRangeField rangeField = null;
    public ConfigTimeTextField timeTextField = new ConfigTimeTextField();
    public TimeDocument time_doc = new TimeDocument(this.timeTextField);
    JLabel jLabel1 = new JLabel(" days ");
    JLabel jLabel2 = new JLabel(" hh:mm:ss ");
    String dayStr;
    String intervalStr;
    String defaultStr;

    public ConfigTimeIntervalObject(int max, int min, String dayStr, String intervalStr) {
        try {
            this.rangeField = new IntegerRangeField(max, min);
            this.dayStr = dayStr;
            this.intervalStr = intervalStr;
            this.defaultStr = dayStr + "-" + intervalStr;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.rangeField.setName("RangeField");
        this.timeTextField.setName("TimeTextField");
        this.rangeField.setInitValue(this.dayStr);
        this.timeTextField.setInitValue(this.intervalStr);
        this.timeTextField.setPreferredSize(new Dimension(60, 24));
        this.setLayout(new FlowLayout(0, 2, 0));
        this.add((Component)this.rangeField, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.timeTextField, null);
        this.add((Component)this.jLabel2, null);
        this.timeTextField.setDocument(this.time_doc);
        this.timeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    TimeDocument cfr_ignored_0 = ConfigTimeIntervalObject.this.time_doc;
                    if (ConfigTimeIntervalObject.this.timeTextField.getText().equals("  :  :  ") && ConfigTimeIntervalObject.this.rangeField.getValue() != null) {
                        TimeDocument cfr_ignored_1 = ConfigTimeIntervalObject.this.time_doc;
                        ConfigTimeIntervalObject.this.time_doc.insertString(0, "00:00:00", null);
                    } else {
                        ConfigTimeIntervalObject.this.time_doc.insertString(8, "", null);
                    }
                }
                catch (Exception ble) {
                    System.out.println(ble.getMessage());
                }
            }
        });
        this.rangeField.Value_Field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    TimeDocument cfr_ignored_0 = ConfigTimeIntervalObject.this.time_doc;
                    if (ConfigTimeIntervalObject.this.timeTextField.getText().equals("  :  :  ") && ConfigTimeIntervalObject.this.rangeField.Value_Field.getText().length() > 0) {
                        TimeDocument cfr_ignored_1 = ConfigTimeIntervalObject.this.time_doc;
                        ConfigTimeIntervalObject.this.time_doc.insertString(0, "00:00:00", null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setTimeTextFieldEnabled(boolean flag) {
        this.timeTextField.setEnabled(flag);
    }

    public void insertTimeDocString(int offset, String s, AttributeSet attributeSet) {
        try {
            this.time_doc.insertString(offset, s, attributeSet);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        this.rangeField.setEnabled(flag);
        this.timeTextField.setEnabled(flag);
        this.jLabel1.setEnabled(flag);
        this.jLabel2.setEnabled(flag);
    }

    public int save(JdmConfig config, String keyword) {
        int rc = 0;
        if (this.dayIsNull()) {
            config.procDelete(keyword, 0);
        } else {
            String statusStr = this.getValue();
            rc = config.insertPara(keyword, statusStr, 4096);
        }
        return rc;
    }

    @Override
    public boolean isChanged() {
        return this.rangeField.isChanged() || this.timeTextField.isChanged();
    }

    public boolean dayIsNull() {
        return this.rangeField.getValue() == null;
    }

    @Override
    public void setInitValue(Object value) {
        this.defaultStr = (String)value;
        String[] sa = this.defaultStr.split("-");
        this.dayStr = sa[0];
        this.rangeField.setInitValue(this.dayStr);
        this.intervalStr = sa[1];
        this.timeTextField.setInitValue(this.intervalStr);
    }

    public String getValue() {
        String content = this.rangeField.getStringValue();
        if (content == null) {
            return null;
        }
        try {
            content = content + "-" + this.timeTextField.getText(0, 8);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return content;
    }

    @Override
    public void setToolTipText(String str) {
        super.setToolTipText(str);
        this.rangeField.setToolTipText(str);
        this.timeTextField.setToolTipText(str);
    }
}

