/*
 * Decompiled with CFR 0.152.
 */
package DmEditor.AllSectionInfo.userfiles;

import DmEditor.AllSectionInfo.userfiles.UDFNRowInfo;
import DmEditor.AllSectionInfo.userfiles.UDFNTableCols;
import DmEditor.ConfigFilePathField;
import DmEditor.MainDlg;
import DmEditor.MainFrame;
import DmEditor.Preferences.Preferences;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.GridLayout2;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.textField.IntegerRangeField;
import dbaut.util.AvailableStrUtil;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.text.Document;

public class UDFNDlg
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
    private CharField logName_TextField = new CharField(32, true);
    private ConfigFilePathField phyName_TextField = new ConfigFilePathField(false);
    private IntegerRangeField pageSize_TextField = new IntegerRangeField(0);
    private IntegerRangeField offset_TextField = new IntegerRangeField(Integer.MAX_VALUE, 0);
    private DbaButton ok_Button = new DbaButton();
    private DbaButton canecel_Button = new DbaButton();
    private String thisPageSize;
    private String offset;
    private UDFNTableCols parentUDFNTableCols = null;
    private DbaButton helpButton = new DbaButton();
    private Component comp = null;
    private JLabel jLabel4 = new JLabel(this.res.getString("Raw_Device_Offset"));

    public UDFNDlg(MainFrame frame, String title, boolean modal, String offset, String pageSize, UDFNTableCols paraUDFNTableCols, Component paracomp) {
        super(frame, title, modal);
        try {
            this.thisPageSize = pageSize;
            this.offset = offset;
            this.parentUDFNTableCols = paraUDFNTableCols;
            this.comp = paracomp;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public UDFNDlg(MainFrame frame, String offset, String pageSize, UDFNTableCols paraUDFNTableCols, Component paracomp) {
        super(frame);
        this.setModal(true);
        try {
            this.thisPageSize = pageSize;
            this.offset = offset;
            this.parentUDFNTableCols = paraUDFNTableCols;
            this.comp = paracomp;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public UDFNDlg(MainDlg dlg, String title, boolean modal, String offset, String pageSize, UDFNTableCols paraUDFNTableCols, Component paracomp) {
        super(dlg, title, modal);
        try {
            this.thisPageSize = pageSize;
            this.offset = offset;
            this.parentUDFNTableCols = paraUDFNTableCols;
            this.comp = paracomp;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public UDFNDlg(MainDlg dlg, String offset, String pageSize, UDFNTableCols paraUDFNTableCols, Component paracomp) {
        super(dlg);
        this.setModal(true);
        try {
            this.thisPageSize = pageSize;
            this.offset = offset;
            this.parentUDFNTableCols = paraUDFNTableCols;
            this.comp = paracomp;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        try {
            if (Preferences.mainHB != null) {
                Preferences.mainHB.enableHelpKey((Component)this.getRootPane(), Preferences.helpres.getString("jconfigurationtool.userfiles"), null);
            } else {
                this.helpButton.setEnabled(false);
            }
        }
        catch (Exception ex) {
            System.out.println("Error Message is : " + ex.getMessage());
            return;
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println("initialization error:");
            ex.getException().printStackTrace();
        }
        JPanel panel1 = new JPanel(new GridLayout2(4, 2, 5, 5));
        JLabel jLabel1 = new JLabel(this.res.getString("Logical_File_Name"));
        JLabel jLabel2 = new JLabel(this.res.getString("Physical_File_Name"));
        JLabel jLabel3 = new JLabel(this.res.getString("Page_Size"));
        panel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel1.setPreferredSize(new Dimension(430, 120));
        this.ok_Button.setMnemonic('O');
        this.ok_Button.setText(this.res.getString("Ok"));
        this.ok_Button.addActionListener(new ReflectionAction(this, "ok_Button_actionPerformed"));
        this.ok_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        this.canecel_Button.setMnemonic('C');
        this.canecel_Button.setText(this.res.getString("Cancel"));
        this.canecel_Button.addActionListener(new ReflectionAction(this, "canecel_Button_actionPerformed"));
        this.canecel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.pageSize_TextField.setValue(this.thisPageSize);
        this.logName_TextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    UDFNDlg.this.logName_TextField_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                UDFNDlg.this.logName_TextField_keyReleased(e);
            }
        });
        this.phyName_TextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    UDFNDlg.this.phyName_TextField_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                UDFNDlg.this.phyName_TextField_keyReleased(e);
            }
        });
        Document document = this.phyName_TextField.getFilePath().getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                UDFNDlg.this.phyName_TextField_documentChange(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UDFNDlg.this.phyName_TextField_documentChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UDFNDlg.this.phyName_TextField_documentChange(e);
            }
        });
        this.helpButton.setText(this.res.getString("Help"));
        this.helpButton.setMnemonic('H');
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/help.gif"));
        if (Preferences.mainHB == null) {
            this.helpButton.setEnabled(false);
        } else {
            this.helpButton.addActionListener((ActionListener)new CSH.DisplayHelpFromSource((HelpBroker)Preferences.mainHB));
        }
        panel1.add(jLabel1);
        panel1.add(this.logName_TextField);
        panel1.add(jLabel2);
        panel1.add(this.phyName_TextField);
        this.pageSize_TextField.setPreferredSize(new Dimension(140, 22));
        JPanel p0 = new JPanel(new BorderLayout());
        p0.add((Component)this.pageSize_TextField, "West");
        panel1.add(jLabel3);
        panel1.add(p0);
        this.offset_TextField.setPreferredSize(new Dimension(140, 22));
        p0 = new JPanel(new BorderLayout());
        p0.add((Component)this.offset_TextField, "West");
        panel1.add(this.jLabel4);
        panel1.add(p0);
        JPanel panel2 = new JPanel();
        panel2.add(this.ok_Button);
        panel2.add(this.canecel_Button);
        panel2.add(this.helpButton);
        this.getContentPane().add((Component)panel2, "South");
        this.getContentPane().add((Component)panel1, "Center");
        this.ok_Button.setEnabled(false);
        this.jLabel4.setEnabled(false);
        this.offset_TextField.setEnabled(false);
        this.setName("UdfDialog");
        this.ok_Button.setName("OKButton");
        this.canecel_Button.setName("CancelButton");
        this.logName_TextField.setName("LogicalNameTextField");
        this.phyName_TextField.setName("PhysicalNameTextField");
        this.pageSize_TextField.setName("PageSizeTextField");
        this.setPreferredSize(new Dimension(600, 220));
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.logName_TextField.requestFocus();
        }
    }

    public void canecel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void setObject(String titleString) {
        this.setTitle(titleString);
    }

    public void ok_Button_actionPerformed(ActionEvent e) {
        Integer objI = this.pageSize_TextField.getValue();
        String objIStr = objI != null ? objI.toString() : "";
        if (this.logName_TextField.getText().length() == 0 || this.phyName_TextField.getText().length() == 0) {
            if (this.logName_TextField.getText().length() == 0) {
                GuiUt.showInformationDlg(this, this.res.getString("Please_enter_the_logical_file_name!"));
                this.logName_TextField.requestFocus();
            } else {
                GuiUt.showInformationDlg(this, this.res.getString("Please_enter_the_physical_file_name!"));
                this.phyName_TextField.requestFocus();
            }
        } else if (objIStr.length() == 0) {
            GuiUt.showInformationDlg(this, this.res.getString("Please_enter_the_page_size!"));
            this.pageSize_TextField.requestFocus();
        } else {
            String logStr = this.logName_TextField.getText();
            String phyStr = this.phyName_TextField.getText();
            boolean flag = true;
            if (!AvailableStrUtil.isAvailableStr(phyStr)) {
                this.phyName_TextField.setText("");
                flag = false;
            }
            if (!AvailableStrUtil.isAvailableStr(logStr)) {
                this.logName_TextField.setText("");
                flag = false;
            }
            if (!flag) {
                return;
            }
            for (int i = 0; i < this.parentUDFNTableCols.getRowCount(); ++i) {
                String log = this.parentUDFNTableCols.getValueAt(i, 0).toString();
                String phy = this.parentUDFNTableCols.getValueAt(i, 1).toString();
                if (log.equals(this.logName_TextField.getText())) {
                    GuiUt.showErrorDlg(this, this.res.getString("user_defined_logical_filename"), null);
                    return;
                }
                if (!phy.equals(this.phyName_TextField.getText())) continue;
                GuiUt.showErrorDlg(this, this.res.getString("user_defined_physical_filename"), null);
                return;
            }
            UDFNRowInfo newRow = null;
            if (GuiUt.isWindows()) {
                newRow = new UDFNRowInfo(this.logName_TextField.getText(), this.phyName_TextField.getText(), "", this.pageSize_TextField.getStringValue());
            } else {
                String offsetValue = "0";
                if (this.offset_TextField.getValue() != null) {
                    offsetValue = this.offset_TextField.getValue().toString();
                }
                newRow = new UDFNRowInfo(this.logName_TextField.getText(), this.phyName_TextField.getText(), offsetValue, this.pageSize_TextField.getStringValue());
            }
            this.parentUDFNTableCols.addValue(newRow);
            this.parentUDFNTableCols.fireTableChanged(new TableModelEvent(this.parentUDFNTableCols));
            this.setVisible(false);
            this.dispose();
        }
    }

    public long stringToLongInt(String inputStr) {
        Long objectLong = new Long(inputStr);
        long lint = objectLong;
        return lint;
    }

    public String longIntToString(long inputLong) {
        Long objectLong = new Long(inputLong);
        String s = objectLong.toString().trim();
        return s;
    }

    void logName_TextField_keyReleased(KeyEvent e) {
        this.setOkButtonStatus();
        if (e.getKeyCode() == 10 && this.phyName_TextField.getText().length() > 0 && this.logName_TextField.getText().length() > 0) {
            this.ok_Button_actionPerformed(null);
        }
    }

    private void setOkButtonStatus() {
        if (this.phyName_TextField.isEmpty() || this.logName_TextField.isEmpty()) {
            this.ok_Button.setEnabled(false);
            return;
        }
        if (GuiUt.isWindows()) {
            this.ok_Button.setEnabled(true);
        } else {
            String ss = this.phyName_TextField.getText().trim();
            if ((ss = ss.toLowerCase()).startsWith("/dev/")) {
                this.ok_Button.setEnabled(!this.offset_TextField.isEmpty());
            } else {
                this.ok_Button.setEnabled(true);
            }
        }
    }

    private void setOffsetEnabled(boolean flag) {
        this.jLabel4.setEnabled(flag);
        this.offset_TextField.setEnabled(flag);
        this.offset_TextField.setValue(flag ? "0" : "");
    }

    void phyName_TextField_keyReleased(KeyEvent e) {
        String ss = this.phyName_TextField.getText().trim();
        ss = ss.toLowerCase();
        if (!GuiUt.isWindows()) {
            this.setOffsetEnabled(ss.startsWith("/dev/"));
        }
        this.setOkButtonStatus();
        if (e.getKeyCode() == 10 && this.phyName_TextField.getText().length() > 0) {
            this.ok_Button_actionPerformed(null);
        }
    }

    void phyName_TextField_documentChange(DocumentEvent e) {
        String ss = this.phyName_TextField.getText().trim();
        if (ss != null) {
            this.setOkButtonStatus();
        }
    }
}

