/*
 * Decompiled with CFR 0.152.
 */
package DmEditor.AllSectionInfo.charset;

import DmEditor.AllSectionInfo.AllSectionInfo;
import DmEditor.AllSectionInfo.ConfigItem;
import DmEditor.Preferences.Preferences;
import dbaut.GuiUt;
import dbaut.comp.DbaPanel;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import dbaut.winlib;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import startup.ToolInfo;

public class CharSetEncodingPanel
extends DbaPanel
implements LocaleChangeListener {
    private static final long serialVersionUID = -4998118571208929084L;
    public static final ArrayList charSetArrayList = new ArrayList();
    public static final ArrayList errCharSetArrayList = new ArrayList();
    private static final ArrayList<String> KEYS = new ArrayList();
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
    private JLabel clientLCodeLabel = new JLabel(this.res.getString("Client_LCode_Label"));
    private JComboBox clientLCodeComboBox = new JComboBox<Option>(new Option[]{new Option("DEFAULT"), new Option("ASCII"), new Option("ISO-8859-1"), new Option("ISO-8859-2"), new Option("ISO-8859-3"), new Option("ISO-8859-4"), new Option("ISO-8859-5"), new Option("ISO-8859-7"), new Option("ISO-8859-9"), new Option("ISO-8859-10"), new Option("ISO-8859-13"), new Option("ISO-8859-14"), new Option("ISO-8859-15"), new Option("ISO-8859-16"), new Option("KOI8-R"), new Option("KOI8-U"), new Option("KOI8-RU"), new Option("CP1250"), new Option("CP1251"), new Option("CP1252"), new Option("CP1253"), new Option("CP1254"), new Option("CP1257"), new Option("CP850"), new Option("CP866"), new Option("MACROMAN"), new Option("MACCENTRALEUROPE"), new Option("MACICELAND"), new Option("MACCROATIAN"), new Option("MACROMANIA"), new Option("MACCYRILLIC"), new Option("MACUKRAINE"), new Option("MACGREEK"), new Option("MACTURKISH"), new Option("MACINTOSH"), new Option("ISO-8859-6"), new Option("ISO-8859-8"), new Option("CP1255"), new Option("CP1256"), new Option("CP862"), new Option("MACHEBREW"), new Option("MACARABIC"), new Option("SHIFT-JIS"), new Option("EUC-JP"), new Option("CP932"), new Option("ISO-2022-JP"), new Option("ISO-2022-JP-1"), new Option("ISO-2022-JP-2"), new Option("GBK"), new Option("GB18030"), new Option("BIG5"), new Option("EUC-CN"), new Option("EUC-TW"), new Option("CP936"), new Option("CP950"), new Option("EUC-KR"), new Option("CP949"), new Option("JOHAB"), new Option("GEORGIAN-ACADEMY"), new Option("GEORGIAN-PS"), new Option("KOI8-T"), new Option("PT154"), new Option("TIS-620"), new Option("CP874"), new Option("MACTHAI"), new Option("MULELAO-1"), new Option("CP1133"), new Option("VISCII"), new Option("TCVN"), new Option("CP1258"), new Option("UTF-8")});
    private JLabel errLCodeLabel = new JLabel(this.res.getString("Err_LCode_Label"));
    private JComboBox errLCodeComboBox = new JComboBox<Option>(new Option[]{new Option("DEFAULT"), new Option("EN_ASCII"), new Option("EN_ISO-8859-1"), new Option("EN_ISO-8859-2"), new Option("EN_ISO-8859-5"), new Option("EN_ISO-8859-7"), new Option("EN_UTF-8"), new Option("JA_SHIFT-JIS"), new Option("JA_EUC-JP"), new Option("JA_UTF-8"), new Option("ZH_CN_GBK"), new Option("ZH_CN_GB18030"), new Option("ZH_CN_UTF-8"), new Option("ZH_TW_BIG5"), new Option("ZH_TW_UTF-8")});
    private boolean fromRunTimeSetting;
    private JLabel header = null;

    public CharSetEncodingPanel(HelpResourceBundle helpres, String helpid2) {
        this(helpres, helpid2, false);
    }

    public CharSetEncodingPanel(HelpResourceBundle helpres, String helpid2, boolean fromRunTimeSetting) {
        super(helpres, helpid2);
        this.fromRunTimeSetting = fromRunTimeSetting;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("CharSetEncodingPanel");
        this.clientLCodeComboBox.setName("CliLcodeComboBox");
        this.errLCodeComboBox.setName("ErrLcodeComboBox");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        if (!this.fromRunTimeSetting) {
            this.header = new JLabel(this.res.getString("*_All_the_following_setting_are_applied_on_client_end"));
            this.header.setFont(Preferences.bigFont);
        }
        JPanel emptyPanel1 = new JPanel();
        emptyPanel1.setPreferredSize(new Dimension(200, 5));
        JPanel emptyPanel2 = new JPanel();
        emptyPanel2.setPreferredSize(new Dimension(20, 5));
        JPanel emptyPanel3 = new JPanel();
        emptyPanel2.setPreferredSize(new Dimension(20, 20));
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel northCenterPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(2, 1, 0, 5));
        JPanel comboPanel = new JPanel(new GridLayout(2, 1, 0, 5));
        labelPanel.add(this.clientLCodeLabel);
        labelPanel.add(this.errLCodeLabel);
        comboPanel.add(this.clientLCodeComboBox);
        comboPanel.add(this.errLCodeComboBox);
        northCenterPanel.add((Component)labelPanel, "West");
        northCenterPanel.add((Component)comboPanel, "Center");
        northPanel.add((Component)northCenterPanel, "Center");
        northPanel.add((Component)emptyPanel1, "East");
        northPanel.add((Component)emptyPanel2, "West");
        northPanel.add((Component)emptyPanel3, "North");
        this.add((Component)northPanel, "North");
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.clientLCodeLabel.setEnabled(flag);
        this.clientLCodeComboBox.setEnabled(flag);
        this.errLCodeLabel.setEnabled(flag);
        this.errLCodeComboBox.setEnabled(flag);
    }

    public void initComponents(AllSectionInfo allSectionInfo) {
        ConfigItem item = null;
        for (String key : KEYS) {
            item = allSectionInfo.getItem(key);
            item.initDefaultValue();
        }
    }

    public void addComponents(Vector ht) {
        ht.add(new ConfigItem("clilcode", this.clientLCodeComboBox, null, 14));
        ht.add(new ConfigItem("errlcode", this.errLCodeComboBox, null, 15));
    }

    public void setSectionInfo(AllSectionInfo allSectionInfo) {
        String osDefaultClientLCode = "DEFAULT";
        String osDefaultErrLCode = "DEFAULT";
        allSectionInfo.add("db_clilcode", this.clientLCodeComboBox, osDefaultClientLCode, (short)14);
        allSectionInfo.add("db_errlcode", this.errLCodeComboBox, osDefaultErrLCode, (short)15);
    }

    private String getOSDefaultErrLCode() {
        String defStrErrLCode = null;
        if (GuiUt.isWindows()) {
            winlib w = new winlib();
            long[] phKey = new long[1];
            int rc = -1;
            rc = ToolInfo.isDBMaker ? w.OpenKey(-2147483646L, "SOFTWARE\\DBMaker\\5.1\\", phKey) : w.OpenKey(-2147483646L, "SOFTWARE\\DBMaster\\5.1\\", phKey);
            byte[] lang = new byte[1024];
            int[] size = new int[]{1024};
            rc = w.QueryValue(phKey, "LANG", 1, lang, size);
            defStrErrLCode = new String(lang, 0, size[0]).trim();
            w.CloseKey(phKey);
            if (rc != 0) {
                if (ToolInfo.isDBMaker) {
                    System.out.println("can't RegOpenKeyEx SOFTWARE\\DBMaker\\5.1\\");
                } else {
                    System.out.println("can't RegOpenKeyEx SOFTWARE\\DBMaster\\5.1\\");
                }
                defStrErrLCode = Locale.getDefault().toString();
            }
        } else {
            defStrErrLCode = this.getLang();
        }
        return defStrErrLCode;
    }

    private String getOSDefaultClientLCode() {
        String lang;
        int beginIndex;
        Locale defaultLocale;
        String defStrLocale;
        String defStrCliLCode = null;
        defStrCliLCode = GuiUt.isWindows() ? ((defStrLocale = (defaultLocale = Locale.getDefault()).toString()).equalsIgnoreCase("zh_CN") ? "GBK" : (defStrLocale.equalsIgnoreCase("zh_TW") ? "BIG5" : (defStrLocale.equalsIgnoreCase("en_US") ? "ASCII" : (defStrLocale.equalsIgnoreCase("ja_JP") ? "SHIFT-JIS" : "ASCII")))) : ((beginIndex = (lang = this.getLang()).indexOf(".")) > -1 ? lang.substring(beginIndex + 1) : (lang.equalsIgnoreCase("zh_CN") ? "GBK" : (lang.equalsIgnoreCase("zh_TW") ? "BIG5" : (lang.equalsIgnoreCase("en_US") ? "ASCII" : (lang.equalsIgnoreCase("ja_JP") ? "SHIFT-JIS" : "ASCII")))));
        return defStrCliLCode;
    }

    private String getLang() {
        String lang = null;
        try {
            Process process = null;
            process = GuiUt.isWindows() ? Runtime.getRuntime().exec("cmd.exe /c set") : Runtime.getRuntime().exec("env");
            BufferedReader bf = null;
            bf = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = bf.readLine()) != null) {
                String key;
                int startIndex = line.indexOf("=");
                if (startIndex <= -1 || !(key = line.substring(0, startIndex)).equals("Lang")) continue;
                lang = line.substring(startIndex + 1);
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lang;
    }

    public static String parseCharSetString(String inStr) {
        inStr = inStr.toUpperCase();
        String standardCharSet = null;
        int index1 = -1;
        int index2 = -1;
        int index3 = -1;
        index1 = inStr.indexOf(".");
        if (index1 > -1) {
            String lang = inStr.substring(0, index1);
            String charSet = inStr.substring(index1 + 1);
            index2 = lang.indexOf("_");
            if (index2 > -1 && !lang.equalsIgnoreCase("zh_CN") && !lang.equalsIgnoreCase("zh_TW")) {
                lang = lang.substring(0, index2);
            }
            if (charSet.equalsIgnoreCase("shift_jis")) {
                charSet = "SHIFT-JIS";
            }
            if (charSet.equalsIgnoreCase("euc_jp")) {
                charSet = "EUC-JP";
            }
            standardCharSet = lang + "." + charSet;
        } else {
            index3 = inStr.indexOf("_");
            if (index3 > -1) {
                String lang = inStr.substring(0, index3);
                String lang1 = inStr.substring(index3 + 1);
                if (lang.equalsIgnoreCase("en")) {
                    standardCharSet = "EN.ASCII";
                } else if (lang.equalsIgnoreCase("ja")) {
                    standardCharSet = "JA.SHIFT-JIS";
                } else if (lang.equalsIgnoreCase("zh")) {
                    if (lang1.equalsIgnoreCase("CN")) {
                        standardCharSet = "ZH_CN.GBK";
                    }
                    if (lang1.equalsIgnoreCase("TW")) {
                        standardCharSet = "ZH_TW.BIG5";
                    }
                }
            } else {
                standardCharSet = inStr.equalsIgnoreCase("en") ? "EN.ASCII" : (inStr.equalsIgnoreCase("ja") ? "JA.SHIFT-JIS" : "DEFAULT");
            }
        }
        return standardCharSet;
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e == null ? DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale()) : DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", e.getLocale());
        this.comboBoxLocaleChanged(this.clientLCodeComboBox);
        this.comboBoxLocaleChanged(this.errLCodeComboBox);
        this.clientLCodeLabel.setText(this.res.getString("Client_LCode_Label"));
        this.errLCodeLabel.setText(this.res.getString("Err_LCode_Label"));
        if (this.header != null) {
            this.header.setText(this.res.getString("*_All_the_following_setting_are_applied_on_client_end"));
        }
    }

    private void comboBoxLocaleChanged(JComboBox comboBox) {
        int size = comboBox.getItemCount();
        for (int i = 0; i < size; ++i) {
            ((Option)comboBox.getItemAt(i)).localeChanged();
        }
    }

    static {
        charSetArrayList.add("DEFAULT");
        charSetArrayList.add("ASCII");
        charSetArrayList.add("ISO-8859-1");
        charSetArrayList.add("ISO-8859-2");
        charSetArrayList.add("ISO-8859-3");
        charSetArrayList.add("ISO-8859-4");
        charSetArrayList.add("ISO-8859-5");
        charSetArrayList.add("ISO-8859-7");
        charSetArrayList.add("ISO-8859-9");
        charSetArrayList.add("ISO-8859-10");
        charSetArrayList.add("ISO-8859-13");
        charSetArrayList.add("ISO-8859-14");
        charSetArrayList.add("ISO-8859-15");
        charSetArrayList.add("ISO-8859-16");
        charSetArrayList.add("KOI8-R");
        charSetArrayList.add("KOI8-U");
        charSetArrayList.add("KOI8-RU");
        charSetArrayList.add("CP1250");
        charSetArrayList.add("CP1251");
        charSetArrayList.add("CP1252");
        charSetArrayList.add("CP1253");
        charSetArrayList.add("CP1254");
        charSetArrayList.add("CP1257");
        charSetArrayList.add("CP850");
        charSetArrayList.add("CP866");
        charSetArrayList.add("MACROMAN");
        charSetArrayList.add("MACCENTRALEUROPE");
        charSetArrayList.add("MACICELAND");
        charSetArrayList.add("MACCROATIAN");
        charSetArrayList.add("MACROMANIA");
        charSetArrayList.add("MACCYRILLIC");
        charSetArrayList.add("MACUKRAINE");
        charSetArrayList.add("MACGREEK");
        charSetArrayList.add("MACTURKISH");
        charSetArrayList.add("MACINTOSH");
        charSetArrayList.add("ISO-8859-6");
        charSetArrayList.add("ISO-8859-8");
        charSetArrayList.add("CP1255");
        charSetArrayList.add("CP1256");
        charSetArrayList.add("CP862");
        charSetArrayList.add("MACHEBREW");
        charSetArrayList.add("MACARABIC");
        charSetArrayList.add("SHIFT-JIS");
        charSetArrayList.add("EUC-JP");
        charSetArrayList.add("CP932");
        charSetArrayList.add("ISO-2022-JP");
        charSetArrayList.add("ISO-2022-JP-1");
        charSetArrayList.add("ISO-2022-JP-2");
        charSetArrayList.add("GBK");
        charSetArrayList.add("GB18030");
        charSetArrayList.add("BIG5");
        charSetArrayList.add("EUC-CN");
        charSetArrayList.add("EUC-TW");
        charSetArrayList.add("CP936");
        charSetArrayList.add("CP950");
        charSetArrayList.add("EUC-KR");
        charSetArrayList.add("CP949");
        charSetArrayList.add("JOHAB");
        charSetArrayList.add("GEORGIAN-ACADEMY");
        charSetArrayList.add("GEORGIAN-PS");
        charSetArrayList.add("KOI8-T");
        charSetArrayList.add("PT154");
        charSetArrayList.add("TIS-620");
        charSetArrayList.add("CP874");
        charSetArrayList.add("MACTHAI");
        charSetArrayList.add("MULELAO-1");
        charSetArrayList.add("CP1133");
        charSetArrayList.add("VISCII");
        charSetArrayList.add("TCVN");
        charSetArrayList.add("CP1258");
        charSetArrayList.add("UTF-8");
        errCharSetArrayList.add("DEFAULT");
        errCharSetArrayList.add("EN.ASCII");
        errCharSetArrayList.add("EN.ISO-8859-1");
        errCharSetArrayList.add("EN.ISO-8859-2");
        errCharSetArrayList.add("EN.ISO-8859-5");
        errCharSetArrayList.add("EN.ISO-8859-7");
        errCharSetArrayList.add("EN.UTF-8");
        errCharSetArrayList.add("JA.SHIFT-JIS");
        errCharSetArrayList.add("JA.EUC-JP");
        errCharSetArrayList.add("JA.UTF-8");
        errCharSetArrayList.add("ZH_CN.GBK");
        errCharSetArrayList.add("ZH_CN.GB18030");
        errCharSetArrayList.add("ZH_CN.UTF-8");
        errCharSetArrayList.add("ZH_TW.BIG5");
        errCharSetArrayList.add("ZH_TW.UTF-8");
        KEYS.add("db_clilcode");
        KEYS.add("db_errlcode");
    }

    public class Option {
        String id = null;
        String msg = null;

        Option(String id) {
            this.id = id;
            this.msg = CharSetEncodingPanel.this.res.getString(id);
        }

        public String toString() {
            return this.msg;
        }

        public void localeChanged() {
            this.msg = CharSetEncodingPanel.this.res.getString(this.id);
        }
    }
}

