/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import com.borland.jb.util.FastStringBuffer;
import com.borland.jbcl.editors.String2DArrayEditorPanel;
import com.borland.jbcl.editors.StringEditor;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.table.TableCellEditor;

public class String2DArrayEditor
implements PropertyEditor {
    static final String NULLSTRING = "null";
    String2DArrayEditorPanel editorPanel;
    PropertyChangeListener listener;
    String[][] value;

    public void setValue(Object o) {
        String[][] sa = (String[][])o;
        this.value = sa;
        if (sa != null && this.editorPanel != null) {
            this.editorPanel.setItems(this.value);
        }
    }

    public Object getValue() {
        if (this.editorPanel != null) {
            if (this.editorPanel.grid.isEditing()) {
                TableCellEditor editor = this.editorPanel.grid.getCellEditor();
                editor.stopCellEditing();
            }
            this.value = this.editorPanel.getItems();
        }
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g2, Rectangle box) {
    }

    public String getAsText() {
        return StringEditor.rawTextToDisplay(String2DArrayEditor.string2DArrayToText(this.value));
    }

    public String getJavaInitializationString() {
        return String2DArrayEditor.javaInitializationForArrayOfStringArrays(this.value);
    }

    public static final String javaInitializationForArrayOfStrings(String[] strings) {
        if (strings == null || strings.length == 0) {
            return NULLSTRING;
        }
        int lineLength = 0;
        FastStringBuffer fsb = new FastStringBuffer("new String[] {");
        for (int i2 = 0; i2 < strings.length; ++i2) {
            fsb.append(StringEditor.textToSource(strings[i2]));
            if (i2 + 1 < strings.length) {
                fsb.append(", ");
            }
            if (strings[i2] == null || (lineLength += strings[i2].length()) <= 92) continue;
            lineLength = 0;
            fsb.append("\n\t");
        }
        fsb.append("}");
        return fsb.toString();
    }

    public static final String javaInitializationForArrayOfStringArrays(String[][] strings) {
        return String2DArrayEditor.javaInitializationForArrayOfStringArrays(strings, false);
    }

    public static final String javaInitializationForArrayOfStringArrays(String[][] strings, boolean newLineEachRow) {
        if (strings == null || strings.length == 0) {
            return NULLSTRING;
        }
        boolean lineLength = false;
        FastStringBuffer fsb = new FastStringBuffer("new String[][] {");
        if (newLineEachRow) {
            fsb.append("\n\t");
        }
        for (int i2 = 0; i2 < strings.length; ++i2) {
            fsb.append("{");
            fsb.append(String2DArrayEditor.stringArrayToText(strings[i2]));
            fsb.append("},");
            if (!newLineEachRow) continue;
            fsb.append("\n\t");
        }
        fsb.append("}");
        return fsb.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.value = String2DArrayEditor.textToString2DArray(StringEditor.displayTextToRaw(text));
        if (this.value != null && this.editorPanel != null) {
            this.editorPanel.setItems(this.value);
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.editorPanel == null) {
            this.editorPanel = new String2DArrayEditorPanel();
        }
        return this.editorPanel;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "String2DArrayEditor???", null, this.value));
        }
    }

    private static final String string2DArrayToText(String[][] array) {
        FastStringBuffer fsb = new FastStringBuffer("");
        if (array != null) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                fsb.append(String2DArrayEditor.stringArrayToText(array[i2]));
            }
        }
        return fsb.toString();
    }

    private static final String[][] textToString2DArray(String text) {
        int end;
        int textLength = text.length();
        int e2 = 0;
        int start = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            start = end + 1;
            ++e2;
        }
        if (start < text.length()) {
            ++e2;
        }
        String[][] array = new String[1][e2];
        start = 0;
        e2 = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            array[0][e2] = text.substring(start, end);
            start = end + 1;
            ++e2;
        }
        if (start < text.length()) {
            array[0][e2] = text.substring(start);
        }
        return array;
    }

    private static final String stringArrayToText(String[] array) {
        FastStringBuffer fsb = new FastStringBuffer("");
        if (array != null) {
            int lineLen = 0;
            for (int i2 = 0; i2 < array.length; ++i2) {
                String s = StringEditor.textToSource(array[i2]);
                fsb.append(s);
                if (i2 + 1 < array.length) {
                    fsb.append(", ");
                }
                if ((lineLen += s.length()) <= 90) continue;
                fsb.append("\n\t");
                lineLen = 0;
            }
        }
        return fsb.toString();
    }

    private static final String[] textToStringArray(String text) {
        int end;
        int textLength = text.length();
        int e2 = 0;
        int start = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            start = end + 1;
            ++e2;
        }
        if (start < text.length()) {
            ++e2;
        }
        String[] array = new String[e2];
        start = 0;
        e2 = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            array[e2] = text.substring(start, end);
            start = end + 1;
            ++e2;
        }
        if (start < text.length()) {
            array[e2] = text.substring(start);
        }
        return array;
    }

    static {
        NULLSTRING = NULLSTRING;
    }
}

