/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.ColumnVariant;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.ValidationException;
import com.borland.dx.dataset.Variant;
import com.borland.dx.text.InvalidFormatException;
import com.borland.dx.text.ItemEditMask;
import com.borland.dx.text.ItemEditMaskState;
import com.borland.dx.text.ItemEditMaskStr;
import com.borland.dx.text.ItemFormatter;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.util.JbclUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Hashtable;
import java.util.Locale;

public class MaskableTextItemEditor
extends TextField
implements ItemEditor,
Serializable {
    private transient ItemEditMask ems;
    private ItemEditMaskState state;
    private boolean hookedEvents;
    private boolean editingNow;
    private DataSet ds;
    private String startingText;
    private transient Object startingValue;
    boolean changed;
    boolean allSelected;
    transient ItemFormatter formatter;
    int alignment = 33;
    int dataType;

    public MaskableTextItemEditor() {
    }

    public MaskableTextItemEditor(int alignment, Insets margins) {
        this(alignment, margins, null, null);
    }

    public MaskableTextItemEditor(ItemFormatter formatter, ItemEditMask editMasker) {
        this();
        this.formatter = formatter;
        this.setEditMasker(editMasker);
    }

    public MaskableTextItemEditor(int alignment, Insets margins, ItemFormatter formatter, ItemEditMask editMasker) {
        this();
        this.alignment = alignment;
        this.formatter = formatter;
        this.setEditMasker(editMasker);
    }

    public Object getValue() {
        Variant value = new Variant();
        if (this.ems == null) {
            String s = this.getText();
            if (this.startingText != null && s.equals(this.startingText)) {
                return this.startingValue;
            }
            if (this.formatter != null) {
                try {
                    value = (Variant)this.formatter.parse(s);
                }
                catch (Exception e2) {
                    if (e2 instanceof InvalidFormatException) {
                        this.state.cursorPos = ((InvalidFormatException)e2).getErrorOffset();
                    }
                    this.updateSelection();
                    if (this.ds != null) {
                        this.handleException(e2);
                    }
                    throw new IllegalStateException();
                }
                return value;
            }
            value.setString(s);
            return value;
        }
        if (!this.changed) {
            return this.startingValue;
        }
        try {
            this.ems.getFinalValue(this.state, value);
            Variant s = value;
            return s;
        }
        catch (Exception e3) {
            if (e3 instanceof InvalidFormatException) {
                this.state.cursorPos = ((InvalidFormatException)e3).getErrorOffset();
            }
            this.updateSelection();
            if (this.ds != null) {
                this.handleException(e3);
            }
            throw new IllegalStateException();
        }
    }

    public Component getComponent() {
        return this;
    }

    public void startEdit(Object data, Rectangle bounds, ItemEditSite editSite) {
        block26: {
            if (data != null && data != this.startingValue && data instanceof Variant) {
                this.startingValue = new Variant();
                ((Variant)this.startingValue).setVariant((Variant)data);
            } else {
                this.startingValue = data;
            }
            this.startingText = null;
            this.changed = false;
            DataSet dataSet = this.ds = data != null && data instanceof ColumnVariant ? ((ColumnVariant)data).getDataSet() : null;
            if (this.ems == null) {
                try {
                    if (data == null) {
                        this.setText("");
                        break block26;
                    }
                    if (this.formatter != null && data instanceof Variant) {
                        String oldPattern = this.formatter.getPattern();
                        String widePattern = null;
                        if (this.ems == null && data != null && data instanceof ColumnVariant && ((ColumnVariant)data).getColumn().getDisplayMask() == null && this.formatter.getFormatObj() != null && this.formatter.getFormatObj() instanceof DateFormat) {
                            int yearMaskIndex = -1;
                            yearMaskIndex = oldPattern.indexOf(121);
                            if (yearMaskIndex != -1) {
                                int yearMaskCount = 1;
                                int patternLength = oldPattern.length();
                                while (yearMaskIndex + yearMaskCount < patternLength && oldPattern.charAt(yearMaskIndex + yearMaskCount) == 'y') {
                                    ++yearMaskCount;
                                }
                                if (yearMaskCount < 4) {
                                    widePattern = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(oldPattern.substring(0, yearMaskIndex)))).append("yyyy").append(yearMaskIndex + yearMaskCount < patternLength ? oldPattern.substring(yearMaskIndex + yearMaskCount) : "")));
                                }
                            }
                        }
                        if (widePattern != null) {
                            this.formatter.setPattern(widePattern);
                        }
                        this.setText(this.formatter.format(data));
                        if (widePattern != null) {
                            this.formatter.setPattern(oldPattern);
                        }
                        break block26;
                    }
                    this.setText(data.toString());
                }
                catch (Exception ex) {
                    this.setText("");
                }
            } else {
                if (data == null || !(data instanceof Variant)) {
                    Variant v = new Variant();
                    if (data == null) {
                        v.setNull(1);
                    } else {
                        v.setString(data.toString());
                    }
                    data = v;
                }
                this.state = this.ems.prepare((Variant)data);
                this.allSelected = true;
                this.updateDisplay();
            }
        }
        this.editingNow = true;
        this.startingText = this.getText();
        if (bounds != null) {
            this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (editSite != null) {
            this.setBackground(editSite.getBackground());
            this.setForeground(editSite.getForeground());
            this.setFont(editSite.getFont());
        }
        this.setVisible(true);
        String text = this.getText();
        Point clickPoint = editSite != null ? editSite.getEditClickPoint() : null;
        int position = 0;
        if (clickPoint == null && text != null) {
            position = this.state == null ? text.length() : this.state.cursorPos;
        } else if (text != null) {
            int xClick = clickPoint.x - bounds.x;
            position = JbclUtil.findInsertPoint(xClick, text, clickPoint, this.getFont());
        }
        if (this.ems == null) {
            if (clickPoint != null) {
                this.select(position, position);
            } else {
                this.select(0, position);
            }
        } else {
            this.state.cursorPos = position;
            this.ems.move(this.state, 501);
            this.updateDisplay();
        }
        this.requestFocus();
    }

    public void changeBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    private void handleException(Exception x) {
        try {
            ValidationException.invalidFormat((Exception)x, null, null);
        }
        catch (ValidationException ex) {
            DataSetModel.handleException(this.ds, this, (Exception)((Object)ex));
        }
    }

    public boolean canPost() {
        if (this.ems == null) {
            if (this.formatter == null) {
                return true;
            }
            String s = this.getText();
            if (this.startingText != null && s.equals(this.startingText)) {
                return true;
            }
            try {
                this.formatter.parse(s);
            }
            catch (Exception x) {
                this.handleException(x);
                boolean bl = false;
                return bl;
            }
            return true;
        }
        String msg = null;
        if (!this.changed) {
            return true;
        }
        boolean result = false;
        try {
            result = this.ems.isComplete(this.state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateSelection();
        if (result) {
            try {
                this.ems.getFinalValue(this.state, new Variant());
            }
            catch (Exception e2) {
                if (e2 instanceof InvalidFormatException) {
                    msg = e2.getMessage();
                }
                result = false;
            }
        }
        if (!result && this.ds != null) {
            if (msg == null) {
                msg = Res._DataEntryIncomplete;
            }
            this.handleException((Exception)new InvalidFormatException(msg));
        }
        return result;
    }

    public void endEdit(boolean posted) {
        this.editingNow = false;
        this.startingValue = null;
        this.startingText = null;
        this.changed = false;
    }

    public void setEditMask(String editMask, int variantType, Locale locale) {
        this.setEditMasker((ItemEditMask)new ItemEditMaskStr(editMask, null, variantType, locale));
    }

    public void setEditMasker(ItemEditMask editMasker) {
        this.ems = editMasker;
        this.state = null;
        if (this.ems != null) {
            this.hookEvents();
        }
        if (this.editingNow) {
            this.startEdit(null, null, null);
        }
    }

    protected void processKeyEvent(KeyEvent e2) {
        if (this.hookedEvents) {
            this.handleKeyEvent(e2);
        }
        super.processKeyEvent(e2);
    }

    protected void processFocusEvent(FocusEvent e2) {
        super.processFocusEvent(e2);
        this.maskControl_gotFocus();
    }

    protected void processMouseEvent(MouseEvent e2) {
        if (this.hookedEvents && this.ems != null && e2.getID() == 502) {
            this.updateSelection();
        } else if (this.hookedEvents && this.ems != null && e2.getID() == 500) {
            this.handleMouseClicked(e2);
        } else {
            super.processMouseEvent(e2);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e2) {
        super.processMouseMotionEvent(e2);
    }

    void maskControl_gotFocus() {
        if (this.hookedEvents && this.state == null) {
            this.startEdit(null, null, null);
        }
        this.updateSelection();
    }

    void updateSelection() {
        if (this.state != null) {
            if (this.allSelected) {
                this.select(0, this.state.displayString.toString().length());
            } else {
                this.select(this.state.cursorPos, this.state.cursorPos + 1);
            }
        }
    }

    void updateDisplay() {
        if (this.state != null) {
            this.setText(this.state.displayString.toString());
            this.updateSelection();
        }
    }

    void deleteSelection(boolean preserveAtCursor) {
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        int nChars = selEnd - selStart;
        if (nChars < 0) {
            selStart = selEnd;
            nChars = -nChars;
        }
        if (nChars > 1 || !preserveAtCursor) {
            this.ems.delete(this.state, selStart, nChars);
        }
        this.allSelected = false;
        this.changed = true;
    }

    private void handleKeyEvent(KeyEvent e2) {
        int id = e2.getID();
        int keyCode = e2.getKeyCode();
        if (id != 401 && id != 400) {
            return;
        }
        this.allSelected = false;
        switch (keyCode) {
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                this.ems.move(this.state, keyCode);
                this.updateSelection();
                break;
            }
            case 8: {
                if (!this.ems.move(this.state, 37)) break;
                this.updateSelection();
                this.deleteSelection(false);
                this.updateDisplay();
                break;
            }
            case 127: {
                this.deleteSelection(false);
                this.ems.move(this.state, 39);
                this.updateDisplay();
                break;
            }
            case 9: 
            case 10: {
                if (id != 400) {
                    return;
                }
                this.canPost();
                break;
            }
            case 27: {
                this.startEdit(this.startingValue, null, null);
                this.changed = false;
                break;
            }
            default: {
                if (e2.isControlDown() && keyCode == 86 || e2.isShiftDown() && keyCode == 155) {
                    Clipboard clipboard = this.getToolkit().getSystemClipboard();
                    Transferable content = clipboard.getContents(this);
                    if (content != null) {
                        try {
                            String data = (String)content.getTransferData(DataFlavor.stringFlavor);
                            if (data.length() > 0) {
                                this.deleteSelection(true);
                            }
                            int end = data.length();
                            for (int i2 = 0; i2 < end; ++i2) {
                                this.ems.insert(this.state, data.charAt(i2));
                            }
                            this.changed = true;
                            this.updateDisplay();
                        }
                        catch (Exception ex) {
                            this.getToolkit().beep();
                        }
                    }
                    e2.consume();
                    return;
                }
                char ch = e2.getKeyChar();
                if (id != 400 || ch >= '\u0000' && ch < ' ') {
                    return;
                }
                this.deleteSelection(true);
                this.ems.insert(this.state, ch);
                this.updateDisplay();
            }
        }
        e2.consume();
    }

    private void handleMouseClicked(MouseEvent e2) {
        Point clickPoint = e2.getPoint();
        int xClick = clickPoint.x;
        String text = this.state.displayString.toString();
        this.state.cursorPos = JbclUtil.findInsertPoint(xClick, text, clickPoint, this.getFont());
        this.ems.move(this.state, 500);
        this.updateSelection();
    }

    private void hookEvents() {
        if (!this.hookedEvents) {
            this.enableEvents(60L);
            this.hookedEvents = true;
        }
    }

    public ItemFormatter getFormatter() {
        return this.formatter;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(2);
        if (this.ems instanceof Serializable) {
            hash.put("e", this.ems);
        }
        if (this.formatter instanceof Serializable) {
            hash.put("f", this.formatter);
        }
        s.writeObject(hash);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Hashtable hash = (Hashtable)s.readObject();
        Object data = hash.get("e");
        if (data instanceof ItemEditMask) {
            this.ems = (ItemEditMask)data;
        }
        if ((data = hash.get("f")) instanceof ItemFormatter) {
            this.formatter = (ItemFormatter)data;
        }
    }
}

