/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;

public class BMPImageEncoder
extends ImageEncoderImpl {
    private OutputStream output;
    private int version;
    private boolean isCompressed;
    private boolean isTopDown;
    private int w;
    private int h;

    public BMPImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        this.output = outputStream;
        BMPEncodeParam bMPEncodeParam = imageEncodeParam == null ? new BMPEncodeParam() : (BMPEncodeParam)imageEncodeParam;
        this.version = bMPEncodeParam.getVersion();
        this.isCompressed = bMPEncodeParam.isCompressed();
        this.isTopDown = bMPEncodeParam.isTopDown();
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        int n;
        int n2;
        int n3 = renderedImage.getMinX();
        int n4 = renderedImage.getMinY();
        this.w = renderedImage.getWidth();
        this.h = renderedImage.getHeight();
        int n5 = 24;
        boolean bl = false;
        int n6 = 0;
        IndexColorModel indexColorModel = null;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n7 = sampleModel.getNumBands();
        ColorModel colorModel = renderedImage.getColorModel();
        if (n7 != 1 && n7 != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder1"));
        }
        int[] nArray = sampleModel.getSampleSize();
        if (nArray[0] > 8) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder2"));
        }
        int n8 = 1;
        while (n8 < nArray.length) {
            if (nArray[n8] != nArray[0]) {
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder3"));
            }
            ++n8;
        }
        int n9 = sampleModel.getTransferType();
        if (n9 == 1 || n9 == 2 || n9 == 3 || n9 == 4 || n9 == 5) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder0"));
        }
        int n10 = this.w * n7;
        int n11 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (colorModel instanceof IndexColorModel) {
            bl = true;
            indexColorModel = (IndexColorModel)colorModel;
            n6 = indexColorModel.getMapSize();
            if (n6 <= 2) {
                n5 = 1;
                n10 = (int)Math.ceil((double)this.w / 8.0);
            } else if (n6 <= 16) {
                n5 = 4;
                n10 = (int)Math.ceil((double)this.w / 2.0);
            } else if (n6 <= 256) {
                n5 = 8;
            } else {
                n5 = 24;
                bl = false;
                n6 = 0;
                n10 = this.w * 3;
            }
            if (bl) {
                byArray = new byte[n6];
                byArray2 = new byte[n6];
                byArray3 = new byte[n6];
                byArray4 = new byte[n6];
                indexColorModel.getAlphas(byArray4);
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
            }
        } else if (n7 == 1) {
            bl = true;
            n6 = 256;
            n5 = nArray[0];
            n10 = (int)Math.ceil((double)(this.w * n5) / 8.0);
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            byArray4 = new byte[256];
            n2 = 0;
            while (n2 < 256) {
                byArray[n2] = (byte)n2;
                byArray2[n2] = (byte)n2;
                byArray3[n2] = (byte)n2;
                byArray4[n2] = (byte)n2;
                ++n2;
            }
        }
        n2 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = n6;
        int n19 = 0;
        int n20 = n10 % 4;
        if (n20 != 0) {
            n19 = 4 - n20;
        }
        switch (this.version) {
            case 0: {
                n12 = 26 + n6 * 3;
                n13 = 12;
                n14 = (n10 + n19) * this.h;
                n2 = n14 + n12;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
            case 1: {
                n12 = 54 + n6 * 4;
                n14 = (n10 + n19) * this.h;
                n2 = n14 + n12;
                n13 = 40;
                break;
            }
            case 2: {
                n13 = 108;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
        }
        this.writeFileHeader(n2, n12);
        this.writeInfoHeader(n13, n5);
        this.writeDWord(n11);
        this.writeDWord(n14);
        this.writeDWord(n15);
        this.writeDWord(n16);
        this.writeDWord(n17);
        this.writeDWord(n18);
        if (bl) {
            switch (this.version) {
                case 0: {
                    n = 0;
                    while (n < n6) {
                        this.output.write(byArray3[n]);
                        this.output.write(byArray2[n]);
                        this.output.write(byArray[n]);
                        ++n;
                    }
                    break;
                }
                default: {
                    int n21 = 0;
                    while (n21 < n6) {
                        this.output.write(byArray3[n21]);
                        this.output.write(byArray2[n21]);
                        this.output.write(byArray[n21]);
                        this.output.write(byArray4[n21]);
                        ++n21;
                    }
                    break block5;
                }
            }
        }
        n = this.w * n7;
        int[] nArray2 = new int[8 * n];
        byte[] byArray5 = new byte[n10];
        if (!this.isTopDown) {
            int n22 = n4 + this.h;
            int n23 = n22 - 1;
            while (n23 >= n4) {
                int n24 = Math.min(8, n23 - n4 + 1);
                Raster raster = renderedImage.getData(new Rectangle(n3, n23 - n24 + 1, this.w, n24));
                raster.getPixels(n3, n23 - n24 + 1, this.w, n24, nArray2);
                int n25 = 0;
                int n26 = n * n24 - 1;
                int n27 = 0;
                while (n27 < n24) {
                    n25 = n26 - (n27 + 1) * n + 1;
                    this.writePixels(n25, n, n5, nArray2, byArray5, n19, n7, indexColorModel);
                    ++n27;
                }
                n23 -= 8;
            }
        } else {
            int n28 = n4 + this.h;
            int n29 = n4;
            while (n29 < n28) {
                int n30 = Math.min(8, n28 - n29);
                Raster raster = renderedImage.getData(new Rectangle(n3, n29, this.w, n30));
                raster.getPixels(n3, n29, this.w, n30, nArray2);
                int n31 = 0;
                int n32 = 0;
                while (n32 < n30) {
                    this.writePixels(n31, n, n5, nArray2, byArray5, n19, n7, indexColorModel);
                    ++n32;
                }
                n29 += 8;
            }
        }
    }

    private void writePixels(int n, int n2, int n3, int[] nArray, byte[] byArray, int n4, int n5, IndexColorModel indexColorModel) throws IOException {
        int n6 = 0;
        int n7 = 0;
        switch (n3) {
            case 1: {
                int n8;
                int n9 = 0;
                while (n9 < n2 / 8) {
                    byArray[n7++] = (byte)(nArray[n++] << 7 | nArray[n++] << 6 | nArray[n++] << 5 | nArray[n++] << 4 | nArray[n++] << 3 | nArray[n++] << 2 | nArray[n++] << 1 | nArray[n++]);
                    ++n9;
                }
                if (n2 % 8 > 0) {
                    n6 = 0;
                    n8 = 0;
                    while (n8 < n2 % 8) {
                        n6 |= nArray[n++] << 7 - n8;
                        ++n8;
                    }
                    byArray[n7++] = (byte)n6;
                }
                this.output.write(byArray, 0, (n2 + 7) / 8);
                break;
            }
            case 4: {
                int n8 = 0;
                while (n8 < n2 / 2) {
                    n6 = nArray[n++] << 4 | nArray[n++];
                    byArray[n7++] = (byte)n6;
                    ++n8;
                }
                if (n2 % 2 == 1) {
                    n6 = nArray[n] << 4;
                    byArray[n7++] = (byte)n6;
                }
                this.output.write(byArray, 0, (n2 + 1) / 2);
                break;
            }
            case 8: {
                int n10 = 0;
                while (n10 < n2) {
                    byArray[n10] = (byte)nArray[n++];
                    ++n10;
                }
                this.output.write(byArray, 0, n2);
                break;
            }
            case 24: {
                int n11;
                if (n5 == 3) {
                    n11 = 0;
                    while (n11 < n2) {
                        byArray[n7++] = (byte)nArray[n + 2];
                        byArray[n7++] = (byte)nArray[n + 1];
                        byArray[n7++] = (byte)nArray[n];
                        n += 3;
                        n11 += 3;
                    }
                    this.output.write(byArray, 0, n2);
                    break;
                }
                n11 = indexColorModel.getMapSize();
                byte[] byArray2 = new byte[n11];
                byte[] byArray3 = new byte[n11];
                byte[] byArray4 = new byte[n11];
                indexColorModel.getReds(byArray2);
                indexColorModel.getGreens(byArray3);
                indexColorModel.getBlues(byArray4);
                int n12 = 0;
                while (n12 < n2) {
                    int n13 = nArray[n];
                    byArray[n7++] = byArray4[n13];
                    byArray[n7++] = byArray3[n13];
                    byArray[n7++] = byArray4[n13];
                    ++n;
                    ++n12;
                }
                this.output.write(byArray, 0, n2 * 3);
            }
        }
        n7 = 0;
        while (n7 < n4) {
            this.output.write(0);
            ++n7;
        }
    }

    private void writeFileHeader(int n, int n2) throws IOException {
        this.output.write(66);
        this.output.write(77);
        this.writeDWord(n);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.writeDWord(n2);
    }

    private void writeInfoHeader(int n, int n2) throws IOException {
        this.writeDWord(n);
        this.writeDWord(this.w);
        this.writeDWord(this.h);
        this.writeWord(1);
        this.writeWord(n2);
    }

    public void writeWord(int n) throws IOException {
        this.output.write(n & 0xFF);
        this.output.write((n & 0xFF00) >> 8);
    }

    public void writeDWord(int n) throws IOException {
        this.output.write(n & 0xFF);
        this.output.write((n & 0xFF00) >> 8);
        this.output.write((n & 0xFF0000) >> 16);
        this.output.write((n & 0xFF000000) >> 24);
    }
}

