/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtt.dlg;

import com.syscom.misc.XMLImageResource;
import com.syscom.misc.XTTUt;
import com.syscom.treetable.DropTargetTreeTable;
import com.syscom.treetable.LinkTableModel;
import com.syscom.undo.DocumentUndoEdit;
import com.syscom.undo.LinkDocumentUndoEdit;
import com.syscom.ut.ComboEditorField;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.ComboBoxCellEditor;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.node.Attribute;
import com.syscom.xml.node.QueryElement;
import com.syscom.xml.schema.SchemaTreeNodeInterface;
import com.syscom.xml.schema.node.Column;
import com.syscom.xml.schema.node.Table;
import com.syscom.xml.schema.node.View;
import com.syscom.xml.xtt.console.HelpButton;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xtt.dlg.LinkDropTableCellRenderer;
import com.syscom.xml.xtt.tree.CheckNode;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DropTargetLinkDlg
extends JDialog {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtt.dlg.resource.Res", LocaleManager.getLocale());
    private CheckNode node = null;
    private DefaultMutableTreeNode dmtn = null;
    private DbaButton okButton = new DbaButton(this.res.getString("Ok"), 'O');
    private DbaButton cancelButton = new DbaButton(this.res.getString("Cancel"), 'C');
    private JComboBox combo = new JComboBox();
    private DefaultComboBoxModel cbm = new DefaultComboBoxModel();
    private Vector cbmVector = new Vector();
    private DropTargetTreeTable treeTable = null;
    private LinkTableModel linkTableModel = null;
    String queryObjectName = "";
    JTextField queryObjectNameTextField = new JTextField();
    private Vector linkDataVector = new Vector();
    private LinkDocumentUndoEdit data_undo_edit = null;

    public DropTargetLinkDlg(Frame frame, String title, boolean modal, CheckNode node, DefaultMutableTreeNode dmtn, LinkDocumentUndoEdit edit) {
        super(frame, title, true);
        try {
            this.node = node;
            this.dmtn = dmtn;
            this.data_undo_edit = edit;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DropTargetLinkDlg(Frame frame, CheckNode node, DefaultMutableTreeNode dmtn, LinkDocumentUndoEdit edit) {
        super(frame);
        this.setModal(true);
        try {
            this.node = node;
            this.dmtn = dmtn;
            this.data_undo_edit = edit;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() {
        this.setTitle(this.node.toString());
        this.okButton.setIcon(XMLImageResource.getResource(this.getClass(), "/xmlimages/ut/ok.gif"));
        this.cancelButton.setIcon(XMLImageResource.getResource(this.getClass(), "/xmlimages/ut/cancel.gif"));
        this.okButton.setPreferredSize(new Dimension(80, 20));
        this.cancelButton.setPreferredSize(new Dimension(80, 20));
        HelpButton helpButton = new HelpButton();
        XTTFrame.frame.enableDialogHelp(this.getRootPane(), helpButton, "droptargetlinkdlg");
        this.combo.setEditor(new ComboEditorField());
        this.combo.setEditable(true);
        SchemaTreeNodeInterface userObj = (SchemaTreeNodeInterface)this.node.getUserObject();
        if (userObj instanceof Table) {
            this.queryObjectName = XTTFrame.frame.isExistQueryObjectName("TABLE_SQL");
            this.queryObjectNameTextField.setText(this.queryObjectName);
        } else {
            this.queryObjectName = XTTFrame.frame.isExistQueryObjectName("VIEW_SQL");
            this.queryObjectNameTextField.setText(this.queryObjectName);
        }
        Enumeration<TreeNode> enum1 = this.node.children();
        this.cbm.addElement("");
        String s = "";
        TreeNode obj = null;
        Column column = null;
        while (enum1.hasMoreElements()) {
            obj = enum1.nextElement();
            column = (Column)((DefaultMutableTreeNode)obj).getUserObject();
            s = column.getColumnAliasName() != null ? "$" + this.queryObjectName + "." + column.getColumnAliasName() : "$" + this.queryObjectName + "." + obj;
            this.cbm.addElement(s);
            this.cbmVector.add(column);
            s = "";
        }
        this.combo.setModel(this.cbm);
        this.linkTableModel = new LinkTableModel(this.dmtn);
        this.treeTable = new DropTargetTreeTable(this.linkTableModel);
        this.treeTable.getColumnModel().getColumn(1).setCellEditor(new ComboBoxCellEditor(this.combo));
        this.treeTable.getColumnModel().getColumn(1).setCellRenderer(new LinkDropTableCellRenderer());
        JScrollPane sp = new JScrollPane(this.treeTable);
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel queryObjectNamePanel = new JPanel(new BorderLayout());
        JLabel queryObjectNameLabel = new JLabel(this.res.getString("Query_object_name_"));
        JPanel tmpPanel = new JPanel();
        tmpPanel.setPreferredSize(new Dimension(100, 18));
        queryObjectNamePanel.add((Component)queryObjectNameLabel, "West");
        queryObjectNamePanel.add((Component)tmpPanel, "East");
        queryObjectNamePanel.add((Component)this.queryObjectNameTextField, "Center");
        topPanel.add((Component)queryObjectNamePanel, "North");
        topPanel.add((Component)sp, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel bottomTopPanel = new JPanel(new BorderLayout());
        JPanel bottomBottomPanel = new JPanel(new GridLayout(1, 1));
        JPanel bottomBottomTopPanel = new JPanel(new BorderLayout());
        JPanel bottomBottomBottomPanel = new JPanel();
        bottomBottomBottomPanel.add(this.okButton);
        bottomBottomBottomPanel.add(this.cancelButton);
        bottomBottomBottomPanel.add(helpButton);
        bottomBottomPanel.add(bottomBottomBottomPanel);
        bottomPanel.add((Component)bottomBottomPanel, "South");
        bottomPanel.add((Component)bottomTopPanel, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.getContentPane().add((Component)topPanel, "Center");
        this.autoMapValue((XTTTreeNodeInterface)this.dmtn.getUserObject());
        this.okButton.addActionListener(new ReflectionAction(this, "okButton_actionPerformed"));
        this.cancelButton.addActionListener(new ReflectionAction(this, "cancelButton_actionPerformed"));
        this.queryObjectNameTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                JTextField tf = (JTextField)input;
                String inStr = tf.getText();
                if (XTTUt.isLegalQueryObjectName(inStr)) {
                    DropTargetLinkDlg.this.queryObjectName = inStr;
                    Enumeration<TreeNode> enum2 = DropTargetLinkDlg.this.node.children();
                    DropTargetLinkDlg.this.cbm.removeAllElements();
                    DropTargetLinkDlg.this.cbmVector.removeAllElements();
                    DropTargetLinkDlg.this.combo.removeAllItems();
                    DropTargetLinkDlg.this.cbm.addElement("");
                    String s = "";
                    TreeNode obj = null;
                    Column column = null;
                    while (enum2.hasMoreElements()) {
                        obj = enum2.nextElement();
                        column = (Column)((DefaultMutableTreeNode)obj).getUserObject();
                        s = column.getColumnAliasName() != null ? "$" + DropTargetLinkDlg.this.queryObjectName + "." + column.getColumnAliasName() : "$" + DropTargetLinkDlg.this.queryObjectName + "." + obj;
                        DropTargetLinkDlg.this.cbm.addElement(s);
                        DropTargetLinkDlg.this.cbmVector.add(column);
                        s = "";
                    }
                    DropTargetLinkDlg.this.combo.setModel(DropTargetLinkDlg.this.cbm);
                    DropTargetLinkDlg.this.resetLinkValue((XTTTreeNodeInterface)DropTargetLinkDlg.this.dmtn.getUserObject());
                    DropTargetLinkDlg.this.autoMapValue((XTTTreeNodeInterface)DropTargetLinkDlg.this.dmtn.getUserObject());
                    XTTFrame.frame.refreshXTT();
                    return true;
                }
                return false;
            }
        });
        this.okButton.setEnabled(false);
        this.setButtonStatus();
        this.combo.addActionListener(new ReflectionAction(this, "combo_actionPerformed"));
    }

    public void combo_actionPerformed(ActionEvent e) {
        this.setButtonStatus();
    }

    private void buildLinkDataVector(Vector inputVector) {
        XTTTreeNodeInterface rootXTT = ((XTTTreeNodeInterface)((DefaultMutableTreeNode)this.treeTable.getTree().getPathForRow(0).getLastPathComponent()).getUserObject()).getParent();
        int children_size = rootXTT.getChildren().size();
        if (children_size <= 0) {
            return;
        }
        XTTTreeNodeInterface childXTT = null;
        for (int j = 0; j < children_size; ++j) {
            childXTT = (XTTTreeNodeInterface)rootXTT.getChildren().elementAt(j);
            childXTT.buildLinkDataVector(inputVector);
        }
    }

    private String getQueryColumns() {
        String s = "";
        if (this.linkDataVector.size() <= 0) {
            return s;
        }
        int size = this.linkDataVector.size();
        int pos = 0;
        String tmp = "";
        Column column = null;
        for (int i = 0; i < size; ++i) {
            pos = this.cbm.getIndexOf(this.linkDataVector.elementAt(i));
            if (pos < 0) continue;
            tmp = this.parseValue(this.linkDataVector.elementAt(i).toString());
            column = (Column)this.cbmVector.elementAt(i);
            s = column.getColumnAliasName() != null ? s + column.getColumnName() + " as " + column.getColumnAliasName() + ", " : s + column.getColumnName() + ", ";
        }
        if ((s = s.trim()).endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String parseValue(String s) {
        String tmpStr = "$" + this.queryObjectName + ".";
        int index = s.indexOf(tmpStr);
        return s.substring(index + tmpStr.length(), s.length());
    }

    private String buildSQL() {
        String tmp = this.getQueryColumns().trim();
        if (tmp.length() <= 0) {
            return "";
        }
        SchemaTreeNodeInterface obj = (SchemaTreeNodeInterface)this.node.getUserObject();
        String command = "select ";
        Table table = null;
        View view = null;
        Object child = null;
        Object schema_column = null;
        Object qe = null;
        Object att = null;
        command = command + tmp + " from ";
        if (obj instanceof Table) {
            table = (Table)obj;
            command = command + table.getOwnerName() + "." + table.getTableName();
        } else {
            view = (View)obj;
            command = command + view.getOwnerName() + "." + view.getTableName();
        }
        return command;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void okButton_actionPerformed(ActionEvent e) {
        this.queryObjectName = this.queryObjectNameTextField.getText().trim();
        XTTFrame.frame.getTreeTable().getQueryObjectVector().add(this.queryObjectName);
        this.buildLinkDataVector(this.linkDataVector);
        this.setLinkValue((XTTTreeNodeInterface)this.dmtn.getUserObject());
        XTTTreeNodeInterface targetXTT = (XTTTreeNodeInterface)this.dmtn.getUserObject();
        QueryElement qe = (QueryElement)targetXTT;
        String command = this.buildSQL();
        if (qe.getQueryName().length() > 0 && qe.getCommand().length() > 0) {
            if (command.length() > 0) {
                int reply = GuiUt.showOptionDlg(XTTFrame.frame, this.res.getString("Warning"), this.res.getString("The_target_element"));
                if (reply != 0) return;
                String old = qe.getQueryName();
                qe.setQueryName(this.queryObjectName);
                DocumentUndoEdit edit = new DocumentUndoEdit(qe, "queryName", old, true);
                this.data_undo_edit.addUndo(edit);
                old = qe.getCommand();
                qe.setCommand(command);
                edit = new DocumentUndoEdit(qe, "command", old, true);
                this.data_undo_edit.addUndo(edit);
            }
        } else {
            String old = qe.getQueryName();
            qe.setQueryName(this.queryObjectName);
            DocumentUndoEdit edit = new DocumentUndoEdit(qe, "queryName", old, true);
            this.data_undo_edit.addUndo(edit);
            old = qe.getCommand();
            qe.setCommand(command);
            edit = new DocumentUndoEdit(qe, "command", old, true);
            this.data_undo_edit.addUndo(edit);
        }
        XTTFrame.frame.refreshXTT();
        this.setVisible(false);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.resetLinkValue((XTTTreeNodeInterface)this.dmtn.getUserObject());
        this.setVisible(false);
        this.dispose();
    }

    private void setLinkValue(XTTTreeNodeInterface XTT2) {
        Vector children = XTT2.getChildren();
        if (children == null) {
            return;
        }
        XTTTreeNodeInterface xtt2 = null;
        int size = children.size();
        Attribute att = null;
        QueryElement qe = null;
        DocumentUndoEdit edit = null;
        String old = null;
        for (int i = 0; i < size; ++i) {
            xtt2 = (XTTTreeNodeInterface)children.elementAt(i);
            if (xtt2 instanceof Attribute) {
                att = (Attribute)xtt2;
                if (!att.getLinkValue().equalsIgnoreCase(att.getValue())) {
                    old = att.getValue();
                    att.setAttributeValue(att.getLinkValue());
                    edit = new DocumentUndoEdit(att, "attributeValue", old, true);
                    this.data_undo_edit.addUndo(edit);
                }
            } else if (xtt2 instanceof QueryElement && !(qe = (QueryElement)xtt2).getLinkTextValue().equalsIgnoreCase(qe.getTextValue())) {
                old = qe.getTextValue();
                qe.setTextValue(qe.getLinkTextValue());
                edit = new DocumentUndoEdit(qe, "textValue", old, true);
                this.data_undo_edit.addUndo(edit);
            }
            this.setLinkValue(xtt2);
        }
    }

    private void resetLinkValue(XTTTreeNodeInterface XTT2) {
        Vector children = XTT2.getChildren();
        if (children == null) {
            return;
        }
        XTTTreeNodeInterface xtt2 = null;
        int size = children.size();
        Attribute att = null;
        QueryElement qe = null;
        for (int i = 0; i < size; ++i) {
            xtt2 = (XTTTreeNodeInterface)children.elementAt(i);
            if (xtt2 instanceof Attribute) {
                att = (Attribute)xtt2;
                if (!att.getLinkValue().equalsIgnoreCase(att.getValue())) {
                    att.setLinkValue(att.getValue());
                }
            } else if (xtt2 instanceof QueryElement && !(qe = (QueryElement)xtt2).getLinkTextValue().equalsIgnoreCase(qe.getTextValue())) {
                qe.setLinkTextValue(qe.getTextValue());
            }
            this.resetLinkValue(xtt2);
        }
    }

    private void setButtonStatus() {
        this.treeTable.editingStopped(null);
        this.treeTable.getTree().expandPath(this.treeTable.getTree().getPathForRow(0));
        int rowCount = this.treeTable.getRowCount();
        boolean b = false;
        XTTTreeNodeInterface xtt2 = null;
        String value = null;
        for (int i = 0; i < rowCount; ++i) {
            xtt2 = (XTTTreeNodeInterface)this.treeTable.getValueAt(i, 1);
            if (xtt2 instanceof QueryElement) {
                value = ((QueryElement)xtt2).getLinkTextValue();
            } else if (xtt2 instanceof Attribute) {
                value = ((Attribute)xtt2).getLinkValue();
            }
            if (value.length() <= 0) continue;
            this.okButton.setEnabled(true);
            b = true;
            break;
        }
        if (!b) {
            this.okButton.setEnabled(false);
        }
    }

    private void autoMapValue(XTTTreeNodeInterface XTT2) {
        Vector children = XTT2.getChildren();
        if (children == null) {
            return;
        }
        XTTTreeNodeInterface xtt2 = null;
        int size = children.size();
        Attribute att = null;
        QueryElement qe = null;
        int cbm_pos = 0;
        for (int i = 0; i < size; ++i) {
            xtt2 = (XTTTreeNodeInterface)children.elementAt(i);
            if (xtt2 instanceof Attribute) {
                att = (Attribute)xtt2;
                cbm_pos = this.cbm.getIndexOf("$" + this.queryObjectName + "." + att.getName().toUpperCase());
                if (cbm_pos >= 0 && att.getValue().length() <= 0) {
                    att.setLinkValue(this.cbm.getElementAt(cbm_pos).toString());
                }
                cbm_pos = 0;
            } else if (xtt2 instanceof QueryElement) {
                qe = (QueryElement)xtt2;
                cbm_pos = this.cbm.getIndexOf("$" + this.queryObjectName + "." + qe.getLocalName().toUpperCase());
                if (cbm_pos >= 0 && qe.getTextValue().length() <= 0) {
                    qe.setLinkTextValue(this.cbm.getElementAt(cbm_pos).toString());
                }
                cbm_pos = 0;
            }
            this.autoMapValue(xtt2);
        }
    }

    public class my {
    }
}

