/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.node;

import com.syscom.datatransfer.XTTDatatransfer;
import com.syscom.misc.QueryParser;
import com.syscom.misc.XMLImageResource;
import com.syscom.misc.XTTUt;
import com.syscom.preferences.PreferencesXml;
import com.syscom.undo.DisplaySettingUndoEdit;
import com.syscom.undo.DocumentUndoEdit;
import com.syscom.ut.DbaObject;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.node.Attribute;
import com.syscom.xml.node.Template;
import com.syscom.xml.node.display.AbstractDisplayPanel;
import com.syscom.xml.node.display.ElementDisplayPanel;
import com.syscom.xml.node.display.ElementMainPanel;
import com.syscom.xml.node.display.QueryPanel;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xtt.xttobjects.ColumnObject;
import com.syscom.xml.xtt.xttobjects.DocumentInfoObject;
import com.syscom.xml.xtt.xttobjects.InvalidElementObject;
import com.syscom.xml.xttinterface.DisplaySettingInterface;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryElement
extends XTTDatatransfer
implements XTTTreeNodeInterface,
DisplaySettingInterface,
LocaleChangeListener {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.node.resource.Res", LocaleManager.getLocale());
    private static ImageIcon icon = null;
    private static ImageIcon disabled_icon = null;
    private static String imagefilename = "/xmlimages/query_element_display.gif";
    private static String disabledImageFile = "/xmlimages/query_element_at_gray.gif";
    private boolean isHidden = false;
    private DefaultMutableTreeNode defaultMutableTreeNode = null;
    private String queryName = "";
    private String command = "";
    private String prefix = "";
    private String localName = "";
    private String textValue = "";
    private String link_textValue = "";
    private String abbreviation = "";
    private String indent = "";
    private String linebreak = "";
    private String linebreakChar = "";
    private String xsdlocalname = "";
    private String nullHandling = "";
    private String loMode = "";
    private String displayMode = "";
    private XTTTreeNodeInterface parent = null;
    private Vector children = null;
    private Node node = null;
    public Vector queryVector = new Vector();
    public Vector queryColumnTypeVector = new Vector();
    public Vector queryColumnVector = new Vector();
    private boolean expand = false;
    private String inValidStr = null;

    public QueryElement(Node node) {
        this.node = node;
        this.prefix = node.getPrefix();
        this.localName = node.getLocalName();
        this.getAttributes();
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public QueryElement() {
        this.prefix = null;
        this.localName = "";
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public QueryElement(String name) {
        this.prefix = null;
        this.localName = name;
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public void remove_menuitem_actionPerformed(ActionEvent e) {
        XTTFrame.frame.Remove_MenuItem_actionPerformed(null);
    }

    public void attribute_menuitem_actionPerformed(ActionEvent e) {
        int pos;
        if (this.defaultMutableTreeNode == null) {
            GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Cannot_convert_to1"), null);
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.defaultMutableTreeNode.getParent();
        DefaultMutableTreeNode parentParentNode = (DefaultMutableTreeNode)parentNode.getParent();
        Attribute att = new Attribute();
        att.setName(this.localName);
        att.setAttributeValue(this.textValue);
        att.setLinkValue(this.link_textValue);
        att.setParent(this.parent);
        att.setChildren(this.children);
        QueryElement parent_qe = (QueryElement)parentNode.getUserObject();
        int break_line = -1;
        int children_size = parent_qe.getChildren().size();
        XTTTreeNodeInterface childXTT = null;
        for (int i = 0; i < children_size; ++i) {
            childXTT = (XTTTreeNodeInterface)parent_qe.getChildren().elementAt(i);
            if (!(childXTT instanceof QueryElement)) continue;
            break_line = i;
            break;
        }
        if (break_line == (pos = parent_qe.getChildren().indexOf(this))) {
            parent_qe.remove(this);
            parent_qe.addChildAt(att, pos);
        } else if (break_line < pos) {
            parent_qe.addChildAt(att, break_line);
            parent_qe.remove(this);
        }
        this.defaultMutableTreeNode.removeFromParent();
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(att);
        att.setDefaultMutableTreeNode(dmtn);
        int item_pos = parent_qe.getChildren().indexOf(att);
        ((DefaultTreeModel)XTTFrame.frame.getTreeTable().getTree().getModel()).insertNodeInto(dmtn, parentNode, item_pos);
        XTTFrame.frame.refreshTree(parentNode, parentParentNode);
        XTTFrame.frame.refreshTree(dmtn, parentNode);
        TreePath p = new TreePath(dmtn.getPath());
        XTTFrame.frame.getTreeTable().getTree().makeVisible(p);
        int row = XTTFrame.frame.getTreeTable().getTree().getRowForPath(p);
        XTTFrame.frame.getTreeTable().getSelectionModel().setSelectionInterval(row, row);
        ((AbstractTableModel)XTTFrame.frame.getTreeTable().getModel()).fireTableChanged(new TableModelEvent(XTTFrame.frame.getTreeTable().getModel()));
    }

    public String getCommand() {
        if (this.command != null && this.command.length() <= 0) {
            return this.command;
        }
        if (this.command.startsWith("select")) {
            return this.command;
        }
        String s = "SELECT * FROM \"" + this.command + "\"";
        return s;
    }

    public String getDisplayCommand() {
        return this.command;
    }

    public void setCommand(String cmd) {
        this.command = cmd;
        XTTFrame.setXTTModified(true);
        XTTFrame.xttRefresh_xttCombo();
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
        XTTFrame.setXTTModified(true);
        XTTFrame.xttRefresh_xttCombo();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localname) {
        this.localName = localname;
        XTTFrame.setXTTModified(true);
        XTTFrame.xttRefresh_xttCombo();
    }

    public void setXSDLocalName(String localname) {
        this.xsdlocalname = localname;
        this.localName = localname;
    }

    public String getXSDLocalName() {
        return this.xsdlocalname;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
        this.setLinkTextValue(textValue);
        XTTFrame.setXTTModified(true);
        XTTFrame.xttRefresh_xttCombo();
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getLinebreak() {
        return this.linebreak;
    }

    public void setLinebreak(String linebreak) {
        this.linebreak = linebreak;
    }

    public String getLinebreakChar() {
        return this.linebreakChar;
    }

    public void setLinebreakChar(String linebreakchar) {
        this.linebreakChar = linebreakchar;
    }

    public String getLinkTextValue() {
        return this.link_textValue;
    }

    public void setLinkTextValue(String link_textValue) {
        this.link_textValue = link_textValue;
    }

    public void setNullHandling(String null_handling) {
        this.nullHandling = null_handling;
    }

    public String getNullHandling() {
        return this.nullHandling;
    }

    public void setLoMode(String lo_mode) {
        this.loMode = lo_mode;
    }

    public String getLoMode() {
        return this.loMode;
    }

    public void setDisplayMode(String display_mode) {
        this.displayMode = display_mode;
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean b) {
        this.isHidden = b;
    }

    @Override
    public void getAttributes() {
        String s = null;
        Element elm = (Element)this.node;
        s = PreferencesXml.getAttributeValue(elm, "query");
        if (s != null && s.length() > 0) {
            this.queryName = s;
        } else if (this.prefix != null && this.prefix.length() > 0 && this.localName != null && this.localName.length() > 0) {
            if (this.prefix.equals("xtt") && this.localName.equals("query")) {
                s = PreferencesXml.getAttributeValue(elm, "name");
            }
            if (s != null && s.length() > 0) {
                this.queryName = s;
            }
        }
        s = PreferencesXml.getAttributeValue(elm, "command");
        if (s != null && s.length() > 0) {
            this.command = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "abbreviation")) != null && s.length() > 0) {
            this.abbreviation = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "linebreakchar")) != null && s.length() > 0) {
            this.linebreakChar = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "indent")) != null && s.length() > 0) {
            this.indent = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "linebreak")) != null && s.length() > 0) {
            this.linebreak = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "null_handling")) != null && s.length() > 0) {
            this.nullHandling = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "lo_mode")) != null && s.length() > 0) {
            this.loMode = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "display_mode")) != null && s.length() > 0) {
            this.displayMode = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "textvalue")) != null && s.length() > 0) {
            this.textValue = s;
            this.link_textValue = s;
        }
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = XMLImageResource.getResource(this.getClass(), imagefilename);
        }
        return icon;
    }

    @Override
    public ImageIcon getDisabledImageIcon() {
        if (disabled_icon == null) {
            disabled_icon = XMLImageResource.getResource(this.getClass(), disabledImageFile);
        }
        return disabled_icon;
    }

    @Override
    public boolean isFreeze() {
        return false;
    }

    @Override
    public void setDefaultMutableTreeNode(DefaultMutableTreeNode current_node) {
        this.defaultMutableTreeNode = current_node;
    }

    @Override
    public DefaultMutableTreeNode getDefaultMutableTreeNode() {
        return this.defaultMutableTreeNode;
    }

    @Override
    public String toString() {
        return this.localName;
    }

    @Override
    public String getToolTipText() {
        return this.queryName + " = \"" + this.command + "\"";
    }

    @Override
    public Vector getChildren() {
        return this.children;
    }

    @Override
    public void addChild(XTTTreeNodeInterface child) {
        if (this.children == null) {
            this.children = new Vector();
        }
        child.setParent(this);
        this.children.addElement(child);
    }

    public void addChildAt(XTTTreeNodeInterface child, int position) {
        if (this.children == null) {
            this.children = new Vector();
        }
        child.setParent(this);
        if (this.children.size() <= 0) {
            this.children.addElement(child);
        } else {
            this.children.add(position, child);
        }
    }

    @Override
    public void addNextSibling(XTTTreeNodeInterface node) {
        int parent_children_size = this.parent.getChildren().size();
        int break_line = -1;
        XTTTreeNodeInterface childXTT = null;
        for (int i = 0; i < parent_children_size; ++i) {
            childXTT = (XTTTreeNodeInterface)this.parent.getChildren().elementAt(i);
            if (!(childXTT instanceof QueryElement)) continue;
            break_line = i;
            break;
        }
        Vector v = this.parent.getChildren();
        int index = v.indexOf(this);
        if (break_line == -1) {
            break_line = index;
        }
        if (index > break_line) {
            if (node instanceof QueryElement) {
                v.add(index + 1, node);
            } else if (node instanceof Attribute) {
                v.add(break_line, node);
            }
        } else if (node instanceof QueryElement) {
            v.add(break_line + 1, node);
        } else if (node instanceof Attribute) {
            v.add(index, node);
        }
        node.setParent(this.parent);
    }

    @Override
    public void remove(XTTTreeNodeInterface node) {
        node.setParent(null);
        this.children.remove(node);
    }

    @Override
    public void setChildren(Vector v) {
        this.children = v;
    }

    @Override
    public XTTTreeNodeInterface getParent() {
        return this.parent;
    }

    @Override
    public void setParent(XTTTreeNodeInterface node) {
        this.parent = node;
    }

    @Override
    public XTTTreeNodeInterface shorten() {
        return this;
    }

    @Override
    public AbstractDisplayPanel[] getDisplayComponent() {
        AbstractDisplayPanel[] a0 = new AbstractDisplayPanel[]{new ElementMainPanel(this), new QueryPanel(this), new ElementDisplayPanel(this)};
        return a0;
    }

    @Override
    public String getValue(short variable) {
        switch (variable) {
            case 0: {
                return this.abbreviation;
            }
            case 1: {
                return this.indent;
            }
            case 2: {
                return this.linebreak;
            }
            case 3: {
                return this.linebreakChar;
            }
            case 4: {
                return this.displayMode;
            }
            case 7: {
                return this.nullHandling;
            }
            case 6: {
                return this.loMode;
            }
        }
        return "";
    }

    @Override
    public void setValue(short variable, String value) {
        boolean b = false;
        switch (variable) {
            case 0: {
                if (this.abbreviation.equalsIgnoreCase(value)) break;
                String originalValue = this.abbreviation;
                this.abbreviation = value;
                b = true;
                DisplaySettingUndoEdit edit = new DisplaySettingUndoEdit(this, originalValue, "value", true, variable);
                XTTFrame.frame.undoSupport.postEdit(edit);
                XTTFrame.frame.menubar.setUndoEnabled(true);
                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                break;
            }
            case 1: {
                if (this.indent.length() == 0 && value.trim().length() == 0 || this.indent.equalsIgnoreCase(value)) break;
                String originalValue = this.indent;
                this.indent = value;
                b = true;
                DisplaySettingUndoEdit edit = new DisplaySettingUndoEdit(this, originalValue, "value", true, variable);
                XTTFrame.frame.undoSupport.postEdit(edit);
                XTTFrame.frame.menubar.setUndoEnabled(true);
                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                break;
            }
            case 2: {
                if (this.linebreak.equalsIgnoreCase(value)) break;
                String originalValue = this.linebreak;
                this.linebreak = value;
                b = true;
                DisplaySettingUndoEdit edit = new DisplaySettingUndoEdit(this, originalValue, "value", true, variable);
                XTTFrame.frame.undoSupport.postEdit(edit);
                XTTFrame.frame.menubar.setUndoEnabled(true);
                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                break;
            }
            case 3: {
                if (this.linebreakChar.equalsIgnoreCase(value)) break;
                String originalValue = this.linebreakChar;
                this.linebreakChar = value;
                b = true;
                DisplaySettingUndoEdit edit = new DisplaySettingUndoEdit(this, originalValue, "value", true, variable);
                XTTFrame.frame.undoSupport.postEdit(edit);
                XTTFrame.frame.menubar.setUndoEnabled(true);
                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                break;
            }
            case 4: {
                if (this.displayMode.equalsIgnoreCase(value)) break;
                String originalValue = this.displayMode;
                this.displayMode = value;
                b = true;
                DisplaySettingUndoEdit edit = new DisplaySettingUndoEdit(this, originalValue, "value", true, variable);
                XTTFrame.frame.undoSupport.postEdit(edit);
                XTTFrame.frame.menubar.setUndoEnabled(true);
                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                break;
            }
            case 7: {
                if (this.nullHandling.equalsIgnoreCase(value)) break;
                String originalValue = this.nullHandling;
                this.nullHandling = value;
                b = true;
                DisplaySettingUndoEdit edit = new DisplaySettingUndoEdit(this, originalValue, "value", true, variable);
                XTTFrame.frame.undoSupport.postEdit(edit);
                XTTFrame.frame.menubar.setUndoEnabled(true);
                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                break;
            }
            case 6: {
                if (this.loMode.equalsIgnoreCase(value)) break;
                String originalValue = this.loMode;
                this.loMode = value;
                b = true;
                DisplaySettingUndoEdit edit = new DisplaySettingUndoEdit(this, originalValue, "value", true, variable);
                XTTFrame.frame.undoSupport.postEdit(edit);
                XTTFrame.frame.menubar.setUndoEnabled(true);
                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
            }
        }
        if (b) {
            XTTFrame.setXTTModified(true);
            XTTFrame.xttRefresh_xttCombo();
        }
    }

    public void scanTree4Generate(Vector documentV) {
        int index;
        DocumentInfoObject dio = new DocumentInfoObject(this.children, this.localName);
        if (this.textValue != null && this.textValue.length() > 0) {
            dio.setHasTextValue(true);
            Vector v = new Vector();
            this.getColumnData(v);
            int size = v.size();
            if (size > 0) {
                ColumnObject co = null;
                Object obj = null;
                String s = null;
                for (int i = 0; i < size; ++i) {
                    obj = v.elementAt(i);
                    if (obj instanceof ColumnObject) {
                        co = (ColumnObject)obj;
                        s = co.getQueryObject();
                    } else {
                        s = obj.toString();
                    }
                    if (!this.textValue.equals(s)) continue;
                    dio.setType(XTTFrame.mapDB2XSD(co.getType()));
                    break;
                }
            }
        }
        if ((index = documentV.indexOf(dio)) < 0) {
            documentV.add(dio);
        } else {
            DocumentInfoObject qe_dio = (DocumentInfoObject)documentV.elementAt(index);
            qe_dio.addDuplicate(this);
        }
        if (this.children != null) {
            int children_size = this.children.size();
            XTTTreeNodeInterface childXTT = null;
            for (int j = 0; j < children_size; ++j) {
                childXTT = (XTTTreeNodeInterface)this.children.elementAt(j);
                if (childXTT instanceof QueryElement) {
                    ((QueryElement)childXTT).scanTree4Generate(documentV);
                    continue;
                }
                if (!(childXTT instanceof Attribute)) continue;
                ((Attribute)childXTT).scanTree4Generate();
            }
        }
    }

    public void getColumnData(Vector v) {
        this.getColumnData(v, false, false);
    }

    public void getColumnData(Vector v, boolean scanTemplate, boolean isValidation) {
        this.prepareSQL(this.getCommand(), isValidation);
        v.addAll(this.queryVector);
        XTTTreeNodeInterface xtt2 = this.getParent();
        if (xtt2 instanceof QueryElement) {
            ((QueryElement)xtt2).getColumnData(v, scanTemplate, isValidation);
        }
        if (scanTemplate && xtt2 instanceof Template) {
            ((Template)xtt2).getParameterObject(v);
        }
    }

    public boolean prepareSQL(String queryStr, boolean isValidation) {
        String sqlStr = QueryParser.getPreparedStmt(queryStr).trim();
        if (sqlStr == null || sqlStr.trim().length() <= 0) {
            this.queryColumnVector.removeAllElements();
            this.queryColumnTypeVector.removeAllElements();
            this.inValidStr = null;
            return true;
        }
        PreparedStatement pstmt = null;
        ResultSetMetaData rsmd = null;
        try {
            if (XTTFrame.frame.conn == null || XTTFrame.frame.conn.dbconn == null) {
                this.inValidStr = null;
                return false;
            }
            XTTFrame.frame.conn.dbconn.setAutoCommit(false);
            pstmt = XTTFrame.frame.conn.dbconn.prepareStatement(sqlStr);
            rsmd = pstmt.getMetaData();
            if (rsmd == null) {
                GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Please_input_SQL"), null);
                DbaObject.close(pstmt);
                XTTFrame.frame.conn.dbconn.rollback();
                XTTFrame.frame.conn.dbconn.setAutoCommit(true);
                this.inValidStr = null;
                return false;
            }
            int size = rsmd.getColumnCount();
            this.queryColumnVector.removeAllElements();
            this.queryColumnTypeVector.removeAllElements();
            for (int i = 1; i <= size; ++i) {
                this.queryColumnVector.add(rsmd.getColumnName(i));
                this.queryColumnTypeVector.add(rsmd.getColumnTypeName(i));
            }
            DbaObject.close(pstmt);
            XTTFrame.frame.conn.dbconn.rollback();
            XTTFrame.frame.conn.dbconn.setAutoCommit(true);
            if (this.queryName != null && this.queryName.length() > 0) {
                int column_size = this.queryColumnVector.size();
                this.queryVector.removeAllElements();
                ColumnObject co = null;
                for (int i = 0; i < column_size; ++i) {
                    co = new ColumnObject(this.queryName, this.queryColumnVector.elementAt(i).toString(), this.queryColumnTypeVector.elementAt(i).toString());
                    this.queryVector.add(co);
                }
            } else {
                this.queryVector.removeAllElements();
            }
            XTTFrame.frame.refreshXTT();
            this.inValidStr = null;
            return true;
        }
        catch (SQLException sqle) {
            if (!isValidation) {
                GuiUt.showErrorDlg(XTTFrame.frame, sqle.getMessage(), null);
            }
            System.out.println("dddd = " + sqle.getMessage());
            this.inValidStr = sqle.getMessage();
            this.queryColumnVector.removeAllElements();
            this.queryColumnTypeVector.removeAllElements();
            this.queryVector.removeAllElements();
            DbaObject.close(pstmt);
            DbaObject.rollback(XTTFrame.frame.conn.dbconn);
            DbaObject.setAutoCommit(XTTFrame.frame.conn.dbconn, true);
            return false;
        }
    }

    @Override
    public String write(int space_count) {
        String qeStr = "";
        qeStr = qeStr + XTTUt.buildSpaceString(space_count += 2);
        qeStr = qeStr + "<" + this.localName;
        if (this.getTextValue().trim().length() > 0) {
            qeStr = qeStr + " xtt:textvalue=\"" + XTTUt.mapXMLData(this.getTextValue(), false) + "\"";
        }
        if (this.getQueryName().trim().length() > 0 && this.getCommand().trim().length() > 0) {
            qeStr = qeStr + " xtt:query=\"" + this.getQueryName() + "\"" + " xtt:command=\"" + XTTUt.mapXMLData(this.getCommand(), false) + "\"";
        }
        if (this.abbreviation.trim().length() > 0) {
            qeStr = qeStr + " xtt:abbreviation=\"" + this.abbreviation + "\"";
        }
        if (this.indent.trim().length() > 0) {
            qeStr = qeStr + " xtt:indent=\"" + this.indent + "\"";
        }
        if (this.linebreakChar.trim().length() > 0) {
            qeStr = qeStr + " xtt:linebreakchar=\"" + this.linebreakChar + "\"";
        }
        if (this.linebreak.trim().length() > 0) {
            qeStr = qeStr + " xtt:linebreak=\"" + this.linebreak + "\"";
        }
        if (this.displayMode.trim().length() > 0) {
            qeStr = qeStr + " xtt:display_mode=\"" + this.displayMode + "\"";
        }
        if (this.nullHandling.trim().length() > 0) {
            qeStr = qeStr + " xtt:null_handling=\"" + this.nullHandling + "\"";
        }
        if (this.loMode.trim().length() > 0) {
            qeStr = qeStr + " xtt:lo_mode=\"" + this.loMode + "\"";
        }
        if (this.children != null) {
            int size = this.children.size();
            XTTTreeNodeInterface childXTT = null;
            qeStr = qeStr + ">\n";
            for (int j = 0; j < size; ++j) {
                childXTT = (XTTTreeNodeInterface)this.children.elementAt(j);
                qeStr = qeStr + XTTUt.buildSpaceString(space_count) + childXTT.write(space_count);
            }
            qeStr = qeStr + XTTUt.buildSpaceString(space_count);
            qeStr = qeStr + XTTUt.buildSpaceString(space_count -= 2) + "</" + this.localName + ">\n";
        } else {
            qeStr = qeStr + " />\n";
        }
        return qeStr;
    }

    @Override
    public void refresh() {
        if (this.children != null) {
            int size = this.children.size();
            Vector<XTTTreeNodeInterface> attVector = new Vector<XTTTreeNodeInterface>();
            Vector<XTTTreeNodeInterface> qeVector = new Vector<XTTTreeNodeInterface>();
            XTTTreeNodeInterface childXTT = null;
            for (int j = 0; j < size; ++j) {
                childXTT = (XTTTreeNodeInterface)this.children.elementAt(j);
                if (childXTT instanceof QueryElement) {
                    qeVector.add(childXTT);
                    childXTT.refresh();
                    continue;
                }
                if (!(childXTT instanceof Attribute)) continue;
                attVector.add(childXTT);
                childXTT.refresh();
            }
            this.children.removeAllElements();
            if (attVector.size() > 0) {
                this.children.addAll(attVector);
            }
            if (qeVector.size() > 0) {
                this.children.addAll(qeVector);
            }
        }
    }

    @Override
    public void buildLinkDataVector(Vector inputVector) {
        Vector v;
        if (!this.textValue.equalsIgnoreCase(this.link_textValue) && (v = QueryParser.getVariables(this.link_textValue)).size() > 0) {
            inputVector.addAll(v);
        }
        if (this.children == null) {
            return;
        }
        int children_size = this.children.size();
        XTTTreeNodeInterface childXTT = null;
        for (int j = 0; j < children_size; ++j) {
            childXTT = (XTTTreeNodeInterface)this.children.elementAt(j);
            childXTT.buildLinkDataVector(inputVector);
        }
    }

    @Override
    public void findInvalidNode(Vector v) {
        InvalidElementObject ieo;
        Vector vv;
        if (this.textValue != null && this.textValue.length() > 0 && (vv = QueryParser.getVariables(this.textValue)).size() > 0) {
            Vector columnVector = new Vector();
            this.getColumnData(columnVector, true, true);
            if (columnVector.size() <= 0) {
                String s1 = this.res.getString("is_not_matched_in");
                String s2 = GuiUt.mapStringForProperty(s1, this.getTextValue());
                InvalidElementObject ieo2 = new InvalidElementObject(this, s2);
                v.add(ieo2);
            }
            int size = vv.size();
            String vectorItemStr = null;
            String queryObjectStr = null;
            boolean found = true;
            int columnVectorSize = columnVector.size();
            Object obj = null;
            for (int i = 0; i < size; ++i) {
                vectorItemStr = vv.elementAt(i).toString();
                found = true;
                for (int j = 0; j < columnVectorSize; ++j) {
                    obj = columnVector.elementAt(j);
                    queryObjectStr = obj instanceof ColumnObject ? ((ColumnObject)obj).getQueryObject() : obj.toString();
                    if (!vectorItemStr.equalsIgnoreCase(queryObjectStr)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                String s1 = this.res.getString("is_not_existed_in");
                String s2 = GuiUt.mapStringForProperty(s1, this.getTextValue());
                InvalidElementObject ieo3 = new InvalidElementObject(this, s2);
                v.add(ieo3);
                break;
            }
        }
        if (this.queryName != null && this.queryName.length() > 0 && (this.command == null || this.command.length() <= 0)) {
            String s1 = this.res.getString("cannot_has_any_SQL");
            String s2 = GuiUt.mapStringForProperty(s1, this.getQueryName());
            InvalidElementObject ieo4 = new InvalidElementObject(this, s2);
            v.add(ieo4);
        }
        if (this.command != null && this.command.length() > 0 && (this.queryName == null || this.queryName.length() <= 0)) {
            ieo = new InvalidElementObject(this, this.res.getString("SQL_command_must_be"));
            v.add(ieo);
        }
        if (this.queryName != null && this.queryName.length() > 0 && this.command != null && this.command.length() > 0 && !this.prepareSQL(this.command, true) && this.inValidStr != null) {
            ieo = new InvalidElementObject(this, this.inValidStr, true);
            v.add(ieo);
        }
        if (this.children == null) {
            return;
        }
        int children_size = this.children.size();
        XTTTreeNodeInterface childXTT = null;
        for (int j = 0; j < children_size; ++j) {
            childXTT = (XTTTreeNodeInterface)this.children.elementAt(j);
            childXTT.findInvalidNode(v);
        }
    }

    @Override
    public boolean isExpand() {
        return this.expand;
    }

    @Override
    public void setExpand(boolean b) {
        this.expand = b;
    }

    @Override
    public XTTTreeNodeInterface duplicateSelf() {
        QueryElement qe = new QueryElement();
        if (this.localName != null && this.localName.length() > 0) {
            qe.setLocalName(this.localName);
        }
        if (this.queryName != null && this.queryName.length() > 0) {
            qe.setQueryName(this.queryName);
        }
        if (this.command != null && this.command.length() > 0) {
            qe.setCommand(this.command);
        }
        if (this.textValue != null && this.textValue.length() > 0) {
            qe.setTextValue(this.textValue);
        }
        if (this.link_textValue != null && this.link_textValue.length() > 0) {
            qe.setLinkTextValue(this.link_textValue);
        }
        if (this.abbreviation != null && this.abbreviation.length() > 0) {
            qe.setAbbreviation(this.abbreviation);
        }
        if (this.indent != null && this.indent.length() > 0) {
            qe.setIndent(this.indent);
        }
        if (this.linebreak != null && this.linebreak.length() > 0) {
            qe.setLinkTextValue(this.linebreak);
        }
        if (this.linebreakChar != null && this.linebreakChar.length() > 0) {
            qe.setLinebreakChar(this.linebreakChar);
        }
        if (this.xsdlocalname != null && this.xsdlocalname.length() > 0) {
            qe.setXSDLocalName(this.xsdlocalname);
        }
        if (this.nullHandling != null && this.nullHandling.length() > 0) {
            qe.setNullHandling(this.nullHandling);
        }
        if (this.loMode != null && this.loMode.length() > 0) {
            qe.setLoMode(this.loMode);
        }
        if (this.displayMode != null && this.displayMode.length() > 0) {
            qe.setDisplayMode(this.displayMode);
        }
        if (this.parent != null) {
            qe.setParent(this.parent);
        }
        qe.setExpand(this.expand);
        qe.setHidden(this.isHidden);
        if (this.children != null && this.children.size() > 0) {
            int size = this.children.size();
            XTTTreeNodeInterface childXTT = null;
            for (int i = 0; i < size; ++i) {
                childXTT = (XTTTreeNodeInterface)this.children.elementAt(i);
                qe.addChild(childXTT.duplicateSelf());
            }
        }
        return qe;
    }

    public void setChildQueryObjectName(XTTTreeNodeInterface selfXTT, String originalStr, String modifiedStr, UndoableEdit edit) {
        if (selfXTT == null) {
            return;
        }
        XTTTreeNodeInterface childXTT = null;
        Vector children = selfXTT.getChildren();
        if (children == null) {
            return;
        }
        if (modifiedStr.length() <= 0) {
            return;
        }
        int size = children.size();
        String sqlStr = null;
        String modifiedSqlStr = null;
        for (int i = 0; i < size; ++i) {
            Attribute att;
            DocumentUndoEdit ed;
            int index;
            childXTT = (XTTTreeNodeInterface)children.elementAt(i);
            if (childXTT instanceof QueryElement) {
                QueryElement qe = (QueryElement)childXTT;
                sqlStr = qe.getCommand();
                if (sqlStr.length() > 0 && (index = sqlStr.indexOf(originalStr)) >= 0) {
                    modifiedSqlStr = sqlStr.substring(0, index) + modifiedStr + sqlStr.substring(index + originalStr.length(), sqlStr.length());
                    qe.setCommand(modifiedSqlStr);
                    ed = new DocumentUndoEdit(qe, "command", sqlStr, true);
                    ((DocumentUndoEdit)edit).addUndo(ed);
                }
                if ((sqlStr = qe.getTextValue()).length() > 0 && (index = sqlStr.indexOf(originalStr)) > 0) {
                    modifiedSqlStr = sqlStr.substring(0, index) + modifiedStr + sqlStr.substring(index + originalStr.length(), sqlStr.length());
                    qe.setTextValue(modifiedSqlStr);
                    ed = new DocumentUndoEdit(qe, "textValue", sqlStr, true);
                    ((DocumentUndoEdit)edit).addUndo(ed);
                }
            } else if (childXTT instanceof Attribute && (sqlStr = (att = (Attribute)childXTT).getValue()).length() > 0 && (index = sqlStr.indexOf(originalStr)) >= 0) {
                modifiedSqlStr = sqlStr.substring(0, index) + modifiedStr + sqlStr.substring(index + originalStr.length(), sqlStr.length());
                att.setAttributeValue(modifiedSqlStr);
                ed = new DocumentUndoEdit(att, "value", sqlStr, true);
                ((DocumentUndoEdit)edit).addUndo(ed);
            }
            this.setChildQueryObjectName(childXTT, originalStr, modifiedStr, edit);
        }
    }

    public void copy_menuitem_actionPerformed(ActionEvent e) {
        XTTFrame.frame.Copy_MenuItem_actionPerformed(e);
    }

    public void cut_menuitem_actionPerformed(ActionEvent e) {
        XTTFrame.frame.Cut_MenuItem_actionPerformed(e);
    }

    public void paste_menuitem_actionPerformed(ActionEvent e) {
        XTTFrame.frame.Paste_MenuItem_actionPerformed(e);
    }

    public void new_element_menuitem_actionPerformed(ActionEvent e) {
        XTTFrame.frame.elementToolButton_actionPerformed(e);
    }

    public void new_attribute_menuitem_actionPerformed(ActionEvent e) {
        XTTFrame.frame.attributeToolButton_actionPerformed(e);
    }

    @Override
    public void showPopup(MouseEvent e) {
        JPopupMenu qe_popupmenu = new JPopupMenu();
        JMenuItem remove_menuitem = new JMenuItem(this.res.getString("Remove"), XMLImageResource.getResource(this.getClass(), "/xmlimages/toolbar/remove_treenode.gif"));
        remove_menuitem.addActionListener(new ReflectionAction(this, "remove_menuitem_actionPerformed"));
        JMenuItem paste_menuitem = new JMenuItem(this.res.getString("Paste"), XMLImageResource.getResource(this.getClass(), "/xmlimages/Paste24.gif"));
        paste_menuitem.addActionListener(new ReflectionAction(this, "paste_menuitem_actionPerformed"));
        JMenuItem new_element_menuitem = new JMenuItem(this.res.getString("Element"), XMLImageResource.getResource(this.getClass(), "/xmlimages/toolbar/new_element.gif"));
        new_element_menuitem.addActionListener(new ReflectionAction(this, "new_element_menuitem_actionPerformed"));
        JMenuItem new_attribute_menuitem = new JMenuItem(this.res.getString("Attribute"), XMLImageResource.getResource(this.getClass(), "/xmlimages/toolbar/new_attribute.gif"));
        new_attribute_menuitem.addActionListener(new ReflectionAction(this, "new_attribute_menuitem_actionPerformed"));
        JMenuItem copy_menuitem = new JMenuItem(this.res.getString("Copy"), XMLImageResource.getResource(this.getClass(), "/xmlimages/Copy24.gif"));
        copy_menuitem.addActionListener(new ReflectionAction(this, "copy_menuitem_actionPerformed"));
        JMenuItem cut_menuitem = new JMenuItem(this.res.getString("Cut"), XMLImageResource.getResource(this.getClass(), "/xmlimages/Cut24.gif"));
        cut_menuitem.addActionListener(new ReflectionAction(this, "cut_menuitem_actionPerformed"));
        if (this.getParent() instanceof Template) {
            if (XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                qe_popupmenu.add(new_element_menuitem);
                qe_popupmenu.add(new_attribute_menuitem);
                qe_popupmenu.addSeparator();
            }
        } else {
            qe_popupmenu.add(new_element_menuitem);
            qe_popupmenu.add(new_attribute_menuitem);
            qe_popupmenu.addSeparator();
            if (this.children == null || this.children.size() <= 0) {
                JMenuItem attribute_menuitem = new JMenuItem(this.res.getString("Change_to_ATTRIBUTE"), XMLImageResource.getResource(this.getClass(), "/xmlimages/toolbar/new_attribute.gif"));
                attribute_menuitem.addActionListener(new ReflectionAction(this, "attribute_menuitem_actionPerformed"));
                qe_popupmenu.add(attribute_menuitem);
                qe_popupmenu.addSeparator();
            }
        }
        qe_popupmenu.add(cut_menuitem);
        qe_popupmenu.add(copy_menuitem);
        qe_popupmenu.add(paste_menuitem);
        qe_popupmenu.addSeparator();
        qe_popupmenu.add(remove_menuitem);
        qe_popupmenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public int getTabbedIndex(String property) {
        if (property.equals("localName") || property.equals("textValue")) {
            return 0;
        }
        if (property.equals("queryName") || property.equals("command")) {
            return 1;
        }
        return 2;
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = ResourceBundle.getBundle("com.syscom.xml.node.resource.Res", LocaleManager.getLocale());
    }
}

