/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.textField;

import com.syscom.ut.textField.DbaTextField;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JPasswordField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class CharPasswordField
extends JPasswordField
implements DbaTextField {
    private Toolkit toolkit;
    private int max_length = 0;
    private boolean length_limited = false;
    private CharPasswordField field = this;
    private CharPasswordField current = this;

    public CharPasswordField(String value, int max_length) {
        this();
        this.max_length = max_length;
        this.length_limited = true;
        this.setValue(value);
    }

    public CharPasswordField(int max_length, boolean max) {
        this();
        this.max_length = max_length;
        this.length_limited = true;
    }

    public CharPasswordField(int max_length) {
        this(max_length, true);
    }

    public CharPasswordField() {
        this.toolkit = Toolkit.getDefaultToolkit();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public Object getValue() {
        return new String(this.getPassword());
    }

    public void setValue(String value) {
        this.setText(value);
    }

    @Override
    protected Document createDefaultModel() {
        return new CharDocument();
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CharPasswordField.this.this_focusGained(e);
            }
        });
    }

    public void this_focusGained(FocusEvent e) {
        this.selectAll();
    }

    protected class CharDocument
    extends PlainDocument {
        protected CharDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (CharPasswordField.this.length_limited) {
                byte[] strByteArray;
                String temp = new String(CharPasswordField.this.field.getPassword());
                if (temp == null || str == null) {
                    return;
                }
                byte[] tmpByteArray = temp.getBytes();
                if (tmpByteArray.length + (strByteArray = str.getBytes()).length > CharPasswordField.this.max_length) {
                    CharPasswordField.this.toolkit.beep();
                    return;
                }
            }
            super.insertString(offs, str, a);
        }
    }
}

