/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.locale;

import com.syscom.ut.GuiUt;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.resource.DBAResourceBundle;
import java.util.Locale;
import java.util.Vector;
import javax.swing.UIManager;
import startup.ToolInfo;

public class LocaleManager
implements LocaleChangeListener {
    private static LocaleManager localeManager = null;
    private static Locale locale = null;
    private Vector listenerList = new Vector();
    public static final short ENGLISH = 0;
    public static final short CHINESE = 1;
    public static final short JAPANESE = 2;
    public static final short CHINA = 3;
    public static boolean isDBMaker = true;
    public static boolean[] language_enable = new boolean[]{true, true, true, true};
    private static short default_System_Language = 0;
    private static final Locale[] locales = new Locale[]{Locale.US, Locale.TAIWAN, Locale.JAPAN, Locale.CHINA};

    public LocaleManager(short choice) {
        if (choice < 0 || choice >= locales.length) {
            choice = 0;
        }
        locale = locales[choice];
        LocaleManager.setDefaultSystemLanguage(ToolInfo.getDefaultLanguage());
        LocaleManager.setIsDBMaker(ToolInfo.getDBMaker());
        LocaleManager.setLanguageEnableArray(ToolInfo.getLanguageEnable());
    }

    public static short getDefaultSystemLanguage() {
        LocaleManager.setDefaultSystemLanguage(ToolInfo.getDefaultLanguage());
        if (GuiUt.isWindows()) {
            return default_System_Language;
        }
        return 0;
    }

    public static void setDefaultSystemLanguage(short lang) {
        default_System_Language = lang;
    }

    public static boolean getIsDBMaker() {
        LocaleManager.setIsDBMaker(ToolInfo.getDBMaker());
        return isDBMaker;
    }

    public static void setIsDBMaker(boolean b) {
        isDBMaker = b;
    }

    public static void setLanguageEnableArray(boolean[] booleanArray) {
        for (boolean LocaleManager.language_enable[i] : booleanArray) {
        }
    }

    public static short getHelpFileLanguage() {
        LocaleManager.setDefaultSystemLanguage(ToolInfo.getDefaultLanguage());
        return default_System_Language;
    }

    public static Locale getLocale(short choice) {
        if (choice < 0 || choice >= locales.length) {
            return null;
        }
        return locales[choice];
    }

    public static Locale getLocale() {
        if (localeManager == null) {
            localeManager = new LocaleManager(LocaleManager.getDefaultSystemLanguage());
        }
        return locale;
    }

    public static LocaleManager getLocaleManager() {
        if (localeManager == null) {
            localeManager = new LocaleManager(LocaleManager.getDefaultSystemLanguage());
        }
        return localeManager;
    }

    public static LocaleManager getLocaleManager(short language_choice) {
        if (localeManager == null) {
            localeManager = new LocaleManager(language_choice);
        }
        return localeManager;
    }

    public synchronized void addLocaleChangeListener(LocaleChangeListener listener) {
        this.listenerList.addElement(listener);
    }

    public synchronized void removeLocaleChangeListener(LocaleChangeListener listener) {
        this.listenerList.removeElement(listener);
    }

    public Vector getLocaleChangedListener() {
        Vector listeners = (Vector)this.listenerList.clone();
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localeChanged(LocaleChangeEvent e) {
        Vector listeners;
        locale = e.getLocale();
        DBAResourceBundle res = new DBAResourceBundle("utproperties.Res", LocaleManager.getLocale());
        Locale.setDefault(locale);
        UIManager.put("FileChooser.lookInLabelText", res.getString("Look_in"));
        UIManager.put("FileChooser.fileNameLabelText", res.getString("File_name"));
        UIManager.put("FileChooser.filesOfTypeLabelText", res.getString("File_of_types"));
        UIManager.put("FileChooser.upFolderToolTipText", res.getString("upFolderToolTipText"));
        UIManager.put("FileChooser.homeFolderToolTipText", res.getString("homeFolderToolTipText"));
        UIManager.put("FileChooser.newFolderToolTipText", res.getString("newFolderToolTipText"));
        UIManager.put("FileChooser.listViewButtonToolTipText", res.getString("listViewButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", res.getString("detailsViewButtonToolTipText"));
        UIManager.put("FileChooser.acceptAllFileFilterText", res.getString("acceptAllFileFilterText"));
        UIManager.put("FileChooser.saveButtonText", res.getString("saveButtonText"));
        UIManager.put("FileChooser.openButtonText", res.getString("openButtonText"));
        UIManager.put("FileChooser.saveDialogTitleText", res.getString("saveDialogTitleText"));
        UIManager.put("FileChooser.openDialogTitleText", res.getString("openDialogTitleText"));
        UIManager.put("FileChooser.cancelButtonText", res.getString("cancelButtonText"));
        UIManager.put("FileChooser.saveButtonToolTipText", res.getString("saveButtonToolTipText"));
        UIManager.put("FileChooser.openButtonToolTipText", res.getString("openButtonToolTipText"));
        UIManager.put("FileChooser.cancelButtonToolTipText", res.getString("cancelButtonToolTipText"));
        LocaleManager localeManager = this;
        synchronized (localeManager) {
            listeners = (Vector)this.listenerList.clone();
        }
        int size = listeners.size();
        for (int i = 0; i < size; ++i) {
            ((LocaleChangeListener)listeners.elementAt(i)).localeChanged(e);
        }
    }

    public void resetLocale(short choice) {
        if (choice >= 0 && choice < locales.length) {
            locale = locales[choice];
        }
    }

    public static String getLanguage() {
        Locale l = LocaleManager.getLocale();
        if (l.equals(Locale.US)) {
            return new String("english");
        }
        if (l.equals(Locale.TAIWAN)) {
            return new String("chinese");
        }
        if (l.equals(Locale.JAPAN)) {
            return new String("japanese");
        }
        if (l.equals(Locale.CHINA)) {
            return new String("china");
        }
        return new String("english");
    }

    public static short getLanguageChoice() {
        Locale l = LocaleManager.getLocale();
        if (l.equals(Locale.TAIWAN)) {
            return 1;
        }
        if (l.equals(Locale.US)) {
            return 0;
        }
        if (l.equals(Locale.JAPAN)) {
            return 2;
        }
        if (l.equals(Locale.CHINA)) {
            return 3;
        }
        return 0;
    }

    public static String getErrlcode() {
        Locale currentLocale = LocaleManager.getLocale();
        if (currentLocale == Locale.TAIWAN) {
            return "zh_TW";
        }
        if (currentLocale == Locale.CHINA) {
            return "zh_CN";
        }
        if (currentLocale == Locale.JAPAN) {
            return "ja";
        }
        return "en";
    }
}

