/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.comp;

import com.syscom.ut.locale.LocaleManager;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicMenuUI;

public class DbaMenu
extends JMenu {
    public DbaMenu() {
        this.setUI(new MyMenuUI());
    }

    public DbaMenu(String t, char c) {
        this();
        this.setText(t);
        this.setMnemonic(c);
    }

    @Override
    public void setMnemonic(char c) {
        super.setMnemonic(c);
        if (LocaleManager.getLanguageChoice() != 0) {
            String t = this.getText();
            String upper_t = t.toUpperCase();
            String lower_t = t.toLowerCase();
            if (t.length() > 0 && upper_t.indexOf(c) < 0 && lower_t.indexOf(c) < 0) {
                super.setText(t + "(" + c + ")");
            }
        }
    }

    @Override
    public void setText(String t) {
        if (this.getMnemonic() == 0 || LocaleManager.getLanguageChoice() == 0) {
            super.setText(t);
        } else if (LocaleManager.getLanguageChoice() != 0) {
            char c = (char)this.getMnemonic();
            String upper_t = t.toUpperCase();
            String lower_t = t.toLowerCase();
            if (t.length() > 0 && upper_t.indexOf(c) < 0 && lower_t.indexOf(c) < 0) {
                super.setText(t + "(" + c + ")");
            } else if (t.length() > 0) {
                super.setText(t);
            }
        }
    }

    public class MyMenuUI
    extends BasicMenuUI {
        @Override
        protected MouseInputListener createMouseInputListener(JComponent c) {
            return new MouseInputHandler();
        }

        private class MouseInputHandler
        implements MouseInputListener {
            private MouseInputHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean i = false;
                boolean j = true;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MenuElement[] selectedPath;
                JMenu menu = (JMenu)MyMenuUI.this.menuItem;
                if (!menu.isEnabled()) {
                    return;
                }
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                if (menu.isTopLevelMenu()) {
                    if (menu.isSelected()) {
                        manager.clearSelectedPath();
                    } else {
                        Container cnt = menu.getParent();
                        if (cnt != null && cnt instanceof JMenuBar) {
                            MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), menu};
                            manager.setSelectedPath(me);
                        }
                    }
                }
                if ((selectedPath = manager.getSelectedPath()).length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                        MenuElement[] newPath = new MenuElement[selectedPath.length + 1];
                        System.arraycopy(selectedPath, 0, newPath, 0, selectedPath.length);
                        newPath[selectedPath.length] = menu.getPopupMenu();
                        manager.setSelectedPath(newPath);
                    } else {
                        MyMenuUI.this.setupPostTimer(menu);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JMenu menu = (JMenu)MyMenuUI.this.menuItem;
                if (!menu.isEnabled()) {
                    return;
                }
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                manager.processMouseEvent(e);
                if (!e.isConsumed()) {
                    manager.clearSelectedPath();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JMenu menu = (JMenu)MyMenuUI.this.menuItem;
                if (!menu.isEnabled()) {
                    return;
                }
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                MenuElement[] selectedPath = manager.getSelectedPath();
                if (!menu.isTopLevelMenu()) {
                    if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                        if (menu.getDelay() == 0) {
                            MenuElement[] newPath = new MenuElement[selectedPath.length + 2];
                            System.arraycopy(selectedPath, 0, newPath, 0, selectedPath.length);
                            newPath[selectedPath.length] = MyMenuUI.this.menuItem;
                            newPath[selectedPath.length + 1] = menu.getPopupMenu();
                            manager.setSelectedPath(newPath);
                        } else {
                            manager.setSelectedPath(MyMenuUI.this.getPath());
                            MyMenuUI.this.setupPostTimer(menu);
                        }
                    }
                } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                    MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                    manager.setSelectedPath(newPath);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                JMenu menu = (JMenu)MyMenuUI.this.menuItem;
                if (!menu.isEnabled()) {
                    return;
                }
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean i = false;
                boolean j = false;
            }
        }
    }
}

