/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut;

import com.syscom.ut.DbaObject;
import com.syscom.ut.GuiUt;
import com.syscom.ut.JdmConfig;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.xtt.console.XTTFrame;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseConnection {
    public Connection dbconn;
    public static String dbLoginStr = "jdbc:dbmaker:";
    public static String dbDriverName = "dbmaker.sql.JdbcOdbcDriver";
    String dbname = "";
    String username = "";
    String dbdir = "";
    Float fileversion;
    Float version;
    public boolean isDBA = false;
    private Component dlg = null;
    public boolean isIDCAP = true;
    private boolean startDB = false;

    public DatabaseConnection(String dbname, String username, String password, Component dlg) {
        this.dlg = dlg;
        Object stmt = null;
        try {
            this.dbname = dbname;
            this.username = username;
            Class.forName(dbDriverName);
            JdmConfig config = new JdmConfig();
            if (config.isTerminalServer(dbname)) {
                System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
                if (!GuiUt.isWindows()) {
                    System.out.println("DM_CONNECT_MODE=START_DB");
                    System.setProperty("DM_CONNECT_MODE", "START_DB");
                    this.startDB = true;
                } else {
                    System.out.println("DM_CONNECT_MODE=CONNECT_DB");
                    System.setProperty("DM_CONNECT_MODE", "CONNECT_DB");
                }
            } else {
                System.out.println("DM_DRIVER_MODE=CLIENT_SERVER");
                System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
                System.out.println("DM_CONNECT_MODE=CONNECT_DB");
                System.setProperty("DM_CONNECT_MODE", "CONNECT_DB");
            }
            String errlcode = LocaleManager.getErrlcode();
            String conStr = dbLoginStr + dbname + ";errlcode=" + errlcode;
            this.dbconn = DriverManager.getConnection(conStr, username, password);
            this.dbconn.setAutoCommit(true);
            ((JdbcOdbcConnection)this.dbconn).setOption(1126, 2);
            XTTFrame.frame.isConnect = true;
            this.isIDCAP = ((JdbcOdbcConnection)this.dbconn).getOptionInt(28) == 1;
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(XTTFrame.frame, null, sqle);
            XTTFrame.frame.isConnect = false;
            DbaObject.close(stmt);
        }
        catch (ClassNotFoundException ex) {
            GuiUt.showErrorDlg(XTTFrame.frame, ex.getMessage(), null);
            XTTFrame.frame.isConnect = false;
        }
        catch (Exception ex) {
            GuiUt.showErrorDlg(XTTFrame.frame, ex.getMessage(), null);
            XTTFrame.frame.isConnect = false;
        }
    }

    private void getVersion() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            JdmConfig config = new JdmConfig();
            int rc = config.fileOpen("dmconfig.ini", this.dbname, "r");
            this.dbdir = (String)config.getPara("DB_DBDIR", 4096);
            if (this.dbdir != null) {
                this.dbdir = this.dbdir.trim();
            }
            config.fileClose();
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("select VALUE from SYSTEM.SYSINFO WHERE INFO in ('FILE_VERSION', 'VERSION') ORDER BY ID");
            if (rs.next()) {
                this.version = new Float(rs.getString(1));
            }
            if (rs.next()) {
                this.fileversion = new Float(rs.getString(1));
            }
            rs.close();
            if (this.version.floatValue() >= 3.6f) {
                rs = stmt.executeQuery("SELECT GETSYSINFO('DBDIR') FROM SYSTEM.SYSINFO");
                if (rs.next()) {
                    this.dbdir = rs.getString(1);
                    if (this.dbdir != null) {
                        this.dbdir = this.dbdir.trim();
                    }
                }
                rs.close();
            }
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.dlg, null, sqle);
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    public boolean disconnect() {
        try {
            if (this.dbconn != null) {
                if (this.startDB) {
                    System.out.println("DM_DISCONNECT_MODE=TERMINATE_DB");
                    System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
                }
                this.dbconn.close();
            }
            return true;
        }
        catch (SQLException E) {
            GuiUt.showSQLException(XTTFrame.frame, null, E);
            System.out.println("Transaction failed : " + E.getMessage());
            E.printStackTrace();
            return false;
        }
    }

    public String getDatabaseName() {
        return this.dbname;
    }

    public String getUserName() {
        return this.username;
    }

    public boolean isDBA(Connection conn) {
        Statement stmt = null;
        ResultSet rs = null;
        boolean b = true;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select DBA from SYSAUTHUSER where USER_NAME = '" + this.username + "'");
            while (rs.next()) {
                b = rs.getBoolean(1);
            }
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        catch (SQLException sqldbae) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(XTTFrame.frame, null, sqldbae);
            b = false;
        }
        return b;
    }
}

