/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.undo;

import com.syscom.xml.node.display.AbstractDisplayPanel;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class DocumentUndoEdit
extends AbstractUndoableEdit {
    private String data = null;
    private XTTTreeNodeInterface xtt = null;
    private String method = null;
    private Vector undoQueueVector = new Vector();
    private boolean inInternal = false;

    public DocumentUndoEdit(XTTTreeNodeInterface xtt2, String method, String old, boolean b) {
        this.xtt = xtt2;
        this.data = old;
        this.method = method;
        this.inInternal = b;
    }

    public DocumentUndoEdit(XTTTreeNodeInterface xtt2, String method, String old) {
        this(xtt2, method, old, false);
    }

    private String getTrueMethodName(String inStr) {
        String name = "set";
        name = name + inStr.substring(0, 1).toUpperCase() + inStr.substring(1, inStr.length());
        return name;
    }

    @Override
    public void undo() throws CannotUndoException {
        try {
            Class<?> cls = this.xtt.getClass();
            Class[] classes = new Class[]{this.data.getClass()};
            Method m = cls.getMethod(this.getTrueMethodName(this.method), classes);
            Object[] objs = new Object[]{this.data};
            m.invoke((Object)this.xtt, objs);
            if (!this.inInternal) {
                int size = this.undoQueueVector.size();
                DocumentUndoEdit edit = null;
                for (int i = size - 1; i >= 0; --i) {
                    edit = (DocumentUndoEdit)this.undoQueueVector.elementAt(i);
                    edit.undo();
                }
                this.undoQueueVector.removeAllElements();
                DefaultMutableTreeNode dmtn = this.xtt.getDefaultMutableTreeNode();
                XTTFrame.frame.setSelectedNode(dmtn);
                ((JTabbedPane)XTTFrame.frame.getBottomPanel()).setSelectedIndex(this.xtt.getTabbedIndex(this.method));
                ((AbstractDisplayPanel)((JTabbedPane)XTTFrame.frame.getBottomPanel()).getSelectedComponent()).grabComponentFocus(this.method);
                XTTFrame.frame.refreshXTT();
            }
        }
        catch (InvocationTargetException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return false;
    }

    public void addUndo(DocumentUndoEdit edit) {
        this.undoQueueVector.add(edit);
    }
}

