/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.table;

import com.syscom.table.DataTableModelRowInfo;
import com.syscom.undo.TableUndoEdit;
import com.syscom.ut.GuiUt;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.node.Template;
import com.syscom.xml.xtt.console.XTTFrame;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DataTableModel
extends AbstractTableModel
implements LocaleChangeListener {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.table.resource.Res", LocaleManager.getLocale());
    private String[] columnNames = new String[]{this.res.getString("Name"), this.res.getString("Default")};
    public Vector data = new Vector();
    private boolean isCellEditable = true;
    private Template template = null;
    private boolean isRun = false;
    private boolean first = false;

    public DataTableModel(Template template, boolean b) {
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
        this.template = template;
        this.isRun = b;
    }

    public void setTableColumnNames(String col1, String col2) {
        this.columnNames[0] = col1;
        this.columnNames[1] = col2;
    }

    public void setCellEditable(boolean b) {
        this.isCellEditable = b;
    }

    public boolean isEmptyRowInfoFirstRow() {
        DataTableModelRowInfo rowInfo = (DataTableModelRowInfo)this.data.elementAt(0);
        return rowInfo.getValueAt(0).toString().trim().length() <= 0 && rowInfo.getValueAt(1).toString().trim().length() <= 0;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    @Override
    public Object getValueAt(int row, int col) {
        DataTableModelRowInfo rowData = (DataTableModelRowInfo)this.data.elementAt(row);
        return rowData.getValueAt(col);
    }

    public Class getColumnClass(int c) {
        DataTableModelRowInfo rowData = (DataTableModelRowInfo)this.data.elementAt(0);
        return rowData.getValueAt(c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.isCellEditable) {
            return true;
        }
        return col == 1;
    }

    public void addValue(DataTableModelRowInfo newData) {
        this.data.addElement(newData);
    }

    public void addValueAt(DataTableModelRowInfo newData, int pos) {
        this.data.insertElementAt(newData, pos);
    }

    public void addEmptyRow() {
        DataTableModelRowInfo myRowInfo = new DataTableModelRowInfo("", "");
        this.addValue(myRowInfo);
    }

    private boolean isDublicateParaName(String data) {
        boolean b = false;
        int rowCount = this.getRowCount();
        String value = null;
        for (int i = 0; i < rowCount - 1; ++i) {
            value = this.getValueAt(i, 0).toString();
            if (!data.equals(value)) continue;
            b = true;
            break;
        }
        return b;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            return;
        }
        if (col == 0 && this.isDublicateParaName(value.toString())) {
            if (!this.first) {
                this.first = true;
                String s1 = this.res.getString("Template_parameter");
                String s2 = GuiUt.mapStringForProperty(s1, value.toString());
                GuiUt.showErrorDlg(XTTFrame.frame, s2, null);
            }
            this.first = false;
            return;
        }
        Object old_value = this.getValueAt(row, col);
        DataTableModelRowInfo rowData = (DataTableModelRowInfo)this.data.elementAt(row);
        rowData.setValueAt(value, col);
        TableUndoEdit edit = new TableUndoEdit(this.template, "parameterObject", old_value, this, row, col);
        XTTFrame.frame.undoSupport.postEdit(edit);
        XTTFrame.frame.menubar.setUndoEnabled(true);
        XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
        int rowNumber = 0;
        rowNumber = this.data.size();
        if (col == 0 && value.toString().length() > 0 && (rowNumber == 1 || this.getValueAt(rowNumber - 1, 0).toString().trim().length() > 0)) {
            this.addEmptyRow();
            this.fireTableChanged(new TableModelEvent(this));
            if (!this.isRun) {
                XTTFrame.setXTTModified(true);
            }
            XTTFrame.frame.refresh_XTTCombo();
        }
        this.fireTableChanged(new TableModelEvent(this));
        if (!this.isRun) {
            this.template.set_dtmDefault(this);
        }
        if (!this.isRun) {
            XTTFrame.setXTTModified(true);
        }
        XTTFrame.frame.refresh_XTTCombo();
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    public String getParameterName(int row) {
        DataTableModelRowInfo rowData = (DataTableModelRowInfo)this.data.elementAt(row);
        return rowData.getParameterName();
    }

    public String getParameterDefaultValue(int row) {
        DataTableModelRowInfo rowData = (DataTableModelRowInfo)this.data.elementAt(row);
        return rowData.getParameterDefaultValue();
    }

    public void removeSelectedRow(int row) {
        this.data.remove(row);
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = ResourceBundle.getBundle("com.syscom.table.resource.Res", LocaleManager.getLocale());
    }
}

