/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.lookandfeel;

import com.syscom.lookandfeel.DmxttUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;

public class DmxttBorders
extends MetalBorders {
    private static Border toggleButtonBorder;
    private static Border buttonBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            UIDefaults table = UIManager.getLookAndFeelDefaults();
            BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    public static class RolloverJToggleButtonBorder
    extends ToggleButtonBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (model.isRollover() && (!model.isPressed() || model.isArmed()) || model.isSelected()) {
                super.paintBorder(c, g, x, y, w, h);
            }
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        protected Color shadow;
        protected Color highlight;

        public ToggleButtonBorder() {
            UIDefaults table = UIManager.getLookAndFeelDefaults();
            this.shadow = table.getColor("controlShadow");
            this.highlight = table.getColor("controlHighlight");
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JToggleButton button = (JToggleButton)c;
            ButtonModel model = button.getModel();
            if (!c.isEnabled()) {
                DmxttUtils.drawDisabledBorder(g, x, y, w - 1, h - 1);
            } else if (model.isSelected()) {
                DmxttUtils.drawLoweredBezel(g, x, y, w, h);
            } else if (model.isPressed() && model.isArmed()) {
                DmxttUtils.drawPressed3DBorder(g, x, y, w, h);
            } else {
                DmxttUtils.drawRaisedBezel(g, x, y, w, h);
            }
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (model.isRollover() && (!model.isPressed() || model.isArmed())) {
                super.paintBorder(c, g, x, y, w, h);
            }
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JButton button = (JButton)c;
            ButtonModel model = button.getModel();
            if (!model.isEnabled()) {
                DmxttUtils.drawDisabledBorder(g, x, y, w - 1, h - 1);
            } else if (model.isPressed() && model.isArmed()) {
                DmxttUtils.drawPressed3DBorder(g, x, y, w, h);
            } else {
                DmxttUtils.drawRaisedBezel(g, x, y, w, h);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }
    }
}

