/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.importxsddtd.xsd;

import com.syscom.xml.node.Attribute;
import com.syscom.xml.node.QueryElement;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.util.Stack;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDParser {
    public static final String STD_XSD_URI = "http://www.w3.org/2001/XMLSchema";
    static Stack stack = new Stack();

    public static void getXSDAttribute(XTTTreeNodeInterface parent, Node curNode, Node rootNode) {
        NodeList list = curNode.getChildNodes();
        Node node = null;
        int size = list.getLength();
        String prefix = null;
        String localname = null;
        Attribute child = null;
        for (int i = 0; i < size; ++i) {
            Node refNode;
            String[] sa1;
            String[] sa0;
            NamedNodeMap nnm;
            Object att_tmp;
            node = list.item(i);
            if (node.getNodeType() != 1) continue;
            prefix = node.getPrefix();
            localname = node.getLocalName();
            if (prefix == null && localname == null) continue;
            if (node.getNamespaceURI().equals(STD_XSD_URI) && localname != null && localname.equals("attribute")) {
                child = new Attribute();
                att_tmp = null;
                nnm = node.getAttributes();
                sa0 = XSDParser.getNodeAttributes(node, "name");
                if (sa0 != null) {
                    child.setXSDName(sa0[1]);
                    String[] saX = XSDParser.getNodeAttributes(node, "default");
                    if (saX != null) {
                        child.setAttributeValue(saX[1]);
                    }
                    parent.addChild(child);
                    continue;
                }
                sa1 = XSDParser.getNodeAttributes(node, "ref");
                if (sa1 == null || (refNode = XSDParser.getXSDRef(node, sa1[1], rootNode)) == null) continue;
                String[] sa2 = XSDParser.getNodeAttributes(refNode, "name");
                child.setXSDName(sa2[1]);
                String[] saX = XSDParser.getNodeAttributes(node, "default");
                if (saX != null) {
                    child.setAttributeValue(saX[1]);
                }
                parent.addChild(child);
                nnm = refNode.getAttributes();
                node = refNode;
                continue;
            }
            if (!node.getNamespaceURI().equals(STD_XSD_URI) || localname == null || !localname.equals("attributeGroup")) continue;
            att_tmp = null;
            nnm = node.getAttributes();
            sa0 = XSDParser.getNodeAttributes(node, "name");
            if (sa0 != null) {
                XSDParser.getXSDAttribute(parent, node, rootNode);
                continue;
            }
            sa1 = XSDParser.getNodeAttributes(node, "ref");
            if (sa1 == null || (refNode = XSDParser.getXSDRefAttributeGroup(node, sa1[1], rootNode)) == null) continue;
            XSDParser.getXSDAttribute(parent, refNode, rootNode);
        }
    }

    public static Node getXSDType(Node e, String typeName, Node rootNode) {
        Element ele = null;
        String attValue = null;
        for (Node node = rootNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || !node.getLocalName().equals("simpleType") && !node.getLocalName().equals("complexType") || (attValue = (ele = (Element)node).getAttribute("name")) == null || attValue.length() <= 0 || !attValue.equals(typeName)) continue;
            return node;
        }
        return null;
    }

    public static void getXSDSequence(XTTTreeNodeInterface parent, Node sequenceNode, Node rootNode) {
        String localname = null;
        for (Node node = sequenceNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || (localname = node.getLocalName()) == null || localname.length() <= 0) continue;
            if (localname.equals("element")) {
                XSDParser.getXSDElement(parent, (Element)node, rootNode);
                continue;
            }
            if (localname.equals("group")) {
                XSDParser.getXSDGroup(parent, node, rootNode);
                continue;
            }
            if (localname.equals("choice")) {
                XSDParser.getXSDChoice(parent, node, rootNode);
                continue;
            }
            if (!localname.equals("sequence")) continue;
            XSDParser.getXSDSequence(parent, node, rootNode);
        }
    }

    public static void getXSDSimpleContent(XTTTreeNodeInterface parent, Node curnode, Node rootNode) {
        XSDParser.getXSDComplexContent(parent, curnode, rootNode);
    }

    public static void getXSDComplexContent(XTTTreeNodeInterface parent, Node curnode, Node rootNode) {
        XSDParser.getXSDAttribute(parent, curnode, rootNode);
        String localname = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || (localname = node.getLocalName()) == null || localname.length() <= 0) continue;
            if (localname.equals("restriction")) {
                XSDParser.getXSDRestriction(parent, node, rootNode);
                continue;
            }
            if (!localname.equals("extension")) continue;
            XSDParser.getXSDExtension(parent, node, rootNode);
        }
    }

    public static void getXSDRestriction(XTTTreeNodeInterface parent, Node curnode, Node rootNode) {
        XSDParser.getXSDAttribute(parent, curnode, rootNode);
        String localname = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || (localname = node.getLocalName()) == null || localname.length() <= 0) continue;
            if (localname.equals("all")) {
                XSDParser.getXSDAll(parent, node, rootNode);
                continue;
            }
            if (localname.equals("choice")) {
                XSDParser.getXSDChoice(parent, node, rootNode);
                continue;
            }
            if (localname.equals("sequence")) {
                XSDParser.getXSDSequence(parent, node, rootNode);
                continue;
            }
            if (!localname.equals("group")) continue;
            XSDParser.getXSDGroup(parent, node, rootNode);
        }
    }

    public static void getXSDExtension(XTTTreeNodeInterface parent, Node curnode, Node rootNode) {
        XSDParser.getXSDAttribute(parent, curnode, rootNode);
        String localname = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || (localname = node.getLocalName()) == null || localname.length() <= 0) continue;
            if (localname.equals("all")) {
                XSDParser.getXSDAll(parent, node, rootNode);
                continue;
            }
            if (localname.equals("choice")) {
                XSDParser.getXSDChoice(parent, node, rootNode);
                continue;
            }
            if (!localname.equals("sequence")) continue;
            XSDParser.getXSDSequence(parent, node, rootNode);
        }
    }

    public static void getXSDGroup(XTTTreeNodeInterface parent, Node curnode, Node rootNode) {
        String localname = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || (localname = node.getLocalName()) == null || localname.length() <= 0) continue;
            if (localname.equals("all")) {
                XSDParser.getXSDAll(parent, node, rootNode);
                continue;
            }
            if (localname.equals("choice")) {
                XSDParser.getXSDChoice(parent, node, rootNode);
                continue;
            }
            if (!localname.equals("sequence")) continue;
            XSDParser.getXSDSequence(parent, node, rootNode);
        }
    }

    public static void getXSDAll(XTTTreeNodeInterface parent, Node curnode, Node rootNode) {
        Object ele = null;
        Object attValue = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || !node.getLocalName().equals("element")) continue;
            XSDParser.getXSDElement(parent, (Element)node, rootNode);
        }
    }

    public static void getXSDChoice(XTTTreeNodeInterface parent, Node curnode, Node rootNode) {
        Element node = XSDParser.getSuitableFirstSubElement((Element)curnode);
        if (node == null) {
            return;
        }
        if (!node.getNamespaceURI().equals(STD_XSD_URI)) {
            return;
        }
        String localname = node.getLocalName();
        if (localname == null || localname.length() == 0) {
            return;
        }
        if (localname.equals("element")) {
            XSDParser.getXSDElement(parent, node, rootNode);
        } else if (localname.equals("group")) {
            XSDParser.getXSDGroup(parent, node, rootNode);
        } else if (localname.equals("choice")) {
            XSDParser.getXSDChoice(parent, node, rootNode);
        } else if (localname.equals("sequence")) {
            XSDParser.getXSDSequence(parent, node, rootNode);
        }
    }

    public static Node getXSDRefAttributeGroup(Node e, String attributeGroupName, Node rootNode) {
        Element ele = null;
        String attValue = null;
        for (Node node = rootNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || !node.getLocalName().equals("attributeGroup") || (attValue = (ele = (Element)node).getAttribute("name")) == null || attValue.length() <= 0 || !attValue.equals(attributeGroupName)) continue;
            return node;
        }
        return null;
    }

    public static Node getXSDRef(Node e, String refName, Node rootNode) {
        Element ele = null;
        String attValue = null;
        for (Node node = rootNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || !node.getLocalName().equals("element") || (attValue = (ele = (Element)node).getAttribute("name")) == null || attValue.length() <= 0 || !attValue.equals(refName)) continue;
            return node;
        }
        return null;
    }

    public static String[] getNodeAttributes(Node node, String attName) {
        String[] sa = new String[2];
        if (node.hasAttributes()) {
            NamedNodeMap nnm = node.getAttributes();
            Attr attr = (Attr)nnm.getNamedItem(attName);
            if (attr != null) {
                sa[0] = attr.getName();
                sa[1] = attr.getValue();
            } else {
                sa = null;
            }
        } else {
            sa = null;
        }
        return sa;
    }

    public static Element getSuitableFirstSubElement(Element parent) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(STD_XSD_URI) || node.getLocalName().equals("annotation")) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getFirstSubElement(Element parent) {
        NodeList list = parent.getChildNodes();
        int size = list.getLength();
        Node node = null;
        for (int i = 0; i < size; ++i) {
            node = list.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static void getXSDElement(XTTTreeNodeInterface parent, Element curelement, Node rootNode) {
        block22: {
            String type;
            Element typeElement;
            String localname;
            QueryElement child;
            block23: {
                block21: {
                    child = null;
                    localname = curelement.getLocalName();
                    String a_name = null;
                    String a_ref = null;
                    String a_type = null;
                    if (curelement.getNamespaceURI() == null || curelement.getNamespaceURI().length() == 0 || !curelement.getNamespaceURI().equals(STD_XSD_URI)) {
                        return;
                    }
                    if (localname == null || localname.length() == 0) {
                        return;
                    }
                    if (!localname.equals("element")) {
                        return;
                    }
                    child = new QueryElement();
                    a_name = curelement.getAttribute("name");
                    if (a_name == null || a_name.length() == 0) {
                        a_ref = curelement.getAttribute("ref");
                        if (a_ref == null || a_ref.length() == 0) {
                            return;
                        }
                        Node refNode = XSDParser.getXSDRef(curelement, a_ref, rootNode);
                        if (refNode == null) {
                            return;
                        }
                        a_name = ((Element)refNode).getAttribute("name");
                        curelement = (Element)refNode;
                    }
                    if (a_name == null || a_name.length() == 0) {
                        return;
                    }
                    if (stack.indexOf(a_name) >= 0) {
                        return;
                    }
                    child.setXSDLocalName(a_name);
                    parent.addChild(child);
                    stack.push(a_name);
                    a_type = curelement.getAttribute("type");
                    typeElement = null;
                    if (a_type == null || a_type.length() <= 0) break block21;
                    if (a_type.startsWith("xsd:")) break block22;
                    typeElement = (Element)XSDParser.getXSDType(curelement, a_type, rootNode);
                    break block23;
                }
                typeElement = XSDParser.getSuitableFirstSubElement(curelement);
            }
            if (typeElement != null && (type = typeElement.getLocalName()).equals("complexType")) {
                XSDParser.getXSDAttribute(child, typeElement, rootNode);
                Element e3 = XSDParser.getSuitableFirstSubElement(typeElement);
                String localname1 = e3.getLocalName();
                if (e3.getNamespaceURI().equals(STD_XSD_URI) && localname1 != null && localname.length() != 0) {
                    if (localname1.equals("simpleContent")) {
                        XSDParser.getXSDSimpleContent(child, e3, rootNode);
                    } else if (localname1.equals("complexContnet")) {
                        XSDParser.getXSDComplexContent(child, e3, rootNode);
                    } else if (localname1.equals("group")) {
                        XSDParser.getXSDGroup(child, e3, rootNode);
                    } else if (localname1.equals("all")) {
                        XSDParser.getXSDAll(child, e3, rootNode);
                    } else if (localname1.equals("choice")) {
                        XSDParser.getXSDChoice(child, e3, rootNode);
                    } else if (localname1.equals("sequence")) {
                        XSDParser.getXSDSequence(child, e3, rootNode);
                    }
                }
            }
        }
        stack.pop();
    }
}

