/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.runtime.output.OutputBase;

abstract class StreamOutput
extends OutputBase {
    protected static final String AMP = "&amp;";
    protected static final String LT = "&lt;";
    protected static final String GT = "&gt;";
    protected static final String CRLF = "&#xA;";
    protected static final String APOS = "&apos;";
    protected static final String QUOT = "&quot;";
    protected static final String NBSP = "&nbsp;";
    protected static final String CHAR_ESC_START = "&#";
    protected static final char[] INDENT = "                    ".toCharArray();
    protected static final int MAX_INDENT_LEVEL = INDENT.length >> 1;
    protected static final int MAX_INDENT = INDENT.length;
    protected static final int BUFFER_SIZE = 32768;
    protected static final int OUTPUT_BUFFER_SIZE = 4096;
    protected Writer _writer;
    protected StringBuffer _buffer;
    protected boolean _is8859Encoded = false;
    protected boolean _indent = false;
    protected boolean _omitHeader = false;
    protected String _standalone = null;
    protected String _version = "1.0";
    protected boolean _lineFeedNextStartTag = false;
    protected boolean _linefeedNextEndTag = false;
    protected boolean _indentNextEndTag = false;
    protected int _indentLevel = 0;
    protected boolean _escaping = true;
    protected String _encoding = "UTF-8";
    protected int _indentNumber = 2;
    protected Vector _attributes = new Vector();

    protected StreamOutput(StreamOutput output) {
        this._writer = output._writer;
        this._encoding = output._encoding;
        this._is8859Encoded = output._is8859Encoded;
        this._buffer = output._buffer;
        this._indentNumber = output._indentNumber;
    }

    protected StreamOutput(Writer writer, String encoding) {
        this._writer = writer;
        this._encoding = encoding;
        this._is8859Encoded = encoding.equalsIgnoreCase("iso-8859-1");
        this._buffer = new StringBuffer(32768);
    }

    protected StreamOutput(OutputStream out, String encoding) throws IOException {
        try {
            this._encoding = encoding;
            this._writer = new OutputStreamWriter(out, this._encoding);
            this._is8859Encoded = encoding.equalsIgnoreCase("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            this._encoding = "utf-8";
            this._writer = new OutputStreamWriter(out, "utf-8");
        }
        this._buffer = new StringBuffer(32768);
    }

    public void setIndentNumber(int value) {
        this._indentNumber = value;
    }

    public void setDoctype(String system, String pub) {
        this._doctypeSystem = system;
        this._doctypePublic = pub;
    }

    public void setIndent(boolean indent) {
        this._indent = indent;
    }

    public void omitHeader(boolean value) {
        this._omitHeader = value;
    }

    public void setStandalone(String standalone) {
        this._standalone = standalone;
    }

    public void setVersion(String version2) {
        this._version = version2;
    }

    protected void outputBuffer() {
        try {
            int n = 0;
            int length = this._buffer.length();
            String output = this._buffer.toString();
            if (length > 4096) {
                do {
                    this._writer.write(output, n, 4096);
                } while ((n += 4096) + 4096 < length);
            }
            this._writer.write(output, n, length - n);
            this._writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void appendDTD(String name) {
        this._buffer.append("<!DOCTYPE ").append(name);
        if (this._doctypePublic == null) {
            this._buffer.append(" SYSTEM");
        } else {
            this._buffer.append(" PUBLIC \"").append(this._doctypePublic).append("\"");
        }
        if (this._doctypeSystem != null) {
            this._buffer.append(" \"").append(this._doctypeSystem).append("\">\n");
        } else {
            this._buffer.append(">\n");
        }
    }

    protected void indent(boolean linefeed) {
        if (linefeed) {
            this._buffer.append('\n');
        }
        this._buffer.append(INDENT, 0, this._indentLevel < MAX_INDENT_LEVEL ? this._indentLevel * this._indentNumber : MAX_INDENT);
    }

    protected void escapeCharacters(char[] ch, int off, int len) {
    }

    protected void appendAttributes() {
        if (!this._attributes.isEmpty()) {
            int i = 0;
            int length = this._attributes.size();
            do {
                Attribute attr = (Attribute)this._attributes.elementAt(i);
                this._buffer.append(' ').append(attr.name).append("=\"").append(attr.value).append('\"');
            } while (++i < length);
            this._attributes.clear();
        }
    }

    protected void closeStartTag() throws TransletException {
        this.appendAttributes();
        this._buffer.append('>');
        this._startTagOpen = false;
    }

    protected void appendComment(String comment) throws TransletException {
        boolean lastIsDash = false;
        int n = comment.length();
        this._buffer.append("<!--");
        int i = 0;
        while (i < n) {
            boolean isDash;
            char ch = comment.charAt(i);
            boolean bl = isDash = ch == '-';
            if (lastIsDash && isDash) {
                this._buffer.append(" -");
            } else {
                this._buffer.append(ch);
            }
            lastIsDash = isDash;
            ++i;
        }
        if (lastIsDash) {
            this._buffer.append(' ');
        }
        this._buffer.append("-->");
    }

    static class Attribute {
        public String name;
        public String value;

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            try {
                return this.name.equalsIgnoreCase(((Attribute)obj).name);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

