/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.dom.NodeIteratorBase;

public final class ReverseIterator
extends NodeIteratorBase {
    private static final int INIT_DATA_SIZE = 16;
    private final NodeIterator _source;
    private int[] _data = null;
    private int _last = 0;
    private int _current = 0;
    private int _start = -1;

    public ReverseIterator(NodeIterator source) {
        this._source = source;
    }

    public int next() {
        return this._current > 0 ? this._data[--this._current] : 0;
    }

    public NodeIterator setStartNode(int node) {
        if (this._data == null || node != this._start) {
            this._start = node;
            this._source.setStartNode(node);
            this._data = new int[16];
            this._last = 0;
            while ((node = this._source.next()) != 0) {
                if (this._last == this._data.length) {
                    int[] newArray = new int[this._data.length * 2];
                    System.arraycopy(this._data, 0, newArray, 0, this._last);
                    this._data = newArray;
                }
                this._data[this._last++] = node;
            }
        }
        this._startNode = this._current = this._last;
        return this;
    }

    public NodeIterator reset() {
        this._current = this._startNode;
        return this;
    }

    public int getPosition() {
        return this._last - this._current;
    }

    public int getLast() {
        return this._last;
    }

    public void setMark() {
        this._source.setMark();
        this._markedNode = this._current;
    }

    public void gotoMark() {
        this._source.gotoMark();
        this._current = this._markedNode;
    }
}

