/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.AbsolutePathPattern;
import org.apache.xalan.xsltc.compiler.Constants;
import org.apache.xalan.xsltc.compiler.Param;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.Variable;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.xml.sax.Attributes;

public abstract class SyntaxTreeNode
implements Constants {
    private Parser _parser;
    protected SyntaxTreeNode _parent;
    private Stylesheet _stylesheet;
    private Template _template;
    private final Vector _contents = new Vector(2);
    protected QName _qname;
    private int _line;
    protected Attributes _attributes = null;
    private Hashtable _prefixMapping = null;
    protected static final SyntaxTreeNode Dummy = new AbsolutePathPattern(null);
    protected static final int IndentIncrement = 4;
    private static final char[] _spaces = "                                                       ".toCharArray();

    public SyntaxTreeNode() {
        this._line = 0;
        this._qname = null;
    }

    public SyntaxTreeNode(int line) {
        this._line = line;
        this._qname = null;
    }

    public SyntaxTreeNode(String uri, String prefix, String local) {
        this._line = 0;
        this.setQName(uri, prefix, local);
    }

    protected final void setLineNumber(int line) {
        this._line = line;
    }

    public final int getLineNumber() {
        return this._line;
    }

    protected void setQName(QName qname) {
        this._qname = qname;
    }

    protected void setQName(String uri, String prefix, String localname) {
        this._qname = new QName(uri, prefix, localname);
    }

    protected QName getQName() {
        return this._qname;
    }

    protected void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    protected String getAttribute(String qname) {
        if (this._attributes == null) {
            return "";
        }
        String value = this._attributes.getValue(qname);
        return value == null || value.equals("") ? "" : value;
    }

    protected boolean hasAttribute(String qname) {
        return this._attributes != null && this._attributes.getValue(qname) != null;
    }

    protected Attributes getAttributes() {
        return this._attributes;
    }

    protected void setPrefixMapping(Hashtable mapping) {
        this._prefixMapping = mapping;
    }

    protected Hashtable getPrefixMapping() {
        return this._prefixMapping;
    }

    protected void addPrefixMapping(String prefix, String uri) {
        if (this._prefixMapping == null) {
            this._prefixMapping = new Hashtable();
        }
        this._prefixMapping.put(prefix, uri);
    }

    protected String lookupNamespace(String prefix) {
        String uri = null;
        if (this._prefixMapping != null) {
            uri = (String)this._prefixMapping.get(prefix);
        }
        if (uri == null && this._parent != null) {
            uri = this._parent.lookupNamespace(prefix);
            if (prefix == "" && uri == null) {
                uri = "";
            }
        }
        return uri;
    }

    protected String lookupPrefix(String uri) {
        String prefix = null;
        if (this._prefixMapping != null && this._prefixMapping.contains(uri)) {
            Enumeration prefixes = this._prefixMapping.keys();
            while (prefixes.hasMoreElements()) {
                prefix = (String)prefixes.nextElement();
                String mapsTo = (String)this._prefixMapping.get(prefix);
                if (!mapsTo.equals(uri)) continue;
                return prefix;
            }
        } else if (this._parent != null) {
            prefix = this._parent.lookupPrefix(uri);
            if (uri == "" && prefix == null) {
                prefix = "";
            }
        }
        return prefix;
    }

    protected void setParser(Parser parser2) {
        this._parser = parser2;
    }

    public final Parser getParser() {
        return this._parser;
    }

    protected void setParent(SyntaxTreeNode parent) {
        if (this._parent == null) {
            this._parent = parent;
        }
    }

    protected final SyntaxTreeNode getParent() {
        return this._parent;
    }

    protected final boolean isDummy() {
        return this == Dummy;
    }

    protected int getImportPrecedence() {
        Stylesheet stylesheet = this.getStylesheet();
        if (stylesheet == null) {
            return Integer.MIN_VALUE;
        }
        return stylesheet.getImportPrecedence();
    }

    public Stylesheet getStylesheet() {
        if (this._stylesheet == null) {
            SyntaxTreeNode parent = this;
            while (parent != null) {
                if (parent instanceof Stylesheet) {
                    return (Stylesheet)parent;
                }
                parent = parent.getParent();
            }
            this._stylesheet = (Stylesheet)parent;
        }
        return this._stylesheet;
    }

    protected Template getTemplate() {
        if (this._template == null) {
            SyntaxTreeNode parent = this;
            while (parent != null && !(parent instanceof Template)) {
                parent = parent.getParent();
            }
            this._template = (Template)parent;
        }
        return this._template;
    }

    protected final XSLTC getXSLTC() {
        return this._parser.getXSLTC();
    }

    protected final SymbolTable getSymbolTable() {
        return this._parser == null ? null : this._parser.getSymbolTable();
    }

    public void parseContents(Parser parser2) {
        this.parseChildren(parser2);
    }

    protected final void parseChildren(Parser parser2) {
        Vector<QName> locals = null;
        int count = this._contents.size();
        int i = 0;
        while (i < count) {
            SyntaxTreeNode child = (SyntaxTreeNode)this._contents.elementAt(i);
            parser2.getSymbolTable().setCurrentNode(child);
            child.parseContents(parser2);
            QName varOrParamName = this.updateScope(parser2, child);
            if (varOrParamName != null) {
                if (locals == null) {
                    locals = new Vector<QName>(2);
                }
                locals.addElement(varOrParamName);
            }
            ++i;
        }
        parser2.getSymbolTable().setCurrentNode(this);
        if (locals != null) {
            int nLocals = locals.size();
            int i2 = 0;
            while (i2 < nLocals) {
                parser2.removeVariable((QName)locals.elementAt(i2));
                ++i2;
            }
        }
    }

    protected QName updateScope(Parser parser2, SyntaxTreeNode node) {
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            parser2.addVariable(var);
            return var.getName();
        }
        if (node instanceof Param) {
            Param param = (Param)node;
            parser2.addParameter(param);
            return param.getName();
        }
        return null;
    }

    public abstract Type typeCheck(SymbolTable var1) throws TypeCheckError;

    protected Type typeCheckContents(SymbolTable stable) throws TypeCheckError {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this._contents.elementAt(i);
            item.typeCheck(stable);
            ++i;
        }
        return Type.Void;
    }

    public abstract void translate(ClassGenerator var1, MethodGenerator var2);

    protected void translateContents(ClassGenerator classGen, MethodGenerator methodGen) {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this._contents.elementAt(i);
            item.translate(classGen, methodGen);
            ++i;
        }
        int i2 = 0;
        while (i2 < n) {
            if (this._contents.elementAt(i2) instanceof VariableBase) {
                VariableBase var = (VariableBase)this._contents.elementAt(i2);
                var.unmapRegister(methodGen);
            }
            ++i2;
        }
    }

    protected void compileResultTree(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        Stylesheet stylesheet = classGen.getStylesheet();
        il.append(methodGen.loadHandler());
        String DOM_CLASS = classGen.getDOMClass();
        int index = cpg.addMethodref("org.apache.xalan.xsltc.dom.DOMImpl", "<init>", "(I)V");
        il.append(new NEW(cpg.addClass("org.apache.xalan.xsltc.dom.DOMImpl")));
        il.append(InstructionConstants.DUP);
        il.append(InstructionConstants.DUP);
        il.append(new PUSH(cpg, 64));
        il.append(new INVOKESPECIAL(index));
        index = cpg.addMethodref("org.apache.xalan.xsltc.dom.DOMImpl", "getOutputDomBuilder", "()Lorg/apache/xalan/xsltc/TransletOutputHandler;");
        il.append(new INVOKEVIRTUAL(index));
        il.append(InstructionConstants.DUP);
        il.append(methodGen.storeHandler());
        il.append(methodGen.startDocument());
        this.translateContents(classGen, methodGen);
        il.append(methodGen.loadHandler());
        il.append(methodGen.endDocument());
        if (!DOM_CLASS.equals("org/apache/xalan/xsltc/dom/DOMImpl")) {
            index = cpg.addMethodref("org/apache/xalan/xsltc/dom/DOMAdapter", "<init>", "(Lorg/apache/xalan/xsltc/dom/DOMImpl;[Ljava/lang/String;[Ljava/lang/String;)V");
            il.append(new NEW(cpg.addClass("org/apache/xalan/xsltc/dom/DOMAdapter")));
            il.append(new DUP_X1());
            il.append(InstructionConstants.SWAP);
            if (!stylesheet.callsNodeset()) {
                il.append(new ICONST(0));
                il.append(new ANEWARRAY(cpg.addClass("java.lang.String")));
                il.append(InstructionConstants.DUP);
                il.append(new INVOKESPECIAL(index));
            } else {
                il.append(InstructionConstants.ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namesArray", "[Ljava/lang/String;")));
                il.append(InstructionConstants.ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namespaceArray", "[Ljava/lang/String;")));
                il.append(new INVOKESPECIAL(index));
                il.append(InstructionConstants.DUP);
                il.append(methodGen.loadDOM());
                il.append(new CHECKCAST(cpg.addClass(classGen.getDOMClass())));
                il.append(InstructionConstants.SWAP);
                index = cpg.addMethodref("org.apache.xalan.xsltc.dom.MultiDOM", "addDOMAdapter", "(Lorg/apache/xalan/xsltc/dom/DOMAdapter;)I");
                il.append(new INVOKEVIRTUAL(index));
                il.append(InstructionConstants.POP);
            }
        }
        il.append(InstructionConstants.SWAP);
        il.append(methodGen.storeHandler());
    }

    protected boolean contextDependent() {
        return true;
    }

    protected boolean dependentContents() {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this._contents.elementAt(i);
            if (item.contextDependent()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final void addElement(SyntaxTreeNode element) {
        this._contents.addElement(element);
        element.setParent(this);
    }

    protected final void setFirstElement(SyntaxTreeNode element) {
        this._contents.insertElementAt(element, 0);
        element.setParent(this);
    }

    protected final void removeElement(SyntaxTreeNode element) {
        this._contents.remove(element);
        element.setParent(null);
    }

    protected final Vector getContents() {
        return this._contents;
    }

    protected final boolean hasContents() {
        return this.elementCount() > 0;
    }

    protected final int elementCount() {
        return this._contents.size();
    }

    protected final Enumeration elements() {
        return this._contents.elements();
    }

    protected final Object elementAt(int pos) {
        return this._contents.elementAt(pos);
    }

    protected final SyntaxTreeNode lastChild() {
        if (this._contents.size() == 0) {
            return null;
        }
        return (SyntaxTreeNode)this._contents.lastElement();
    }

    public void display(int indent) {
        this.displayContents(indent);
    }

    protected void displayContents(int indent) {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this._contents.elementAt(i);
            item.display(indent);
            ++i;
        }
    }

    protected final void indent(int indent) {
        System.out.print(new String(_spaces, 0, indent));
    }

    protected void reportError(SyntaxTreeNode element, Parser parser2, int errorCode, String message) {
        ErrorMsg error = new ErrorMsg(errorCode, (Object)message, element);
        parser2.reportError(3, error);
    }

    protected void reportWarning(SyntaxTreeNode element, Parser parser2, int errorCode, String message) {
        ErrorMsg error = new ErrorMsg(errorCode, (Object)message, element);
        parser2.reportError(4, error);
    }
}

