/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.jdbc.ws.client;

import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.ResourceBundle;

public class ClientBasic {
    protected String SERVICE_CLASSNAME = this.getClass().getSimpleName();
    public static final int ERROR_CONNECTION = -101;
    public static final int ERROR_STATEMENT = -201;
    public static final int ERROR_RESULTSET = -301;
    public static final short SQL_NEED_DATA = 99;
    public static int ERR_SQL_SYS = 5000;
    public static int ERR_DATA_CVT_OVERFLOW = ERR_SQL_SYS + 2;
    public static HashMap<Integer, Error> ERRORS = new HashMap<Integer, Error>(){
        {
            this.put(ERR_DATA_CVT_OVERFLOW, new Error(ERR_DATA_CVT_OVERFLOW, "ERR_DATA_CVT_OVERFLOW", "data conversion overflow", "HY019"));
        }
    };
    private static ResourceBundle rb = null;

    protected static void trace(String string) {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            String string2 = "[DBMaker]" + string;
            printWriter.write(string2);
        }
    }

    protected static SQLException JDBCErrorNotSupport(String string) {
        return ClientBasic.JDBCError("JERR_UNSUPPORT_OPERATION", string, null);
    }

    protected static SQLException JDBCErrorNotSupport(String string, String string2) {
        return ClientBasic.JDBCError("JERR_UNSUPPORT_OPERATION", string + "." + string2, null);
    }

    protected static SQLException JDBCError(String string, String string2, int n) {
        ClientBasic.trace("ServiceClient.JDBCError(String, String, int) (" + n + ")");
        String string3 = null;
        switch (n) {
            case -301: 
            case -201: 
            case -101: {
                string3 = string + "." + string2 + " failed";
                return new SQLException(string3);
            }
        }
        string3 = string + "." + string2 + " method return " + n;
        return new SQLException(string3, Integer.toString(n));
    }

    protected static ResourceBundle getResourceBundle() {
        if (rb == null) {
            try {
                rb = ResourceBundle.getBundle("dbmaker.jdbc.ws.client.dmJdbc");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rb;
    }

    protected static SQLException JDBCError(String string, String string2, SQLException sQLException) {
        ClientBasic.trace("ServiceClient.JDBCError(int, String, SQLException) (" + string + ")");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (sQLException != null) {
            string5 = sQLException.getSQLState();
            string3 = " (" + sQLException.getErrorCode() + ", " + sQLException.getMessage() + ")";
        }
        string4 = ClientBasic.getResourceBundle().getString(string);
        if (string2 != null) {
            string4 = string4 + " " + string2;
        }
        if (string3 != null) {
            string4 = string4 + string3;
        }
        return new SQLException(string4, string5);
    }

    protected static void JDBCError(String string, String string2) throws SQLException {
        ClientBasic.trace("ServiceClient.JDBCError(int, String) (" + string + ")");
        String string3 = null;
        string3 = ClientBasic.getResourceBundle().getString(string);
        if (string2 != null) {
            string3 = string3 + string2;
        }
        throw new SQLException(string3);
    }

    public static void JDBCError(int n) throws SQLException {
        Error error = ERRORS.get(n);
        throw new SQLException(error.message, error.sqlstate, error.code);
    }

    static class Error {
        int code = 0;
        String symbol = null;
        String message = null;
        String sqlstate = null;

        Error(int n, String string, String string2, String string3) {
            this.code = n;
            this.symbol = string;
            this.message = string2;
            this.sqlstate = string3;
        }
    }
}

