/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class RasterProxy
implements Serializable {
    private transient Raster raster;

    public RasterProxy(Raster raster) {
        this.raster = raster;
    }

    public Raster getRaster() {
        return this.raster;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Raster raster = this.raster.getParent();
        if (raster != null) {
            raster = raster.createCompatibleWritableRaster(this.raster.getBounds());
            ((WritableRaster)raster).setRect(this.raster);
        } else {
            raster = this.raster;
        }
        objectOutputStream.writeInt(raster.getWidth());
        objectOutputStream.writeInt(raster.getHeight());
        objectOutputStream.writeObject(SerializerFactory.getState(raster.getSampleModel(), null));
        objectOutputStream.writeObject(SerializerFactory.getState(raster.getDataBuffer(), null));
        objectOutputStream.writeObject(new Point(raster.getMinX(), raster.getMinY()));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SerializableState serializableState = null;
        SerializableState serializableState2 = null;
        Point point = null;
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        serializableState = (SerializableState)objectInputStream.readObject();
        serializableState2 = (SerializableState)objectInputStream.readObject();
        point = (Point)objectInputStream.readObject();
        SampleModel sampleModel = (SampleModel)serializableState.getObject();
        if (sampleModel == null) {
            this.raster = null;
            return;
        }
        DataBuffer dataBuffer = (DataBuffer)serializableState2.getObject();
        this.raster = Raster.createRaster(sampleModel, dataBuffer, point);
    }
}

