/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;
import javax.media.jai.UnpackedImageData;

final class ExtremaOpImage
extends StatisticsOpImage {
    private double[][] extrema = null;
    private PixelAccessor srcPA;
    private int srcSampleType;

    private final boolean tileIntersectsROI(int n, int n2) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
    }

    public ExtremaOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4) {
        super(renderedImage, rOI, n, n2, n3, n4);
        this.srcPA = new PixelAccessor(renderedImage);
        this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
    }

    public Object getProperty(String string) {
        if (this.extrema == null) {
            return super.getProperty(string);
        }
        if (string.equalsIgnoreCase("extrema")) {
            double[][] dArray = new double[2][this.srcPA.numBands];
            int n = 0;
            while (n < this.srcPA.numBands) {
                dArray[0][n] = this.extrema[0][n];
                dArray[1][n] = this.extrema[1][n];
                ++n;
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("minimum")) {
            double[] dArray = new double[this.srcPA.numBands];
            int n = 0;
            while (n < this.srcPA.numBands) {
                dArray[n] = this.extrema[0][n];
                ++n;
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("maximum")) {
            double[] dArray = new double[this.srcPA.numBands];
            int n = 0;
            while (n < this.srcPA.numBands) {
                dArray[n] = this.extrema[1][n];
                ++n;
            }
            return dArray;
        }
        return Image.UndefinedProperty;
    }

    protected String[] getStatisticsNames() {
        return new String[]{"extrema", "maximum", "minimum"};
    }

    protected Object createStatistics(String string) {
        Object object = null;
        object = string.equalsIgnoreCase("extrema") ? new double[2][this.srcPA.numBands] : (string.equalsIgnoreCase("minimum") || string.equalsIgnoreCase("maximum") ? (Object)new double[this.srcPA.numBands] : (Object)Image.UndefinedProperty);
        return object;
    }

    private final int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        return n4 == 0 ? n : n + (n3 - n4);
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        block18: {
            int n;
            Object object2;
            block19: {
                block17: {
                    LinkedList linkedList;
                    Rectangle rectangle = this.getSourceImage(0).getBounds().intersection(raster.getBounds());
                    if (this.roi == null) {
                        linkedList = new LinkedList();
                        linkedList.addLast(rectangle);
                    } else {
                        linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        if (linkedList == null) {
                            return;
                        }
                    }
                    ListIterator listIterator = linkedList.listIterator(0);
                    while (listIterator.hasNext()) {
                        object2 = rectangle.intersection((Rectangle)listIterator.next());
                        n = ((Rectangle)object2).x;
                        int n2 = ((Rectangle)object2).y;
                        ((Rectangle)object2).x = this.startPosition(n, this.xStart, this.xPeriod);
                        ((Rectangle)object2).y = this.startPosition(n2, this.yStart, this.yPeriod);
                        ((Rectangle)object2).width = n + ((Rectangle)object2).width - ((Rectangle)object2).x;
                        ((Rectangle)object2).height = n2 + ((Rectangle)object2).height - ((Rectangle)object2).y;
                        if (((Rectangle)object2).isEmpty()) continue;
                        if (this.extrema == null) {
                            this.extrema = new double[2][this.srcPA.numBands];
                            raster.getPixel(((Rectangle)object2).x, ((Rectangle)object2).y, this.extrema[0]);
                            int n3 = 0;
                            while (n3 < this.srcPA.numBands) {
                                this.extrema[1][n3] = this.extrema[0][n3];
                                ++n3;
                            }
                        }
                        UnpackedImageData unpackedImageData = this.srcPA.getPixels(raster, (Rectangle)object2, this.srcSampleType, false);
                        switch (unpackedImageData.type) {
                            case 0: {
                                this.accumulateStatisticsByte(unpackedImageData);
                                break;
                            }
                            case 1: {
                                this.accumulateStatisticsUShort(unpackedImageData);
                                break;
                            }
                            case 2: {
                                this.accumulateStatisticsShort(unpackedImageData);
                                break;
                            }
                            case 3: {
                                this.accumulateStatisticsInt(unpackedImageData);
                                break;
                            }
                            case 4: {
                                this.accumulateStatisticsFloat(unpackedImageData);
                                break;
                            }
                            case 5: {
                                this.accumulateStatisticsDouble(unpackedImageData);
                            }
                        }
                    }
                    if (!string.equalsIgnoreCase("extrema")) break block17;
                    object2 = (double[][])object;
                    n = 0;
                    while (n < this.srcPA.numBands) {
                        object2[0][n] = this.extrema[0][n];
                        object2[1][n] = this.extrema[1][n];
                        ++n;
                    }
                    break block18;
                }
                if (!string.equalsIgnoreCase("minimum")) break block19;
                object2 = (double[])object;
                n = 0;
                while (n < this.srcPA.numBands) {
                    object2[n] = this.extrema[0][n];
                    ++n;
                }
                break block18;
            }
            if (!string.equalsIgnoreCase("maximum")) break block18;
            object2 = (double[])object;
            n = 0;
            while (n < this.srcPA.numBands) {
                object2[n] = this.extrema[1][n];
                ++n;
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            int n6 = (int)this.extrema[0][n5];
            int n7 = (int)this.extrema[1][n5];
            byte[] byArray2 = byArray[n5];
            int n8 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
            int n9 = unpackedImageData.bandOffsets[n5];
            while (n9 < n8) {
                int n10 = n9 + rectangle.width * n2;
                int n11 = n9;
                while (n11 < n10) {
                    int n12 = byArray2[n11] & 0xFF;
                    if (n12 < n6) {
                        n6 = n12;
                    } else if (n12 > n7) {
                        n7 = n12;
                    }
                    n11 += n4;
                }
                n9 += n3;
            }
            this.extrema[0][n5] = n6;
            this.extrema[1][n5] = n7;
            ++n5;
        }
    }

    private void accumulateStatisticsUShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            int n6 = (int)this.extrema[0][n5];
            int n7 = (int)this.extrema[1][n5];
            short[] sArray2 = sArray[n5];
            int n8 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
            int n9 = unpackedImageData.bandOffsets[n5];
            while (n9 < n8) {
                int n10 = n9 + rectangle.width * n2;
                int n11 = n9;
                while (n11 < n10) {
                    int n12 = sArray2[n11] & 0xFFFF;
                    if (n12 < n6) {
                        n6 = n12;
                    } else if (n12 > n7) {
                        n7 = n12;
                    }
                    n11 += n4;
                }
                n9 += n3;
            }
            this.extrema[0][n5] = n6;
            this.extrema[1][n5] = n7;
            ++n5;
        }
    }

    private void accumulateStatisticsShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            int n6 = (int)this.extrema[0][n5];
            int n7 = (int)this.extrema[1][n5];
            short[] sArray2 = sArray[n5];
            int n8 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
            int n9 = unpackedImageData.bandOffsets[n5];
            while (n9 < n8) {
                int n10 = n9 + rectangle.width * n2;
                int n11 = n9;
                while (n11 < n10) {
                    int n12 = sArray2[n11];
                    if (n12 < n6) {
                        n6 = n12;
                    } else if (n12 > n7) {
                        n7 = n12;
                    }
                    n11 += n4;
                }
                n9 += n3;
            }
            this.extrema[0][n5] = n6;
            this.extrema[1][n5] = n7;
            ++n5;
        }
    }

    private void accumulateStatisticsInt(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        int[][] nArray = unpackedImageData.getIntData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            int n6 = (int)this.extrema[0][n5];
            int n7 = (int)this.extrema[1][n5];
            int[] nArray2 = nArray[n5];
            int n8 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
            int n9 = unpackedImageData.bandOffsets[n5];
            while (n9 < n8) {
                int n10 = n9 + rectangle.width * n2;
                int n11 = n9;
                while (n11 < n10) {
                    int n12 = nArray2[n11];
                    if (n12 < n6) {
                        n6 = n12;
                    } else if (n12 > n7) {
                        n7 = n12;
                    }
                    n11 += n4;
                }
                n9 += n3;
            }
            this.extrema[0][n5] = n6;
            this.extrema[1][n5] = n7;
            ++n5;
        }
    }

    private void accumulateStatisticsFloat(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        float[][] fArray = unpackedImageData.getFloatData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            float f = (float)this.extrema[0][n5];
            float f2 = (float)this.extrema[1][n5];
            float[] fArray2 = fArray[n5];
            int n6 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
            int n7 = unpackedImageData.bandOffsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    float f3 = fArray2[n9];
                    if (f3 < f) {
                        f = f3;
                    } else if (f3 > f2) {
                        f2 = f3;
                    }
                    n9 += n4;
                }
                n7 += n3;
            }
            this.extrema[0][n5] = f;
            this.extrema[1][n5] = f2;
            ++n5;
        }
    }

    private void accumulateStatisticsDouble(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        double[][] dArray = unpackedImageData.getDoubleData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            double d = this.extrema[0][n5];
            double d2 = this.extrema[1][n5];
            double[] dArray2 = dArray[n5];
            int n6 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
            int n7 = unpackedImageData.bandOffsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    double d3 = dArray2[n9];
                    if (d3 < d) {
                        d = d3;
                    } else if (d3 > d2) {
                        d2 = d3;
                    }
                    n9 += n4;
                }
                n7 += n3;
            }
            this.extrema[0][n5] = d;
            this.extrema[1][n5] = d2;
            ++n5;
        }
    }
}

