/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibMinFilterOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.operator.MinFilterDescriptor;
import javax.media.jai.operator.MinFilterShape;

public class MlibMinFilterRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        MinFilterShape minFilterShape = (MinFilterShape)parameterBlock.getObjectParameter(0);
        int n = parameterBlock.getIntParameter(1);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (minFilterShape == MinFilterDescriptor.MIN_MASK_SQUARE && (n == 3 || n == 5 || n == 7) && renderedImage.getSampleModel().getNumBands() == 1) {
            return new MlibMinFilterOpImage(renderedImage, borderExtender, renderingHints, imageLayout, minFilterShape, n);
        }
        return null;
    }
}

