/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibBinarizeOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.ImageLayout;

public class MlibBinarizeRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        boolean bl;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel.getNumBands() > 1) {
            return null;
        }
        double d = parameterBlock.getDoubleParameter(0);
        boolean bl2 = bl = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3);
        if (bl) {
            return null;
        }
        if ((d > 255.0 || d <= 0.0) && sampleModel.getDataType() == 0 || (d > 32767.0 || d <= 0.0) && sampleModel.getDataType() == 2 || (d > 2.147483647E9 || d <= 0.0) && sampleModel.getDataType() == 3) {
            return null;
        }
        return new MlibBinarizeOpImage(renderedImage, imageLayout, (Map)renderingHints, d);
    }
}

