/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.locale;

import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.resource.DBAResourceBundle;
import java.util.Locale;
import java.util.Vector;
import javax.swing.UIManager;
import startup.ToolInfo;

public class LocaleManager
implements LocaleChangeListener {
    private static LocaleManager localeManager = null;
    private static Locale locale = null;
    private Vector listenerList = new Vector();
    public static final short ENGLISH = 0;
    public static final short CHINESE = 1;
    public static final short JAPANESE = 2;
    public static final short CHINA = 3;
    public static boolean isDBMaker = true;
    public static boolean[] language_enable = new boolean[]{true, true, true, true};
    private static short default_System_Language = 0;
    private static final Locale[] locales = new Locale[]{Locale.US, Locale.TAIWAN, Locale.JAPAN, Locale.CHINA};
    private static final String WIN_ID = "Windows";

    public LocaleManager(short s) {
        if (s < 0 || s >= locales.length) {
            s = 0;
        }
        locale = locales[s];
        LocaleManager.setDefaultSystemLanguage(ToolInfo.getDefaultLanguage());
        LocaleManager.setIsDBMaker(ToolInfo.getDBMaker());
        LocaleManager.setLanguageEnableArray(ToolInfo.getLanguageEnable());
    }

    public static short getDefaultSystemLanguage() {
        LocaleManager.setDefaultSystemLanguage(ToolInfo.getDefaultLanguage());
        if (LocaleManager.isWindowsPlatform()) {
            return default_System_Language;
        }
        return 0;
    }

    public static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(WIN_ID);
    }

    public static void setDefaultSystemLanguage(short s) {
        default_System_Language = s;
    }

    public static boolean getIsDBMaker() {
        LocaleManager.setIsDBMaker(ToolInfo.getDBMaker());
        return isDBMaker;
    }

    public static void setIsDBMaker(boolean bl) {
        isDBMaker = bl;
    }

    public static void setLanguageEnableArray(boolean[] blArray) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            LocaleManager.language_enable[i] = blArray[i];
        }
    }

    public static short getHelpFileLanguage() {
        LocaleManager.setDefaultSystemLanguage(ToolInfo.getDefaultLanguage());
        return default_System_Language;
    }

    public static Locale getLocale(short s) {
        if (s < 0 || s >= locales.length) {
            return null;
        }
        return locales[s];
    }

    public static Locale getLocale() {
        if (localeManager == null) {
            localeManager = new LocaleManager(LocaleManager.getDefaultSystemLanguage());
        }
        return locale;
    }

    public static LocaleManager getLocaleManager() {
        if (localeManager == null) {
            localeManager = new LocaleManager(LocaleManager.getDefaultSystemLanguage());
        }
        return localeManager;
    }

    public static LocaleManager getLocaleManager(short s) {
        if (localeManager == null) {
            localeManager = new LocaleManager(s);
        }
        return localeManager;
    }

    public synchronized void addLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        this.listenerList.addElement(localeChangeListener);
    }

    public synchronized void removeLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        this.listenerList.removeElement(localeChangeListener);
    }

    public Vector getLocaleChangedListener() {
        Vector vector = (Vector)this.listenerList.clone();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localeChanged(LocaleChangeEvent localeChangeEvent) {
        Vector vector;
        locale = localeChangeEvent.getLocale();
        DBAResourceBundle dBAResourceBundle = new DBAResourceBundle("utproperties.Res", LocaleManager.getLocale());
        Locale.setDefault(locale);
        UIManager.put("FileChooser.lookInLabelText", dBAResourceBundle.getString("Look_in"));
        UIManager.put("FileChooser.fileNameLabelText", dBAResourceBundle.getString("File_name"));
        UIManager.put("FileChooser.filesOfTypeLabelText", dBAResourceBundle.getString("File_of_types"));
        UIManager.put("FileChooser.upFolderToolTipText", dBAResourceBundle.getString("upFolderToolTipText"));
        UIManager.put("FileChooser.homeFolderToolTipText", dBAResourceBundle.getString("homeFolderToolTipText"));
        UIManager.put("FileChooser.newFolderToolTipText", dBAResourceBundle.getString("newFolderToolTipText"));
        UIManager.put("FileChooser.listViewButtonToolTipText", dBAResourceBundle.getString("listViewButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", dBAResourceBundle.getString("detailsViewButtonToolTipText"));
        UIManager.put("FileChooser.acceptAllFileFilterText", dBAResourceBundle.getString("acceptAllFileFilterText"));
        UIManager.put("FileChooser.saveButtonText", dBAResourceBundle.getString("saveButtonText"));
        UIManager.put("FileChooser.openButtonText", dBAResourceBundle.getString("openButtonText"));
        UIManager.put("FileChooser.saveDialogTitleText", dBAResourceBundle.getString("saveDialogTitleText"));
        UIManager.put("FileChooser.openDialogTitleText", dBAResourceBundle.getString("openDialogTitleText"));
        UIManager.put("FileChooser.cancelButtonText", dBAResourceBundle.getString("cancelButtonText"));
        UIManager.put("FileChooser.saveButtonToolTipText", dBAResourceBundle.getString("saveButtonToolTipText"));
        UIManager.put("FileChooser.openButtonToolTipText", dBAResourceBundle.getString("openButtonToolTipText"));
        UIManager.put("FileChooser.cancelButtonToolTipText", dBAResourceBundle.getString("cancelButtonToolTipText"));
        LocaleManager localeManager = this;
        synchronized (localeManager) {
            vector = (Vector)this.listenerList.clone();
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((LocaleChangeListener)vector.elementAt(i)).localeChanged(localeChangeEvent);
        }
    }

    public void resetLocale(short s) {
        if (s >= 0 && s < locales.length) {
            locale = locales[s];
        }
    }

    public static String getLanguage() {
        Locale locale = LocaleManager.getLocale();
        if (locale.equals(Locale.US)) {
            return new String("english");
        }
        if (locale.equals(Locale.TAIWAN)) {
            return new String("chinese");
        }
        if (locale.equals(Locale.JAPAN)) {
            return new String("japanese");
        }
        if (locale.equals(Locale.CHINA)) {
            return new String("china");
        }
        return new String("english");
    }

    public static short getLanguageChoice() {
        Locale locale = LocaleManager.getLocale();
        if (locale.equals(Locale.TAIWAN)) {
            return 1;
        }
        if (locale.equals(Locale.US)) {
            return 0;
        }
        if (locale.equals(Locale.JAPAN)) {
            return 2;
        }
        if (locale.equals(Locale.CHINA)) {
            return 3;
        }
        return 0;
    }

    public static String getErrlcode() {
        Locale locale = LocaleManager.getLocale();
        if (locale == Locale.TAIWAN) {
            return "zh_TW";
        }
        if (locale == Locale.CHINA) {
            return "zh_CN";
        }
        if (locale == Locale.JAPAN) {
            return "ja";
        }
        return "en";
    }
}

