/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class IniFile {
    protected Vector lines;
    protected Vector subjects;
    protected Vector variables;
    protected Vector values;
    protected String fileName;
    protected boolean saveOnChange = false;

    public IniFile(String string) {
        this(string, false);
    }

    public IniFile(String string, boolean bl) {
        this.saveOnChange = bl;
        this.fileName = string;
        if (!new File(string).exists() && !this.createFile()) {
            return;
        }
        this.loadFile();
        this.parseLines();
    }

    public Vector getLines(String string) {
        Vector vector = (Vector)this.lines.clone();
        int n = this.findSubjectLine(string);
        int n2 = this.endOfSubject(n) - 1;
        int n3 = n2 + 1;
        while (n3 < vector.size()) {
            vector.removeElementAt(n3);
        }
        for (n3 = 0; n3 < n; ++n3) {
            vector.removeElementAt(0);
        }
        return vector;
    }

    public void addLines(Vector vector) {
        this.lines.addAll(vector);
        if (this.saveOnChange) {
            this.saveFile();
        }
    }

    public void loadFile() {
        this.lines = new Vector();
        this.subjects = new Vector();
        this.variables = new Vector();
        this.values = new Vector();
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName)));
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.read(byArray);
            String string = new String(byArray);
            while (true) {
                int n;
                if ((n = string.indexOf(10)) < 0) {
                    if (string.length() <= 0) break;
                    if (this.isaSubject(string = string.trim())) {
                        this.lines.addElement(string.toUpperCase().trim());
                        break;
                    }
                    this.lines.addElement(string.trim());
                    break;
                }
                if (n < 2) {
                    string = string.substring(n + 1);
                    continue;
                }
                String string2 = string.substring(0, n);
                string = string.substring(n + 1);
                if (string2.length() == 0) break;
                if (this.isaSubject(string2 = string2.trim())) {
                    this.lines.addElement(string2.toUpperCase().trim());
                    continue;
                }
                this.lines.addElement(string2.trim());
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IniFile load failed: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    protected boolean createFile() {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.fileName));
            dataOutputStream.writeBytes(";INI File: " + this.fileName + System.getProperty("line.separator"));
            dataOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            System.out.println("IniFile create failed: " + iOException.getMessage());
            iOException.printStackTrace();
            return false;
        }
    }

    public void parseLines() {
        String string = null;
        String string2 = null;
        boolean bl = false;
        for (int i = 0; i < this.lines.size(); ++i) {
            string = (String)this.lines.elementAt(i);
            if (this.isaSubject(string)) {
                string2 = string.substring(1, string.length() - 1);
                if (this.subjects.contains(string2)) {
                    bl = true;
                    continue;
                }
                bl = false;
                this.subjects.addElement(string2);
                this.variables.addElement(new Vector());
                this.values.addElement(new Vector());
                continue;
            }
            if (!this.isanAssignment(string) || bl) continue;
            String string3 = string;
            this.addAssignment(string2, string3);
        }
    }

    public boolean addAssignment(String string, String string2) {
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n).trim();
        String string4 = new String(string2.substring(n + 1, string2.length()).trim());
        int n2 = string4.indexOf(32);
        while (n2 == 0) {
            string4 = new String(string4.substring(n2 + 1, string4.length()).trim());
            n2 = string4.indexOf(32);
        }
        if (string4.length() == 0 || string3.length() == 0) {
            return false;
        }
        return this.addValue(string, string3.trim(), string4, false);
    }

    public boolean setValue(String string, String string2, String string3) {
        boolean bl = this.addValue(string, string2, string3, true);
        if (this.saveOnChange) {
            this.saveFile();
        }
        return bl;
    }

    protected boolean addValue(String string, String string2, String string3, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (!this.subjects.contains(string)) {
            this.subjects.addElement(string);
            this.variables.addElement(new Vector());
            this.values.addElement(new Vector());
        }
        int n = this.subjects.indexOf(string);
        Vector vector = (Vector)this.variables.elementAt(n);
        Vector vector2 = (Vector)this.values.elementAt(n);
        if (!vector.contains(string2)) {
            vector.addElement(string2);
            vector2.addElement(string3);
            int n2 = vector.indexOf(string2);
            vector2.setElementAt(string3, n2);
        }
        if (bl) {
            this.setLine(string, string2, string3);
        }
        return true;
    }

    protected boolean isaSubject(String string) {
        return string.startsWith("[") && string.endsWith("]");
    }

    protected void setLine(String string, String string2, String string3) {
        int n;
        int n2;
        int n3 = this.findSubjectLine(string);
        if (n3 == -1) {
            this.addSubjectLine(string);
            n3 = this.lines.size() - 1;
        }
        if ((n2 = this.findAssignmentBetween(string2, n3, n = this.endOfSubject(n3))) == -1) {
            this.lines.insertElementAt(string2 + "=" + string3, n);
        } else {
            this.lines.setElementAt(string2 + "=" + string3, n2);
        }
    }

    public int findAssignmentLine(String string, String string2) {
        int n = this.findSubjectLine(string);
        int n2 = this.endOfSubject(n);
        return this.findAssignmentBetween(string2, n, n2);
    }

    protected int findAssignmentBetween(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!((String)this.lines.elementAt(i)).startsWith(string + "=")) continue;
            return i;
        }
        return -1;
    }

    public void addSubjectLine(String string) {
        this.lines.addElement("[" + string + "]");
    }

    public int findSubjectLine(String string) {
        String string2 = "[" + string + "]";
        for (int i = 0; i < this.lines.size(); ++i) {
            String string3 = (String)this.lines.elementAt(i);
            if (!string2.equalsIgnoreCase(string3)) continue;
            return i;
        }
        return -1;
    }

    protected int endOfSubject(int n) {
        int n2 = n + 1;
        if (n >= this.lines.size()) {
            return this.lines.size();
        }
        for (int i = n + 1; i < this.lines.size(); ++i) {
            if (this.isanAssignment((String)this.lines.elementAt(i))) {
                n2 = i + 1;
            }
            if (!this.isaSubject((String)this.lines.elementAt(i))) continue;
            return n2;
        }
        return n2;
    }

    protected boolean isanAssignment(String string) {
        return string.indexOf("=") != -1 && !string.startsWith(";") && !string.startsWith("/");
    }

    public Vector getLines() {
        return (Vector)this.lines.clone();
    }

    public String[] getVariables(String string) {
        int n = 0;
        for (n = 0; n < this.subjects.size(); ++n) {
            String string2 = (String)this.subjects.elementAt(n);
            if (!string2.equalsIgnoreCase(string)) continue;
            Vector vector = (Vector)this.variables.elementAt(n);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public String[] getValues(String string) {
        int n = 0;
        for (n = 0; n < this.subjects.size(); ++n) {
            String string2 = (String)this.subjects.elementAt(n);
            if (!string2.equalsIgnoreCase(string)) continue;
            Vector vector = (Vector)this.values.elementAt(n);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public String[] getSubjects() {
        Object[] objectArray = new String[this.subjects.size()];
        this.subjects.copyInto(objectArray);
        return objectArray;
    }

    public String getValue(String string, String string2) {
        int n = 0;
        for (n = 0; n < this.subjects.size() && !string.equalsIgnoreCase((String)this.subjects.elementAt(n)); ++n) {
        }
        if (n == this.subjects.size()) {
            return "";
        }
        Vector vector = (Vector)this.values.elementAt(n);
        Vector vector2 = (Vector)this.variables.elementAt(n);
        int n2 = vector2.indexOf(string2);
        if (n2 != -1) {
            return (String)vector.elementAt(n2);
        }
        return "";
    }

    public void deleteValue(String string, String string2) {
        int n = this.subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        Vector vector = (Vector)this.values.elementAt(n);
        Vector vector2 = (Vector)this.variables.elementAt(n);
        int n2 = vector2.indexOf(string2);
        if (n2 != -1) {
            vector.removeElementAt(n2);
            vector2.removeElementAt(n2);
            int n3 = this.findAssignmentLine(string, string2);
            if (n3 != -1) {
                this.lines.removeElementAt(n3);
            }
            if (vector2.size() == 0) {
                this.deleteSubject(string);
            }
            if (this.saveOnChange) {
                this.saveFile();
            }
        }
    }

    public int renameSubject(String string, String string2) {
        int n = this.subjects.indexOf(string);
        if (n == -1) {
            return -1;
        }
        this.subjects.setElementAt(string2, n);
        int n2 = this.findSubjectLine(string);
        this.lines.setElementAt("[" + string2 + "]", n2);
        if (this.saveOnChange) {
            this.saveFile();
        }
        return 0;
    }

    public void deleteSubject(String string) {
        int n = this.subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        this.values.removeElementAt(n);
        this.variables.removeElementAt(n);
        this.subjects.removeElementAt(n);
        int n2 = this.findSubjectLine(string);
        int n3 = this.endOfSubject(n2);
        for (int i = n2; i < n3; ++i) {
            this.lines.removeElementAt(n2);
        }
        if (this.saveOnChange) {
            this.saveFile();
        }
    }

    public void saveFile() {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName)));
            for (int i = 0; i < this.lines.size(); ++i) {
                dataOutputStream.writeBytes((String)this.lines.elementAt(i) + System.getProperty("line.separator"));
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IniFile save failed: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    public void saveAsFile(String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            for (int i = 0; i < this.lines.size(); ++i) {
                dataOutputStream.writeBytes((String)this.lines.elementAt(i) + System.getProperty("line.separator"));
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IniFile save failed: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    protected void finalize() {
    }
}

