/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.util.json;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.io.Output;
import org.msgpack.io.StreamOutput;
import org.msgpack.packer.AbstractPacker;
import org.msgpack.packer.Packer;
import org.msgpack.packer.PackerStack;

public class JSONPacker
extends AbstractPacker {
    private static final byte[] a = new byte[]{110, 117, 108, 108};
    private static final byte[] b = new byte[]{116, 114, 117, 101};
    private static final byte[] c = new byte[]{102, 97, 108, 115, 101};
    protected final Output out;
    private int[] d;
    private PackerStack e = new PackerStack();
    private CharsetDecoder f;
    private static final int[] g = new int[128];
    private static final byte[] h;

    /*
     * WARNING - void declaration
     */
    public JSONPacker(OutputStream stream) {
        this(new MessagePack(), (OutputStream)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONPacker(MessagePack msgpack, OutputStream stream) {
        this((MessagePack)var1_1, new StreamOutput((OutputStream)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected JSONPacker(MessagePack msgpack, Output out) {
        super((MessagePack)var1_1);
        void var2_2;
        void var1_1;
        this.out = var2_2;
        this.e = new PackerStack();
        this.d = new int[128];
        this.f = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeBoolean(boolean v) throws IOException {
        void var1_1;
        this.a();
        if (var1_1 != false) {
            this.out.write(b, 0, b.length);
        } else {
            this.out.write(c, 0, c.length);
        }
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeByte(byte v) throws IOException {
        void var1_1;
        this.a();
        byte[] byArray = Byte.toString((byte)var1_1).getBytes();
        this.out.write(byArray, 0, byArray.length);
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeShort(short v) throws IOException {
        void var1_1;
        this.a();
        byte[] byArray = Short.toString((short)var1_1).getBytes();
        this.out.write(byArray, 0, byArray.length);
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeInt(int v) throws IOException {
        void var1_1;
        this.a();
        byte[] byArray = Integer.toString((int)var1_1).getBytes();
        this.out.write(byArray, 0, byArray.length);
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeLong(long v) throws IOException {
        void var1_1;
        this.a();
        byte[] byArray = Long.toString((long)var1_1).getBytes();
        this.out.write(byArray, 0, byArray.length);
        this.c();
    }

    @Override
    protected void writeBigInteger(BigInteger v) throws IOException {
        byte[] byArray;
        this.a();
        byArray = byArray.toString().getBytes();
        this.out.write(byArray, 0, byArray.length);
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeFloat(float v) throws IOException {
        void var1_1;
        this.a();
        Float f2 = Float.valueOf(v);
        if (f2.isInfinite() || f2.isNaN()) {
            throw new IOException("JSONPacker doesn't support NaN and infinite float value");
        }
        byte[] byArray = Float.toString((float)var1_1).getBytes();
        this.out.write(byArray, 0, byArray.length);
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeDouble(double v) throws IOException {
        void var1_1;
        this.a();
        Double d2 = v;
        if (d2.isInfinite() || d2.isNaN()) {
            throw new IOException("JSONPacker doesn't support NaN and infinite float value");
        }
        byte[] byArray = Double.toString((double)var1_1).getBytes();
        this.out.write(byArray, 0, byArray.length);
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeByteArray(byte[] b2, int off, int len) throws IOException {
        JSONPacker jSONPacker;
        void var2_2;
        void var3_4;
        this.b();
        this.out.writeByte((byte)34);
        JSONPacker jSONPacker2 = this;
        void var5_6 = var3_4;
        void var4_7 = var2_2;
        void var3_5 = jSONPacker;
        Output output = jSONPacker2.out;
        jSONPacker = jSONPacker2;
        jSONPacker2.a(output, ByteBuffer.wrap((byte[])var3_5, (int)var4_7, (int)var5_6));
        this.out.writeByte((byte)34);
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeByteBuffer(ByteBuffer bb) throws IOException {
        this.b();
        this.out.writeByte((byte)34);
        int n2 = bb.position();
        try {
            JSONPacker jSONPacker = this;
            jSONPacker.a(jSONPacker.out, bb);
            bb.position(n2);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.position(n2);
            throw throwable;
        }
        this.out.writeByte((byte)34);
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeString(String s2) throws IOException {
        void var1_1;
        this.b();
        this.out.writeByte((byte)34);
        JSONPacker.a(this.out, (String)var1_1);
        this.out.writeByte((byte)34);
        this.c();
    }

    @Override
    public Packer writeNil() throws IOException {
        this.a();
        this.out.write(a, 0, a.length);
        this.c();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Packer writeArrayBegin(int size) throws IOException {
        void var1_1;
        this.a();
        this.out.writeByte((byte)91);
        this.c();
        this.e.pushArray((int)var1_1);
        this.d[this.e.getDepth()] = 1;
        return this;
    }

    @Override
    public Packer writeArrayEnd(boolean check) throws IOException {
        if (!this.e.topIsArray()) {
            throw new MessageTypeException("writeArrayEnd() is called but writeArrayBegin() is not called");
        }
        int n2 = this.e.getTopCount();
        if (n2 > 0) {
            int n3;
            if (n3 != 0) {
                throw new MessageTypeException("writeArrayEnd(check=true) is called but the array is not end: " + n2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.writeNil();
            }
        }
        this.e.pop();
        this.out.writeByte((byte)93);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Packer writeMapBegin(int size) throws IOException {
        void var1_1;
        this.a();
        this.out.writeByte((byte)123);
        this.c();
        this.e.pushMap((int)var1_1);
        this.d[this.e.getDepth()] = 3;
        return this;
    }

    @Override
    public Packer writeMapEnd(boolean check) throws IOException {
        if (!this.e.topIsMap()) {
            throw new MessageTypeException("writeMapEnd() is called but writeMapBegin() is not called");
        }
        int n2 = this.e.getTopCount();
        if (n2 > 0) {
            int n3;
            if (n3 != 0) {
                throw new MessageTypeException("writeMapEnd(check=true) is called but the map is not end: " + n2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.writeNil();
            }
        }
        this.e.pop();
        this.out.writeByte((byte)125);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void reset() {
        this.e.clear();
    }

    private void a() throws IOException {
        int n2 = this.d[this.e.getDepth()];
        if ((n2 & 2) != 0) {
            throw new IOException("Key of a map must be a string in JSON");
        }
        this.b();
    }

    private void b() throws IOException {
        int n2 = this.d[this.e.getDepth()];
        if ((n2 & 4) != 0) {
            this.out.writeByte((byte)58);
            return;
        }
        if (this.e.getDepth() > 0 && (n2 & 1) == 0) {
            this.out.writeByte((byte)44);
        }
    }

    private void c() throws IOException {
        int n2 = this.d[this.e.getDepth()];
        if ((n2 & 2) != 0) {
            n2 &= 0xFFFFFFFD;
            n2 |= 4;
        } else if ((n2 & 4) != 0) {
            n2 &= 0xFFFFFFFB;
            n2 |= 2;
        }
        this.d[this.e.getDepth()] = n2 &= 0xFFFFFFFE;
        this.e.reduceCount();
    }

    private void a(Output output, ByteBuffer object) throws IOException {
        object = this.f.decode((ByteBuffer)object).toString();
        JSONPacker.a(output, (String)object);
    }

    private static void a(Output output, String object) throws IOException {
        byte[] byArray = new byte[]{92, 117, 0, 0, 0, 0};
        object = ((String)object).toCharArray();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            Object object2 = object[i2];
            if (object2 <= 127) {
                int n2 = g[object2];
                if (n2 == 0) {
                    byArray[2] = (byte)object2;
                    output.write(byArray, 2, 1);
                    continue;
                }
                if (n2 > 0) {
                    byArray[2] = 92;
                    byArray[3] = (byte)n2;
                    output.write(byArray, 2, 2);
                    continue;
                }
                byArray[2] = 48;
                byArray[3] = 48;
                byArray[4] = h[object2 >> 4];
                byArray[5] = h[object2 & 0xF];
                output.write(byArray, 0, 6);
                continue;
            }
            if (object2 <= 2047) {
                byArray[2] = (byte)(0xC0 | object2 >> 6);
                byArray[3] = (byte)(0x80 | object2 & 0x3F);
                output.write(byArray, 2, 2);
                continue;
            }
            if (object2 >= 55296 && object2 <= 57343) {
                byArray[2] = h[object2 >> 12 & 0xF];
                byArray[3] = h[object2 >> 8 & 0xF];
                byArray[4] = h[object2 >> 4 & 0xF];
                byArray[5] = h[object2 & 0xF];
                output.write(byArray, 0, 6);
                continue;
            }
            byArray[2] = (byte)(0xE0 | object2 >> 12);
            byArray[3] = (byte)(0x80 | object2 >> 6 & 0x3F);
            byArray[4] = (byte)(0x80 | object2 & 0x3F);
            output.write(byArray, 2, 3);
        }
    }

    static {
        for (int i2 = 0; i2 < 32; ++i2) {
            JSONPacker.g[i2] = -1;
        }
        JSONPacker.g[34] = 34;
        JSONPacker.g[92] = 92;
        JSONPacker.g[8] = 98;
        JSONPacker.g[9] = 116;
        JSONPacker.g[12] = 102;
        JSONPacker.g[10] = 110;
        JSONPacker.g[13] = 114;
        char[] cArray = "0123456789ABCDEF".toCharArray();
        h = new byte[cArray.length];
        for (int i3 = 0; i3 < cArray.length; ++i3) {
            JSONPacker.h[i3] = (byte)cArray[i3];
        }
    }
}

