/*
 * Decompiled with CFR 0.152.
 */
package javassist.tools.reflect;

import java.util.Iterator;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.Translator;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.tools.reflect.CannotReflectException;

public class Reflection
implements Translator {
    protected CtMethod trapMethod;
    protected CtMethod trapStaticMethod;
    protected CtMethod trapRead;
    protected CtMethod trapWrite;
    protected CtClass[] readParam;
    protected ClassPool classPool = null;
    protected CodeConverter converter = new CodeConverter();

    private static boolean a(String string) {
        return string.startsWith("_m_") || string.equals("_getClass") || string.equals("_setMetaobject") || string.equals("_getMetaobject") || string.startsWith("_r_") || string.startsWith("_w_");
    }

    @Override
    public void start(ClassPool pool) throws NotFoundException {
        CtClass ctClass;
        this.classPool = ctClass;
        try {
            ctClass = this.classPool.get("javassist.tools.reflect.Sample");
            this.rebuildClassFile(ctClass.getClassFile());
            this.trapMethod = ctClass.getDeclaredMethod("trap");
            this.trapStaticMethod = ctClass.getDeclaredMethod("trapStatic");
            this.trapRead = ctClass.getDeclaredMethod("trapRead");
            this.trapWrite = ctClass.getDeclaredMethod("trapWrite");
            this.readParam = new CtClass[]{this.classPool.get("java.lang.Object")};
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException("javassist.tools.reflect.Sample is not found or broken.");
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException("javassist.tools.reflect.Sample is not found or broken.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onLoad(ClassPool pool, String classname) throws CannotCompileException, NotFoundException {
        void var2_2;
        CtClass ctClass = pool.get((String)var2_2);
        ctClass.instrument(this.converter);
    }

    /*
     * WARNING - void declaration
     */
    public boolean makeReflective(String classname, String metaobject, String metaclass) throws CannotCompileException, NotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        Reflection reflection = this;
        return reflection.makeReflective(reflection.classPool.get((String)var1_1), this.classPool.get((String)var2_2), this.classPool.get((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public boolean makeReflective(Class clazz, Class metaobject, Class metaclass) throws CannotCompileException, NotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.makeReflective(var1_1.getName(), var2_2.getName(), var3_3.getName());
    }

    /*
     * WARNING - void declaration
     */
    public boolean makeReflective(CtClass clazz, CtClass metaobject, CtClass metaclass) throws CannotCompileException, CannotReflectException, NotFoundException {
        Reflection reflection;
        void var2_2;
        void var3_3;
        if (clazz.isInterface()) {
            throw new CannotReflectException("Cannot reflect an interface: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get("javassist.tools.reflect.ClassMetaobject"))) {
            throw new CannotReflectException("Cannot reflect a subclass of ClassMetaobject: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get("javassist.tools.reflect.Metaobject"))) {
            throw new CannotReflectException("Cannot reflect a subclass of Metaobject: " + clazz.getName());
        }
        this.a(clazz);
        void var4_4 = var3_3;
        var3_3 = var2_2;
        var2_2 = reflection;
        reflection = this;
        if (var2_2.getAttribute("Reflective") != null) {
            return false;
        }
        var2_2.setAttribute("Reflective", new byte[0]);
        Object object = reflection.classPool.get("javassist.tools.reflect.Metalevel");
        boolean bl = !var2_2.subtypeOf((CtClass)object);
        if (bl) {
            var2_2.addInterface((CtClass)object);
        }
        reflection.a((CtClass)var2_2, bl);
        reflection.b((CtClass)var2_2);
        if (bl) {
            object = new CtField(reflection.classPool.get("javassist.tools.reflect.Metaobject"), "_metaobject", (CtClass)var2_2);
            ((CtField)object).setModifiers(4);
            var2_2.addField((CtField)object, CtField.Initializer.byNewWithParams((CtClass)var3_3));
            var2_2.addMethod(CtNewMethod.getter("_getMetaobject", (CtField)object));
            var2_2.addMethod(CtNewMethod.setter("_setMetaobject", (CtField)object));
        }
        object = new CtField(reflection.classPool.get("javassist.tools.reflect.ClassMetaobject"), "_classobject", (CtClass)var2_2);
        ((CtField)object).setModifiers(10);
        var2_2.addField((CtField)object, CtField.Initializer.byNew((CtClass)var4_4, new String[]{var2_2.getName()}));
        var2_2.addMethod(CtNewMethod.getter("_getClass", (CtField)object));
        return true;
    }

    private void a(CtClass ctClass) {
        CtField[] ctFieldArray = ctClass.getDeclaredFields();
        for (int i2 = 0; i2 < ctFieldArray.length; ++i2) {
            CtField ctField = ctFieldArray[i2];
            int n2 = ctField.getModifiers();
            if ((n2 & 1) == 0 || (n2 & 0x10) != 0) continue;
            String string = ctField.getName();
            this.converter.replaceFieldRead(ctField, ctClass, "_r_" + string);
            this.converter.replaceFieldWrite(ctField, ctClass, "_w_" + string);
        }
    }

    private void a(CtClass ctClass, boolean bl) throws CannotCompileException, NotFoundException {
        CtMethod[] ctMethodArray = ctClass.getMethods();
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            CtMethod ctMethod = ctMethodArray[i2];
            int n2 = ctMethod.getModifiers();
            if (!Modifier.isPublic(n2) || Modifier.isAbstract(n2)) continue;
            this.a(n2, ctClass, ctMethod, i2, bl);
        }
    }

    private void a(int n2, CtClass ctClass, CtMethod ctMethod, int n3, boolean bl) throws CannotCompileException, NotFoundException {
        CtMethod ctMethod2;
        String string = ctMethod.getName();
        if (Reflection.a(string)) {
            return;
        }
        if (ctMethod.getDeclaringClass() == ctClass) {
            if (Modifier.isNative(n2)) {
                return;
            }
            ctMethod2 = ctMethod;
            if (Modifier.isFinal(n2)) {
                ctMethod2.setModifiers(n2 &= 0xFFFFFFEF);
            }
        } else {
            if (Modifier.isFinal(n2)) {
                return;
            }
            ctMethod2 = CtNewMethod.delegator(Reflection.a(ctMethod, bl), ctClass);
            ctMethod2.setModifiers(n2 &= 0xFFFFFEFF);
            ctClass.addMethod(ctMethod2);
        }
        ctMethod2.setName("_m_" + n3 + "_" + string);
        ctMethod2 = Modifier.isStatic(n2) ? this.trapStaticMethod : this.trapMethod;
        ctMethod = CtNewMethod.wrapped(ctMethod.getReturnType(), string, ctMethod.getParameterTypes(), ctMethod.getExceptionTypes(), ctMethod2, CtMethod.ConstParameter.integer(n3), ctClass);
        ctMethod.setModifiers(n2);
        ctClass.addMethod(ctMethod);
    }

    private static CtMethod a(CtMethod ctMethod, boolean bl) throws NotFoundException {
        if (bl) {
            return ctMethod;
        }
        String string = ctMethod.getName();
        CtMethod[] ctMethodArray = ctMethod.getDeclaringClass().getDeclaredMethods();
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            String string2 = ctMethodArray[i2].getName();
            if (!string2.endsWith(string) || !string2.startsWith("_m_") || !ctMethodArray[i2].getSignature().equals(ctMethod.getSignature())) continue;
            return ctMethodArray[i2];
        }
        return ctMethod;
    }

    private void b(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtField[] ctFieldArray = ctClass.getDeclaredFields();
        for (int i2 = 0; i2 < ctFieldArray.length; ++i2) {
            Object object = ctFieldArray[i2];
            int n2 = ((CtField)object).getModifiers();
            if ((n2 & 1) == 0 || (n2 & 0x10) != 0) continue;
            String string = ((CtField)object).getName();
            object = ((CtField)object).getType();
            Object object2 = CtNewMethod.wrapped((CtClass)object, "_r_" + string, this.readParam, null, this.trapRead, CtMethod.ConstParameter.string(string), ctClass);
            object2.setModifiers(n2 |= 8);
            ctClass.addMethod((CtMethod)object2);
            CtClass[] ctClassArray = new CtClass[2];
            object2 = ctClassArray;
            ctClassArray[0] = this.classPool.get("java.lang.Object");
            object2[1] = object;
            object2 = CtNewMethod.wrapped(CtClass.voidType, "_w_" + string, object2, null, this.trapWrite, CtMethod.ConstParameter.string(string), ctClass);
            object2.setModifiers(n2);
            ctClass.addMethod((CtMethod)object2);
        }
    }

    public void rebuildClassFile(ClassFile cf) throws BadBytecode {
        Iterator iterator;
        if (ClassFile.MAJOR_VERSION < 50) {
            return;
        }
        for (MethodInfo methodInfo : ((ClassFile)((Object)iterator)).getMethods()) {
            methodInfo.rebuildStackMap(this.classPool);
        }
    }
}

